/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.gradle.BuildListener;
import org.gradle.api.invocation.Gradle;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.problems.buildtree.ProblemReporter;

public class ProblemReportingBuildActionRunner
implements BuildActionRunner {
    private final BuildActionRunner delegate;
    private final ExceptionAnalyser exceptionAnalyser;
    private final List<? extends ProblemReporter> reporters;

    public ProblemReportingBuildActionRunner(BuildActionRunner delegate, ExceptionAnalyser exceptionAnalyser, List<? extends ProblemReporter> reporters) {
        this.delegate = delegate;
        this.exceptionAnalyser = exceptionAnalyser;
        this.reporters = ImmutableList.sortedCopyOf(Comparator.comparing(ProblemReporter::getId), reporters);
    }

    @Override
    public BuildActionRunner.Result run(BuildAction action, BuildTreeLifecycleController buildController) {
        RootProjectBuildDirCollectingListener rootProjectBuildDirListener = this.getRootProjectBuildDirCollectingListener(buildController);
        BuildActionRunner.Result result = this.delegate.run(action, buildController);
        File rootProjectBuildDir = rootProjectBuildDirListener.rootProjectBuildDir;
        List<Throwable> failures = this.reportProblems(rootProjectBuildDir);
        return result.addFailures(failures);
    }

    private List<Throwable> reportProblems(File rootProjectBuildDir) {
        ArrayList<Throwable> failures = new ArrayList<Throwable>();
        Consumer<Throwable> collector = failure -> failures.add(this.exceptionAnalyser.transform((Throwable)failure));
        for (ProblemReporter problemReporter : this.reporters) {
            try {
                problemReporter.report(rootProjectBuildDir, collector);
            }
            catch (Exception e) {
                failures.add(e);
            }
        }
        return failures;
    }

    private RootProjectBuildDirCollectingListener getRootProjectBuildDirCollectingListener(BuildTreeLifecycleController buildController) {
        RootProjectBuildDirCollectingListener listener = new RootProjectBuildDirCollectingListener(this.defaultRootBuildDirOf(buildController));
        buildController.getGradle().addBuildListener((BuildListener)listener);
        return listener;
    }

    private File defaultRootBuildDirOf(BuildTreeLifecycleController buildController) {
        return new File(((BuildLayout)buildController.getGradle().getServices().get(BuildLayout.class)).getRootDirectory(), "build");
    }

    private static class RootProjectBuildDirCollectingListener
    extends InternalBuildAdapter {
        File rootProjectBuildDir;

        public RootProjectBuildDirCollectingListener(File defaultBuildDir) {
            this.rootProjectBuildDir = defaultBuildDir;
        }

        public void projectsEvaluated(Gradle gradle) {
            this.rootProjectBuildDir = gradle.getRootProject().getBuildDir();
        }
    }
}

