/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.SnapshotTaskInputsBuildOperationType;
import org.gradle.caching.BuildCacheKey;
import org.gradle.internal.execution.caching.CachingInputs;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.operations.trace.CustomOperationTraceSerialization;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public class SnapshotTaskInputsBuildOperationResult
implements SnapshotTaskInputsBuildOperationType.Result,
CustomOperationTraceSerialization {
    @VisibleForTesting
    final CachingState cachingState;

    public SnapshotTaskInputsBuildOperationResult(CachingState cachingState) {
        this.cachingState = cachingState;
    }

    @Override
    public Map<String, byte[]> getInputValueHashesBytes() {
        return this.cachingState.getInputs().map(CachingInputs::getInputValueFingerprints).filter(inputValueFingerprints -> !inputValueFingerprints.isEmpty()).map(inputValueFingerprints -> inputValueFingerprints.entrySet().stream().collect(SnapshotTaskInputsBuildOperationResult.toLinkedHashMap(HashCode::toByteArray))).orElse(null);
    }

    @Override
    public void visitInputFileProperties(SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor visitor) {
        this.cachingState.getInputs().ifPresent(inputs -> {
            State state = new State(visitor);
            for (Map.Entry entry : inputs.getInputFileFingerprints().entrySet()) {
                CurrentFileCollectionFingerprint fingerprint = (CurrentFileCollectionFingerprint)entry.getValue();
                state.propertyName = (String)entry.getKey();
                state.propertyHash = fingerprint.getHash();
                state.propertyNormalizationStrategyIdentifier = fingerprint.getStrategyIdentifier();
                state.fingerprints = fingerprint.getFingerprints();
                visitor.preProperty(state);
                fingerprint.getSnapshot().accept((FileSystemSnapshotHierarchyVisitor)state);
                visitor.postProperty();
            }
        });
    }

    @Override
    public byte[] getClassLoaderHashBytes() {
        return this.cachingState.getInputs().map(new Function<CachingInputs, byte[]>(){

            @Override
            @Nullable
            public byte[] apply(CachingInputs inputs) {
                ImplementationSnapshot implementation = inputs.getImplementation();
                if (implementation.getClassLoaderHash() == null) {
                    return null;
                }
                return implementation.getClassLoaderHash().toByteArray();
            }
        }).orElse(null);
    }

    @Override
    public List<byte[]> getActionClassLoaderHashesBytes() {
        return this.cachingState.getInputs().map(CachingInputs::getAdditionalImplementations).filter(additionalImplementation -> !additionalImplementation.isEmpty()).map(additionalImplementations -> additionalImplementations.stream().map(input -> input.getClassLoaderHash() == null ? null : input.getClassLoaderHash().toByteArray()).collect(Collectors.toList())).orElse(null);
    }

    @Override
    @Nullable
    public List<String> getActionClassNames() {
        return this.cachingState.getInputs().map(CachingInputs::getAdditionalImplementations).filter(additionalImplementations -> !additionalImplementations.isEmpty()).map(additionalImplementations -> additionalImplementations.stream().map(ImplementationSnapshot::getTypeName).collect(Collectors.toList())).orElse(null);
    }

    @Override
    @Nullable
    public List<String> getOutputPropertyNames() {
        return this.cachingState.getInputs().map(CachingInputs::getOutputProperties).filter(outputPropertyNames -> !outputPropertyNames.isEmpty()).map(ImmutableSet::asList).orElse(null);
    }

    @Override
    public byte[] getHashBytes() {
        return this.cachingState.getKey().map(BuildCacheKey::toByteArray).orElse(null);
    }

    @Override
    public Object getCustomOperationTraceSerializableModel() {
        TreeMap<String, Object> model = new TreeMap<String, Object>();
        List<byte[]> actionClassLoaderHashesBytes = this.getActionClassLoaderHashesBytes();
        if (actionClassLoaderHashesBytes != null) {
            List actionClassloaderHashes = this.getActionClassLoaderHashesBytes().stream().map(hash -> hash == null ? null : HashCode.fromBytes((byte[])hash).toString()).collect(Collectors.toList());
            model.put("actionClassLoaderHashes", actionClassloaderHashes);
        } else {
            model.put("actionClassLoaderHashes", null);
        }
        model.put("actionClassNames", this.getActionClassNames());
        byte[] hashBytes = this.getHashBytes();
        if (hashBytes != null) {
            model.put("hash", HashCode.fromBytes((byte[])hashBytes).toString());
        } else {
            model.put("hash", null);
        }
        byte[] classLoaderHashBytes = this.getClassLoaderHashBytes();
        if (classLoaderHashBytes != null) {
            model.put("classLoaderHash", HashCode.fromBytes((byte[])classLoaderHashBytes).toString());
        } else {
            model.put("classLoaderHash", null);
        }
        model.put("inputFileProperties", this.fileProperties());
        model.put("inputPropertiesLoadedByUnknownClassLoader", this.getInputPropertiesLoadedByUnknownClassLoader());
        Map<String, byte[]> inputValueHashesBytes = this.getInputValueHashesBytes();
        if (inputValueHashesBytes != null) {
            Map inputValueHashes = inputValueHashesBytes.entrySet().stream().collect(SnapshotTaskInputsBuildOperationResult.toLinkedHashMap(value -> value == null ? null : HashCode.fromBytes((byte[])value).toString()));
            model.put("inputValueHashes", inputValueHashes);
        } else {
            model.put("inputValueHashes", null);
        }
        model.put("outputPropertyNames", this.getOutputPropertyNames());
        return model;
    }

    private static <K, V, U> Collector<Map.Entry<K, V>, ?, LinkedHashMap<K, U>> toLinkedHashMap(Function<? super V, ? extends U> valueMapper) {
        return Collectors.toMap(Map.Entry::getKey, entry -> valueMapper.apply((Object)entry.getValue()), (a, b) -> b, LinkedHashMap::new);
    }

    protected Map<String, Object> fileProperties() {
        final TreeMap<String, Object> fileProperties = new TreeMap<String, Object>();
        this.visitInputFileProperties(new SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor(){
            Property property;
            final Deque<DirEntry> dirStack = new ArrayDeque<DirEntry>();

            @Override
            public void preProperty(SnapshotTaskInputsBuildOperationType.Result.VisitState state) {
                this.property = new Property(HashCode.fromBytes((byte[])state.getPropertyHashBytes()).toString(), state.getPropertyNormalizationStrategyName());
                fileProperties.put(state.getPropertyName(), this.property);
            }

            @Override
            public void preRoot(SnapshotTaskInputsBuildOperationType.Result.VisitState state) {
            }

            @Override
            public void preDirectory(SnapshotTaskInputsBuildOperationType.Result.VisitState state) {
                boolean isRoot = this.dirStack.isEmpty();
                DirEntry dir = new DirEntry(isRoot ? state.getPath() : state.getName());
                if (isRoot) {
                    this.property.roots.add(dir);
                } else {
                    this.dirStack.peek().children.add(dir);
                }
                this.dirStack.push(dir);
            }

            @Override
            public void file(SnapshotTaskInputsBuildOperationType.Result.VisitState state) {
                boolean isRoot = this.dirStack.isEmpty();
                FileEntry file = new FileEntry(isRoot ? state.getPath() : state.getName(), HashCode.fromBytes((byte[])state.getHashBytes()).toString());
                if (isRoot) {
                    this.property.roots.add(file);
                } else {
                    this.dirStack.peek().children.add(file);
                }
            }

            @Override
            public void postDirectory() {
                this.dirStack.pop();
            }

            @Override
            public void postRoot() {
            }

            @Override
            public void postProperty() {
            }

            class DirEntry
            extends Entry {
                private final List<Entry> children;

                DirEntry(String path) {
                    super(path);
                    this.children = new ArrayList<Entry>();
                }

                public Collection<Entry> getChildren() {
                    return this.children;
                }
            }

            class FileEntry
            extends Entry {
                private final String hash;

                FileEntry(String path, String hash) {
                    super(path);
                    this.hash = hash;
                }

                public String getHash() {
                    return this.hash;
                }
            }

            abstract class Entry {
                private final String path;

                public Entry(String path) {
                    this.path = path;
                }

                public String getPath() {
                    return this.path;
                }
            }

            class Property {
                private final String hash;
                private final String normalization;
                private final List<Entry> roots = new ArrayList<Entry>();

                public Property(String hash, String normalization) {
                    this.hash = hash;
                    this.normalization = normalization;
                }

                public String getHash() {
                    return this.hash;
                }

                public String getNormalization() {
                    return this.normalization;
                }

                public Collection<Entry> getRoots() {
                    return this.roots;
                }
            }
        });
        return fileProperties;
    }

    @NonNullApi
    private static class State
    implements SnapshotTaskInputsBuildOperationType.Result.VisitState,
    FileSystemSnapshotHierarchyVisitor {
        final SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor visitor;
        Map<String, FileSystemLocationFingerprint> fingerprints;
        String propertyName;
        HashCode propertyHash;
        String propertyNormalizationStrategyIdentifier;
        String name;
        String path;
        HashCode hash;
        int depth;

        public State(SnapshotTaskInputsBuildOperationType.Result.InputFilePropertyVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public byte[] getPropertyHashBytes() {
            return this.propertyHash.toByteArray();
        }

        @Override
        public String getPropertyNormalizationStrategyName() {
            return this.propertyNormalizationStrategyIdentifier;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public byte[] getHashBytes() {
            return this.hash.toByteArray();
        }

        public void enterDirectory(DirectorySnapshot physicalSnapshot) {
            this.path = physicalSnapshot.getAbsolutePath();
            this.name = physicalSnapshot.getName();
            this.hash = null;
            if (this.depth++ == 0) {
                this.visitor.preRoot(this);
            }
            this.visitor.preDirectory(this);
        }

        public SnapshotVisitResult visitEntry(FileSystemLocationSnapshot snapshot) {
            boolean isRoot;
            if (snapshot.getType() == FileType.Directory) {
                return SnapshotVisitResult.CONTINUE;
            }
            this.path = snapshot.getAbsolutePath();
            this.name = snapshot.getName();
            FileSystemLocationFingerprint fingerprint = this.fingerprints.get(this.path);
            if (fingerprint == null) {
                return SnapshotVisitResult.CONTINUE;
            }
            this.hash = fingerprint.getNormalizedContentHash();
            boolean bl = isRoot = this.depth == 0;
            if (isRoot) {
                this.visitor.preRoot(this);
            }
            this.visitor.file(this);
            if (isRoot) {
                this.visitor.postRoot();
            }
            return SnapshotVisitResult.CONTINUE;
        }

        public void leaveDirectory(DirectorySnapshot directorySnapshot) {
            this.visitor.postDirectory();
            if (--this.depth == 0) {
                this.visitor.postRoot();
            }
        }
    }
}

