/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.Platform;
import org.jetbrains.kotlin.com.google.errorprone.annotations.CanIgnoreReturnValue;

public final class ObjectArrays {
    private ObjectArrays() {
    }

    public static <T> T[] newArray(Class<T> type2, int length) {
        return (Object[])Array.newInstance(type2, length);
    }

    public static <T> T[] newArray(T[] reference, int length) {
        return Platform.newArray(reference, length);
    }

    public static <T> T[] concat(T[] first, T[] second, Class<T> type2) {
        T[] result2 = ObjectArrays.newArray(type2, first.length + second.length);
        System.arraycopy(first, 0, result2, 0, first.length);
        System.arraycopy(second, 0, result2, first.length, second.length);
        return result2;
    }

    public static <T> T[] concat(@Nullable T element, T[] array) {
        T[] result2 = ObjectArrays.newArray(array, array.length + 1);
        result2[0] = element;
        System.arraycopy(array, 0, result2, 1, array.length);
        return result2;
    }

    public static <T> T[] concat(T[] array, @Nullable T element) {
        T[] result2 = Arrays.copyOf(array, array.length + 1);
        result2[array.length] = element;
        return result2;
    }

    static <T> T[] toArrayImpl(Collection<?> c, T[] array) {
        int size = c.size();
        if (array.length < size) {
            array = ObjectArrays.newArray(array, size);
        }
        ObjectArrays.fillArray(c, array);
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    static <T> T[] toArrayImpl(Object[] src, int offset2, int len, T[] dst) {
        Preconditions.checkPositionIndexes(offset2, offset2 + len, src.length);
        if (dst.length < len) {
            dst = ObjectArrays.newArray(dst, len);
        } else if (dst.length > len) {
            dst[len] = null;
        }
        System.arraycopy(src, offset2, dst, 0, len);
        return dst;
    }

    static Object[] toArrayImpl(Collection<?> c) {
        return ObjectArrays.fillArray(c, new Object[c.size()]);
    }

    static Object[] copyAsObjectArray(Object[] elements, int offset2, int length) {
        Preconditions.checkPositionIndexes(offset2, offset2 + length, elements.length);
        if (length == 0) {
            return new Object[0];
        }
        Object[] result2 = new Object[length];
        System.arraycopy(elements, offset2, result2, 0, length);
        return result2;
    }

    @CanIgnoreReturnValue
    private static Object[] fillArray(Iterable<?> elements, Object[] array) {
        int i = 0;
        for (Object element : elements) {
            array[i++] = element;
        }
        return array;
    }

    static void swap(Object[] array, int i, int j) {
        Object temp = array[i];
        array[i] = array[j];
        array[j] = temp;
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object ... array) {
        return ObjectArrays.checkElementsNotNull(array, array.length);
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object[] array, int length) {
        for (int i = 0; i < length; ++i) {
            ObjectArrays.checkElementNotNull(array[i], i);
        }
        return array;
    }

    @CanIgnoreReturnValue
    static Object checkElementNotNull(Object element, int index2) {
        if (element == null) {
            throw new NullPointerException("at index " + index2);
        }
        return element;
    }
}

