/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentParseErrors;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.ParseCommandLineArgumentsKt;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.repl.IReplStageState;
import org.jetbrains.kotlin.cli.common.repl.ReplCheckResult;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.cli.common.repl.ReplCompileResult;
import org.jetbrains.kotlin.cli.common.repl.ReplEvalResult;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreApplicationEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.ZipHandler;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.CompileServiceImpl;
import org.jetbrains.kotlin.daemon.CompileServiceImplBase;
import org.jetbrains.kotlin.daemon.CompileServiceImplKt;
import org.jetbrains.kotlin.daemon.CompilerSelector;
import org.jetbrains.kotlin.daemon.EventManager;
import org.jetbrains.kotlin.daemon.EventManagerImpl;
import org.jetbrains.kotlin.daemon.KeepFirstErrorMessageCollector;
import org.jetbrains.kotlin.daemon.KotlinJvmReplService;
import org.jetbrains.kotlin.daemon.RemoteCompilationCanceledStatusClient;
import org.jetbrains.kotlin.daemon.RemoteExpectActualTracker;
import org.jetbrains.kotlin.daemon.RemoteIncrementalCompilationComponentsClient;
import org.jetbrains.kotlin.daemon.RemoteIncrementalDataProvider;
import org.jetbrains.kotlin.daemon.RemoteIncrementalResultsConsumer;
import org.jetbrains.kotlin.daemon.RemoteLookupTrackerClient;
import org.jetbrains.kotlin.daemon.RemoteOutputStreamClient;
import org.jetbrains.kotlin.daemon.RemoteReplStateFacadeServer;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompilationResults;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptionsMemoryComparator;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.FileAgeComparator;
import org.jetbrains.kotlin.daemon.common.IncrementalCompilationOptions;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.RemoteInputStream;
import org.jetbrains.kotlin.daemon.common.RemoteOperationsTracer;
import org.jetbrains.kotlin.daemon.common.RemoteOutputStream;
import org.jetbrains.kotlin.daemon.common.ReplStateFacade;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.daemon.common.WallAndThreadAndMemoryTotalProfiler;
import org.jetbrains.kotlin.daemon.common.WallAndThreadTotalProfiler;
import org.jetbrains.kotlin.daemon.report.CompileServicesFacadeMessageCollector;
import org.jetbrains.kotlin.daemon.report.DaemonMessageReporter;
import org.jetbrains.kotlin.daemon.report.DaemonMessageReporterKt;
import org.jetbrains.kotlin.daemon.report.DaemonMessageReporterPrintStreamAdapter;
import org.jetbrains.kotlin.daemon.report.GetICReporterKt;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.incremental.parsing.ParseFileUtilsKt;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00b2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002BK\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\bH\u0016J*\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0'2\u0006\u0010*\u001a\u00020\u000e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0(H\u0016J\b\u0010-\u001a\u00020\u0013H\u0016JE\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\u0006\u0010*\u001a\u00020\u000e2\u000e\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020)002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\b\u00105\u001a\u0004\u0018\u000106H\u0016\u00a2\u0006\u0002\u00107J \u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0002Je\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\u0006\u0010*\u001a\u00020\u000e2\u000e\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020)002\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020C2\b\u0010E\u001a\u0004\u0018\u00010F2\u001e\u0010G\u001a\u001a\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020J0HH\u0002\u00a2\u0006\u0002\u0010KJ\u0014\u0010L\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0M0'H\u0016J\u000e\u0010N\u001a\b\u0012\u0004\u0012\u00020)0'H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0'H\u0016J\u000e\u0010O\u001a\b\u0012\u0004\u0012\u00020\n0'H\u0016J\u000e\u0010P\u001a\b\u0012\u0004\u0012\u00020\u001a0'H\u0016J\u0010\u0010Q\u001a\u00020$2\u0006\u0010R\u001a\u00020$H\u0002J3\u0010S\u001a\b\u0012\u0004\u0012\u0002HT0'\"\u0004\b\u0000\u0010T2\b\b\u0002\u0010U\u001a\u00020V2\u0012\u0010G\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HT0'0\u0012H\u0082\bJ3\u0010W\u001a\b\u0012\u0004\u0012\u0002HT0'\"\u0004\b\u0000\u0010T2\b\b\u0002\u0010U\u001a\u00020V2\u0012\u0010G\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HT0'0\u0012H\u0082\bJ!\u0010X\u001a\u00020\u00132\b\b\u0002\u0010U\u001a\u00020V2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\bJ!\u0010Y\u001a\u00020\u00132\b\b\u0002\u0010U\u001a\u00020V2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0082\bJ\b\u0010Z\u001a\u00020\u0013H\u0014J\u0018\u0010[\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\b\u0010\\\u001a\u0004\u0018\u00010)H\u0016JS\u0010]\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\b\u0010\\\u001a\u0004\u0018\u00010)2\u000e\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020)002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\f\u0010^\u001a\b\u0012\u0004\u0012\u00020,0M2\u0006\u0010_\u001a\u00020)H\u0016\u00a2\u0006\u0002\u0010`J\u00a1\u0001\u0010]\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\b\u0010\\\u001a\u0004\u0018\u00010)2\u0006\u0010a\u001a\u00020b2\u0006\u00103\u001a\u00020;2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020,0M2\u0006\u0010_\u001a\u00020)2\u0012\u0010c\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010d\u0018\u0001002\u0018\u0010e\u001a\u0014\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020d0f\u0018\u0001002\u0006\u0010g\u001a\u00020C2\b\u0010h\u001a\u0004\u0018\u00010C2\b\u0010i\u001a\u0004\u0018\u00010C2\b\u0010j\u001a\u0004\u0018\u00010k2\b\u0010E\u001a\u0004\u0018\u00010FH\u0016\u00a2\u0006\u0002\u0010lJ\b\u0010m\u001a\u00020\u0013H\u0014J\b\u0010n\u001a\u00020\u0013H\u0014J\u0018\u0010o\u001a\b\u0012\u0004\u0012\u00020p0'2\b\u0010\\\u001a\u0004\u0018\u00010)H\u0016J\u0016\u0010q\u001a\b\u0012\u0004\u0012\u00020p0'2\u0006\u0010*\u001a\u00020\u000eH\u0016J\u0016\u0010r\u001a\b\u0012\u0004\u0012\u00020p0'2\u0006\u0010*\u001a\u00020\u000eH\u0016J]\u0010s\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010a\u001a\u00020b2\u000e\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020)002\u0006\u00103\u001a\u00020;2\u0006\u0010t\u001a\u00020C2\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020C2\b\u0010E\u001a\u0004\u0018\u00010FH\u0016\u00a2\u0006\u0002\u0010xJ]\u0010y\u001a\b\u0012\u0004\u0012\u00020\u000e0'2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010a\u001a\u00020b2\u000e\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020)002\u0006\u00103\u001a\u00020;2\u0006\u0010t\u001a\u00020C2\u0006\u0010z\u001a\u00020v2\u0006\u0010w\u001a\u00020C2\b\u0010E\u001a\u0004\u0018\u00010FH\u0016\u00a2\u0006\u0002\u0010xJ\u001e\u0010{\u001a\b\u0012\u0004\u0012\u00020|0'2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010}\u001a\u00020~H\u0016J0\u0010\u007f\u001a\t\u0012\u0005\u0012\u00030\u0080\u00010'2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010}\u001a\u00020~2\u000f\u0010\u0081\u0001\u001a\n\u0012\u0004\u0012\u00020~\u0018\u00010MH\u0016J1\u0010\u0082\u0001\u001a\t\u0012\u0005\u0012\u00030\u0083\u00010'2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010}\u001a\u00020~2\u000f\u0010\u0081\u0001\u001a\n\u0012\u0004\u0012\u00020~\u0018\u00010MH\u0016J(\u0010\u0084\u0001\u001a\b\u0012\u0004\u0012\u00020|0'2\u0006\u0010*\u001a\u00020\u000e2\u0007\u0010\u0085\u0001\u001a\u00020\u000e2\u0006\u0010}\u001a\u00020~H\u0016J)\u0010\u0086\u0001\u001a\t\u0012\u0005\u0012\u00030\u0080\u00010'2\u0006\u0010*\u001a\u00020\u000e2\u0007\u0010\u0085\u0001\u001a\u00020\u000e2\u0006\u0010}\u001a\u00020~H\u0016J\u0018\u0010\u0087\u0001\u001a\t\u0012\u0005\u0012\u00030\u0088\u00010'2\u0006\u0010*\u001a\u00020\u000eH\u0016J\u0018\u0010\u0089\u0001\u001a\b\u0012\u0004\u0012\u00020$0'2\u0007\u0010\u008a\u0001\u001a\u00020$H\u0016J\u000f\u0010\u008b\u0001\u001a\b\u0012\u0004\u0012\u00020p0'H\u0016J\t\u0010\u008c\u0001\u001a\u00020\u0013H\u0002J\t\u0010\u008d\u0001\u001a\u00020\u0013H\u0002J@\u0010\u008e\u0001\u001a\b\u0012\u0004\u0012\u0002HT0'\"\u0004\b\u0000\u0010T2\u0006\u0010*\u001a\u00020\u000e2 \u0010G\u001a\u001c\u0012\u0005\u0012\u00030\u0090\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002HT0'0\u008f\u0001\u00a2\u0006\u0003\b\u0091\u0001H\u0082\bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0092\u0001"}, d2={"Lorg/jetbrains/kotlin/daemon/CompileServiceImpl;", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase;", "registry", "Ljava/rmi/registry/Registry;", "compiler", "Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "port", "", "timer", "Ljava/util/Timer;", "onShutdown", "Lkotlin/Function0;", "", "(Ljava/rmi/registry/Registry;Lorg/jetbrains/kotlin/daemon/CompilerSelector;Lorg/jetbrains/kotlin/daemon/common/CompilerId;Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;ILjava/util/Timer;Lkotlin/jvm/functions/Function0;)V", "getCompiler", "()Lorg/jetbrains/kotlin/daemon/CompilerSelector;", "getDaemonJVMOptions", "()Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "lastUsedSeconds", "", "getLastUsedSeconds", "()J", "getOnShutdown", "()Lkotlin/jvm/functions/Function0;", "getRegistry", "()Ljava/rmi/registry/Registry;", "rwlock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "checkCompilerId", "", "expectedCompilerId", "classesFqNamesByFiles", "Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "", "", "sessionId", "sourceFiles", "Ljava/io/File;", "clearJarCache", "compile", "compilerArguments", "", "compilationOptions", "Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;", "compilationResults", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "(I[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Lorg/jetbrains/kotlin/daemon/common/CompilationResults;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "createCompileServices", "Lorg/jetbrains/kotlin/config/Services;", "facade", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "eventManager", "Lorg/jetbrains/kotlin/daemon/EventManager;", "rpcProfiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "doCompile", "args", "compilerMessagesStreamProxy", "Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;", "serviceOutputStreamProxy", "operationsTracer", "Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;", "body", "Lkotlin/Function3;", "Ljava/io/PrintStream;", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "(I[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;Lkotlin/jvm/functions/Function3;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "getClients", "", "getDaemonInfo", "getDaemonOptions", "getUsedMemory", "gracefulShutdown", "onAnotherThread", "ifAlive", "R", "minAliveness", "Lorg/jetbrains/kotlin/daemon/CompileServiceImplBase$Aliveness;", "ifAliveExclusive", "ifAliveExclusiveUnit", "ifAliveUnit", "initiateElections", "leaseCompileSession", "aliveFlagPath", "leaseReplSession", "templateClasspath", "templateClassName", "(Ljava/lang/String;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilationOptions;Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBase;Ljava/util/List;Ljava/lang/String;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "targetPlatform", "Lorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;", "scriptArgs", "", "scriptArgsTypes", "Ljava/lang/Class;", "compilerMessagesOutputStream", "evalOutputStream", "evalErrorStream", "evalInputStream", "Lorg/jetbrains/kotlin/daemon/common/RemoteInputStream;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;Ljava/util/List;Ljava/lang/String;[Ljava/lang/Object;[Ljava/lang/Class;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteInputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "periodicAndAfterSessionCheck", "periodicSeldomCheck", "registerClient", "", "releaseCompileSession", "releaseReplSession", "remoteCompile", "compilerOutputStream", "outputFormat", "Lorg/jetbrains/kotlin/daemon/common/CompileService$OutputFormat;", "serviceOutputStream", "(ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/CompileService$OutputFormat;Lorg/jetbrains/kotlin/daemon/common/RemoteOutputStream;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)Lorg/jetbrains/kotlin/daemon/common/CompileService$CallResult;", "remoteIncrementalCompile", "compilerOutputFormat", "remoteReplLineCheck", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCheckResult;", "codeLine", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "remoteReplLineCompile", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCompileResult;", "history", "remoteReplLineEval", "Lorg/jetbrains/kotlin/cli/common/repl/ReplEvalResult;", "replCheck", "replStateId", "replCompile", "replCreateState", "Lorg/jetbrains/kotlin/daemon/common/ReplStateFacade;", "scheduleShutdown", "graceful", "shutdown", "shutdownNow", "shutdownWithDelay", "withValidRepl", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/daemon/KotlinJvmReplService;", "Lkotlin/ExtensionFunctionType;", "kotlin-daemon"})
public final class CompileServiceImpl
extends CompileServiceImplBase
implements CompileService {
    @NotNull
    private final Registry registry;
    @NotNull
    private final CompilerSelector compiler;
    @NotNull
    private final DaemonJVMOptions daemonJVMOptions;
    @NotNull
    private final Function0<Unit> onShutdown;
    @NotNull
    private final ReentrantReadWriteLock rwlock;

    public CompileServiceImpl(@NotNull Registry registry, @NotNull CompilerSelector compiler, @NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions, @NotNull DaemonJVMOptions daemonJVMOptions, int port, @NotNull Timer timer, @NotNull Function0<Unit> onShutdown) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkNotNullParameter((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
        Intrinsics.checkNotNullParameter(onShutdown, (String)"onShutdown");
        super(daemonOptions, compilerId, port, timer);
        this.registry = registry;
        this.compiler = compiler;
        this.daemonJVMOptions = daemonJVMOptions;
        this.onShutdown = onShutdown;
        this.rwlock = new ReentrantReadWriteLock();
        try {
            UnicastRemoteObject.unexportObject(this, false);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        Remote remote = UnicastRemoteObject.exportObject(this, port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        if (remote == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.daemon.common.CompileService");
        }
        CompileService stub = (CompileService)remote;
        this.registry.rebind(DaemonParamsKt.getCOMPILER_SERVICE_RMI_NAME(), stub);
    }

    @NotNull
    public final Registry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final CompilerSelector getCompiler() {
        return this.compiler;
    }

    @NotNull
    public final DaemonJVMOptions getDaemonJVMOptions() {
        return this.daemonJVMOptions;
    }

    @NotNull
    public final Function0<Unit> getOnShutdown() {
        return this.onShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final <R> CompileService.CallResult<R> withValidRepl(int sessionId, Function1<? super KotlinJvmReplService, ? extends CompileService.CallResult<? extends R>> body) {
        Object object;
        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2;
        boolean $i$f$withValidRepl = false;
        CompileServiceImplBase this_$iv = this;
        boolean $i$f$withValidReplImpl = false;
        CompileServiceImplBase this_$iv$iv = this_$iv;
        boolean $i$f$withValidClientOrSessionProxy = false;
        if (sessionId == CompileService.Companion.getNO_SESSION()) {
            clientOrSessionProxy2 = null;
        } else {
            clientOrSessionProxy = CompileServiceImplBase.access$getState(this_$iv$iv).getSessions().get(sessionId);
            if (clientOrSessionProxy == null) {
                object = new CompileService.CallResult.Error(Intrinsics.stringPlus((String)"Unknown or invalid session ", (Object)sessionId));
                return object;
            }
            clientOrSessionProxy2 = clientOrSessionProxy;
        }
        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv$iv = clientOrSessionProxy2;
        try {
            Object object2;
            Object object3;
            CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv).incrementAndGet();
            CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv = session$iv$iv;
            boolean bl = false;
            CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy3 = session$iv;
            Object object4 = object3 = clientOrSessionProxy3 == null ? null : clientOrSessionProxy3.getData();
            if (object3 == null) {
                // empty if block
            }
            CompileService.CallResult callResult = (object2 = object3) == null ? null : (CompileService.CallResult)body.invoke(object2);
            clientOrSessionProxy = callResult == null ? (CompileService.CallResult)new CompileService.CallResult.Error(Intrinsics.stringPlus((String)"Not a REPL session ", (Object)sessionId)) : callResult;
            object = clientOrSessionProxy;
            return object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv, CompileServiceImplKt.nowSeconds());
            InlineMarker.finallyEnd((int)1);
        }
    }

    @Override
    protected long getLastUsedSeconds() {
        return this.rwlock.isWriteLocked() || this.rwlock.getReadLockCount() - this.rwlock.getReadHoldCount() > 0 ? CompileServiceImplKt.nowSeconds() : this.get_lastUsedSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<String> getDaemonInfo() {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Dying;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl3 = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl4 = false;
                    callResult3 = new CompileService.CallResult.Good<String>(Intrinsics.stringPlus((String)"Kotlin daemon on port ", (Object)this.getPort()));
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<DaemonOptions> getDaemonOptions() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl3 = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl4 = false;
                    callResult3 = new CompileService.CallResult.Good<DaemonOptions>(this.getDaemonOptions());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<DaemonJVMOptions> getDaemonJVMOptions() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl3 = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl4 = false;
                    this.getLog().info(Intrinsics.stringPlus((String)"getDaemonJVMOptions: ", (Object)this.getDaemonJVMOptions()));
                    callResult3 = new CompileService.CallResult.Good<DaemonJVMOptions>(this.getDaemonJVMOptions());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult registerClient(@Nullable String aliveFlagPath) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl3 = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl4 = false;
                    this.getState().addClient(aliveFlagPath);
                    this.getLog().info(Intrinsics.stringPlus((String)"Registered a client alive file: ", (Object)aliveFlagPath));
                    callResult3 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<List<String>> getClients() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl3 = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl4 = false;
                    callResult3 = new CompileService.CallResult.Good<List<String>>(this.getState().getClientsFlagPaths());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> leaseCompileSession(@Nullable String aliveFlagPath) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl3 = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl4 = false;
                    Integer n = this.getState().getSessions().leaseSession(new CompileServiceImplBase.ClientOrSessionProxy(aliveFlagPath, null, null, 6, null));
                    boolean bl5 = false;
                    boolean bl6 = false;
                    int $this$leaseCompileSession_u24lambda_u2d6_u24lambda_u2d5 = ((Number)n).intValue();
                    boolean bl7 = false;
                    this.getLog().info("leased a new session " + $this$leaseCompileSession_u24lambda_u2d6_u24lambda_u2d5 + ", session alive file: " + aliveFlagPath);
                    Unit unit = Unit.INSTANCE;
                    Integer n2 = n;
                    callResult3 = new CompileService.CallResult.Good<Integer>(n2);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult releaseCompileSession(int sessionId) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl3 = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    int n;
                    int n2;
                    boolean bl4 = false;
                    this.getState().getSessions().remove(sessionId);
                    this.getLog().info(Intrinsics.stringPlus((String)"cleaning after session ", (Object)sessionId));
                    ReentrantReadWriteLock reentrantReadWriteLock2 = this.rwlock;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock2.readLock();
                    int n3 = reentrantReadWriteLock2.getWriteHoldCount() == 0 ? reentrantReadWriteLock2.getReadHoldCount() : 0;
                    boolean bl7 = false;
                    int n4 = 0;
                    n4 = 0;
                    int n5 = n3;
                    while (n4 < n5) {
                        n2 = n4++;
                        n = 0;
                        readLock2.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock2.writeLock();
                    writeLock.lock();
                    try {
                        boolean bl8 = false;
                        this.clearJarCache();
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        n5 = 0;
                        n2 = 0;
                        n2 = 0;
                        n = n3;
                        while (n2 < n) {
                            int n6 = n2++;
                            boolean bl9 = false;
                            readLock2.lock();
                        }
                        writeLock.unlock();
                    }
                    callResult3 = this.postReleaseCompileSession();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkCompilerId(@NotNull CompilerId expectedCompilerId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expectedCompilerId, (String)"expectedCompilerId");
        CharSequence charSequence = this.getCompilerId().getCompilerVersion();
        boolean bl2 = false;
        if (!(charSequence.length() == 0)) {
            if (!Intrinsics.areEqual((Object)this.getCompilerId().getCompilerVersion(), (Object)expectedCompilerId.getCompilerVersion())) return false;
        }
        Iterable $this$all$iv = this.getCompilerId().getCompilerClasspath();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                String it = (String)element$iv;
                boolean bl3 = false;
                if (expectedCompilerId.getCompilerClasspath().contains(it)) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if (this.getClasspathWatcher().isChanged()) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompileService.CallResult<Long> getUsedMemory() {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl3 = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl4 = false;
                    boolean withGC$iv = true;
                    boolean $i$f$usedMemory = false;
                    System.gc();
                    Runtime rt$iv = Runtime.getRuntime();
                    callResult3 = new CompileService.CallResult.Good<Long>(rt$iv.totalMemory() - rt$iv.freeMemory());
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult shutdown() {
        CompileService.CallResult callResult;
        int n;
        int n2;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAliveExclusive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl4 = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl5 = false;
                    this.shutdownWithDelay();
                    callResult3 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl6 = false;
                readLock.lock();
            }
            writeLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Boolean> scheduleShutdown(boolean graceful) {
        CompileService.CallResult callResult;
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl3 = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl4;
                    boolean bl5 = false;
                    if (graceful) {
                        bl4 = this.gracefulShutdown(true);
                    } else {
                        this.shutdownWithDelay();
                        bl4 = true;
                    }
                    boolean res = bl4;
                    callResult3 = new CompileService.CallResult.Good<Boolean>(res);
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    @Override
    @NotNull
    public CompileService.CallResult<Integer> remoteCompile(int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull CompilerCallbackServicesFacade servicesFacade, @NotNull RemoteOutputStream compilerOutputStream, @NotNull CompileService.OutputFormat outputFormat, @NotNull RemoteOutputStream serviceOutputStream, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        Intrinsics.checkNotNullParameter((Object)compilerOutputStream, (String)"compilerOutputStream");
        Intrinsics.checkNotNullParameter((Object)outputFormat, (String)"outputFormat");
        Intrinsics.checkNotNullParameter((Object)serviceOutputStream, (String)"serviceOutputStream");
        return this.doCompile(sessionId, args, compilerOutputStream, serviceOutputStream, operationsTracer, (Function3<? super PrintStream, ? super EventManager, ? super Profiler, ? extends ExitCode>)((Function3)new Function3<PrintStream, EventManager, Profiler, ExitCode>(outputFormat, this, targetPlatform, args, servicesFacade){
            final /* synthetic */ CompileService.OutputFormat $outputFormat;
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ String[] $args;
            final /* synthetic */ CompilerCallbackServicesFacade $servicesFacade;
            {
                this.$outputFormat = $outputFormat;
                this.this$0 = $receiver;
                this.$targetPlatform = $targetPlatform;
                this.$args = $args;
                this.$servicesFacade = $servicesFacade;
                super(3);
            }

            @NotNull
            public final ExitCode invoke(@NotNull PrintStream printStream, @NotNull EventManager eventManager, @NotNull Profiler profiler) {
                ExitCode exitCode;
                Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
                Intrinsics.checkNotNullParameter((Object)eventManager, (String)"eventManager");
                Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
                CompileService.OutputFormat outputFormat = this.$outputFormat;
                int n = remoteCompile.WhenMappings.$EnumSwitchMapping$0[outputFormat.ordinal()];
                switch (n) {
                    case 1: {
                        CLICompiler<?> cLICompiler = this.this$0.getCompiler().get(this.$targetPlatform);
                        String[] stringArray = new String[this.$args.length];
                        System.arraycopy(this.$args, 0, stringArray, 0, this.$args.length);
                        exitCode = cLICompiler.exec(printStream, stringArray);
                        break;
                    }
                    case 2: {
                        CLICompiler<?> cLICompiler = this.this$0.getCompiler().get(this.$targetPlatform);
                        Services services = CompileServiceImpl.access$createCompileServices(this.this$0, this.$servicesFacade, eventManager, profiler);
                        String[] stringArray = new String[this.$args.length];
                        System.arraycopy(this.$args, 0, stringArray, 0, this.$args.length);
                        exitCode = cLICompiler.execAndOutputXml(printStream, services, stringArray);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return exitCode;
            }
        }));
    }

    @Override
    @NotNull
    public CompileService.CallResult<Integer> remoteIncrementalCompile(int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull CompilerCallbackServicesFacade servicesFacade, @NotNull RemoteOutputStream compilerOutputStream, @NotNull CompileService.OutputFormat compilerOutputFormat, @NotNull RemoteOutputStream serviceOutputStream, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        Intrinsics.checkNotNullParameter((Object)compilerOutputStream, (String)"compilerOutputStream");
        Intrinsics.checkNotNullParameter((Object)compilerOutputFormat, (String)"compilerOutputFormat");
        Intrinsics.checkNotNullParameter((Object)serviceOutputStream, (String)"serviceOutputStream");
        return this.doCompile(sessionId, args, compilerOutputStream, serviceOutputStream, operationsTracer, (Function3<? super PrintStream, ? super EventManager, ? super Profiler, ? extends ExitCode>)((Function3)new Function3<PrintStream, EventManager, Profiler, ExitCode>(compilerOutputFormat, this, targetPlatform, servicesFacade, args){
            final /* synthetic */ CompileService.OutputFormat $compilerOutputFormat;
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ CompilerCallbackServicesFacade $servicesFacade;
            final /* synthetic */ String[] $args;
            {
                this.$compilerOutputFormat = $compilerOutputFormat;
                this.this$0 = $receiver;
                this.$targetPlatform = $targetPlatform;
                this.$servicesFacade = $servicesFacade;
                this.$args = $args;
                super(3);
            }

            @NotNull
            public final ExitCode invoke(@NotNull PrintStream printStream, @NotNull EventManager eventManager, @NotNull Profiler profiler) {
                String[] stringArray;
                Services services;
                CLICompiler<?> cLICompiler;
                Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
                Intrinsics.checkNotNullParameter((Object)eventManager, (String)"eventManager");
                Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
                CompileService.OutputFormat outputFormat = this.$compilerOutputFormat;
                int n = remoteIncrementalCompile.WhenMappings.$EnumSwitchMapping$0[outputFormat.ordinal()];
                switch (n) {
                    case 1: {
                        throw new NotImplementedError("Only XML output is supported in remote incremental compilation");
                    }
                    case 2: {
                        cLICompiler = this.this$0.getCompiler().get(this.$targetPlatform);
                        services = CompileServiceImpl.access$createCompileServices(this.this$0, this.$servicesFacade, eventManager, profiler);
                        stringArray = new String[this.$args.length];
                        System.arraycopy(this.$args, 0, stringArray, 0, this.$args.length);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return cLICompiler.execAndOutputXml(printStream, services, stringArray);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<Set<String>> classesFqNamesByFiles(int sessionId, @NotNull Set<? extends File> sourceFiles) {
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        $i$f$ifAlive = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p(this);
        var6_6 = false;
        var7_7 = false;
        var7_8 = var5_5.readLock();
        var7_8.lock();
        try {
            block13: {
                block12: {
                    $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                    this_$iv$iv = this;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block12;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    v0 = new CompileService.CallResult.Dying();
                    break block13;
                }
                try {
                    block14: {
                        $i$a$-ifAlive$default-CompileServiceImpl$classesFqNamesByFiles$1 = false;
                        this_$iv = this;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != CompileService.Companion.getNO_SESSION()) break block14;
                        v1 = null;
                        ** GOTO lbl36
                    }
                    var15_19 = CompileServiceImplBase.access$getState(this_$iv).getSessions().get(sessionId);
                    if (var15_19 == null) {
                        v2 = new CompileService.CallResult.Error(Intrinsics.stringPlus((String)"Unknown or invalid session ", (Object)sessionId));
                    } else {
                        v1 = var15_19;
lbl36:
                        // 2 sources

                        session$iv = v1;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter(this_$iv).incrementAndGet();
                            it = session$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImpl$classesFqNamesByFiles$1$1 = false;
                            var15_19 = new CompileService.CallResult.Good<Set>(ParseFileUtilsKt.classesFqNames(sourceFiles));
                            v2 = var15_19;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var19_24 = v2;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var12_16 = e$iv$iv.getMessage();
                    var19_24 = new CompileService.CallResult.Error(var12_16 == null ? "unknown" : var12_16);
                }
                v0 = var19_24;
            }
            var8_10 = v0;
        }
        finally {
            var7_8.unlock();
        }
        return var8_10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> compile(int sessionId, @NotNull String[] compilerArguments, @NotNull CompilationOptions compilationOptions, @NotNull CompilerServicesFacadeBase servicesFacade, @Nullable CompilationResults compilationResults) {
        block83: {
            block82: {
                Intrinsics.checkNotNullParameter((Object)compilerArguments, (String)"compilerArguments");
                Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
                Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
                this_$iv = this;
                $i$f$compileImpl = false;
                var8_8 = false;
                var9_9 = false;
                $i$a$-run-CompileServiceImplBase$compileImpl$1$iv = false;
                var11_11 = compilationOptions;
                p0 = servicesFacade;
                $i$a$-compileImpl-CompileServiceImpl$compile$2 = false;
                messageCollector$iv = new CompileServicesFacadeMessageCollector((CompilerServicesFacadeBase)p0, (CompilationOptions)p1);
                p1 = compilationOptions;
                p0 = servicesFacade;
                $i$a$-compileImpl-CompileServiceImpl$compile$3 = false;
                daemonReporter$iv = DaemonMessageReporterKt.DaemonMessageReporter((CompilerServicesFacadeBase)p0, (CompilationOptions)p1);
                targetPlatform$iv = compilationOptions.getTargetPlatform();
                CompileServiceImplBase.access$getLog(this_$iv).info(Intrinsics.stringPlus((String)"Starting compilation with args: ", (Object)ArraysKt.joinToString$default((Object[])compilerArguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
                var17_23 = targetPlatform$iv;
                var18_24 = CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$0[var17_23.ordinal()];
                switch (var18_24) {
                    case 1: {
                        v0 = (CLICompiler)new K2JVMCompiler();
                        break;
                    }
                    case 2: {
                        v0 = (CLICompiler)new K2JSCompiler();
                        break;
                    }
                    case 3: {
                        v0 = (CLICompiler)new K2MetadataCompiler();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                compiler$iv = v0;
                k2PlatformArgs$iv = (CommonCompilerArguments)compiler$iv.createArguments();
                ParseCommandLineArgumentsKt.parseCommandLineArguments((List)ArraysKt.asList((Object[])compilerArguments), (CommonToolArguments)((CommonToolArguments)k2PlatformArgs$iv));
                argumentParseError$iv = ParseCommandLineArgumentsKt.validateArguments((ArgumentParseErrors)k2PlatformArgs$iv.getErrors());
                if (argumentParseError$iv == null) break block82;
                MessageCollector.DefaultImpls.report$default((MessageCollector)messageCollector$iv, (CompilerMessageSeverity)CompilerMessageSeverity.ERROR, (String)argumentParseError$iv, null, (int)4, null);
                v1 = new CompileService.CallResult.Good<Integer>(ExitCode.COMPILATION_ERROR.getCode());
                break block83;
            }
            var20_27 = compilationOptions.getCompilerMode();
            var21_28 = CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$1[var20_27.ordinal()];
            block20 : switch (var21_28) {
                case 1: {
                    p0 = (CompilerCallbackServicesFacade)servicesFacade;
                    $i$a$-compileImpl-CompileServiceImpl$compile$1 = false;
                    enabled$iv$iv = p0.hasIncrementalCaches();
                    $i$f$withIC = false;
                    isEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJvm();
                    IncrementalCompilation.setIsEnabledForJvm((boolean)enabled$iv$iv);
                    try {
                        $i$a$-withIC-CompileServiceImplBase$compileImpl$1$1$iv = false;
                        var26_41 = this_$iv;
                        tracer$iv$iv = null;
                        $i$f$doCompile = false;
                        var29_53 = this_$iv$iv;
                        var30_57 = false;
                        var31_61 = false;
                        $this$doCompile_u24lambda_u2d12$iv$iv = var29_53;
                        $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2d12$iv$iv).fine("alive!");
                        this_$iv$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != CompileService.Companion.getNO_SESSION()) ** GOTO lbl70
                        v2 = null;
                        ** GOTO lbl75
lbl70:
                        // 1 sources

                        var36_82 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId);
                        if (var36_82 != null) ** GOTO lbl74
                        v3 = new CompileService.CallResult.Error(Intrinsics.stringPlus((String)"Unknown or invalid session ", (Object)sessionId));
                        ** GOTO lbl190
lbl74:
                        // 1 sources

                        v2 = var36_82;
lbl75:
                        // 2 sources

                        session$iv$iv$iv = v2;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                            it$iv$iv = session$iv$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                            var40_102 = tracer$iv$iv;
                            rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                            eventManager$iv$iv = new EventManagerImpl();
                            try {
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2d12$iv$iv).fine("trying get exitCode");
                                this_$iv$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv;
                                $i$f$checkedCompile = false;
                                try {
                                    var45_131 = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                    obj$iv$iv$iv$iv = null;
                                    $i$f$withMeasure = false;
                                    startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                    $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                    var50_163 = rpcProfiler$iv$iv;
                                    eventManger$iv = eventManager$iv$iv;
                                    $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$1$1$iv = false;
                                    $i$a$-compileImpl-CompileServiceImpl$compile$3 = profiler$iv;
                                    $i$a$-compileImpl-CompileServiceImpl$compile$1 = eventManger$iv;
                                    p0 = (CompilerCallbackServicesFacade)servicesFacade;
                                    $i$a$-compileImpl-CompileServiceImpl$compile$4 = false;
                                    services$iv = this.createCompileServices((CompilerCallbackServicesFacade)p0, (EventManager)p1, (Profiler)p2);
                                    res$iv$iv$iv$iv = compiler$iv.exec(messageCollector$iv, services$iv, (CommonToolArguments)k2PlatformArgs$iv).getCode();
                                    $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                    res$iv$iv$iv = res$iv$iv$iv$iv;
                                    if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                        withGC$iv$iv$iv$iv = false;
                                        $i$f$usedMemory = false;
                                        rt$iv$iv$iv$iv = Runtime.getRuntime();
                                        v4 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                    } else {
                                        v4 = 0L;
                                    }
                                    endMem$iv$iv$iv = v4;
                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(Intrinsics.stringPlus((String)"Done with result ", (Object)res$iv$iv$iv));
                                    if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                        pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                        rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                        v5 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                        rt$iv$iv$iv$iv = "%+d";
                                        var59_200 = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                        var60_206 = false;
                                        v6 = String.format((String)rt$iv$iv$iv$iv, Arrays.copyOf(var59_200, var59_200.length));
                                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"java.lang.String.format(this, *args)");
                                        rt$iv$iv$iv$iv = v5.append(v6).append(" kb)").toString();
                                        var59_201 = false;
                                        var60_206 = false;
                                        it$iv$iv$iv = rt$iv$iv$iv$iv;
                                        $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                        daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                        var59_202 = rpcProfiler$iv$iv.getCounters();
                                        var60_206 = false;
                                        rt$iv$iv$iv$iv = var59_202.entrySet().iterator();
                                        while (rt$iv$iv$iv$iv.hasNext()) {
                                            it$iv$iv$iv = var59_202 = rt$iv$iv$iv$iv.next();
                                            $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                            obj$iv$iv$iv = it$iv$iv$iv.getKey();
                                            $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = var59_202;
                                            var63_223 = false;
                                            counters$iv$iv$iv = (PerfCounters)$i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv.getValue();
                                            $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                            var63_223 = false;
                                            var64_228 = false;
                                            it$iv$iv$iv = $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv;
                                            $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                            daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                        }
                                    }
                                    v7 = res$iv$iv$iv;
                                }
                                catch (Throwable e$iv$iv$iv) {
                                    v8 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                    v9 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                    res$iv$iv$iv = e$iv$iv$iv.getStackTrace();
                                    Intrinsics.checkNotNullExpressionValue((Object)res$iv$iv$iv, (String)"e.stackTrace");
                                    v10 = v9.append(ArraysKt.joinToString$default((Object[])res$iv$iv$iv, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                    if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                        v11 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                        $this$withMeasure$iv$iv$iv$iv = e$iv$iv$iv.getCause();
                                        Intrinsics.checkNotNull((Object)$this$withMeasure$iv$iv$iv$iv);
                                        res$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.getStackTrace();
                                        Intrinsics.checkNotNullExpressionValue((Object)res$iv$iv$iv, (String)"e.cause!!.stackTrace");
                                        v12 = v11.append(ArraysKt.joinToString$default((Object[])res$iv$iv$iv, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                    } else {
                                        v12 = "";
                                    }
                                    v8.log(Level.SEVERE, v10.append(v12).toString());
                                    throw e$iv$iv$iv;
                                }
                                exitCode$iv$iv = ((Number)v7).intValue();
                                exitCode$iv$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                            }
                            finally {
                                eventManager$iv$iv.fireCompilationFinished();
                                this_$iv$iv$iv = tracer$iv$iv;
                            }
                            var36_82 = exitCode$iv$iv;
                            v3 = var36_82;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
lbl190:
                        // 2 sources

                        var68_245 = v3;
                        v1 = var68_245;
                        break;
                    }
                    finally {
                        IncrementalCompilation.setIsEnabledForJvm((boolean)isEnabledBackup$iv$iv);
                    }
                }
                case 2: {
                    enabled$iv$iv = this_$iv;
                    tracer$iv$iv = null;
                    $i$f$doCompile = false;
                    var25_39 = this_$iv$iv;
                    this_$iv$iv = false;
                    tracer$iv$iv = false;
                    $this$doCompile_u24lambda_u2d12$iv$iv = var25_39;
                    $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2d12$iv$iv).fine("alive!");
                    this_$iv$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv;
                    $i$f$withValidClientOrSessionProxy = false;
                    if (sessionId == CompileService.Companion.getNO_SESSION()) {
                        v13 = null;
                    } else {
                        $this$doCompile_u24lambda_u2d12$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId);
                        if ($this$doCompile_u24lambda_u2d12$iv$iv == null) {
                            v1 = new CompileService.CallResult.Error(Intrinsics.stringPlus((String)"Unknown or invalid session ", (Object)sessionId));
                            break;
                        }
                        v13 = $this$doCompile_u24lambda_u2d12$iv$iv;
                    }
                    session$iv$iv$iv = v13;
                    try {
                        CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                        it$iv$iv = session$iv$iv$iv;
                        $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                        var36_84 = tracer$iv$iv;
                        rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                        eventManager$iv$iv = new EventManagerImpl();
                        try {
                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2d12$iv$iv).fine("trying get exitCode");
                            this_$iv$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv;
                            $i$f$checkedCompile = false;
                            try {
                                eventManager$iv$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                obj$iv$iv$iv$iv = null;
                                $i$f$withMeasure = false;
                                startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                obj$iv$iv$iv$iv = rpcProfiler$iv$iv;
                                $noName_0$iv = eventManager$iv$iv;
                                $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$2$iv = false;
                                res$iv$iv$iv$iv = compiler$iv.exec(messageCollector$iv, Services.EMPTY, (CommonToolArguments)k2PlatformArgs$iv).getCode();
                                $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                res$iv$iv$iv = res$iv$iv$iv$iv;
                                if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                    withGC$iv$iv$iv$iv = false;
                                    $i$f$usedMemory = false;
                                    rt$iv$iv$iv$iv = Runtime.getRuntime();
                                    v14 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                } else {
                                    v14 = 0L;
                                }
                                endMem$iv$iv$iv = v14;
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(Intrinsics.stringPlus((String)"Done with result ", (Object)res$iv$iv$iv));
                                if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                    pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                    rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                    v15 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                    rt$iv$iv$iv$iv = "%+d";
                                    services$iv = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                    rt$iv$iv$iv$iv = false;
                                    v16 = String.format((String)rt$iv$iv$iv$iv, Arrays.copyOf(services$iv, services$iv.length));
                                    Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"java.lang.String.format(this, *args)");
                                    rt$iv$iv$iv$iv = v15.append(v16).append(" kb)").toString();
                                    services$iv = false;
                                    rt$iv$iv$iv$iv = false;
                                    it$iv$iv$iv = rt$iv$iv$iv$iv;
                                    $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                    daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                    services$iv = rpcProfiler$iv$iv.getCounters();
                                    rt$iv$iv$iv$iv = false;
                                    rt$iv$iv$iv$iv = services$iv.entrySet().iterator();
                                    while (rt$iv$iv$iv$iv.hasNext()) {
                                        it$iv$iv$iv = services$iv = rt$iv$iv$iv$iv.next();
                                        $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                        obj$iv$iv$iv = it$iv$iv$iv.getKey();
                                        $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = services$iv;
                                        var72_254 = false;
                                        counters$iv$iv$iv = (PerfCounters)$i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv.getValue();
                                        $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                        var72_254 = false;
                                        var59_203 = false;
                                        it$iv$iv$iv = $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv;
                                        $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                        daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                    }
                                }
                                v17 = res$iv$iv$iv;
                            }
                            catch (Throwable e$iv$iv$iv) {
                                v18 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                v19 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                res$iv$iv$iv = e$iv$iv$iv.getStackTrace();
                                Intrinsics.checkNotNullExpressionValue((Object)res$iv$iv$iv, (String)"e.stackTrace");
                                v20 = v19.append(ArraysKt.joinToString$default((Object[])res$iv$iv$iv, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                    v21 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                    $this$withMeasure$iv$iv$iv$iv = e$iv$iv$iv.getCause();
                                    Intrinsics.checkNotNull((Object)$this$withMeasure$iv$iv$iv$iv);
                                    res$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.getStackTrace();
                                    Intrinsics.checkNotNullExpressionValue((Object)res$iv$iv$iv, (String)"e.cause!!.stackTrace");
                                    v22 = v21.append(ArraysKt.joinToString$default((Object[])res$iv$iv$iv, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                } else {
                                    v22 = "";
                                }
                                v18.log(Level.SEVERE, v20.append(v22).toString());
                                throw e$iv$iv$iv;
                            }
                            exitCode$iv$iv = ((Number)v17).intValue();
                            exitCode$iv$iv = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                        }
                        finally {
                            eventManager$iv$iv.fireCompilationFinished();
                            this_$iv$iv$iv = tracer$iv$iv;
                        }
                        $this$doCompile_u24lambda_u2d12$iv$iv = exitCode$iv$iv;
                        v1 = $this$doCompile_u24lambda_u2d12$iv$iv;
                        break;
                    }
                    finally {
                        CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                    }
                }
                case 3: {
                    gradleIncrementalArgs$iv = (IncrementalCompilationOptions)compilationOptions;
                    gradleIncrementalServicesFacade$iv = servicesFacade;
                    var24_37 = targetPlatform$iv;
                    var25_40 = CompileServiceImplBase.WhenMappings.$EnumSwitchMapping$0[var24_37.ordinal()];
                    switch (var25_40) {
                        case 1: {
                            enabled$iv$iv = true;
                            $i$f$withIC = false;
                            isEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJvm();
                            IncrementalCompilation.setIsEnabledForJvm((boolean)enabled$iv$iv);
                            try {
                                $i$a$-withIC$default-CompileServiceImplBase$compileImpl$1$3$iv = false;
                                this_$iv$iv$iv = this_$iv;
                                tracer$iv$iv = null;
                                $i$f$doCompile = false;
                                var33_72 = this_$iv$iv;
                                var34_76 = false;
                                $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                $this$doCompile_u24lambda_u2d12$iv$iv = var33_72;
                                $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2d12$iv$iv).fine("alive!");
                                this_$iv$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv;
                                $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId != CompileService.Companion.getNO_SESSION()) ** GOTO lbl355
                                v23 = null;
                                ** GOTO lbl360
lbl355:
                                // 1 sources

                                e$iv$iv$iv = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId);
                                if (e$iv$iv$iv != null) ** GOTO lbl359
                                v24 = new CompileService.CallResult.Error(Intrinsics.stringPlus((String)"Unknown or invalid session ", (Object)sessionId));
                                ** GOTO lbl481
lbl359:
                                // 1 sources

                                v23 = e$iv$iv$iv;
lbl360:
                                // 2 sources

                                session$iv$iv$iv = v23;
                                try {
                                    CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                    it$iv$iv = session$iv$iv$iv;
                                    $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                    rpc$iv$iv$iv = tracer$iv$iv;
                                    rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                    eventManager$iv$iv = new EventManagerImpl();
                                    try {
                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2d12$iv$iv).fine("trying get exitCode");
                                        this_$iv$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv;
                                        $i$f$checkedCompile = false;
                                        try {
                                            rt$iv$iv$iv$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                            obj$iv$iv$iv$iv = null;
                                            $i$f$withMeasure = false;
                                            startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                            $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                            obj$iv$iv$iv = rpcProfiler$iv$iv;
                                            $noName_0$iv = eventManager$iv$iv;
                                            $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$3$1$iv = false;
                                            v25 = (K2JVMCompilerArguments)k2PlatformArgs$iv;
                                            Intrinsics.checkNotNull((Object)compilationResults);
                                            p2 = gradleIncrementalArgs$iv;
                                            p1 = compilationResults;
                                            p0 = gradleIncrementalServicesFacade$iv;
                                            var83_258 = messageCollector$iv;
                                            var82_260 = gradleIncrementalArgs$iv;
                                            var81_262 = v25;
                                            var80_264 = this_$iv;
                                            $i$a$-compileImpl-CompileServiceImpl$compile$5 = false;
                                            var84_266 = GetICReporterKt.getBuildReporter((CompilerServicesFacadeBase)a, (CompilationResults)b, (IncrementalCompilationOptions)c);
                                            res$iv$iv$iv$iv = CompileServiceImplBase.access$execIncrementalCompiler(var80_264, var81_262, var82_260, var83_258, var84_266).getCode();
                                            $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                            res$iv$iv$iv = res$iv$iv$iv$iv;
                                            if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                withGC$iv$iv$iv$iv = false;
                                                $i$f$usedMemory = false;
                                                rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                v26 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                            } else {
                                                v26 = 0L;
                                            }
                                            endMem$iv$iv$iv = v26;
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(Intrinsics.stringPlus((String)"Done with result ", (Object)res$iv$iv$iv));
                                            if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                v27 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                rt$iv$iv$iv$iv = "%+d";
                                                exitCode$iv$iv = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                var63_224 = false;
                                                v28 = String.format((String)rt$iv$iv$iv$iv, Arrays.copyOf(exitCode$iv$iv, exitCode$iv$iv.length));
                                                Intrinsics.checkNotNullExpressionValue((Object)v28, (String)"java.lang.String.format(this, *args)");
                                                rt$iv$iv$iv$iv = v27.append(v28).append(" kb)").toString();
                                                exitCode$iv$iv = false;
                                                var63_224 = false;
                                                it$iv$iv$iv = rt$iv$iv$iv$iv;
                                                $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                                exitCode$iv$iv = rpcProfiler$iv$iv.getCounters();
                                                var63_224 = false;
                                                rt$iv$iv$iv$iv = exitCode$iv$iv.entrySet().iterator();
                                                while (rt$iv$iv$iv$iv.hasNext()) {
                                                    it$iv$iv$iv = exitCode$iv$iv = rt$iv$iv$iv$iv.next();
                                                    var65_235 = false;
                                                    obj$iv$iv$iv = it$iv$iv$iv.getKey();
                                                    var65_236 = exitCode$iv$iv;
                                                    var66_239 = false;
                                                    counters$iv$iv$iv = (PerfCounters)var65_236.getValue();
                                                    var65_236 = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                    var66_239 = false;
                                                    exitCode$iv$iv = false;
                                                    it$iv$iv$iv = var65_236;
                                                    $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                    daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                                }
                                            }
                                            v29 = res$iv$iv$iv;
                                        }
                                        catch (Throwable e$iv$iv$iv) {
                                            v30 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                            v31 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                            var59_205 = e$iv$iv$iv.getStackTrace();
                                            Intrinsics.checkNotNullExpressionValue((Object)var59_205, (String)"e.stackTrace");
                                            v32 = v31.append(ArraysKt.joinToString$default((Object[])var59_205, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                            if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                v33 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                $this$withMeasure$iv$iv$iv$iv = e$iv$iv$iv.getCause();
                                                Intrinsics.checkNotNull((Object)$this$withMeasure$iv$iv$iv$iv);
                                                var59_205 = $this$withMeasure$iv$iv$iv$iv.getStackTrace();
                                                Intrinsics.checkNotNullExpressionValue((Object)var59_205, (String)"e.cause!!.stackTrace");
                                                v34 = v33.append(ArraysKt.joinToString$default((Object[])var59_205, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                            } else {
                                                v34 = "";
                                            }
                                            v30.log(Level.SEVERE, v32.append(v34).toString());
                                            throw e$iv$iv$iv;
                                        }
                                        exitCode$iv$iv = ((Number)v29).intValue();
                                        var76_273 = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                    }
                                    finally {
                                        eventManager$iv$iv.fireCompilationFinished();
                                        this_$iv$iv$iv = tracer$iv$iv;
                                    }
                                    e$iv$iv$iv = var76_273;
                                    v24 = e$iv$iv$iv;
                                }
                                finally {
                                    CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                }
lbl481:
                                // 2 sources

                                var12_14 = v24;
                                v1 = var12_14;
                                break block20;
                            }
                            finally {
                                IncrementalCompilation.setIsEnabledForJvm((boolean)isEnabledBackup$iv$iv);
                            }
                        }
                        case 2: {
                            $i$f$withJsIC = false;
                            isJsEnabledBackup$iv$iv = IncrementalCompilation.isEnabledForJs();
                            IncrementalCompilation.setIsEnabledForJs((boolean)true);
                            try {
                                $i$a$-withJsIC-CompileServiceImplBase$compileImpl$1$4$iv = false;
                                $i$a$-withIC$default-CompileServiceImplBase$compileImpl$1$3$iv = this_$iv;
                                tracer$iv$iv = null;
                                $i$f$doCompile = false;
                                var32_69 = this_$iv$iv;
                                var33_73 = false;
                                var34_77 = false;
                                $this$doCompile_u24lambda_u2d12$iv$iv = var32_69;
                                $i$a$-run-CompileServiceImplBase$doCompile$1$iv$iv = false;
                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2d12$iv$iv).fine("alive!");
                                this_$iv$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv;
                                $i$f$withValidClientOrSessionProxy = false;
                                if (sessionId != CompileService.Companion.getNO_SESSION()) ** GOTO lbl508
                                v35 = null;
                                ** GOTO lbl513
lbl508:
                                // 1 sources

                                var39_100 = CompileServiceImplBase.access$getState((CompileServiceImplBase)this_$iv$iv$iv).getSessions().get(sessionId);
                                if (var39_100 != null) ** GOTO lbl512
                                v36 = new CompileService.CallResult.Error(Intrinsics.stringPlus((String)"Unknown or invalid session ", (Object)sessionId));
                                ** GOTO lbl634
lbl512:
                                // 1 sources

                                v35 = var39_100;
lbl513:
                                // 2 sources

                                session$iv$iv$iv = v35;
                                try {
                                    CompileServiceImplBase.access$getCompilationsCounter((CompileServiceImplBase)this_$iv$iv$iv).incrementAndGet();
                                    it$iv$iv = session$iv$iv$iv;
                                    $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = false;
                                    $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$doCompile$1$1$iv$iv = tracer$iv$iv;
                                    rpcProfiler$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                    eventManager$iv$iv = new EventManagerImpl();
                                    try {
                                        CompileServiceImplBase.access$getLog((CompileServiceImplBase)$this$doCompile_u24lambda_u2d12$iv$iv).fine("trying get exitCode");
                                        this_$iv$iv$iv = $this$doCompile_u24lambda_u2d12$iv$iv;
                                        $i$f$checkedCompile = false;
                                        try {
                                            e$iv$iv$iv = profiler$iv$iv$iv = this_$iv$iv$iv.getDaemonOptions().getReportPerf() != false ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                            obj$iv$iv$iv$iv = null;
                                            $i$f$withMeasure = false;
                                            startState$iv$iv$iv$iv = $this$withMeasure$iv$iv$iv$iv.beginMeasure(obj$iv$iv$iv$iv);
                                            $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = false;
                                            $i$a$-checkedCompile-CompileServiceImplBase$doCompile$1$1$exitCode$1$iv$iv = rpcProfiler$iv$iv;
                                            $noName_0$iv = eventManager$iv$iv;
                                            $i$a$-doCompile-CompileServiceImplBase$compileImpl$1$4$1$iv = false;
                                            v37 = (K2JSCompilerArguments)k2PlatformArgs$iv;
                                            Intrinsics.checkNotNull((Object)compilationResults);
                                            $i$a$-compileImpl-CompileServiceImpl$compile$5 = gradleIncrementalArgs$iv;
                                            c = compilationResults;
                                            b = gradleIncrementalServicesFacade$iv;
                                            var83_259 = messageCollector$iv;
                                            var82_261 = gradleIncrementalArgs$iv;
                                            var81_263 = v37;
                                            var80_265 = this_$iv;
                                            $i$a$-compileImpl-CompileServiceImpl$compile$5 = false;
                                            var84_267 = GetICReporterKt.getBuildReporter((CompilerServicesFacadeBase)a, (CompilationResults)b, (IncrementalCompilationOptions)c);
                                            res$iv$iv$iv$iv = CompileServiceImplBase.access$execJsIncrementalCompiler(var80_265, var81_263, var82_261, var83_259, var84_267).getCode();
                                            $this$withMeasure$iv$iv$iv$iv.endMeasure(obj$iv$iv$iv$iv, startState$iv$iv$iv$iv);
                                            res$iv$iv$iv = res$iv$iv$iv$iv;
                                            if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                withGC$iv$iv$iv$iv = false;
                                                $i$f$usedMemory = false;
                                                rt$iv$iv$iv$iv = Runtime.getRuntime();
                                                v38 = rt$iv$iv$iv$iv.totalMemory() - rt$iv$iv$iv$iv.freeMemory();
                                            } else {
                                                v38 = 0L;
                                            }
                                            endMem$iv$iv$iv = v38;
                                            CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info(Intrinsics.stringPlus((String)"Done with result ", (Object)res$iv$iv$iv));
                                            if (this_$iv$iv$iv.getDaemonOptions().getReportPerf()) {
                                                pc$iv$iv$iv = profiler$iv$iv$iv.getTotalCounters();
                                                rpc$iv$iv$iv = rpcProfiler$iv$iv.getTotalCounters();
                                                v39 = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getTime())).append(" ms; thread: user ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv$iv$iv.ms(pc$iv$iv$iv.getThreadTime() - pc$iv$iv$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv$iv$iv.getCount()).append(" calls, ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getTime())).append(" ms, thread ").append(this_$iv$iv$iv.ms(rpc$iv$iv$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv$iv$iv.kb(endMem$iv$iv$iv)).append(" kb (");
                                                var71_253 = "%+d";
                                                var61_211 = new Object[]{this_$iv$iv$iv.kb(pc$iv$iv$iv.getMemory())};
                                                exitCode$iv$iv = false;
                                                v40 = String.format((String)var71_253, Arrays.copyOf(var61_211, var61_211.length));
                                                Intrinsics.checkNotNullExpressionValue((Object)v40, (String)"java.lang.String.format(this, *args)");
                                                var71_253 = v39.append(v40).append(" kb)").toString();
                                                var61_212 = false;
                                                exitCode$iv$iv = false;
                                                it$iv$iv$iv = var71_253;
                                                $i$a$-let-CompileServiceImplBase$checkedCompile$1$iv$iv$iv = false;
                                                daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                                CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                                var61_213 = rpcProfiler$iv$iv.getCounters();
                                                exitCode$iv$iv = false;
                                                var71_253 = var61_213.entrySet().iterator();
                                                while (var71_253.hasNext()) {
                                                    it$iv$iv$iv = var61_213 = (Map.Entry)var71_253.next();
                                                    var64_231 = false;
                                                    obj$iv$iv$iv = it$iv$iv$iv.getKey();
                                                    var64_232 = var61_213;
                                                    var65_237 = false;
                                                    counters$iv$iv$iv = (PerfCounters)var64_232.getValue();
                                                    var64_232 = "PERF: rpc by " + obj$iv$iv$iv + ": " + counters$iv$iv$iv.getCount() + " calls, " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getTime()) + " ms, thread " + this_$iv$iv$iv.ms(counters$iv$iv$iv.getThreadTime()) + " ms";
                                                    var65_237 = false;
                                                    var66_240 = false;
                                                    it$iv$iv$iv = var64_232;
                                                    $i$a$-let-CompileServiceImplBase$checkedCompile$2$iv$iv$iv = false;
                                                    daemonReporter$iv.report(ReportSeverity.INFO, (String)it$iv$iv$iv);
                                                    CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv).info((String)it$iv$iv$iv);
                                                }
                                            }
                                            v41 = res$iv$iv$iv;
                                        }
                                        catch (Throwable e$iv$iv$iv) {
                                            v42 = CompileServiceImplBase.access$getLog((CompileServiceImplBase)this_$iv$iv$iv);
                                            v43 = new StringBuilder().append("Exception: ").append(e$iv$iv$iv).append("\n  ");
                                            var72_257 = e$iv$iv$iv.getStackTrace();
                                            Intrinsics.checkNotNullExpressionValue((Object)var72_257, (String)"e.stackTrace");
                                            v44 = v43.append(ArraysKt.joinToString$default((Object[])var72_257, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                            if (e$iv$iv$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv$iv$iv.getCause(), (Object)e$iv$iv$iv)) {
                                                v45 = new StringBuilder().append("\nCaused by: ").append(e$iv$iv$iv.getCause()).append("\n  ");
                                                var48_157 = e$iv$iv$iv.getCause();
                                                Intrinsics.checkNotNull((Object)var48_157);
                                                var72_257 = var48_157.getStackTrace();
                                                Intrinsics.checkNotNullExpressionValue((Object)var72_257, (String)"e.cause!!.stackTrace");
                                                v46 = v45.append(ArraysKt.joinToString$default((Object[])var72_257, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                            } else {
                                                v46 = "";
                                            }
                                            v42.log(Level.SEVERE, v44.append(v46).toString());
                                            throw e$iv$iv$iv;
                                        }
                                        exitCode$iv$iv = ((Number)v41).intValue();
                                        var75_271 = new CompileService.CallResult.Good<Integer>(exitCode$iv$iv);
                                    }
                                    finally {
                                        eventManager$iv$iv.fireCompilationFinished();
                                        var45_135 = tracer$iv$iv;
                                    }
                                    var39_100 = var75_271;
                                    v36 = var39_100;
                                }
                                finally {
                                    CompileServiceImplBase.access$set_lastUsedSeconds((CompileServiceImplBase)this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                                }
lbl634:
                                // 2 sources

                                var76_274 = v36;
                                v1 = var76_274;
                                break block20;
                            }
                            finally {
                                IncrementalCompilation.setIsEnabledForJs((boolean)isJsEnabledBackup$iv$iv);
                            }
                        }
                    }
                    throw new IllegalStateException(Intrinsics.stringPlus((String)"Incremental compilation is not supported for target platform: ", (Object)targetPlatform$iv));
                }
                default: {
                    throw new IllegalStateException(Intrinsics.stringPlus((String)"Unknown compilation mode ", (Object)compilationOptions.getCompilerMode()));
                }
            }
        }
        return v1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> leaseReplSession(@Nullable String aliveFlagPath, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull CompilerCallbackServicesFacade servicesFacade, @NotNull List<? extends File> templateClasspath, @NotNull String templateClassName, @Nullable Object[] scriptArgs, @Nullable Class<? extends Object>[] scriptArgsTypes, @NotNull RemoteOutputStream compilerMessagesOutputStream, @Nullable RemoteOutputStream evalOutputStream, @Nullable RemoteOutputStream evalErrorStream, @Nullable RemoteInputStream evalInputStream, @Nullable RemoteOperationsTracer operationsTracer) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        Intrinsics.checkNotNullParameter(templateClasspath, (String)"templateClasspath");
        Intrinsics.checkNotNullParameter((Object)templateClassName, (String)"templateClassName");
        Intrinsics.checkNotNullParameter((Object)compilerMessagesOutputStream, (String)"compilerMessagesOutputStream");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl3 = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    CompileService.CallResult callResult4;
                    boolean bl4 = false;
                    if (targetPlatform != CompileService.TargetPlatform.JVM) {
                        callResult4 = new CompileService.CallResult.Error("Sorry, only JVM target platform is supported now");
                    } else {
                        Disposable disposable = Disposer.newDisposable();
                        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
                        Disposable disposable2 = disposable;
                        PrintStream compilerMessagesStream = new PrintStream(new BufferedOutputStream(new RemoteOutputStreamClient(compilerMessagesOutputStream, new DummyProfiler()), 4096));
                        KeepFirstErrorMessageCollector messageCollector = new KeepFirstErrorMessageCollector(compilerMessagesStream);
                        KotlinJvmReplService repl = new KotlinJvmReplService(disposable2, this.getPort(), this.getCompilerId(), templateClasspath, templateClassName, messageCollector, operationsTracer);
                        int sessionId = this.getState().getSessions().leaseSession(new CompileServiceImplBase.ClientOrSessionProxy<KotlinJvmReplService>(aliveFlagPath, repl, disposable2));
                        callResult4 = new CompileService.CallResult.Good<Integer>(sessionId);
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    @Override
    @NotNull
    public CompileService.CallResult releaseReplSession(int sessionId) {
        return this.releaseCompileSession(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplCheckResult> remoteReplLineCheck(int sessionId, @NotNull ReplCodeLine codeLine) {
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        var3_3 = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAlive = false;
        var6_6 = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
        var7_7 = false;
        var8_8 = false;
        var8_9 = var6_6.readLock();
        var8_9.lock();
        try {
            block16: {
                block15: {
                    $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                    this_$iv$iv = (CompileServiceImplBase)this_$iv;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block15;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    v0 = new CompileService.CallResult.Dying();
                    break block16;
                }
                try {
                    block17: {
                        $i$a$-ifAlive-CompileServiceImpl$remoteReplLineCheck$1 = false;
                        this_$iv = this;
                        $i$f$withValidRepl = false;
                        this_$iv$iv = this_$iv;
                        $i$f$withValidReplImpl = false;
                        this_$iv$iv$iv = this_$iv$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != CompileService.Companion.getNO_SESSION()) break block17;
                        v1 = null;
                        ** GOTO lbl40
                    }
                    var20_24 = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                    if (var20_24 == null) {
                        v2 = new CompileService.CallResult.Error(Intrinsics.stringPlus((String)"Unknown or invalid session ", (Object)sessionId));
                    } else {
                        v1 = var20_24;
lbl40:
                        // 2 sources

                        session$iv$iv$iv = v1;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                            session$iv$iv = session$iv$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$withValidReplImpl$1$iv$iv = false;
                            var24_29 = session$iv$iv;
                            v3 = var25_30 = var24_29 == null ? null : var24_29.getData();
                            if (var25_30 == null) {
                                // empty if block
                            }
                            if ((var26_31 = var25_30) == null) {
                                v4 = null;
                            } else {
                                $this$remoteReplLineCheck_u24lambda_u2d21_u24lambda_u2d20 = (KotlinJvmReplService)var26_31;
                                $i$a$-withValidRepl-CompileServiceImpl$remoteReplLineCheck$1$1 = false;
                                v4 = new CompileService.CallResult.Good<ReplCheckResult>($this$remoteReplLineCheck_u24lambda_u2d21_u24lambda_u2d20.check(codeLine));
                            }
                            var27_32 = v4;
                            var20_24 = var27_32 == null ? (CompileService.CallResult)new CompileService.CallResult.Error(Intrinsics.stringPlus((String)"Not a REPL session ", (Object)sessionId)) : var27_32;
                            v2 = var20_24;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var29_34 = v2;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var13_17 = e$iv$iv.getMessage();
                    var29_34 = new CompileService.CallResult.Error(var13_17 == null ? "unknown" : var13_17);
                }
                v0 = var29_34;
            }
            var9_11 = v0;
        }
        finally {
            var8_9.unlock();
        }
        return var9_11;
    }

    private final Services createCompileServices(CompilerCallbackServicesFacade facade, EventManager eventManager, Profiler rpcProfiler) {
        Services.Builder builder = new Services.Builder();
        if (facade.hasIncrementalCaches()) {
            builder.register(IncrementalCompilationComponents.class, (Object)new RemoteIncrementalCompilationComponentsClient(facade, rpcProfiler));
        }
        if (facade.hasLookupTracker()) {
            builder.register(LookupTracker.class, (Object)new RemoteLookupTrackerClient(facade, eventManager, rpcProfiler));
        }
        if (facade.hasCompilationCanceledStatus()) {
            builder.register(CompilationCanceledStatus.class, (Object)new RemoteCompilationCanceledStatusClient(facade, rpcProfiler));
        }
        if (facade.hasExpectActualTracker()) {
            builder.register(ExpectActualTracker.class, (Object)new RemoteExpectActualTracker(facade, rpcProfiler));
        }
        if (facade.hasIncrementalResultsConsumer()) {
            builder.register(IncrementalResultsConsumer.class, (Object)new RemoteIncrementalResultsConsumer(facade, eventManager, rpcProfiler));
        }
        if (facade.hasIncrementalDataProvider()) {
            builder.register(IncrementalDataProvider.class, (Object)new RemoteIncrementalDataProvider(facade, rpcProfiler));
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplCompileResult> remoteReplLineCompile(int sessionId, @NotNull ReplCodeLine codeLine, @Nullable List<ReplCodeLine> history) {
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        var4_4 = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAlive = false;
        var7_7 = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
        var8_8 = false;
        var9_9 = false;
        var9_10 = var7_7.readLock();
        var9_10.lock();
        try {
            block16: {
                block15: {
                    $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                    this_$iv$iv = (CompileServiceImplBase)this_$iv;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block15;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    v0 = new CompileService.CallResult.Dying();
                    break block16;
                }
                try {
                    block17: {
                        $i$a$-ifAlive-CompileServiceImpl$remoteReplLineCompile$1 = false;
                        this_$iv = this;
                        $i$f$withValidRepl = false;
                        this_$iv$iv = this_$iv;
                        $i$f$withValidReplImpl = false;
                        this_$iv$iv$iv = this_$iv$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != CompileService.Companion.getNO_SESSION()) break block17;
                        v1 = null;
                        ** GOTO lbl40
                    }
                    var21_24 = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                    if (var21_24 == null) {
                        v2 = new CompileService.CallResult.Error(Intrinsics.stringPlus((String)"Unknown or invalid session ", (Object)sessionId));
                    } else {
                        v1 = var21_24;
lbl40:
                        // 2 sources

                        session$iv$iv$iv = v1;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                            session$iv$iv = session$iv$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$withValidReplImpl$1$iv$iv = false;
                            var25_29 = session$iv$iv;
                            v3 = var26_30 = var25_29 == null ? null : var25_29.getData();
                            if (var26_30 == null) {
                                // empty if block
                            }
                            if ((var27_31 = var26_30) == null) {
                                v4 = null;
                            } else {
                                $this$remoteReplLineCompile_u24lambda_u2d23_u24lambda_u2d22 = (KotlinJvmReplService)var27_31;
                                $i$a$-withValidRepl-CompileServiceImpl$remoteReplLineCompile$1$1 = false;
                                v4 = new CompileService.CallResult.Good<ReplCompileResult>($this$remoteReplLineCompile_u24lambda_u2d23_u24lambda_u2d22.compile(codeLine, history));
                            }
                            var28_32 = v4;
                            var21_24 = var28_32 == null ? (CompileService.CallResult)new CompileService.CallResult.Error(Intrinsics.stringPlus((String)"Not a REPL session ", (Object)sessionId)) : var28_32;
                            v2 = var21_24;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var30_34 = v2;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var32_36 = e$iv$iv.getMessage();
                    var30_34 = new CompileService.CallResult.Error(var32_36 == null ? "unknown" : var32_36);
                }
                v0 = var30_34;
            }
            var10_12 = v0;
        }
        finally {
            var9_10.unlock();
        }
        return var10_12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplEvalResult> remoteReplLineEval(int sessionId, @NotNull ReplCodeLine codeLine, @Nullable List<ReplCodeLine> history) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl3 = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    boolean bl4 = false;
                    callResult3 = new CompileService.CallResult.Error("Eval on daemon is not supported");
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompileService.CallResult<Integer> leaseReplSession(@Nullable String aliveFlagPath, @NotNull String[] compilerArguments, @NotNull CompilationOptions compilationOptions, @NotNull CompilerServicesFacadeBase servicesFacade, @NotNull List<? extends File> templateClasspath, @NotNull String templateClassName) {
        CompileService.CallResult callResult;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)compilerArguments, (String)"compilerArguments");
        Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        Intrinsics.checkNotNullParameter(templateClasspath, (String)"templateClasspath");
        Intrinsics.checkNotNullParameter((Object)templateClassName, (String)"templateClassName");
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl3 = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    CompileService.CallResult callResult4;
                    boolean bl4 = false;
                    if (compilationOptions.getTargetPlatform() != CompileService.TargetPlatform.JVM) {
                        callResult4 = new CompileService.CallResult.Error("Sorry, only JVM target platform is supported now");
                    } else {
                        Disposable disposable = Disposer.newDisposable();
                        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
                        Disposable disposable2 = disposable;
                        CompileServicesFacadeMessageCollector messageCollector = new CompileServicesFacadeMessageCollector(servicesFacade, compilationOptions);
                        KotlinJvmReplService repl = new KotlinJvmReplService(disposable2, this.getPort(), this.getCompilerId(), templateClasspath, templateClassName, messageCollector, null);
                        int sessionId = this.getState().getSessions().leaseSession(new CompileServiceImplBase.ClientOrSessionProxy<KotlinJvmReplService>(aliveFlagPath, repl, disposable2));
                        callResult4 = new CompileService.CallResult.Good<Integer>(sessionId);
                    }
                    callResult3 = callResult4;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplStateFacade> replCreateState(int sessionId) {
        var2_2 = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAlive = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
        var6_6 = false;
        var7_7 = false;
        var7_8 = var5_5.readLock();
        var7_8.lock();
        try {
            block16: {
                block15: {
                    $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                    this_$iv$iv = (CompileServiceImplBase)this_$iv;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block15;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    v0 = new CompileService.CallResult.Dying();
                    break block16;
                }
                try {
                    block17: {
                        $i$a$-ifAlive-CompileServiceImpl$replCreateState$1 = false;
                        this_$iv = this;
                        $i$f$withValidRepl = false;
                        this_$iv$iv = this_$iv;
                        $i$f$withValidReplImpl = false;
                        this_$iv$iv$iv = this_$iv$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != CompileService.Companion.getNO_SESSION()) break block17;
                        v1 = null;
                        ** GOTO lbl39
                    }
                    var19_24 = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                    if (var19_24 == null) {
                        v2 = new CompileService.CallResult.Error(Intrinsics.stringPlus((String)"Unknown or invalid session ", (Object)sessionId));
                    } else {
                        v1 = var19_24;
lbl39:
                        // 2 sources

                        session$iv$iv$iv = v1;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                            session$iv$iv = session$iv$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$withValidReplImpl$1$iv$iv = false;
                            var23_29 = session$iv$iv;
                            v3 = var24_30 = var23_29 == null ? null : var23_29.getData();
                            if (var24_30 == null) {
                                // empty if block
                            }
                            if ((var25_31 = var24_30) == null) {
                                v4 = null;
                            } else {
                                $this$replCreateState_u24lambda_u2d27_u24lambda_u2d26 = (KotlinJvmReplService)var25_31;
                                $i$a$-withValidRepl-CompileServiceImpl$replCreateState$1$1 = false;
                                v4 = new CompileService.CallResult.Good<RemoteReplStateFacadeServer>($this$replCreateState_u24lambda_u2d27_u24lambda_u2d26.createRemoteState(this.getPort()));
                            }
                            var26_32 = v4;
                            var19_24 = var26_32 == null ? (CompileService.CallResult)new CompileService.CallResult.Error(Intrinsics.stringPlus((String)"Not a REPL session ", (Object)sessionId)) : var26_32;
                            v2 = var19_24;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var28_34 = v2;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var13_18 = e$iv$iv.getMessage();
                    var28_34 = new CompileService.CallResult.Error(var13_18 == null ? "unknown" : var13_18);
                }
                v0 = var28_34;
            }
            var8_10 = v0;
        }
        finally {
            var7_8.unlock();
        }
        return var8_10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplCheckResult> replCheck(int sessionId, int replStateId, @NotNull ReplCodeLine codeLine) {
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        var4_4 = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAlive = false;
        var7_7 = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
        var8_8 = false;
        var9_9 = false;
        var9_10 = var7_7.readLock();
        var9_10.lock();
        try {
            block16: {
                block15: {
                    $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                    this_$iv$iv = (CompileServiceImplBase)this_$iv;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block15;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    v0 = new CompileService.CallResult.Dying();
                    break block16;
                }
                try {
                    block17: {
                        $i$a$-ifAlive-CompileServiceImpl$replCheck$1 = false;
                        this_$iv = this;
                        $i$f$withValidRepl = false;
                        this_$iv$iv = this_$iv;
                        $i$f$withValidReplImpl = false;
                        this_$iv$iv$iv = this_$iv$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != CompileService.Companion.getNO_SESSION()) break block17;
                        v1 = null;
                        ** GOTO lbl40
                    }
                    var21_24 = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                    if (var21_24 == null) {
                        v2 = new CompileService.CallResult.Error(Intrinsics.stringPlus((String)"Unknown or invalid session ", (Object)sessionId));
                    } else {
                        v1 = var21_24;
lbl40:
                        // 2 sources

                        session$iv$iv$iv = v1;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                            session$iv$iv = session$iv$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$withValidReplImpl$1$iv$iv = false;
                            var25_29 = session$iv$iv;
                            v3 = var26_30 = var25_29 == null ? null : var25_29.getData();
                            if (var26_30 == null) {
                                // empty if block
                            }
                            if ((var27_31 = var26_30) == null) {
                                v4 = null;
                            } else {
                                $this$replCheck_u24lambda_u2d29_u24lambda_u2d28 = (KotlinJvmReplService)var27_31;
                                $i$a$-withValidRepl-CompileServiceImpl$replCheck$1$1 = false;
                                v4 = $this$replCheck_u24lambda_u2d29_u24lambda_u2d28.withValidReplState(replStateId, (Function1)new Function1<IReplStageState<?>, ReplCheckResult>($this$replCheck_u24lambda_u2d29_u24lambda_u2d28, codeLine){
                                    final /* synthetic */ KotlinJvmReplService $this_anonymous;
                                    final /* synthetic */ ReplCodeLine $codeLine;
                                    {
                                        this.$this_anonymous = $receiver;
                                        this.$codeLine = $codeLine;
                                        super(1);
                                    }

                                    @NotNull
                                    public final ReplCheckResult invoke(@NotNull IReplStageState<?> state) {
                                        Intrinsics.checkNotNullParameter(state, (String)"state");
                                        return this.$this_anonymous.check(state, this.$codeLine);
                                    }
                                });
                            }
                            var28_32 = v4;
                            var21_24 = var28_32 == null ? (CompileService.CallResult<R>)new CompileService.CallResult.Error(Intrinsics.stringPlus((String)"Not a REPL session ", (Object)sessionId)) : var28_32;
                            v2 = var21_24;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var30_34 = v2;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var32_36 = e$iv$iv.getMessage();
                    var30_34 = new CompileService.CallResult.Error(var32_36 == null ? "unknown" : var32_36);
                }
                v0 = var30_34;
            }
            var10_12 = v0;
        }
        finally {
            var9_10.unlock();
        }
        return var10_12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public CompileService.CallResult<ReplCompileResult> replCompile(int sessionId, int replStateId, @NotNull ReplCodeLine codeLine) {
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        var4_4 = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAlive = false;
        var7_7 = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
        var8_8 = false;
        var9_9 = false;
        var9_10 = var7_7.readLock();
        var9_10.lock();
        try {
            block16: {
                block15: {
                    $i$a$-read-CompileServiceImpl$ifAlive$1$iv = false;
                    this_$iv$iv = (CompileServiceImplBase)this_$iv;
                    $i$f$ifAliveChecksImpl = false;
                    curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block15;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    v0 = new CompileService.CallResult.Dying();
                    break block16;
                }
                try {
                    block17: {
                        $i$a$-ifAlive-CompileServiceImpl$replCompile$1 = false;
                        this_$iv = this;
                        $i$f$withValidRepl = false;
                        this_$iv$iv = this_$iv;
                        $i$f$withValidReplImpl = false;
                        this_$iv$iv$iv = this_$iv$iv;
                        $i$f$withValidClientOrSessionProxy = false;
                        if (sessionId != CompileService.Companion.getNO_SESSION()) break block17;
                        v1 = null;
                        ** GOTO lbl40
                    }
                    var21_24 = CompileServiceImplBase.access$getState(this_$iv$iv$iv).getSessions().get(sessionId);
                    if (var21_24 == null) {
                        v2 = new CompileService.CallResult.Error(Intrinsics.stringPlus((String)"Unknown or invalid session ", (Object)sessionId));
                    } else {
                        v1 = var21_24;
lbl40:
                        // 2 sources

                        session$iv$iv$iv = v1;
                        try {
                            CompileServiceImplBase.access$getCompilationsCounter(this_$iv$iv$iv).incrementAndGet();
                            session$iv$iv = session$iv$iv$iv;
                            $i$a$-withValidClientOrSessionProxy-CompileServiceImplBase$withValidReplImpl$1$iv$iv = false;
                            var25_29 = session$iv$iv;
                            v3 = var26_30 = var25_29 == null ? null : var25_29.getData();
                            if (var26_30 == null) {
                                // empty if block
                            }
                            if ((var27_31 = var26_30) == null) {
                                v4 = null;
                            } else {
                                $this$replCompile_u24lambda_u2d31_u24lambda_u2d30 = (KotlinJvmReplService)var27_31;
                                $i$a$-withValidRepl-CompileServiceImpl$replCompile$1$1 = false;
                                v4 = $this$replCompile_u24lambda_u2d31_u24lambda_u2d30.withValidReplState(replStateId, (Function1)new Function1<IReplStageState<?>, ReplCompileResult>($this$replCompile_u24lambda_u2d31_u24lambda_u2d30, codeLine){
                                    final /* synthetic */ KotlinJvmReplService $this_anonymous;
                                    final /* synthetic */ ReplCodeLine $codeLine;
                                    {
                                        this.$this_anonymous = $receiver;
                                        this.$codeLine = $codeLine;
                                        super(1);
                                    }

                                    @NotNull
                                    public final ReplCompileResult invoke(@NotNull IReplStageState<?> state) {
                                        Intrinsics.checkNotNullParameter(state, (String)"state");
                                        return this.$this_anonymous.compile(state, this.$codeLine);
                                    }
                                });
                            }
                            var28_32 = v4;
                            var21_24 = var28_32 == null ? (CompileService.CallResult<R>)new CompileService.CallResult.Error(Intrinsics.stringPlus((String)"Not a REPL session ", (Object)sessionId)) : var28_32;
                            v2 = var21_24;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv$iv$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    var30_34 = v2;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var32_36 = e$iv$iv.getMessage();
                    var30_34 = new CompileService.CallResult.Error(var32_36 == null ? "unknown" : var32_36);
                }
                v0 = var30_34;
            }
            var10_12 = v0;
        }
        finally {
            var9_10.unlock();
        }
        return var10_12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void periodicAndAfterSessionCheck() {
        block24: {
            block23: {
                block22: {
                    block27: {
                        if (this.getState().getDelayedShutdownQueued().get()) {
                            return;
                        }
                        anyDead = this.getState().getSessions().cleanDead() != false || this.getState().cleanDeadClients() != false;
                        var2_2 = this;
                        minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
                        $i$f$ifAliveUnit = false;
                        var5_5 = CompileServiceImpl.access$getRwlock$p(this_$iv);
                        var6_6 = false;
                        var7_7 = false;
                        var7_8 = var5_5.readLock();
                        var7_8.lock();
                        $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = false;
                        this_$iv$iv = this_$iv;
                        $i$f$ifAliveChecksImpl = false;
                        curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                        if (curState$iv$iv >= minAliveness$iv.ordinal()) break block27;
                        CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                        (CompileService.CallResult)new CompileService.CallResult.Dying();
                        ** GOTO lbl64
                    }
                    $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = false;
                    $i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$1 = false;
                    if (this.getState().getAlive().get() != CompileServiceImplBase.Aliveness.LastSession.ordinal() || !this.getState().getSessions().isEmpty()) break block22;
                    this.getLog().info("All sessions finished");
                    this.shutdownWithDelay();
                    var7_8.unlock();
                    return;
                }
                if (this.getState().getAliveClientsCount() != 0) break block23;
                this.getLog().info("No more clients left");
                this.shutdownWithDelay();
                var7_8.unlock();
                return;
            }
            if (this.getRunFile().exists()) break block24;
            this.getLog().info("Run file removed");
            this.shutdownWithDelay();
            var7_8.unlock();
            return;
        }
        try {
            $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = new CompileService.CallResult.Ok();
            {
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    $i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$1 = e$iv$iv.getMessage();
                    $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = new CompileService.CallResult.Error($i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$1 == null ? "unknown" : $i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$1);
                }
            }
lbl64:
            // 3 sources

            $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = Unit.INSTANCE;
        }
        catch (Throwable $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv) {
            throw $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv;
        }
        finally {
            var7_8.unlock();
        }
        this_$iv = this;
        minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        $i$f$ifAliveUnit = false;
        var5_5 = CompileServiceImpl.access$getRwlock$p(this_$iv);
        var6_6 = false;
        var7_9 = false;
        var7_10 = var5_5.readLock();
        var7_10.lock();
        try {
            $i$a$-read-CompileServiceImpl$ifAliveUnit$1$iv = false;
            this_$iv$iv = this_$iv;
            $i$f$ifAliveChecksImpl = false;
            curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                (CompileService.CallResult)new CompileService.CallResult.Dying();
            } else {
                try {
                    $i$a$-ifAliveChecksImpl-CompileServiceImpl$ifAliveUnit$1$1$iv = false;
                    $i$a$-ifAliveUnit-CompileServiceImpl$periodicAndAfterSessionCheck$2 = false;
                    if (this.getDaemonOptions().getAutoshutdownUnusedSeconds() != DaemonParamsKt.getCOMPILE_DAEMON_TIMEOUT_INFINITE_S() && this.getCompilationsCounter().get() == 0 && CompileServiceImplKt.nowSeconds() - this.getLastUsedSeconds() > (long)this.getDaemonOptions().getAutoshutdownUnusedSeconds()) {
                        this.getLog().info("Unused timeout exceeded " + this.getDaemonOptions().getAutoshutdownUnusedSeconds() + 's');
                        this.gracefulShutdown(false);
                    } else if (this.getDaemonOptions().getAutoshutdownIdleSeconds() != DaemonParamsKt.getCOMPILE_DAEMON_TIMEOUT_INFINITE_S() && CompileServiceImplKt.nowSeconds() - this.getLastUsedSeconds() > (long)this.getDaemonOptions().getAutoshutdownIdleSeconds()) {
                        this.getLog().info("Idle timeout exceeded " + this.getDaemonOptions().getAutoshutdownIdleSeconds() + 's');
                        this.gracefulShutdown(false);
                    } else if (anyDead) {
                        this.clearJarCache();
                    }
                    var12_23 = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    var15_29 = e$iv$iv.getMessage();
                    var12_21 = new CompileService.CallResult.Error(var15_29 == null ? "unknown" : var15_29);
                }
            }
            var8_15 = Unit.INSTANCE;
        }
        finally {
            var7_10.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void periodicSeldomCheck() {
        void this_$iv;
        CompileServiceImpl compileServiceImpl = this;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.Alive;
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock reentrantReadWriteLock = ((CompileServiceImpl)this_$iv).rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                try {
                    boolean bl4 = false;
                    boolean bl5 = false;
                    if (this.getClasspathWatcher().isChanged()) {
                        this.getLog().info("Compiler changed.");
                        this.gracefulShutdown(false);
                    }
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string = e$iv$iv.getMessage();
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initiateElections() {
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            CompileServiceImplBase this_$iv$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
            if (curState$iv$iv < minAliveness$iv.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                try {
                    boolean bl4 = false;
                    boolean bl5 = false;
                    this.getLog().info("initiate elections");
                    List aliveWithOpts2 = SequencesKt.toList(ClientUtilsKt.walkDaemons(new File(DaemonParamsKt.getRunFilesPathOrDefault(this.getDaemonOptions())), this.getCompilerId(), this.getRunFile(), (Function2<? super File, ? super Integer, Boolean>)((Function2)new Function2<File, Integer, Boolean>(this){
                        final /* synthetic */ CompileServiceImpl this$0;
                        {
                            this.this$0 = $receiver;
                            super(2);
                        }

                        public final boolean invoke(@NotNull File $noName_0, int p) {
                            Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
                            return p != this.this$0.getPort();
                        }
                    }), (Function2<? super DaemonReportCategory, ? super String, Unit>)((Function2)new Function2<DaemonReportCategory, String, Unit>(this){
                        final /* synthetic */ CompileServiceImpl this$0;
                        {
                            this.this$0 = $receiver;
                            super(2);
                        }

                        public final void invoke(@NotNull DaemonReportCategory $noName_0, @NotNull String msg) {
                            Intrinsics.checkNotNullParameter((Object)((Object)$noName_0), (String)"$noName_0");
                            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                            this.this$0.getLog().info(msg);
                        }
                    })));
                    Object object = new DaemonJVMOptionsMemoryComparator();
                    boolean bl6 = false;
                    object = new Comparator<T>((Comparator)object){
                        final /* synthetic */ Comparator $comparator;
                        {
                            this.$comparator = comparator;
                        }

                        public final int compare(T a, T b) {
                            DaemonWithMetadata it;
                            Comparator comparator = this.$comparator;
                            boolean bl = false;
                            DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)b;
                            Comparator comparator2 = comparator;
                            boolean bl2 = false;
                            DaemonJVMOptions daemonJVMOptions = it.getJvmOptions();
                            it = (DaemonWithMetadata)a;
                            bl2 = false;
                            DaemonJVMOptions daemonJVMOptions2 = it.getJvmOptions();
                            return comparator2.compare(daemonJVMOptions, daemonJVMOptions2);
                        }
                    };
                    Object object2 = new FileAgeComparator();
                    boolean bl7 = false;
                    Comparator comparator = new Comparator<T>((Comparator)object, (Comparator)object2){
                        final /* synthetic */ Comparator $this_thenBy;
                        final /* synthetic */ Comparator $comparator;
                        {
                            this.$this_thenBy = comparator;
                            this.$comparator = comparator2;
                        }

                        public final int compare(T a, T b) {
                            int n;
                            int previousCompare = this.$this_thenBy.compare(a, b);
                            if (previousCompare != 0) {
                                n = previousCompare;
                            } else {
                                DaemonWithMetadata it;
                                Comparator comparator = this.$comparator;
                                boolean bl = false;
                                DaemonWithMetadata daemonWithMetadata = (DaemonWithMetadata)a;
                                Comparator comparator2 = comparator;
                                boolean bl2 = false;
                                File file = it.getRunFile();
                                it = (DaemonWithMetadata)b;
                                bl2 = false;
                                File file2 = it.getRunFile();
                                n = comparator2.compare(file, file2);
                            }
                            return n;
                        }
                    };
                    object = (DaemonWithMetadata)CollectionsKt.maxWithOrNull((Iterable)aliveWithOpts2, (Comparator)comparator);
                    if (object != null) {
                        object2 = object;
                        bl7 = false;
                        boolean bl8 = false;
                        Object bestDaemonWithMetadata = object2;
                        boolean bl9 = false;
                        DaemonJVMOptions fattestOpts = ((DaemonWithMetadata)bestDaemonWithMetadata).getJvmOptions();
                        if (DaemonParamsKt.memorywiseFitsInto(fattestOpts, this.getDaemonJVMOptions()) && new FileAgeComparator().compare(((DaemonWithMetadata)bestDaemonWithMetadata).getRunFile(), this.getRunFile()) < 0) {
                            this.getLog().info("Assuming other daemons have lower prio, taking clients from them and schedule them to shutdown: my runfile: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + ((DaemonWithMetadata)bestDaemonWithMetadata).getRunFile().getName() + " (" + ((DaemonWithMetadata)bestDaemonWithMetadata).getRunFile().lastModified() + ')');
                            Iterable $this$forEach$iv = aliveWithOpts2;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                DaemonWithMetadata $dstr$daemon$runFile$_u24__u24 = (DaemonWithMetadata)element$iv;
                                boolean bl10 = false;
                                CompileService daemon = $dstr$daemon$runFile$_u24__u24.component1();
                                File runFile = $dstr$daemon$runFile$_u24__u24.component2();
                                try {
                                    CompileService.CallResult<List<String>> callResult;
                                    CompileService.CallResult<List<String>> callResult2 = daemon.getClients();
                                    boolean bl11 = false;
                                    boolean bl12 = false;
                                    CompileService.CallResult<List<String>> it = callResult2;
                                    boolean bl13 = false;
                                    CompileService.CallResult<List<String>> callResult3 = callResult = it.isGood() ? callResult2 : null;
                                    if (callResult != null) {
                                        callResult2 = callResult;
                                        bl11 = false;
                                        bl12 = false;
                                        it = callResult2;
                                        boolean bl14 = false;
                                        Iterable $this$forEach$iv2 = it.get();
                                        boolean $i$f$forEach2 = false;
                                        for (Object element$iv2 : $this$forEach$iv2) {
                                            String clientAliveFile = (String)element$iv2;
                                            boolean bl15 = false;
                                            this.registerClient(clientAliveFile);
                                        }
                                    }
                                    daemon.scheduleShutdown(true);
                                }
                                catch (Throwable e) {
                                    this.getLog().info("Cannot connect to a daemon, assuming dying ('" + runFile.getCanonicalPath() + "'): " + e.getMessage());
                                }
                            }
                        } else if (DaemonParamsKt.memorywiseFitsInto(this.getDaemonJVMOptions(), fattestOpts) && new FileAgeComparator().compare(((DaemonWithMetadata)bestDaemonWithMetadata).getRunFile(), this.getRunFile()) > 0) {
                            CompileService.CallResult<List<String>> callResult;
                            this.getLog().info("Assuming other daemons have higher prio, handover clients to it and schedule shutdown: my runfile: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + ((DaemonWithMetadata)bestDaemonWithMetadata).getRunFile().getName() + " (" + ((DaemonWithMetadata)bestDaemonWithMetadata).getRunFile().lastModified() + ')');
                            CompileService.CallResult<List<String>> callResult4 = this.getClients();
                            boolean bl16 = false;
                            boolean bl17 = false;
                            CompileService.CallResult<List<String>> it = callResult4;
                            boolean bl18 = false;
                            CompileService.CallResult<List<String>> callResult5 = callResult = it.isGood() ? callResult4 : null;
                            if (callResult != null) {
                                callResult4 = callResult;
                                bl16 = false;
                                bl17 = false;
                                it = callResult4;
                                boolean bl19 = false;
                                Iterable $this$forEach$iv = it.get();
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    String it2 = (String)element$iv;
                                    boolean bl20 = false;
                                    ((DaemonWithMetadata)bestDaemonWithMetadata).getDaemon().registerClient(it2);
                                }
                            }
                            this.scheduleShutdown(true);
                        } else {
                            this.getLog().info("Assuming other daemons have equal prio, continue: " + this.getRunFile().getName() + " (" + this.getRunFile().lastModified() + ") vs best other runfile: " + ((DaemonWithMetadata)bestDaemonWithMetadata).getRunFile().getName() + " (" + ((DaemonWithMetadata)bestDaemonWithMetadata).getRunFile().lastModified() + ')');
                        }
                    }
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string = e$iv$iv.getMessage();
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    private final void shutdownNow() {
        this.getLog().info("Shutdown started");
        Handler[] handlerArray = Runtime.getRuntime();
        boolean bl = false;
        boolean bl2 = false;
        Handler[] $this$shutdownNow_u24lambda_u2d46 = handlerArray;
        boolean bl3 = false;
        this.getLog().info("Memory stats: total: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u2d46.totalMemory()) + "mb, free: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u2d46.freeMemory()) + "mb, max: " + CompileServiceImpl.shutdownNow$mb($this$shutdownNow_u24lambda_u2d46.maxMemory()) + "mb");
        this.getState().getAlive().set(CompileServiceImplBase.Aliveness.Dying.ordinal());
        UnicastRemoteObject.unexportObject(this, true);
        this.getLog().info("Shutdown complete");
        this.onShutdown.invoke();
        handlerArray = this.getLog().getHandlers();
        Intrinsics.checkNotNullExpressionValue((Object)handlerArray, (String)"log.handlers");
        Object[] $this$forEach$iv = handlerArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Handler it = (Handler)element$iv;
            boolean bl4 = false;
            it.flush();
        }
    }

    private final void shutdownWithDelay() {
        this.getState().getDelayedShutdownQueued().set(true);
        int currentClientsCount = this.getState().getClientsCounter();
        int currentSessionId = this.getState().getSessions().getLastSessionId();
        int currentCompilationsCount = this.getCompilationsCounter().get();
        this.getLog().info("Delayed shutdown in " + this.getDaemonOptions().getShutdownDelayMilliseconds() + "ms");
        Timer timer = this.getTimer();
        long l = this.getDaemonOptions().getShutdownDelayMilliseconds();
        boolean bl = false;
        boolean bl2 = false;
        TimerTask timerTask = new TimerTask(this, currentClientsCount, currentCompilationsCount, currentSessionId){
            final /* synthetic */ CompileServiceImpl this$0;
            final /* synthetic */ int $currentClientsCount$inlined;
            final /* synthetic */ int $currentCompilationsCount$inlined;
            final /* synthetic */ int $currentSessionId$inlined;
            {
                this.this$0 = compileServiceImpl;
                this.$currentClientsCount$inlined = n;
                this.$currentCompilationsCount$inlined = n2;
                this.$currentSessionId$inlined = n3;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void run() {
                TimerTask $this$shutdownWithDelay_u24lambda_u2d49 = this;
                boolean bl = false;
                this.this$0.getState().getDelayedShutdownQueued().set(false);
                if (this.$currentClientsCount$inlined == this.this$0.getState().getClientsCounter() && this.$currentCompilationsCount$inlined == this.this$0.getCompilationsCounter().get() && this.$currentSessionId$inlined == this.this$0.getState().getSessions().getLastSessionId()) {
                    int n;
                    int n2;
                    void this_$iv;
                    CompileServiceImpl compileServiceImpl = this.this$0;
                    CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
                    boolean $i$f$ifAliveExclusiveUnit = false;
                    ReentrantReadWriteLock reentrantReadWriteLock = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                    boolean bl4 = false;
                    int n4 = 0;
                    n4 = 0;
                    int n5 = n3;
                    while (n4 < n5) {
                        n2 = n4++;
                        n = 0;
                        readLock.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    writeLock.lock();
                    try {
                        boolean bl5 = false;
                        CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
                        boolean $i$f$ifAliveChecksImpl = false;
                        int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                        if (curState$iv$iv < minAliveness$iv.ordinal()) {
                            CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                            CompileService.CallResult cfr_ignored_0 = (CompileService.CallResult)new CompileService.CallResult.Dying();
                        } else {
                            CompileService.CallResult callResult;
                            try {
                                boolean bl6 = false;
                                boolean bl7 = false;
                                this.this$0.getLog().fine("Execute delayed shutdown");
                                CompileServiceImpl.access$shutdownNow(this.this$0);
                                callResult = new CompileService.CallResult.Ok();
                            }
                            catch (Throwable e$iv$iv) {
                                CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                                String string = e$iv$iv.getMessage();
                                callResult = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        n5 = 0;
                        n2 = 0;
                        n2 = 0;
                        n = n3;
                        while (n2 < n) {
                            int n6 = n2++;
                            boolean bl8 = false;
                            readLock.lock();
                        }
                        writeLock.unlock();
                    }
                }
                this.this$0.getLog().info("Cancel delayed shutdown due to a new activity");
            }
        };
        timer.schedule(timerTask, l);
    }

    private final boolean gracefulShutdown(boolean onAnotherThread) {
        if (!this.getState().getAlive().compareAndSet(CompileServiceImplBase.Aliveness.Alive.ordinal(), CompileServiceImplBase.Aliveness.LastSession.ordinal())) {
            this.getLog().info(Intrinsics.stringPlus((String)"Invalid state for graceful shutdown: ", (Object)this.toAlivenessName(this.getState().getAlive().get())));
            return false;
        }
        this.getLog().info("Graceful shutdown signalled");
        if (!onAnotherThread) {
            CompileServiceImpl.gracefulShutdown$shutdownIfIdle(this);
        } else {
            Timer timer = this.getTimer();
            long l = 1L;
            boolean bl = false;
            boolean bl2 = false;
            TimerTask timerTask = new TimerTask(this){
                final /* synthetic */ CompileServiceImpl this$0;
                {
                    this.this$0 = compileServiceImpl;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public void run() {
                    int n;
                    int n2;
                    void this_$iv;
                    TimerTask $this$gracefulShutdown_u24lambda_u2d51 = this;
                    boolean bl = false;
                    CompileServiceImpl compileServiceImpl = this.this$0;
                    CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
                    boolean $i$f$ifAliveExclusiveUnit = false;
                    ReentrantReadWriteLock reentrantReadWriteLock = CompileServiceImpl.access$getRwlock$p((CompileServiceImpl)this_$iv);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                    boolean bl4 = false;
                    int n4 = 0;
                    n4 = 0;
                    int n5 = n3;
                    while (n4 < n5) {
                        n2 = n4++;
                        n = 0;
                        readLock.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    writeLock.lock();
                    try {
                        boolean bl5 = false;
                        CompileServiceImplBase this_$iv$iv = (CompileServiceImplBase)this_$iv;
                        boolean $i$f$ifAliveChecksImpl = false;
                        int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                        if (curState$iv$iv < minAliveness$iv.ordinal()) {
                            CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                            CompileService.CallResult cfr_ignored_0 = (CompileService.CallResult)new CompileService.CallResult.Dying();
                        } else {
                            CompileService.CallResult callResult;
                            try {
                                boolean bl6 = false;
                                boolean bl7 = false;
                                CompileServiceImpl.access$gracefulShutdown$shutdownIfIdle$s62387810(this.this$0);
                                callResult = new CompileService.CallResult.Ok();
                            }
                            catch (Throwable e$iv$iv) {
                                CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                                String string = e$iv$iv.getMessage();
                                callResult = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                            }
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        n5 = 0;
                        n2 = 0;
                        n2 = 0;
                        n = n3;
                        while (n2 < n) {
                            int n6 = n2++;
                            boolean bl8 = false;
                            readLock.lock();
                        }
                        writeLock.unlock();
                    }
                }
            };
            timer.schedule(timerTask, l);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CompileService.CallResult<Integer> doCompile(int sessionId, String[] args, RemoteOutputStream compilerMessagesStreamProxy, RemoteOutputStream serviceOutputStreamProxy, RemoteOperationsTracer operationsTracer, Function3<? super PrintStream, ? super EventManager, ? super Profiler, ? extends ExitCode> body) {
        CompileService.CallResult callResult;
        CompileServiceImplBase.Aliveness minAliveness$iv = CompileServiceImplBase.Aliveness.LastSession;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            block27: {
                CompileService.CallResult callResult3;
                CompileServiceImplBase this_$iv$iv;
                block26: {
                    boolean bl3 = false;
                    this_$iv$iv = this;
                    boolean $i$f$ifAliveChecksImpl = false;
                    int curState$iv$iv = CompileServiceImplBase.access$getState(this_$iv$iv).getAlive().get();
                    if (curState$iv$iv >= minAliveness$iv.ordinal()) break block26;
                    CompileServiceImplBase.access$getLog(this_$iv$iv).info("Cannot perform operation, requested state: " + minAliveness$iv.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv$iv, curState$iv$iv));
                    callResult2 = new CompileService.CallResult.Dying();
                    break block27;
                }
                try {
                    Object object;
                    block24: {
                        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy;
                        CompileServiceImplBase.ClientOrSessionProxy<Object> clientOrSessionProxy2;
                        CompileServiceImplBase this_$iv;
                        block29: {
                            block30: {
                                block28: {
                                    boolean bl4 = false;
                                    this_$iv = this;
                                    boolean $i$f$withValidClientOrSessionProxy = false;
                                    if (sessionId != CompileService.Companion.getNO_SESSION()) break block28;
                                    clientOrSessionProxy2 = null;
                                    break block29;
                                }
                                clientOrSessionProxy = CompileServiceImplBase.access$getState(this_$iv).getSessions().get(sessionId);
                                if (clientOrSessionProxy != null) break block30;
                                object = new CompileService.CallResult.Error(Intrinsics.stringPlus((String)"Unknown or invalid session ", (Object)sessionId));
                                break block24;
                            }
                            clientOrSessionProxy2 = clientOrSessionProxy;
                        }
                        CompileServiceImplBase.ClientOrSessionProxy<Object> session$iv = clientOrSessionProxy2;
                        try {
                            Unit unit;
                            RemoteOperationsTracer remoteOperationsTracer;
                            CompileService.CallResult.Good<Integer> good;
                            block23: {
                                Unit unit2;
                                CompileServiceImplBase.access$getCompilationsCounter(this_$iv).incrementAndGet();
                                CompileServiceImplBase.ClientOrSessionProxy<Object> it = session$iv;
                                boolean bl5 = false;
                                RemoteOperationsTracer remoteOperationsTracer2 = operationsTracer;
                                if (remoteOperationsTracer2 == null) {
                                    unit2 = null;
                                } else {
                                    remoteOperationsTracer2.before("compile");
                                    unit2 = Unit.INSTANCE;
                                }
                                Profiler rpcProfiler = this.getDaemonOptions().getReportPerf() ? (Profiler)new WallAndThreadTotalProfiler() : (Profiler)new DummyProfiler();
                                EventManagerImpl eventManger = new EventManagerImpl();
                                PrintStream compilerMessagesStream = new PrintStream(new BufferedOutputStream(new RemoteOutputStreamClient(compilerMessagesStreamProxy, rpcProfiler), 4096));
                                PrintStream serviceOutputStream = new PrintStream(new BufferedOutputStream(new RemoteOutputStreamClient(serviceOutputStreamProxy, rpcProfiler), 4096));
                                try {
                                    Integer n;
                                    DaemonMessageReporterPrintStreamAdapter compileServiceReporter = new DaemonMessageReporterPrintStreamAdapter(serviceOutputStream);
                                    if (ArraysKt.none((Object[])args)) {
                                        throw new IllegalArgumentException("Error: empty arguments list.");
                                    }
                                    this.getLog().info(Intrinsics.stringPlus((String)"Starting compilation with args: ", (Object)ArraysKt.joinToString$default((Object[])args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
                                    CompileServiceImplBase this_$iv2 = this;
                                    boolean $i$f$checkedCompile = false;
                                    try {
                                        long l;
                                        void $this$withMeasure$iv$iv;
                                        Profiler profiler$iv;
                                        Profiler profiler = profiler$iv = this_$iv2.getDaemonOptions().getReportPerf() ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
                                        Object obj$iv$iv = null;
                                        boolean $i$f$withMeasure = false;
                                        List<Long> startState$iv$iv = $this$withMeasure$iv$iv.beginMeasure(obj$iv$iv);
                                        boolean bl6 = false;
                                        Integer res$iv$iv = ((ExitCode)body.invoke((Object)compilerMessagesStream, (Object)eventManger, (Object)rpcProfiler)).getCode();
                                        $this$withMeasure$iv$iv.endMeasure(obj$iv$iv, startState$iv$iv);
                                        Integer res$iv = res$iv$iv;
                                        if (this_$iv2.getDaemonOptions().getReportPerf()) {
                                            boolean withGC$iv$iv = false;
                                            boolean $i$f$usedMemory = false;
                                            Runtime rt$iv$iv = Runtime.getRuntime();
                                            l = rt$iv$iv.totalMemory() - rt$iv$iv.freeMemory();
                                        } else {
                                            l = 0L;
                                        }
                                        long endMem$iv = l;
                                        CompileServiceImplBase.access$getLog(this_$iv2).info(Intrinsics.stringPlus((String)"Done with result ", (Object)res$iv));
                                        if (this_$iv2.getDaemonOptions().getReportPerf()) {
                                            PerfCounters pc$iv = profiler$iv.getTotalCounters();
                                            PerfCounters rpc$iv = rpcProfiler.getTotalCounters();
                                            StringBuilder stringBuilder = new StringBuilder().append("PERF: Compile on daemon: ").append(this_$iv2.ms(pc$iv.getTime())).append(" ms; thread: user ").append(this_$iv2.ms(pc$iv.getThreadUserTime())).append(" ms, sys ").append(this_$iv2.ms(pc$iv.getThreadTime() - pc$iv.getThreadUserTime())).append(" ms; rpc: ").append(rpc$iv.getCount()).append(" calls, ").append(this_$iv2.ms(rpc$iv.getTime())).append(" ms, thread ").append(this_$iv2.ms(rpc$iv.getThreadTime())).append(" ms; memory: ").append(this_$iv2.kb(endMem$iv)).append(" kb (");
                                            Object object2 = "%+d";
                                            Object[] objectArray = new Object[]{this_$iv2.kb(pc$iv.getMemory())};
                                            boolean bl7 = false;
                                            String string = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(this, *args)");
                                            object2 = stringBuilder.append(string).append(" kb)").toString();
                                            boolean bl8 = false;
                                            bl7 = false;
                                            Object it$iv = object2;
                                            boolean bl9 = false;
                                            ((DaemonMessageReporter)compileServiceReporter).report(ReportSeverity.INFO, (String)it$iv);
                                            CompileServiceImplBase.access$getLog(this_$iv2).info((String)it$iv);
                                            Object object3 = rpcProfiler.getCounters();
                                            bl7 = false;
                                            object2 = object3.entrySet().iterator();
                                            while (object2.hasNext()) {
                                                it$iv = object3 = (Map.Entry)object2.next();
                                                boolean bl10 = false;
                                                Object obj$iv = it$iv.getKey();
                                                Object object4 = object3;
                                                boolean bl11 = false;
                                                PerfCounters counters$iv = (PerfCounters)object4.getValue();
                                                object4 = "PERF: rpc by " + obj$iv + ": " + counters$iv.getCount() + " calls, " + this_$iv2.ms(counters$iv.getTime()) + " ms, thread " + this_$iv2.ms(counters$iv.getThreadTime()) + " ms";
                                                bl11 = false;
                                                boolean bl12 = false;
                                                Object it$iv2 = object4;
                                                boolean bl13 = false;
                                                ((DaemonMessageReporter)compileServiceReporter).report(ReportSeverity.INFO, (String)it$iv2);
                                                CompileServiceImplBase.access$getLog(this_$iv2).info((String)it$iv2);
                                            }
                                        }
                                        n = res$iv;
                                    }
                                    catch (Throwable e$iv) {
                                        String string;
                                        Logger logger = CompileServiceImplBase.access$getLog(this_$iv2);
                                        StringBuilder stringBuilder = new StringBuilder().append("Exception: ").append(e$iv).append("\n  ");
                                        StackTraceElement[] stackTraceElementArray = e$iv.getStackTrace();
                                        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"e.stackTrace");
                                        StringBuilder stringBuilder2 = stringBuilder.append(ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null));
                                        if (e$iv.getCause() != null && !Intrinsics.areEqual((Object)e$iv.getCause(), (Object)e$iv)) {
                                            StringBuilder stringBuilder3 = new StringBuilder().append("\nCaused by: ").append(e$iv.getCause()).append("\n  ");
                                            Throwable throwable = e$iv.getCause();
                                            Intrinsics.checkNotNull((Object)throwable);
                                            stackTraceElementArray = throwable.getStackTrace();
                                            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"e.cause!!.stackTrace");
                                            string = stringBuilder3.append(ArraysKt.joinToString$default((Object[])stackTraceElementArray, (CharSequence)"\n  ", null, null, (int)0, null, null, (int)62, null)).toString();
                                        } else {
                                            string = "";
                                        }
                                        logger.log(Level.SEVERE, stringBuilder2.append(string).toString());
                                        throw e$iv;
                                    }
                                    int exitCode = ((Number)n).intValue();
                                    good = new CompileService.CallResult.Good<Integer>(exitCode);
                                    serviceOutputStream.flush();
                                    compilerMessagesStream.flush();
                                    eventManger.fireCompilationFinished();
                                    remoteOperationsTracer = operationsTracer;
                                    if (remoteOperationsTracer != null) break block23;
                                    unit = null;
                                }
                                catch (Throwable throwable) {
                                    Unit unit3;
                                    serviceOutputStream.flush();
                                    compilerMessagesStream.flush();
                                    eventManger.fireCompilationFinished();
                                    RemoteOperationsTracer remoteOperationsTracer3 = operationsTracer;
                                    if (remoteOperationsTracer3 == null) {
                                        unit3 = null;
                                    } else {
                                        remoteOperationsTracer3.after("compile");
                                        unit3 = Unit.INSTANCE;
                                    }
                                    throw throwable;
                                }
                            }
                            remoteOperationsTracer.after("compile");
                            unit = Unit.INSTANCE;
                            clientOrSessionProxy = good;
                            object = clientOrSessionProxy;
                        }
                        finally {
                            CompileServiceImplBase.access$set_lastUsedSeconds(this_$iv, CompileServiceImplKt.nowSeconds());
                        }
                    }
                    callResult3 = object;
                }
                catch (Throwable e$iv$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv$iv).log(Level.SEVERE, "Exception", e$iv$iv);
                    String string = e$iv$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            readLock.unlock();
        }
        return callResult;
    }

    @Override
    public void clearJarCache() {
        CoreJarFileSystem coreJarFileSystem;
        ZipHandler.clearFileAccessorCache();
        KotlinCoreApplicationEnvironment kotlinCoreApplicationEnvironment = KotlinCoreEnvironment.Companion.getApplicationEnvironment();
        VirtualFileSystem virtualFileSystem = kotlinCoreApplicationEnvironment == null ? null : kotlinCoreApplicationEnvironment.getJarFileSystem();
        CoreJarFileSystem coreJarFileSystem2 = coreJarFileSystem = virtualFileSystem instanceof CoreJarFileSystem ? (CoreJarFileSystem)virtualFileSystem : null;
        if (coreJarFileSystem != null) {
            coreJarFileSystem.clearHandlersCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> CompileService.CallResult<R> ifAlive(CompileServiceImplBase.Aliveness minAliveness, Function0<? extends CompileService.CallResult<? extends R>> body) {
        CompileService.CallResult callResult;
        boolean $i$f$ifAlive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl3 = false;
            CompileServiceImplBase this_$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    String string = e$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ CompileService.CallResult ifAlive$default(CompileServiceImpl this_, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        CompileService.CallResult callResult;
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAlive = false;
        object = this_.rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        readLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl3 = false;
            CompileServiceImplBase this_$iv = this_;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    String string = e$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ifAliveUnit(CompileServiceImplBase.Aliveness minAliveness, Function0<Unit> body) {
        boolean $i$f$ifAliveUnit = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            CompileServiceImplBase this_$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                try {
                    boolean bl4 = false;
                    body.invoke();
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    String string = e$iv.getMessage();
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void ifAliveUnit$default(CompileServiceImpl this_, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveUnit = false;
        object = this_.rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        readLock.lock();
        try {
            boolean bl3 = false;
            CompileServiceImplBase this_$iv = this_;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                try {
                    boolean bl4 = false;
                    body.invoke();
                    CompileService.CallResult callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    String string = e$iv.getMessage();
                    CompileService.CallResult callResult = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            readLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> CompileService.CallResult<R> ifAliveExclusive(CompileServiceImplBase.Aliveness minAliveness, Function0<? extends CompileService.CallResult<? extends R>> body) {
        CompileService.CallResult callResult;
        int n;
        int n2;
        boolean $i$f$ifAliveExclusive = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl4 = false;
            CompileServiceImplBase this_$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    String string = e$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl5 = false;
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ CompileService.CallResult ifAliveExclusive$default(CompileServiceImpl this_, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        CompileService.CallResult callResult;
        int n2;
        int n3;
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveExclusive = false;
        object = this_.rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n4 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        boolean bl3 = false;
        int n5 = 0;
        n5 = 0;
        int n6 = n4;
        while (n5 < n6) {
            n3 = n5++;
            n2 = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            CompileService.CallResult callResult2;
            boolean bl4 = false;
            CompileServiceImplBase this_$iv = this_;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                callResult2 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult3;
                try {
                    callResult3 = (CompileService.CallResult)body.invoke();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    String string = e$iv.getMessage();
                    callResult3 = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
                callResult2 = callResult3;
            }
            callResult = callResult2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            n6 = 0;
            n3 = 0;
            n3 = 0;
            n2 = n4;
            while (n3 < n2) {
                int n7 = n3++;
                boolean bl5 = false;
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
        return callResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ifAliveExclusiveUnit(CompileServiceImplBase.Aliveness minAliveness, Function0<Unit> body) {
        int n;
        int n2;
        boolean $i$f$ifAliveExclusiveUnit = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        boolean bl3 = false;
        int n4 = 0;
        n4 = 0;
        int n5 = n3;
        while (n4 < n5) {
            n2 = n4++;
            n = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            CompileServiceImplBase this_$iv = this;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult;
                try {
                    boolean bl5 = false;
                    body.invoke();
                    callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    String string = e$iv.getMessage();
                    callResult = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            n5 = 0;
            n2 = 0;
            n2 = 0;
            n = n3;
            while (n2 < n) {
                int n6 = n2++;
                boolean bl6 = false;
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void ifAliveExclusiveUnit$default(CompileServiceImpl this_, CompileServiceImplBase.Aliveness minAliveness, Function0 body, int n, Object object) {
        int n2;
        int n3;
        if ((n & 1) != 0) {
            minAliveness = CompileServiceImplBase.Aliveness.LastSession;
        }
        boolean $i$f$ifAliveExclusiveUnit = false;
        object = this_.rwlock;
        boolean bl = false;
        boolean bl2 = false;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n4 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        boolean bl3 = false;
        int n5 = 0;
        n5 = 0;
        int n6 = n4;
        while (n5 < n6) {
            n3 = n5++;
            n2 = 0;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            boolean bl4 = false;
            CompileServiceImplBase this_$iv = this_;
            boolean $i$f$ifAliveChecksImpl = false;
            int curState$iv = CompileServiceImplBase.access$getState(this_$iv).getAlive().get();
            if (curState$iv < minAliveness.ordinal()) {
                CompileServiceImplBase.access$getLog(this_$iv).info("Cannot perform operation, requested state: " + minAliveness.name() + " > actual: " + CompileServiceImplBase.access$toAlivenessName(this_$iv, curState$iv));
                CompileService.CallResult cfr_ignored_0 = new CompileService.CallResult.Dying();
            } else {
                CompileService.CallResult callResult;
                try {
                    boolean bl5 = false;
                    body.invoke();
                    callResult = new CompileService.CallResult.Ok();
                }
                catch (Throwable e$iv) {
                    CompileServiceImplBase.access$getLog(this_$iv).log(Level.SEVERE, "Exception", e$iv);
                    String string = e$iv.getMessage();
                    callResult = new CompileService.CallResult.Error(string == null ? "unknown" : string);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            n6 = 0;
            n3 = 0;
            n3 = 0;
            n2 = n4;
            while (n3 < n2) {
                int n7 = n3++;
                boolean bl6 = false;
                readLock.lock();
            }
            writeLock.unlock();
            InlineMarker.finallyEnd((int)1);
        }
    }

    private static final long shutdownNow$mb(long $this$shutdownNow_u24mb) {
        return $this$shutdownNow_u24mb / (long)0x100000;
    }

    private static final void gracefulShutdown$shutdownIfIdle(CompileServiceImpl this$0) {
        if (this$0.getState().getSessions().isEmpty()) {
            this$0.shutdownWithDelay();
        } else {
            this$0.getDaemonOptions().setAutoshutdownIdleSeconds((int)TimeUnit.MILLISECONDS.toSeconds(this$0.getDaemonOptions().getForceShutdownTimeoutMilliseconds()));
            this$0.getDaemonOptions().setAutoshutdownUnusedSeconds(this$0.getDaemonOptions().getAutoshutdownIdleSeconds());
            this$0.getLog().info("Some sessions are active, waiting for them to finish");
            this$0.getLog().info("Unused/idle timeouts are set to " + this$0.getDaemonOptions().getAutoshutdownUnusedSeconds() + '/' + this$0.getDaemonOptions().getAutoshutdownIdleSeconds() + 's');
        }
    }

    public static final /* synthetic */ Services access$createCompileServices(CompileServiceImpl $this, CompilerCallbackServicesFacade facade, EventManager eventManager, Profiler rpcProfiler) {
        return $this.createCompileServices(facade, eventManager, rpcProfiler);
    }

    public static final /* synthetic */ void access$shutdownNow(CompileServiceImpl $this) {
        $this.shutdownNow();
    }

    public static final /* synthetic */ void access$gracefulShutdown$shutdownIfIdle$s62387810(CompileServiceImpl this$0) {
        CompileServiceImpl.gracefulShutdown$shutdownIfIdle(this$0);
    }
}

