/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.fir.FirLightSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKt;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u0011H\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\u00020\u0006*\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeArgumentsNotAllowedExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "hasAnyArguments", "", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "tree", "Lorg/jetbrains/kotlin/com/intellij/util/diff/FlyweightCapableTreeStructure;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "report", "source", "checkers"})
public final class FirTypeArgumentsNotAllowedExpressionChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirTypeArgumentsNotAllowedExpressionChecker INSTANCE = new FirTypeArgumentsNotAllowedExpressionChecker();

    private FirTypeArgumentsNotAllowedExpressionChecker() {
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirSourceElement firSourceElement;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirExpression explicitReceiver = expression2.getExplicitReceiver();
        if (explicitReceiver instanceof FirResolvedQualifier && ((FirResolvedQualifier)explicitReceiver).getSymbol() == null && Intrinsics.areEqual((Object)((firSourceElement = explicitReceiver.getSource()) == null ? null : Boolean.valueOf(this.hasAnyArguments(firSourceElement))), (Object)true)) {
            this.report(reporter, explicitReceiver.getSource());
            return;
        }
    }

    private final boolean hasAnyArguments(FirSourceElement $this$hasAnyArguments) {
        PsiElement localPsi = FirSourceElementKt.getPsi($this$hasAnyArguments);
        LighterASTNode localLight = $this$hasAnyArguments.getLighterASTNode();
        if (localPsi != null && !(localPsi instanceof PsiErrorElement)) {
            return this.hasAnyArguments(localPsi);
        }
        if ($this$hasAnyArguments instanceof FirLightSourceElement) {
            return this.hasAnyArguments(localLight, $this$hasAnyArguments.getTreeStructure());
        }
        return false;
    }

    private final boolean hasAnyArguments(PsiElement $this$hasAnyArguments) {
        PsiElement[] children2 = $this$hasAnyArguments.getChildren();
        return children2.length > 1 && children2[1] instanceof KtTypeArgumentList;
    }

    private final boolean hasAnyArguments(LighterASTNode $this$hasAnyArguments, FlyweightCapableTreeStructure<LighterASTNode> tree) {
        LighterASTNode lighterASTNode2;
        int n;
        List<LighterASTNode> children2 = SourceHelpersKt.getChildren($this$hasAnyArguments, tree);
        Iterable $this$count$iv = children2;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                LighterASTNode it = (LighterASTNode)element$iv;
                boolean bl = false;
                if (!(it != null)) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n > 1 && Intrinsics.areEqual((Object)((lighterASTNode2 = children2.get(1)) == null ? null : lighterASTNode2.getTokenType()), (Object)KtNodeTypes.TYPE_ARGUMENT_LIST);
    }

    private final void report(DiagnosticReporter $this$report, FirSourceElement source) {
        FirSourceElement firSourceElement = source;
        if (firSourceElement != null) {
            FirSourceElement firSourceElement2 = firSourceElement;
            boolean bl = false;
            boolean bl2 = false;
            FirSourceElement it = firSourceElement2;
            boolean bl3 = false;
            $this$report.report((FirDiagnostic)FirErrors.INSTANCE.getTYPE_ARGUMENTS_NOT_ALLOWED().on(it));
        }
    }
}

