/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.ir;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.lower.VariableRemapper;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.descriptors.WrappedClassConstructorDescriptor;
import org.jetbrains.kotlin.ir.descriptors.WrappedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnableBlockImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrReturnableBlockSymbolImpl;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b\u001a\n\u0010\t\u001a\u00020\n*\u00020\u0004\u001a\"\u0010\u000b\u001a\u00020\f*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u001a8\u0010\u0011\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\u0001H\u0002\u001a\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u0012*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a(\u0010\u0015\u001a\u0004\u0018\u00010\u0012*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\u0001\u00a8\u0006\u0016"}, d2={"createParameterMapping", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "source", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "target", "asSimpleLambda", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getNewWrappedDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "inline", "Lorg/jetbrains/kotlin/ir/expressions/IrReturnableBlock;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "arguments", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "move", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "targetSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrReturnTargetSymbol;", "moveBodyTo", "ir.backend.common"})
public final class IrInlineUtilsKt {
    @Nullable
    public static final IrSimpleFunction asSimpleLambda(@NotNull IrExpression $this$asSimpleLambda) {
        boolean bl;
        IrStatement function2;
        block17: {
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block16: {
                List<IrStatement> list2;
                Intrinsics.checkNotNullParameter((Object)$this$asSimpleLambda, (String)"<this>");
                if ($this$asSimpleLambda instanceof IrFunctionExpression) {
                    boolean bl3;
                    block15: {
                        Iterable $this$any$iv2 = ((IrFunctionExpression)$this$asSimpleLambda).getFunction().getValueParameters();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv22 : $this$any$iv2) {
                                IrValueParameter it = (IrValueParameter)element$iv22;
                                boolean bl4 = false;
                                if (!(AdditionalIrUtilsKt.isVararg(it) || it.getDefaultValue() != null)) continue;
                                bl3 = true;
                                break block15;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        return null;
                    }
                    return ((IrFunctionExpression)$this$asSimpleLambda).getFunction();
                }
                if (!($this$asSimpleLambda instanceof IrBlock) || ((IrBlock)$this$asSimpleLambda).getStatements().size() != 2) {
                    return null;
                }
                List<IrStatement> list3 = list2 = ((IrBlock)$this$asSimpleLambda).getStatements();
                boolean element$iv22 = false;
                function2 = list3.get(0);
                List<IrStatement> element$iv22 = list2;
                boolean it = false;
                IrStatement reference = element$iv22.get(1);
                if (!(function2 instanceof IrSimpleFunction && reference instanceof IrFunctionReference && Intrinsics.areEqual((Object)((IrSimpleFunction)function2).getSymbol(), ((IrFunctionReference)reference).getSymbol()))) {
                    return null;
                }
                $this$any$iv = (Iterable)RangesKt.until((int)0, (int)((IrFunctionReference)reference).getValueArgumentsCount());
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    Iterator iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        int element$iv;
                        int it2 = element$iv = ((IntIterator)iterator2).nextInt();
                        boolean bl5 = false;
                        if (!(((IrFunctionReference)reference).getValueArgument(it2) != null)) continue;
                        bl2 = true;
                        break block16;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return null;
            }
            $this$any$iv = ((IrSimpleFunction)function2).getValueParameters();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrValueParameter it = (IrValueParameter)element$iv;
                    boolean bl6 = false;
                    if (!(AdditionalIrUtilsKt.isVararg(it) || it.getDefaultValue() != null)) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        return (IrSimpleFunction)function2;
    }

    private static final Map<IrValueParameter, IrValueParameter> createParameterMapping(IrFunction source, IrFunction target) {
        Object[] objectArray = new IrValueParameter[]{source.getDispatchReceiverParameter(), source.getExtensionReceiverParameter()};
        List sourceParameters = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])objectArray), (Iterable)source.getValueParameters());
        Object[] objectArray2 = new IrValueParameter[]{target.getDispatchReceiverParameter(), target.getExtensionReceiverParameter()};
        List targetParameters = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])objectArray2), (Iterable)target.getValueParameters());
        boolean bl = sourceParameters.size() == targetParameters.size();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)sourceParameters, (Iterable)targetParameters));
    }

    @Nullable
    public static final IrBody moveBodyTo(@NotNull IrFunction $this$moveBodyTo, @NotNull IrFunction target) {
        Intrinsics.checkNotNullParameter((Object)$this$moveBodyTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return IrInlineUtilsKt.moveBodyTo($this$moveBodyTo, target, IrInlineUtilsKt.createParameterMapping($this$moveBodyTo, target));
    }

    @Nullable
    public static final IrBody moveBodyTo(@NotNull IrFunction $this$moveBodyTo, @NotNull IrFunction target, @NotNull Map<IrValueParameter, ? extends IrValueDeclaration> arguments2) {
        Intrinsics.checkNotNullParameter((Object)$this$moveBodyTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        IrBody irBody = $this$moveBodyTo.getBody();
        return irBody == null ? null : IrInlineUtilsKt.move(irBody, $this$moveBodyTo, target, target.getSymbol(), arguments2);
    }

    private static final IrBody move(IrBody $this$move, IrFunction source, IrDeclarationParent target, IrReturnTargetSymbol targetSymbol, Map<IrValueParameter, ? extends IrValueDeclaration> arguments2) {
        return $this$move.transform((IrElementTransformer)new VariableRemapper(source, targetSymbol, target, arguments2){
            final /* synthetic */ IrFunction $source;
            final /* synthetic */ IrReturnTargetSymbol $targetSymbol;
            final /* synthetic */ IrDeclarationParent $target;
            final /* synthetic */ Map<IrValueParameter, IrValueDeclaration> $arguments;
            {
                this.$source = $source;
                this.$targetSymbol = $targetSymbol;
                this.$target = $target;
                this.$arguments = $arguments;
                super($arguments);
            }

            @NotNull
            public IrExpression visitReturn(@NotNull IrReturn expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                return super.visitReturn(Intrinsics.areEqual((Object)expression2.getReturnTargetSymbol(), (Object)this.$source.getSymbol()) ? (IrReturn)new IrReturnImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), this.$targetSymbol, expression2.getValue()) : expression2);
            }

            @NotNull
            public IrExpression visitBlock(@NotNull IrBlock expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if ((Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.LAMBDA.INSTANCE) || Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.ANONYMOUS_FUNCTION.INSTANCE)) && CollectionsKt.lastOrNull(expression2.getStatements()) instanceof IrFunctionReference) {
                    boolean bl;
                    block5: {
                        Iterable $this$none$iv = expression2.getStatements();
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (T element$iv : $this$none$iv) {
                                IrStatement it = (IrStatement)element$iv;
                                boolean bl2 = false;
                                if (!(it instanceof IrFunction)) continue;
                                bl = false;
                                break block5;
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        this.transformChildrenVoid(((IrFunctionSymbol)((IrFunctionReference)CollectionsKt.last(expression2.getStatements())).getSymbol()).getOwner());
                    }
                }
                return super.visitBlock(expression2);
            }

            @NotNull
            public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration2) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                if (Intrinsics.areEqual((Object)declaration2.getParent(), (Object)this.$source)) {
                    declaration2.setParent(this.$target);
                }
                return super.visitDeclaration(declaration2);
            }
        }, (Object)null);
    }

    @NotNull
    public static final IrReturnableBlock inline(@NotNull IrFunction $this$inline, @NotNull IrDeclarationParent target, @NotNull List<? extends IrValueDeclaration> arguments2) {
        Intrinsics.checkNotNullParameter((Object)$this$inline, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        IrReturnableBlockImpl irReturnableBlockImpl = new IrReturnableBlockImpl($this$inline.getStartOffset(), $this$inline.getEndOffset(), $this$inline.getReturnType(), new IrReturnableBlockSymbolImpl(IrInlineUtilsKt.getNewWrappedDescriptor($this$inline)), null, $this$inline.getSymbol());
        boolean bl = false;
        boolean bl2 = false;
        IrReturnableBlockImpl $this$inline_u24lambda_u2d3 = irReturnableBlockImpl;
        boolean bl3 = false;
        IrReturnableBlockImpl irReturnableBlockImpl2 = $this$inline_u24lambda_u2d3;
        Collection collection = irReturnableBlockImpl2.getStatements();
        Object object = $this$inline.getBody();
        Intrinsics.checkNotNull((Object)object);
        object = IrUtilsKt.getStatements(IrInlineUtilsKt.move((IrBody)object, $this$inline, target, $this$inline_u24lambda_u2d3.getSymbol(), MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)$this$inline.getValueParameters(), (Iterable)arguments2))));
        boolean bl4 = false;
        CollectionsKt.addAll((Collection)collection, (Iterable)object);
        return irReturnableBlockImpl;
    }

    public static /* synthetic */ IrReturnableBlock inline$default(IrFunction irFunction2, IrDeclarationParent irDeclarationParent, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            boolean bl = false;
            list2 = CollectionsKt.emptyList();
        }
        return IrInlineUtilsKt.inline(irFunction2, irDeclarationParent, list2);
    }

    @NotNull
    public static final FunctionDescriptor getNewWrappedDescriptor(@NotNull IrFunction $this$getNewWrappedDescriptor) {
        FunctionDescriptor functionDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$getNewWrappedDescriptor, (String)"<this>");
        IrFunction irFunction2 = $this$getNewWrappedDescriptor;
        if (irFunction2 instanceof IrConstructor) {
            WrappedClassConstructorDescriptor wrappedClassConstructorDescriptor = new WrappedClassConstructorDescriptor();
            boolean bl = false;
            boolean bl2 = false;
            WrappedClassConstructorDescriptor $this$getNewWrappedDescriptor_u24lambda_u2d4 = wrappedClassConstructorDescriptor;
            boolean bl3 = false;
            $this$getNewWrappedDescriptor_u24lambda_u2d4.bind((IrDeclaration)$this$getNewWrappedDescriptor);
            functionDescriptor = wrappedClassConstructorDescriptor;
        } else if (irFunction2 instanceof IrSimpleFunction) {
            WrappedSimpleFunctionDescriptor wrappedSimpleFunctionDescriptor = new WrappedSimpleFunctionDescriptor();
            boolean bl = false;
            boolean bl4 = false;
            WrappedSimpleFunctionDescriptor $this$getNewWrappedDescriptor_u24lambda_u2d5 = wrappedSimpleFunctionDescriptor;
            boolean bl5 = false;
            $this$getNewWrappedDescriptor_u24lambda_u2d5.bind((IrDeclaration)$this$getNewWrappedDescriptor);
            functionDescriptor = wrappedSimpleFunctionDescriptor;
        } else {
            String string2 = Intrinsics.stringPlus((String)"Unknown IrFunction kind: ", (Object)$this$getNewWrappedDescriptor);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return functionDescriptor;
    }
}

