/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.ir.linkage.IrProvider;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.DeclarationStubGenerator;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGeneratorKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.SymbolTableKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/util/ExternalDependenciesGenerator;", "", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "irProviders", "", "Lorg/jetbrains/kotlin/ir/linkage/IrProvider;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/ir/util/SymbolTable;Ljava/util/List;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "generateUnboundSymbolsAsDependencies", "", "ir.tree"})
public final class ExternalDependenciesGenerator {
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final List<IrProvider> irProviders;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public ExternalDependenciesGenerator(@NotNull SymbolTable symbolTable, @NotNull List<? extends IrProvider> irProviders, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter(irProviders, (String)"irProviders");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.symbolTable = symbolTable;
        this.irProviders = irProviders;
        this.languageVersionSettings = languageVersionSettings;
    }

    @NotNull
    public final SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public final void generateUnboundSymbolsAsDependencies() {
        Object v0;
        Object $this$singleOrNull$iv2;
        block5: {
            $this$singleOrNull$iv2 = this.irProviders;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            Iterator iterator2 = $this$singleOrNull$iv2.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                IrProvider it = (IrProvider)element$iv;
                boolean bl = false;
                if (!(it instanceof DeclarationStubGenerator)) continue;
                if (found$iv) {
                    v0 = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        IrProvider irProvider = v0;
        if (irProvider != null) {
            $this$singleOrNull$iv2 = irProvider;
            boolean bl = false;
            boolean single$iv = false;
            Object it = $this$singleOrNull$iv2;
            boolean bl2 = false;
            ((DeclarationStubGenerator)it).setUnboundSymbolGeneration(true);
        }
        boolean $this$singleOrNull$iv2 = false;
        Set<IrSymbol> unbound = SetsKt.emptySet();
        Set<IrSymbol> prevUnbound = null;
        do {
            prevUnbound = unbound;
            unbound = SymbolTableKt.getAllUnbound(this.symbolTable);
            for (IrSymbol symbol2 : unbound) {
                if (symbol2.isBound()) continue;
                ExternalDependenciesGeneratorKt.getDeclaration(this.irProviders, symbol2);
            }
            if (prevUnbound != null) continue;
            Intrinsics.throwUninitializedPropertyAccessException((String)"prevUnbound");
            throw null;
        } while (!Intrinsics.areEqual(unbound, prevUnbound));
    }
}

