/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.concurrent;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.kotlin.dsl.concurrent.ResurrectingThread;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B+\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\u001a\u0010\u0005\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J\u000f\u0010\u0014\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R%\u0010\u0005\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gradle/kotlin/dsl/concurrent/EventLoop;", "T", "", "name", "", "loop", "Lkotlin/Function1;", "Lkotlin/Function0;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "consumer", "Lorg/gradle/kotlin/dsl/concurrent/ResurrectingThread;", "getLoop", "()Lkotlin/jvm/functions/Function1;", "q", "Ljava/util/concurrent/ArrayBlockingQueue;", "accept", "", "event", "(Ljava/lang/Object;)Z", "poll", "()Ljava/lang/Object;", "kotlin-dsl"})
public final class EventLoop<T> {
    private final ArrayBlockingQueue<T> q;
    private ResurrectingThread consumer;
    @NotNull
    private final Function1<Function0<? extends T>, Unit> loop;

    public final boolean accept(T event) {
        if (this.q.offer(event, 50L, TimeUnit.MILLISECONDS)) {
            this.consumer.poke();
            return true;
        }
        return false;
    }

    private final T poll() {
        return this.q.poll(5000L, TimeUnit.MILLISECONDS);
    }

    @NotNull
    public final Function1<Function0<? extends T>, Unit> getLoop() {
        return this.loop;
    }

    public EventLoop(@NotNull String name2, @NotNull Function1<? super Function0<? extends T>, Unit> loop) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(loop, (String)"loop");
        this.loop = loop;
        this.q = new ArrayBlockingQueue(64);
        this.consumer = new ResurrectingThread(name2, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ EventLoop this$0;

            public final void invoke() {
                this.this$0.getLoop().invoke((Object)new Function0<T>(this.this$0){

                    @Nullable
                    public final T invoke() {
                        return (T)EventLoop.access$poll((EventLoop)this.receiver);
                    }
                });
            }
            {
                this.this$0 = eventLoop2;
                super(0);
            }
        }));
    }

    public /* synthetic */ EventLoop(String string2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string2 = "Gradle Kotlin DSL Event Loop";
        }
        this(string2, function1);
    }

    public static final /* synthetic */ Object access$poll(EventLoop $this) {
        return $this.poll();
    }
}

