/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.report.experimental;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.report.ICReporterBase;
import org.jetbrains.kotlin.build.report.RemoteBuildReporter;
import org.jetbrains.kotlin.build.report.RemoteICReporter;
import org.jetbrains.kotlin.build.report.metrics.RemoteBuildMetricsReporter;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResultsAsync;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBaseAsync;
import org.jetbrains.kotlin.daemon.common.IncrementalCompilationOptions;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.daemon.report.CompositeICReporter;
import org.jetbrains.kotlin.daemon.report.experimental.BuildReportICReporterAsync;
import org.jetbrains.kotlin.daemon.report.experimental.CompileIterationICReporterAsync;
import org.jetbrains.kotlin.daemon.report.experimental.DebugMessagesICReporterAsync;
import org.jetbrains.kotlin.daemon.report.experimental.DoNothingRemoteBuildMetricsReporter;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"getICReporterAsync", "Lorg/jetbrains/kotlin/build/report/RemoteBuildReporter;", "servicesFacade", "Lorg/jetbrains/kotlin/daemon/common/CompilerServicesFacadeBaseAsync;", "compilationResults", "Lorg/jetbrains/kotlin/daemon/common/CompilationResultsAsync;", "compilationOptions", "Lorg/jetbrains/kotlin/daemon/common/IncrementalCompilationOptions;", "kotlin-daemon"})
public final class RemoteICReporterKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final RemoteBuildReporter getICReporterAsync(@NotNull CompilerServicesFacadeBaseAsync servicesFacade, @Nullable CompilationResultsAsync compilationResults, @NotNull IncrementalCompilationOptions compilationOptions) {
        Iterator $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)servicesFacade, (String)"servicesFacade");
        Intrinsics.checkNotNullParameter((Object)compilationOptions, (String)"compilationOptions");
        File root = compilationOptions.getModulesInfo().getProjectRoot();
        ArrayList<ICReporterBase> reporters = new ArrayList<ICReporterBase>();
        if (ArraysKt.contains((Object[])compilationOptions.getReportCategories(), (Object)ReportCategory.IC_MESSAGE.getCode())) {
            boolean isVerbose = compilationOptions.getReportSeverity() == ReportSeverity.DEBUG.getCode();
            reporters.add(new DebugMessagesICReporterAsync(servicesFacade, root, isVerbose));
        }
        Integer[] integerArray = compilationOptions.getRequestedCompilationResults();
        Collection destination$iv = new HashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        void var11_14 = $this$forEach$iv$iv;
        int n = ((void)var11_14).length;
        for (int i = 0; i < n; ++i) {
            CompilationResultCategory compilationResultCategory;
            void element$iv$iv;
            void element$iv = element$iv$iv = var11_14[i];
            boolean bl = false;
            int resultCode = ((Number)element$iv).intValue();
            boolean bl2 = false;
            if ((CompilationResultCategory)((Object)ArraysKt.getOrNull((Object[])CompilationResultCategory.values(), (int)resultCode)) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            CompilationResultCategory it$iv = compilationResultCategory;
            boolean bl5 = false;
            destination$iv.add(it$iv);
        }
        HashSet requestedResults = (HashSet)destination$iv;
        $this$mapNotNullTo$iv = requestedResults.iterator();
        while ($this$mapNotNullTo$iv.hasNext()) {
            CompilationResultCategory requestedResult;
            CompilationResultCategory compilationResultCategory = requestedResult = (CompilationResultCategory)((Object)$this$mapNotNullTo$iv.next());
            int n2 = WhenMappings.$EnumSwitchMapping$0[compilationResultCategory.ordinal()];
            switch (n2) {
                case 1: {
                    reporters.add(new CompileIterationICReporterAsync(compilationResults));
                    break;
                }
                case 2: {
                    reporters.add(new BuildReportICReporterAsync(compilationResults, root, false, 4, null));
                    break;
                }
                case 3: {
                    reporters.add(new BuildReportICReporterAsync(compilationResults, root, true));
                }
            }
        }
        CompositeICReporter icReporter = new CompositeICReporter((Iterable<? extends RemoteICReporter>)reporters);
        DoNothingRemoteBuildMetricsReporter metricsReporter = DoNothingRemoteBuildMetricsReporter.INSTANCE;
        return new RemoteBuildReporter((RemoteICReporter)icReporter, (RemoteBuildMetricsReporter)metricsReporter);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompilationResultCategory.values().length];
            nArray[CompilationResultCategory.IC_COMPILE_ITERATION.ordinal()] = 1;
            nArray[CompilationResultCategory.BUILD_REPORT_LINES.ordinal()] = 2;
            nArray[CompilationResultCategory.VERBOSE_BUILD_REPORT_LINES.ordinal()] = 3;
            nArray[CompilationResultCategory.BUILD_METRICS.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

