/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.base.Splitter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.verification.DependencyVerificationMode;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.file.BasicFileResolver;
import org.gradle.internal.buildoption.BooleanBuildOption;
import org.gradle.internal.buildoption.BooleanCommandLineOptionConfiguration;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.buildoption.BuildOptionSet;
import org.gradle.internal.buildoption.CommandLineOptionConfiguration;
import org.gradle.internal.buildoption.EnabledOnlyBooleanBuildOption;
import org.gradle.internal.buildoption.EnumBuildOption;
import org.gradle.internal.buildoption.IntegerBuildOption;
import org.gradle.internal.buildoption.ListBuildOption;
import org.gradle.internal.buildoption.Origin;
import org.gradle.internal.buildoption.StringBuildOption;

public class StartParameterBuildOptions
extends BuildOptionSet<StartParameterInternal> {
    private static List<BuildOption<StartParameterInternal>> options;

    public List<? extends BuildOption<? super StartParameterInternal>> getAllOptions() {
        return options;
    }

    static {
        ArrayList<Object> options = new ArrayList<Object>();
        options.add((Object)new ProjectCacheDirOption());
        options.add((Object)new RerunTasksOption());
        options.add((Object)new ProfileOption());
        options.add((Object)new ContinueOption());
        options.add((Object)new OfflineOption());
        options.add((Object)new RefreshDependenciesOption());
        options.add((Object)new DryRunOption());
        options.add((Object)new ContinuousOption());
        options.add((Object)new NoProjectDependenciesRebuildOption());
        options.add((Object)new BuildFileOption());
        options.add((Object)new SettingsFileOption());
        options.add((Object)new InitScriptOption());
        options.add((Object)new ExcludeTaskOption());
        options.add((Object)new IncludeBuildOption());
        options.add((Object)new ConfigureOnDemandOption());
        options.add((Object)new BuildCacheOption());
        options.add((Object)new BuildCacheDebugLoggingOption());
        options.add((Object)new WatchFileSystemOption());
        options.add((Object)new WatchFileSystemDebugLoggingOption());
        options.add((Object)new DeprecatedWatchFileSystemOption());
        options.add((Object)new VfsVerboseLoggingOption());
        options.add((Object)new BuildScanOption());
        options.add((Object)new DependencyLockingWriteOption());
        options.add((Object)new DependencyVerificationWriteOption());
        options.add((Object)new DependencyVerificationModeOption());
        options.add((Object)new DependencyLockingUpdateOption());
        options.add((Object)new RefreshKeysOption());
        options.add((Object)new ExportKeysOption());
        options.add((Object)new ConfigurationCacheProblemsOption());
        options.add((Object)new ConfigurationCacheOption());
        options.add((Object)new ConfigurationCacheMaxProblemsOption());
        options.add((Object)new ConfigurationCacheRecreateOption());
        options.add((Object)new ConfigurationCacheQuietOption());
        StartParameterBuildOptions.options = Collections.unmodifiableList(options);
    }

    public static class ConfigurationCacheQuietOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.unsafe.configuration-cache.quiet";

        public ConfigurationCacheQuietOption() {
            super(PROPERTY_NAME);
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCacheQuiet(value);
        }
    }

    public static class ConfigurationCacheRecreateOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.unsafe.configuration-cache.recreate-cache";

        public ConfigurationCacheRecreateOption() {
            super(PROPERTY_NAME);
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCacheRecreateCache(value);
        }
    }

    public static class ConfigurationCacheMaxProblemsOption
    extends IntegerBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.unsafe.configuration-cache.max-problems";

        public ConfigurationCacheMaxProblemsOption() {
            super(PROPERTY_NAME);
        }

        public void applyTo(int value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCacheMaxProblems(value);
        }
    }

    public static class ConfigurationCacheProblemsOption
    extends EnumBuildOption<Value, StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.unsafe.configuration-cache-problems";
        public static final String LONG_OPTION = "configuration-cache-problems";

        public ConfigurationCacheProblemsOption() {
            super(LONG_OPTION, Value.class, (Enum[])Value.values(), PROPERTY_NAME, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Configures how the configuration cache handles problems (fail or warn). Defaults to fail.").incubating()});
        }

        public void applyTo(Value value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCacheProblems(value);
        }

        public static enum Value {
            FAIL,
            WARN;

        }
    }

    public static class ConfigurationCacheOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String PROPERTY_NAME = "org.gradle.unsafe.configuration-cache";
        public static final String LONG_OPTION = "configuration-cache";

        public ConfigurationCacheOption() {
            super(PROPERTY_NAME, new BooleanCommandLineOptionConfiguration[]{BooleanCommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Enables the configuration cache. Gradle will try to reuse the build configuration from previous builds.", (String)"Disables the configuration cache.").incubating()});
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setConfigurationCache(value);
        }
    }

    public static class ExportKeysOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        private static final String LONG_OPTION = "export-keys";

        public ExportKeysOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Exports the public keys used for dependency verification.").incubating()});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setExportKeys(true);
        }
    }

    public static class RefreshKeysOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        private static final String LONG_OPTION = "refresh-keys";

        public RefreshKeysOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Refresh the public keys used for dependency verification.").incubating()});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setRefreshKeys(true);
        }
    }

    public static class DependencyLockingUpdateOption
    extends ListBuildOption<StartParameterInternal> {
        public DependencyLockingUpdateOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"update-locks", (String)"Perform a partial update of the dependency lock, letting passed in module notations change version.").incubating()});
        }

        public void applyTo(List<String> modulesToUpdate, StartParameterInternal settings, Origin origin) {
            settings.setLockedDependenciesToUpdate(modulesToUpdate);
        }
    }

    public static class DependencyVerificationModeOption
    extends EnumBuildOption<DependencyVerificationMode, StartParameterInternal> {
        private static final String GRADLE_PROPERTY = "org.gradle.dependency.verification";
        private static final String LONG_OPTION = "dependency-verification";
        private static final String SHORT_OPTION = "F";

        public DependencyVerificationModeOption() {
            super(LONG_OPTION, DependencyVerificationMode.class, (Enum[])DependencyVerificationMode.values(), GRADLE_PROPERTY, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)SHORT_OPTION, (String)"Configures the dependency verification mode (strict, lenient or off)").incubating()});
        }

        public void applyTo(DependencyVerificationMode value, StartParameterInternal settings, Origin origin) {
            settings.setDependencyVerificationMode(value);
        }
    }

    public static class DependencyVerificationWriteOption
    extends StringBuildOption<StartParameterInternal> {
        public static final String SHORT_OPTION = "M";
        public static final String LONG_OPTION = "write-verification-metadata";

        DependencyVerificationWriteOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)SHORT_OPTION, (String)"Generates checksums for dependencies used in the project (comma-separated list)").incubating()});
        }

        public void applyTo(String value, StartParameterInternal settings, Origin origin) {
            List checksums = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)value).stream().map(String::toLowerCase).collect(Collectors.toList());
            settings.setWriteDependencyVerifications(checksums);
        }
    }

    public static class DependencyLockingWriteOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public static final String LONG_OPTION = "write-locks";

        public DependencyLockingWriteOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Persists dependency resolution for locked configurations, ignoring existing locking information if it exists").incubating()});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setWriteDependencyLocks(true);
        }
    }

    public static class BuildScanOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String LONG_OPTION = "scan";

        public BuildScanOption() {
            super(null, new BooleanCommandLineOptionConfiguration[]{BooleanCommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Creates a build scan. Gradle will emit a warning if the build scan plugin has not been applied. (https://gradle.com/build-scans)", (String)"Disables the creation of a build scan. For more information about build scans, please visit https://gradle.com/build-scans.")});
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            if (value) {
                settings.setBuildScan(true);
            } else {
                settings.setNoBuildScan(true);
            }
        }
    }

    public static class VfsVerboseLoggingOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String GRADLE_PROPERTY = "org.gradle.vfs.verbose";

        public VfsVerboseLoggingOption() {
            super(GRADLE_PROPERTY);
        }

        public void applyTo(boolean value, StartParameterInternal startParameter, Origin origin) {
            startParameter.setVfsVerboseLogging(value);
        }
    }

    public static class WatchFileSystemDebugLoggingOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String GRADLE_PROPERTY = "org.gradle.vfs.watch.debug";

        public WatchFileSystemDebugLoggingOption() {
            super(GRADLE_PROPERTY);
        }

        public void applyTo(boolean value, StartParameterInternal startParameter, Origin origin) {
            startParameter.setWatchFileSystemDebugLogging(value);
        }
    }

    @Deprecated
    public static class DeprecatedWatchFileSystemOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String GRADLE_PROPERTY = "org.gradle.unsafe.watch-fs";

        public DeprecatedWatchFileSystemOption() {
            super(GRADLE_PROPERTY);
        }

        public void applyTo(boolean value, StartParameterInternal startParameter, Origin origin) {
            startParameter.setWatchFileSystem(value);
            startParameter.setWatchFileSystemUsingDeprecatedOption(true);
        }
    }

    public static class WatchFileSystemOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String LONG_OPTION = "watch-fs";
        public static final String GRADLE_PROPERTY = "org.gradle.vfs.watch";

        public WatchFileSystemOption() {
            super(GRADLE_PROPERTY, new BooleanCommandLineOptionConfiguration[]{BooleanCommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Enables watching the file system for changes, allowing data about the file system to be re-used for the next build.", (String)"Disables watching the file system.")});
        }

        public void applyTo(boolean value, StartParameterInternal startParameter, Origin origin) {
            startParameter.setWatchFileSystem(value);
        }
    }

    public static class BuildCacheDebugLoggingOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String GRADLE_PROPERTY = "org.gradle.caching.debug";

        public BuildCacheDebugLoggingOption() {
            super(GRADLE_PROPERTY);
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setBuildCacheDebugLogging(value);
        }
    }

    public static class BuildCacheOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String GRADLE_PROPERTY = "org.gradle.caching";

        public BuildCacheOption() {
            super(GRADLE_PROPERTY, new BooleanCommandLineOptionConfiguration[]{BooleanCommandLineOptionConfiguration.create((String)"build-cache", (String)"Enables the Gradle build cache. Gradle will try to reuse outputs from previous builds.", (String)"Disables the Gradle build cache.")});
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setBuildCacheEnabled(value);
        }
    }

    public static class ConfigureOnDemandOption
    extends BooleanBuildOption<StartParameterInternal> {
        public static final String GRADLE_PROPERTY = "org.gradle.configureondemand";

        public ConfigureOnDemandOption() {
            super(GRADLE_PROPERTY, new BooleanCommandLineOptionConfiguration[]{BooleanCommandLineOptionConfiguration.create((String)"configure-on-demand", (String)"Configure necessary projects only. Gradle will attempt to reduce configuration time for large multi-project builds.", (String)"Disables the use of configuration on demand.").incubating()});
        }

        public void applyTo(boolean value, StartParameterInternal settings, Origin origin) {
            settings.setConfigureOnDemand(value);
        }
    }

    public static class IncludeBuildOption
    extends ListBuildOption<StartParameterInternal> {
        public IncludeBuildOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"include-build", (String)"Include the specified build in the composite.")});
        }

        public void applyTo(List<String> values, StartParameterInternal settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            for (String includedBuild : values) {
                settings.includeBuild((File)resolver.transform(includedBuild));
            }
        }
    }

    public static class ExcludeTaskOption
    extends ListBuildOption<StartParameterInternal> {
        public ExcludeTaskOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"exclude-task", (String)"x", (String)"Specify a task to be excluded from execution.")});
        }

        public void applyTo(List<String> values, StartParameterInternal settings, Origin origin) {
            settings.setExcludedTaskNames(values);
        }
    }

    public static class InitScriptOption
    extends ListBuildOption<StartParameterInternal> {
        public InitScriptOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"init-script", (String)"I", (String)"Specify an initialization script.")});
        }

        public void applyTo(List<String> values, StartParameterInternal settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            for (String script : values) {
                settings.addInitScript((File)resolver.transform(script));
            }
        }
    }

    public static class SettingsFileOption
    extends StringBuildOption<StartParameterInternal> {
        public SettingsFileOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"settings-file", (String)"c", (String)"Specify the settings file.")});
        }

        public void applyTo(String value, StartParameterInternal settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setSettingsFile((File)resolver.transform(value));
        }
    }

    public static class BuildFileOption
    extends StringBuildOption<StartParameterInternal> {
        public BuildFileOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"build-file", (String)"b", (String)"Specify the build file.")});
        }

        public void applyTo(String value, StartParameterInternal settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setBuildFile((File)resolver.transform(value));
        }
    }

    public static class NoProjectDependenciesRebuildOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        private static final String LONG_OPTION = "no-rebuild";
        private static final String SHORT_OPTION = "a";

        public NoProjectDependenciesRebuildOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)SHORT_OPTION, (String)"Do not rebuild project dependencies.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setBuildProjectDependencies(false);
        }
    }

    public static class ContinuousOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public ContinuousOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"continuous", (String)"t", (String)"Enables continuous build. Gradle does not exit and will re-execute tasks when task file inputs change.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setContinuous(true);
        }
    }

    public static class DryRunOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public DryRunOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"dry-run", (String)"m", (String)"Run the builds with all task actions disabled.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setDryRun(true);
        }
    }

    public static class RefreshDependenciesOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public RefreshDependenciesOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"refresh-dependencies", (String)"Refresh the state of dependencies.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setRefreshDependencies(true);
        }
    }

    public static class OfflineOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public OfflineOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"offline", (String)"Execute the build without accessing network resources.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setOffline(true);
        }
    }

    public static class ContinueOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public static final String LONG_OPTION = "continue";

        public ContinueOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)LONG_OPTION, (String)"Continue task execution after a task failure.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setContinueOnFailure(true);
        }
    }

    public static class ProfileOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public ProfileOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"profile", (String)"Profile build execution time and generates a report in the <build_dir>/reports/profile directory.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setProfile(true);
        }
    }

    public static class RerunTasksOption
    extends EnabledOnlyBooleanBuildOption<StartParameterInternal> {
        public RerunTasksOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"rerun-tasks", (String)"Ignore previously cached task results.")});
        }

        public void applyTo(StartParameterInternal settings, Origin origin) {
            settings.setRerunTasks(true);
        }
    }

    public static class ProjectCacheDirOption
    extends StringBuildOption<StartParameterInternal> {
        public ProjectCacheDirOption() {
            super(null, new CommandLineOptionConfiguration[]{CommandLineOptionConfiguration.create((String)"project-cache-dir", (String)"Specify the project-specific cache directory. Defaults to .gradle in the root project directory.")});
        }

        public void applyTo(String value, StartParameterInternal settings, Origin origin) {
            BasicFileResolver resolver = new BasicFileResolver(settings.getCurrentDir());
            settings.setProjectCacheDir((File)resolver.transform(value));
        }
    }
}

