/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.model.AbstractMutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.AbstractRealisedModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.AdditionalVariant;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.GradleDependencyMetadata;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;

public class LazyToRealisedModuleComponentResolveMetadataHelper {
    public static ImmutableList<AbstractRealisedModuleComponentResolveMetadata.ImmutableRealisedVariantImpl> realiseVariants(ModuleComponentResolveMetadata mutableMetadata, VariantMetadataRules variantMetadataRules, ImmutableList<? extends ComponentVariant> variants) {
        if (variants.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList realisedVariants = Lists.newArrayListWithExpectedSize((int)variants.size());
        for (ComponentVariant variant : variants) {
            realisedVariants.add(LazyToRealisedModuleComponentResolveMetadataHelper.applyRules(variant, variantMetadataRules, mutableMetadata.getId()));
        }
        return LazyToRealisedModuleComponentResolveMetadataHelper.addVariantsFromRules(mutableMetadata, realisedVariants, variantMetadataRules);
    }

    private static ImmutableList<AbstractRealisedModuleComponentResolveMetadata.ImmutableRealisedVariantImpl> addVariantsFromRules(ModuleComponentResolveMetadata componentMetadata, List<AbstractRealisedModuleComponentResolveMetadata.ImmutableRealisedVariantImpl> declaredVariants, VariantMetadataRules variantMetadataRules) {
        List<AdditionalVariant> additionalVariants = variantMetadataRules.getAdditionalVariants();
        if (additionalVariants.isEmpty()) {
            return ImmutableList.copyOf(declaredVariants);
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.addAll(declaredVariants);
        Map variantsByName = declaredVariants.stream().collect(Collectors.toMap(VariantResolveMetadata::getName, Function.identity()));
        for (AdditionalVariant additionalVariant : additionalVariants) {
            boolean isExternalVariant;
            ImmutableList<? extends ComponentVariant.File> files;
            ImmutableList<? extends ComponentVariant.DependencyConstraint> dependencyConstraints;
            ImmutableList<? extends ComponentVariant.Dependency> dependencies;
            ImmutableCapabilities capabilities;
            ImmutableAttributes attributes;
            String baseName = additionalVariant.getBase();
            ComponentVariant baseVariant = (ComponentVariant)variantsByName.get(baseName);
            if (baseVariant == null) {
                attributes = componentMetadata.getAttributes();
                capabilities = ImmutableCapabilities.EMPTY;
                dependencies = ImmutableList.of();
                dependencyConstraints = ImmutableList.of();
                files = ImmutableList.of();
                isExternalVariant = false;
            } else {
                attributes = (ImmutableAttributes)baseVariant.getAttributes();
                capabilities = (ImmutableCapabilities)baseVariant.getCapabilities();
                dependencies = baseVariant.getDependencies();
                dependencyConstraints = baseVariant.getDependencyConstraints();
                files = baseVariant.getFiles();
                isExternalVariant = baseVariant.isExternalVariant();
            }
            if (baseName == null || baseVariant != null) {
                AbstractRealisedModuleComponentResolveMetadata.ImmutableRealisedVariantImpl variant = LazyToRealisedModuleComponentResolveMetadataHelper.applyRules(new AbstractMutableModuleComponentResolveMetadata.ImmutableVariantImpl(componentMetadata.getId(), additionalVariant.getName(), attributes, dependencies, dependencyConstraints, files, capabilities, isExternalVariant), variantMetadataRules, componentMetadata.getId());
                builder.add((Object)variant);
                continue;
            }
            if (additionalVariant.isLenient()) continue;
            throw new InvalidUserDataException("Variant '" + baseName + "' not defined in module " + componentMetadata.getId().getDisplayName());
        }
        return builder.build();
    }

    private static AbstractRealisedModuleComponentResolveMetadata.ImmutableRealisedVariantImpl applyRules(ComponentVariant variant, VariantMetadataRules variantMetadataRules, ModuleComponentIdentifier id) {
        ImmutableAttributes attributes = variantMetadataRules.applyVariantAttributeRules(variant, variant.getAttributes());
        CapabilitiesMetadata capabilitiesMetadata = variantMetadataRules.applyCapabilitiesRules(variant, variant.getCapabilities());
        ImmutableList<? extends ComponentVariant.File> files = variantMetadataRules.applyVariantFilesMetadataRulesToFiles(variant, variant.getFiles(), id);
        boolean force = PlatformSupport.hasForcedDependencies(variant);
        List<GradleDependencyMetadata> dependencies = variantMetadataRules.applyDependencyMetadataRules(variant, LazyToRealisedModuleComponentResolveMetadataHelper.convertDependencies(variant.getDependencies(), variant.getDependencyConstraints(), force));
        return new AbstractRealisedModuleComponentResolveMetadata.ImmutableRealisedVariantImpl(id, variant.getName(), attributes, variant.getDependencies(), variant.getDependencyConstraints(), files, ImmutableCapabilities.of(capabilitiesMetadata.getCapabilities()), dependencies, variant.isExternalVariant());
    }

    private static List<GradleDependencyMetadata> convertDependencies(List<? extends ComponentVariant.Dependency> dependencies, List<? extends ComponentVariant.DependencyConstraint> dependencyConstraints, boolean force) {
        ArrayList<GradleDependencyMetadata> result = new ArrayList<GradleDependencyMetadata>(dependencies.size());
        for (ComponentVariant.Dependency dependency : dependencies) {
            ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(dependency.getGroup(), dependency.getModule()), dependency.getVersionConstraint(), (AttributeContainer)dependency.getAttributes(), dependency.getRequestedCapabilities());
            ImmutableList<ExcludeMetadata> excludes = dependency.getExcludes();
            result.add(new GradleDependencyMetadata(selector, (List<ExcludeMetadata>)excludes, false, dependency.isEndorsingStrictVersions(), dependency.getReason(), force, dependency.getDependencyArtifact()));
        }
        for (ComponentVariant.DependencyConstraint dependencyConstraint : dependencyConstraints) {
            result.add(new GradleDependencyMetadata(DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(dependencyConstraint.getGroup(), dependencyConstraint.getModule()), dependencyConstraint.getVersionConstraint(), (AttributeContainer)dependencyConstraint.getAttributes(), (Collection<Capability>)ImmutableList.of()), Collections.emptyList(), true, false, dependencyConstraint.getReason(), force, null));
        }
        return result;
    }

    public static ImmutableSet<String> constructHierarchy(Configuration descriptorConfiguration, ImmutableMap<String, Configuration> configurationDefinitions) {
        if (descriptorConfiguration.getExtendsFrom().isEmpty()) {
            return ImmutableSet.of((Object)descriptorConfiguration.getName());
        }
        ImmutableSet.Builder accumulator = new ImmutableSet.Builder();
        LazyToRealisedModuleComponentResolveMetadataHelper.populateHierarchy(descriptorConfiguration, configurationDefinitions, (ImmutableSet.Builder<String>)accumulator);
        return accumulator.build();
    }

    private static void populateHierarchy(Configuration metadata, ImmutableMap<String, Configuration> configurationDefinitions, ImmutableSet.Builder<String> accumulator) {
        accumulator.add((Object)metadata.getName());
        for (String parentName : metadata.getExtendsFrom()) {
            Configuration parent = (Configuration)configurationDefinitions.get((Object)parentName);
            LazyToRealisedModuleComponentResolveMetadataHelper.populateHierarchy(parent, configurationDefinitions, accumulator);
        }
    }
}

