/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.substitution;

import java.util.ArrayList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H&J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u000e\u0010\r\u001a\u0004\u0018\u00010\u0007*\u00020\u0007H\u0002J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0007*\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0007*\u00020\u0007H\u0002J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0007*\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/substitution/AbstractConeSubstitutor;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "()V", "substituteArgument", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "projection", "substituteOrNull", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "type", "substituteType", "wrapProjection", "old", "newType", "substituteArguments", "substituteBounds", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "substituteIntersectedTypes", "Lorg/jetbrains/kotlin/fir/types/ConeIntersectionType;", "substituteOriginal", "Lorg/jetbrains/kotlin/fir/types/ConeDefinitelyNotNullType;", "substituteRecursive", "updateNullabilityIfNeeded", "originalType", "resolve"})
public abstract class AbstractConeSubstitutor
extends ConeSubstitutor {
    private final ConeTypeProjection wrapProjection(ConeTypeProjection old, ConeKotlinType newType) {
        ConeTypeProjection coneTypeProjection = old;
        return coneTypeProjection instanceof ConeStarProjection ? old : (coneTypeProjection instanceof ConeKotlinTypeProjectionIn ? (ConeTypeProjection)new ConeKotlinTypeProjectionIn(newType) : (coneTypeProjection instanceof ConeKotlinTypeProjectionOut ? (ConeTypeProjection)new ConeKotlinTypeProjectionOut(newType) : (coneTypeProjection instanceof ConeKotlinType ? (ConeTypeProjection)newType : old)));
    }

    @Nullable
    public abstract ConeKotlinType substituteType(@NotNull ConeKotlinType var1);

    @Nullable
    public ConeTypeProjection substituteArgument(@NotNull ConeTypeProjection projection) {
        ConeKotlinTypeProjection coneKotlinTypeProjection;
        Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
        ConeTypeProjection coneTypeProjection = projection;
        if (!(coneTypeProjection instanceof ConeKotlinTypeProjection)) {
            coneTypeProjection = null;
        }
        if ((coneKotlinTypeProjection = (ConeKotlinTypeProjection)coneTypeProjection) == null || (coneKotlinTypeProjection = coneKotlinTypeProjection.getType()) == null) {
            return null;
        }
        ConeKotlinTypeProjection type2 = coneKotlinTypeProjection;
        ConeKotlinType coneKotlinType = this.substituteOrNull((ConeKotlinType)type2);
        if (coneKotlinType == null) {
            return null;
        }
        ConeKotlinType newType = coneKotlinType;
        return this.wrapProjection(projection, newType);
    }

    @Nullable
    public final ConeKotlinType updateNullabilityIfNeeded(@Nullable ConeKotlinType $this$updateNullabilityIfNeeded, @NotNull ConeKotlinType originalType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter((Object)originalType, (String)"originalType");
        if (originalType instanceof ConeDefinitelyNotNullType) {
            ConeKotlinType coneKotlinType2 = $this$updateNullabilityIfNeeded;
            coneKotlinType = coneKotlinType2 != null ? TypeUtilsKt.withNullability$default(coneKotlinType2, ConeNullability.NOT_NULL, null, 2, null) : null;
        } else if (ConeTypeUtilsKt.isMarkedNullable(originalType)) {
            ConeKotlinType coneKotlinType3 = $this$updateNullabilityIfNeeded;
            coneKotlinType = coneKotlinType3 != null ? TypeUtilsKt.withNullability$default(coneKotlinType3, ConeNullability.NULLABLE, null, 2, null) : null;
        } else {
            coneKotlinType = $this$updateNullabilityIfNeeded;
        }
        return coneKotlinType;
    }

    @Override
    @Nullable
    public ConeKotlinType substituteOrNull(@NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        ConeKotlinType newType = this.substituteType(type2);
        if (newType != null && type2 instanceof ConeDefinitelyNotNullType) {
            return TypeUtilsKt.makeConeTypeDefinitelyNotNullOrNotNull(newType);
        }
        ConeKotlinType coneKotlinType = newType;
        if (coneKotlinType == null) {
            coneKotlinType = this.substituteRecursive(type2);
        }
        return coneKotlinType;
    }

    private final ConeKotlinType substituteRecursive(ConeKotlinType $this$substituteRecursive) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType coneKotlinType2 = $this$substituteRecursive;
        if (coneKotlinType2 instanceof ConeClassErrorType) {
            return null;
        }
        if (coneKotlinType2 instanceof ConeClassLikeType) {
            coneKotlinType = this.substituteArguments($this$substituteRecursive);
        } else {
            if (coneKotlinType2 instanceof ConeLookupTagBasedType) {
                return null;
            }
            if (coneKotlinType2 instanceof ConeFlexibleType) {
                coneKotlinType = this.substituteBounds((ConeFlexibleType)$this$substituteRecursive);
            } else {
                if (coneKotlinType2 instanceof ConeCapturedType) {
                    return null;
                }
                if (coneKotlinType2 instanceof ConeDefinitelyNotNullType) {
                    coneKotlinType = this.substituteOriginal((ConeDefinitelyNotNullType)$this$substituteRecursive);
                } else if (coneKotlinType2 instanceof ConeIntersectionType) {
                    coneKotlinType = this.substituteIntersectedTypes((ConeIntersectionType)$this$substituteRecursive);
                } else {
                    if (coneKotlinType2 instanceof ConeStubType) {
                        return null;
                    }
                    if (coneKotlinType2 instanceof ConeIntegerLiteralType) {
                        return null;
                    }
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return coneKotlinType;
    }

    private final ConeIntersectionType substituteIntersectedTypes(ConeIntersectionType $this$substituteIntersectedTypes) {
        ArrayList substitutedTypes = new ArrayList($this$substituteIntersectedTypes.getIntersectedTypes().size());
        boolean somethingIsSubstituted = false;
        for (ConeKotlinType type2 : $this$substituteIntersectedTypes.getIntersectedTypes()) {
            boolean bl;
            Object object;
            Object object2;
            block6: {
                block5: {
                    object2 = this.substituteOrNull(type2);
                    if (object2 == null) break block5;
                    object = object2;
                    bl = false;
                    boolean bl2 = false;
                    ConeKotlinType it = object;
                    boolean bl3 = false;
                    somethingIsSubstituted = true;
                    object2 = object;
                    if (object2 != null) break block6;
                }
                object2 = type2;
            }
            ConeKotlinType substitutedType = object2;
            object = substitutedTypes;
            bl = false;
            object.add(substitutedType);
        }
        if (!somethingIsSubstituted) {
            return null;
        }
        return new ConeIntersectionType(substitutedTypes);
    }

    private final ConeKotlinType substituteOriginal(ConeDefinitelyNotNullType $this$substituteOriginal) {
        ConeKotlinType coneKotlinType = this.substituteOrNull($this$substituteOriginal.getOriginal());
        if (coneKotlinType == null || (coneKotlinType = TypeUtilsKt.withNullability$default(coneKotlinType, ConeNullability.NOT_NULL, null, 2, null)) == null) {
            return null;
        }
        ConeKotlinType substituted = coneKotlinType;
        ConeDefinitelyNotNullType coneDefinitelyNotNullType = TypeUtilsKt.create(ConeDefinitelyNotNullType.Companion, substituted);
        return coneDefinitelyNotNullType != null ? (ConeKotlinType)coneDefinitelyNotNullType : substituted;
    }

    private final ConeFlexibleType substituteBounds(ConeFlexibleType $this$substituteBounds) {
        ConeKotlinType newLowerBound = this.substituteOrNull($this$substituteBounds.getLowerBound());
        ConeKotlinType newUpperBound = this.substituteOrNull($this$substituteBounds.getUpperBound());
        if (newLowerBound != null || newUpperBound != null) {
            ConeKotlinType coneKotlinType;
            ConeKotlinType coneKotlinType2 = newLowerBound;
            if (coneKotlinType2 == null || (coneKotlinType2 = ConeTypesKt.lowerBoundIfFlexible(coneKotlinType2)) == null) {
                coneKotlinType2 = $this$substituteBounds.getLowerBound();
            }
            if ((coneKotlinType = newUpperBound) == null || (coneKotlinType = ConeTypesKt.upperBoundIfFlexible(coneKotlinType)) == null) {
                coneKotlinType = $this$substituteBounds.getUpperBound();
            }
            return new ConeFlexibleType(coneKotlinType2, coneKotlinType);
        }
        return null;
    }

    private final ConeKotlinType substituteArguments(ConeKotlinType $this$substituteArguments) {
        int index2;
        boolean bl;
        Object object;
        ConeTypeProjection typeArgument;
        Object var3_2 = null;
        Lazy newArguments2 = LazyKt.lazy((Function0)((Function0)new Function0<ConeTypeProjection[]>($this$substituteArguments){
            final /* synthetic */ ConeKotlinType $this_substituteArguments;

            @NotNull
            public final ConeTypeProjection[] invoke() {
                return new ConeTypeProjection[this.$this_substituteArguments.getTypeArguments().length];
            }
            {
                this.$this_substituteArguments = coneKotlinType;
                super(0);
            }
        }));
        boolean initialized = false;
        ConeTypeProjection[] coneTypeProjectionArray = $this$substituteArguments.getTypeArguments();
        int n = coneTypeProjectionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object2;
            typeArgument = coneTypeProjectionArray[n2];
            object = newArguments2;
            Object var10_13 = null;
            bl = false;
            ConeTypeProjection[] coneTypeProjectionArray2 = (ConeTypeProjection[])object.getValue();
            int n3 = index2;
            ConeTypeProjection coneTypeProjection = this.substituteArgument(typeArgument);
            if (coneTypeProjection != null) {
                object = coneTypeProjection;
                boolean bl2 = false;
                bl = false;
                Object object3 = object;
                int n4 = n3;
                ConeTypeProjection[] coneTypeProjectionArray3 = coneTypeProjectionArray2;
                boolean bl3 = false;
                initialized = true;
                Unit unit = Unit.INSTANCE;
                coneTypeProjectionArray2 = coneTypeProjectionArray3;
                n3 = n4;
                object2 = object;
            } else {
                object2 = null;
            }
            coneTypeProjectionArray2[n3] = object2;
            ++index2;
        }
        if (initialized) {
            ConeTypeProjection[] coneTypeProjectionArray4;
            Object object4;
            coneTypeProjectionArray = $this$substituteArguments.getTypeArguments();
            n = coneTypeProjectionArray.length;
            for (index2 = 0; index2 < n; ++index2) {
                typeArgument = coneTypeProjectionArray[index2];
                object = newArguments2;
                Object var10_15 = null;
                bl = false;
                if (((ConeTypeProjection[])object.getValue())[index2] != null) continue;
                object = newArguments2;
                var10_15 = null;
                bl = false;
                ((ConeTypeProjection[])object.getValue())[index2] = typeArgument;
            }
            ConeKotlinType coneKotlinType = $this$substituteArguments;
            if (coneKotlinType instanceof ConeClassLikeTypeImpl) {
                object4 = newArguments2;
                coneTypeProjectionArray = null;
                n = 0;
                coneTypeProjectionArray4 = (ConeTypeProjection[])object4.getValue();
                if (coneTypeProjectionArray4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<org.jetbrains.kotlin.fir.types.ConeTypeProjection>");
                }
            } else {
                if (coneKotlinType instanceof ConeClassLikeType) {
                    object4 = "Unknown class-like type to substitute: " + $this$substituteArguments + ", " + Reflection.getOrCreateKotlinClass($this$substituteArguments.getClass());
                    boolean bl4 = false;
                    throw (Throwable)new IllegalStateException(object4.toString());
                }
                object4 = "Unknown type to substitute: " + $this$substituteArguments + ", " + Reflection.getOrCreateKotlinClass($this$substituteArguments.getClass());
                boolean bl5 = false;
                throw (Throwable)new IllegalStateException(object4.toString());
            }
            return new ConeClassLikeTypeImpl(((ConeClassLikeTypeImpl)$this$substituteArguments).getLookupTag(), coneTypeProjectionArray4, $this$substituteArguments.getNullability().isNullable(), $this$substituteArguments.getAttributes());
        }
        return null;
    }
}

