/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.InstallationSupplier;

public class EnvironmentVariableListInstallationSupplier
implements InstallationSupplier {
    private final ProviderFactory factory;

    @Inject
    public EnvironmentVariableListInstallationSupplier(ProviderFactory factory) {
        this.factory = factory;
    }

    @Override
    public Set<InstallationLocation> get() {
        Provider property = this.factory.gradleProperty("org.gradle.java.installations.fromEnv").forUseAtConfigurationTime();
        if (property.isPresent()) {
            String listOfEnvironmentVariables = (String)property.get();
            return Arrays.stream(listOfEnvironmentVariables.split(",")).map(this::resolveEnvironmentVariable).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private Optional<InstallationLocation> resolveEnvironmentVariable(String environmentVariable) {
        String path;
        Provider<String> value = this.environmentVariableValue(environmentVariable);
        if (value.isPresent() && !(path = ((String)value.get()).trim()).isEmpty()) {
            return Optional.of(new InstallationLocation(new File(path), "environment variable '" + environmentVariable + "'"));
        }
        return Optional.empty();
    }

    private Provider<String> environmentVariableValue(String environmentVariable) {
        return this.factory.environmentVariable(environmentVariable.trim()).forUseAtConfigurationTime();
    }
}

