/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.builtins.CompileTimeUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0015\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "value", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "receiverClass", "Ljava/lang/Class;", "typeFqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "getValue", "()Ljava/lang/Object;", "getJavaOriginalName", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getMethod", "Ljava/lang/invoke/MethodHandle;", "toString", "Companion", "ir.interpreter"})
public final class Wrapper
extends Complex {
    private final FqNameUnsafe typeFqName;
    private final Class<? extends Object> receiverClass;
    private final Object value;
    private final IrClass irClass;
    private static final Map<String, Object> companionObjectValue;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final MethodHandle getMethod(@NotNull IrFunction irFunction2) {
        String string2;
        Object v7;
        block8: {
            Object object;
            IrFunction irFunction3;
            Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
            String string3 = UtilsKt.getEvaluateIntrinsicValue(irFunction2);
            if (string3 != null) {
                CharSequence charSequence = string3;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    return null;
                }
            }
            if (!((irFunction3 = irFunction2) instanceof IrSimpleFunction)) {
                irFunction3 = null;
            }
            String propertyName = (object = (IrSimpleFunction)irFunction3) != null && (object = ((IrSimpleFunction)object).getCorrespondingPropertySymbol()) != null && (object = (IrProperty)object.getOwner()) != null && (object = object.getName()) != null ? ((Name)object).asString() : null;
            Object[] objectArray = new String[2];
            objectArray[0] = propertyName;
            String string4 = propertyName;
            objectArray[1] = "get" + (string4 != null ? StringsKt.capitalize((String)string4) : null);
            Iterable $this$firstOrNull$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block7: {
                    Method[] $this$any$iv;
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)this.receiverClass.getMethods(), (String)"receiverClass.methods");
                    boolean $i$f$any = false;
                    Method[] methodArray = $this$any$iv;
                    int n = methodArray.length;
                    for (int i = 0; i < n; ++i) {
                        Method element$iv2;
                        Method method = element$iv2 = methodArray[i];
                        boolean bl3 = false;
                        Method method2 = method;
                        Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"method");
                        if (!Intrinsics.areEqual((Object)method2.getName(), (Object)it)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
                if (!bl) continue;
                v7 = element$iv;
                break block8;
            }
            v7 = null;
        }
        String propertyCall = v7;
        String intrinsicName = this.getJavaOriginalName(irFunction2);
        String string5 = intrinsicName;
        if (string5 == null) {
            string5 = string2 = propertyCall;
        }
        if (string5 == null) {
            String string6 = irFunction2.getName().toString();
            string2 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"irFunction.name.toString()");
        }
        String methodName = string2;
        MethodType methodType = Wrapper.Companion.getMethodType(irFunction2);
        return MethodHandles.lookup().findVirtual(this.receiverClass, methodName, methodType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getJavaOriginalName(IrFunction irFunction2) {
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(UtilsKt.getLastOverridden(irFunction2));
        if (fqName2 == null) return null;
        String string2 = fqName2.asString();
        if (string2 == null) return null;
        switch (string2) {
            case "kotlin.collections.Map.<get-entries>": {
                return "entrySet";
            }
            case "kotlin.collections.Map.<get-keys>": {
                return "keySet";
            }
            case "kotlin.CharSequence.get": {
                return "charAt";
            }
            case "kotlin.collections.MutableList.removeAt": {
                return "remove";
            }
            default: {
                return null;
            }
        }
    }

    @NotNull
    public String toString() {
        return "Wrapper(obj='" + this.typeFqName + "', value=" + this.value + ')';
    }

    @NotNull
    public final Object getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    public Wrapper(@NotNull Object value2, @NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        boolean bl = false;
        super(irClass2, new ArrayList());
        this.value = value2;
        this.irClass = irClass2;
        FqNameUnsafe fqNameUnsafe = AdditionalIrUtilsKt.getFqNameForIrSerialization(this.getIrClass()).toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"irClass.fqNameForIrSerialization.toUnsafe()");
        this.typeFqName = fqNameUnsafe;
        this.receiverClass = Wrapper.Companion.getClass(IrUtilsKt.getDefaultType(this.getIrClass()), true);
    }

    static {
        Companion = new Companion(null);
        companionObjectValue = MapsKt.mapOf((Pair)TuplesKt.to((Object)"kotlin.text.Regex$Companion", (Object)Regex.Companion));
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\tJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\rJ\u001c\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\rH\u0002J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d*\u00020\rH\u0002J\f\u0010\u001f\u001a\u00020\u0019*\u00020\rH\u0002J\f\u0010 \u001a\u00020\u0019*\u00020\rH\u0002J\u0014\u0010!\u001a\u00020\u0019*\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper$Companion;", "", "()V", "companionObjectValue", "", "", "getCompanionObject", "Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getConstructorMethod", "Ljava/lang/invoke/MethodHandle;", "irConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getEnumEntry", "enumClass", "getStaticGetter", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getStaticMethod", "irFunction", "getClass", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "asObject", "", "getMethodType", "Ljava/lang/invoke/MethodType;", "getOriginalOverriddenSymbols", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "isExtensionReceiverPrimitive", "isReturnTypePrimitiveAsObject", "isValueParameterPrimitiveAsObject", "index", "", "ir.interpreter"})
    public static final class Companion {
        @NotNull
        public final Wrapper getCompanionObject(@NotNull IrClass irClass2) {
            Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
            String string2 = UtilsKt.getEvaluateIntrinsicValue(irClass2);
            Intrinsics.checkNotNull((Object)string2);
            String objectName = string2;
            Object v = companionObjectValue.get(objectName);
            if (v == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Companion object " + objectName + " cannot be interpreted")));
            }
            Object objectValue = v;
            return new Wrapper(objectValue, irClass2);
        }

        @Nullable
        public final MethodHandle getConstructorMethod(@NotNull IrFunction irConstructor2) {
            Intrinsics.checkNotNullParameter((Object)irConstructor2, (String)"irConstructor");
            String intrinsicValue = UtilsKt.getEvaluateIntrinsicValue(IrUtilsKt.getParentAsClass(irConstructor2));
            if (Intrinsics.areEqual((Object)intrinsicValue, (Object)"kotlin.Char") || Intrinsics.areEqual((Object)intrinsicValue, (Object)"kotlin.Long")) {
                return null;
            }
            MethodType methodType = this.getMethodType(irConstructor2);
            return MethodHandles.lookup().findConstructor(this.getClass(irConstructor2.getReturnType(), true), methodType);
        }

        @Nullable
        public final MethodHandle getStaticMethod(@NotNull IrFunction irFunction2) {
            String intrinsicName;
            Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
            String string2 = intrinsicName = UtilsKt.getEvaluateIntrinsicValue(irFunction2);
            if (string2 != null) {
                CharSequence charSequence = string2;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    return null;
                }
            }
            String string3 = intrinsicName;
            Intrinsics.checkNotNull((Object)string3);
            Class<?> jvmClassName = Class.forName(string3);
            MethodType methodType = this.getMethodType(irFunction2);
            return MethodHandles.lookup().findStatic(jvmClassName, irFunction2.getName().asString(), methodType);
        }

        @Nullable
        public final MethodHandle getStaticGetter(@NotNull IrField field) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Class<? extends Object> jvmClass = this.getClass(IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(field)), true);
            Class<? extends Object> returnType2 = this.getClass(field.getType(), false);
            return MethodHandles.lookup().findStaticGetter(jvmClass, field.getName().asString(), returnType2);
        }

        @Nullable
        public final MethodHandle getEnumEntry(@NotNull IrClass enumClass2) {
            String intrinsicName;
            Intrinsics.checkNotNullParameter((Object)enumClass2, (String)"enumClass");
            String string2 = intrinsicName = UtilsKt.getEvaluateIntrinsicValue(enumClass2);
            if (string2 != null) {
                CharSequence charSequence = string2;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    return null;
                }
            }
            String string3 = intrinsicName;
            Intrinsics.checkNotNull((Object)string3);
            Class<?> enumClassName = Class.forName(string3);
            MethodType methodType = MethodType.methodType(enumClassName, String.class);
            return MethodHandles.lookup().findStatic(enumClassName, "valueOf", methodType);
        }

        /*
         * WARNING - void declaration
         */
        private final MethodType getMethodType(IrFunction $this$getMethodType) {
            MethodType methodType;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$getMethodType.getValueParameters();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Class<? extends Object> clazz = Companion.getClass(it.getType(), Companion.isValueParameterPrimitiveAsObject($this$getMethodType, it.getIndex()));
                collection.add(clazz);
            }
            List argsClasses = (List)destination$iv$iv;
            if ($this$getMethodType instanceof IrSimpleFunction) {
                Class<? extends Object> returnClass = this.getClass($this$getMethodType.getReturnType(), this.isReturnTypePrimitiveAsObject($this$getMethodType));
                IrAnnotationContainer irAnnotationContainer = $this$getMethodType.getExtensionReceiverParameter();
                Class<? extends Object> extensionClass = irAnnotationContainer != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null ? this.getClass((IrType)irAnnotationContainer, this.isExtensionReceiverPrimitive($this$getMethodType)) : null;
                methodType = MethodType.methodType(returnClass, CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(extensionClass), (Iterable)argsClasses));
            } else {
                methodType = MethodType.methodType(Void.TYPE, argsClasses);
            }
            Intrinsics.checkNotNullExpressionValue((Object)methodType, (String)"if (this is IrSimpleFunc\u2026rgsClasses)\n            }");
            return methodType;
        }

        private final Class<? extends Object> getClass(IrType $this$getClass, boolean asObject) {
            Class<Object> clazz;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$getClass);
            IrClass owner = irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null;
            Object object = owner;
            String fqName2 = object != null && (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) != null ? ((FqName)object).asString() : null;
            IrType notNullType = IrTypesKt.makeNotNull($this$getClass);
            if (IrTypePredicatesKt.isPrimitiveType(notNullType) || IrTypePredicatesKt.isString(notNullType)) {
                Class<?> clazz2 = UtilsKt.getPrimitiveClass(notNullType, asObject);
                clazz = clazz2;
                Intrinsics.checkNotNull(clazz2);
            } else if (IrTypePredicatesKt.isArray(notNullType)) {
                clazz = asObject ? Object[].class : Object[].class;
            } else if (IrTypePredicatesKt.isNothing(notNullType)) {
                clazz = Void.class;
            } else if (IrTypePredicatesKt.isAny(notNullType)) {
                clazz = Object.class;
            } else if (IrTypePredicatesKt.isNumber(notNullType)) {
                clazz = Number.class;
            } else if (IrTypePredicatesKt.isCharSequence(notNullType)) {
                clazz = CharSequence.class;
            } else if (IrTypePredicatesKt.isComparable(notNullType)) {
                clazz = Comparable.class;
            } else if (UtilsKt.isThrowable(notNullType)) {
                clazz = Throwable.class;
            } else if (IrTypePredicatesKt.isIterable(notNullType)) {
                clazz = Iterable.class;
            } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.Enum")) {
                clazz = Enum.class;
            } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.Collection") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableCollection")) {
                clazz = Collection.class;
            } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.List") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableList")) {
                clazz = List.class;
            } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.Set") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableSet")) {
                clazz = Set.class;
            } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.Map") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableMap")) {
                clazz = Map.class;
            } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.ListIterator") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableListIterator")) {
                clazz = ListIterator.class;
            } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.Iterator") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableIterator")) {
                clazz = Iterator.class;
            } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.Map.Entry") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableMap.MutableEntry")) {
                clazz = Map.Entry.class;
            } else if (Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.ListIterator") || Intrinsics.areEqual((Object)fqName2, (Object)"kotlin.collections.MutableListIterator")) {
                clazz = ListIterator.class;
            } else if (UtilsKt.hasAnnotation(owner, CompileTimeUtilsKt.getEvaluateIntrinsicAnnotation())) {
                IrClass irClass2 = owner;
                Intrinsics.checkNotNull((Object)irClass2);
                Class<?> clazz3 = Class.forName(UtilsKt.getEvaluateIntrinsicValue(irClass2));
                clazz = clazz3;
                Intrinsics.checkNotNullExpressionValue(clazz3, (String)"Class.forName(owner!!.getEvaluateIntrinsicValue())");
            } else if (fqName2 == null) {
                clazz = Object.class;
            } else {
                Class<?> clazz4 = Class.forName(UtilsKt.internalName(owner));
                clazz = clazz4;
                Intrinsics.checkNotNullExpressionValue(clazz4, (String)"Class.forName(owner.internalName())");
            }
            return clazz;
        }

        private final List<IrFunctionSymbol> getOriginalOverriddenSymbols(IrFunction $this$getOriginalOverriddenSymbols) {
            boolean bl = false;
            List overriddenSymbols2 = new ArrayList();
            if ($this$getOriginalOverriddenSymbols instanceof IrSimpleFunction) {
                List pool = CollectionsKt.toMutableList((Collection)((IrSimpleFunction)$this$getOriginalOverriddenSymbols).getOverriddenSymbols());
                ListIterator<IrSimpleFunctionSymbol> iterator2 = pool.listIterator();
                Object object = iterator2;
                boolean bl2 = false;
                Iterator iterator3 = object;
                while (iterator3.hasNext()) {
                    IrSimpleFunctionSymbol symbol2 = (IrSimpleFunctionSymbol)iterator3.next();
                    if (((IrSimpleFunction)symbol2.getOwner()).getOverriddenSymbols().isEmpty()) {
                        object = overriddenSymbols2;
                        bl2 = false;
                        object.add(symbol2);
                        iterator2.remove();
                        continue;
                    }
                    Iterable $this$forEach$iv = ((IrSimpleFunction)symbol2.getOwner()).getOverriddenSymbols();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                        boolean bl3 = false;
                        iterator2.add(it);
                    }
                }
            }
            if (overriddenSymbols2.isEmpty()) {
                overriddenSymbols2.add($this$getOriginalOverriddenSymbols.getSymbol());
            }
            return overriddenSymbols2;
        }

        private final boolean isExtensionReceiverPrimitive(IrFunction $this$isExtensionReceiverPrimitive) {
            IrAnnotationContainer irAnnotationContainer = $this$isExtensionReceiverPrimitive.getExtensionReceiverParameter();
            return irAnnotationContainer != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null && !IrTypePredicatesKt.isPrimitiveType((IrType)irAnnotationContainer);
        }

        private final boolean isReturnTypePrimitiveAsObject(IrFunction $this$isReturnTypePrimitiveAsObject) {
            for (IrFunctionSymbol symbol2 : this.getOriginalOverriddenSymbols($this$isReturnTypePrimitiveAsObject)) {
                if (UtilsKt.isTypeParameter(symbol2.getOwner().getReturnType()) || IrTypeUtilsKt.isNullable(symbol2.getOwner().getReturnType())) continue;
                return false;
            }
            return true;
        }

        private final boolean isValueParameterPrimitiveAsObject(IrFunction $this$isValueParameterPrimitiveAsObject, int index2) {
            for (IrFunctionSymbol symbol2 : this.getOriginalOverriddenSymbols($this$isValueParameterPrimitiveAsObject)) {
                if (UtilsKt.isTypeParameter(symbol2.getOwner().getValueParameters().get(index2).getType()) || IrTypeUtilsKt.isNullable(symbol2.getOwner().getValueParameters().get(index2).getType())) continue;
                return false;
            }
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

