/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesSupport;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InnerClassConstructorCallsLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "innerClassesSupport", "Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "getInnerClassesSupport", "()Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "ir.backend.common"})
public final class InnerClassConstructorCallsLowering
implements BodyLoweringPass {
    private final BackendContext context;
    private final InnerClassesSupport innerClassesSupport;

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this){
            final /* synthetic */ InnerClassConstructorCallsLowering this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrExpression irExpression = expression2.getDispatchReceiver();
                if (irExpression == null) {
                    return expression2;
                }
                IrExpression dispatchReceiver = irExpression;
                IrConstructorSymbol callee = expression2.getSymbol();
                IrClass parent2 = IrUtilsKt.getParentAsClass((IrDeclaration)callee.getOwner());
                if (!parent2.isInner()) {
                    return expression2;
                }
                IrConstructor newCallee = this.this$0.getInnerClassesSupport().getInnerClassConstructorWithOuterThisParameter((IrConstructor)callee.getOwner());
                int classTypeParametersCount = expression2.getTypeArgumentsCount() - expression2.getConstructorTypeArgumentsCount();
                IrConstructorCallImpl newCall = IrConstructorCallImpl.Companion.fromSymbolOwner(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), (IrConstructorSymbol)newCallee.getSymbol(), classTypeParametersCount, expression2.getOrigin());
                IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default(newCall, expression2, 0, 2, null);
                newCall.putValueArgument(0, dispatchReceiver);
                int n = 1;
                int n2 = CollectionsKt.getLastIndex(newCallee.getValueParameters());
                if (n <= n2) {
                    while (true) {
                        void i;
                        newCall.putValueArgument((int)i, expression2.getValueArgument((int)(i - true)));
                        if (i == n2) break;
                        ++i;
                    }
                }
                return newCall;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrExpression irExpression = expression2.getDispatchReceiver();
                if (irExpression == null) {
                    return expression2;
                }
                IrExpression dispatchReceiver = irExpression;
                IrConstructor classConstructor = (IrConstructor)expression2.getSymbol().getOwner();
                if (!IrUtilsKt.getParentAsClass(classConstructor).isInner()) {
                    return expression2;
                }
                IrConstructor newCallee = this.this$0.getInnerClassesSupport().getInnerClassConstructorWithOuterThisParameter(classConstructor);
                IrDelegatingConstructorCallImpl irDelegatingConstructorCallImpl = new IrDelegatingConstructorCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getUnitType(), (IrConstructorSymbol)newCallee.getSymbol(), expression2.getTypeArgumentsCount(), newCallee.getValueParameters().size());
                int n = 0;
                boolean bl = false;
                IrDelegatingConstructorCallImpl $this$apply = irDelegatingConstructorCallImpl;
                boolean bl2 = false;
                IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default($this$apply, expression2, 0, 2, null);
                IrDelegatingConstructorCallImpl newCall = irDelegatingConstructorCallImpl;
                newCall.putValueArgument(0, dispatchReceiver);
                int n2 = 1;
                n = CollectionsKt.getLastIndex(newCallee.getValueParameters());
                if (n2 <= n) {
                    while (true) {
                        void i;
                        newCall.putValueArgument((int)i, expression2.getValueArgument((int)(i - true)));
                        if (i == n) break;
                        ++i;
                    }
                }
                return newCall;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
                IrConstructor irConstructor2;
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                S s = expression2.getSymbol();
                if (!(s instanceof IrConstructorSymbol)) {
                    s = null;
                }
                IrConstructorSymbol irConstructorSymbol = (IrConstructorSymbol)s;
                if (irConstructorSymbol == null) {
                    return expression2;
                }
                IrConstructorSymbol callee = irConstructorSymbol;
                IrDeclarationParent irDeclarationParent = ((IrConstructor)callee.getOwner()).getParent();
                if (!(irDeclarationParent instanceof IrClass)) {
                    irDeclarationParent = null;
                }
                IrClass irClass2 = (IrClass)irDeclarationParent;
                if (irClass2 == null) {
                    return expression2;
                }
                IrClass parent2 = irClass2;
                if (!parent2.isInner()) {
                    return expression2;
                }
                IrConstructor newCallee = this.this$0.getInnerClassesSupport().getInnerClassConstructorWithOuterThisParameter((IrConstructor)callee.getOwner());
                IrFunctionSymbol irFunctionSymbol = expression2.getReflectionTarget();
                if (irFunctionSymbol != null) {
                    IrFunctionSymbol irFunctionSymbol2 = irFunctionSymbol;
                    boolean bl2 = false;
                    bl = false;
                    IrFunctionSymbol reflectionTarget = irFunctionSymbol2;
                    boolean bl3 = false;
                    irConstructor2 = reflectionTarget instanceof IrConstructorSymbol ? this.this$0.getInnerClassesSupport().getInnerClassConstructorWithOuterThisParameter((IrConstructor)((IrConstructorSymbol)reflectionTarget).getOwner()) : null;
                } else {
                    irConstructor2 = null;
                }
                IrConstructor newReflectionTarget = irConstructor2;
                IrFunctionReference irFunctionReference = expression2;
                bl = false;
                boolean bl4 = false;
                IrFunctionReference $this$run = irFunctionReference;
                boolean bl5 = false;
                IrConstructor irConstructor3 = newReflectionTarget;
                IrFunctionReferenceImpl newReference = new IrFunctionReferenceImpl($this$run.getStartOffset(), $this$run.getEndOffset(), $this$run.getType(), newCallee.getSymbol(), $this$run.getTypeArgumentsCount(), newCallee.getValueParameters().size(), irConstructor3 != null ? (IrConstructorSymbol)irConstructor3.getSymbol() : null, $this$run.getOrigin());
                irFunctionReference = newReference;
                bl = false;
                bl4 = false;
                IrFunctionReference it = irFunctionReference;
                boolean bl6 = false;
                IrMemberAccessExpressionKt.copyTypeArgumentsFrom$default(it, expression2, 0, 2, null);
                it.setDispatchReceiver(expression2.getDispatchReceiver());
                it.setExtensionReceiver(expression2.getExtensionReceiver());
                int n = 0;
                int n2 = expression2.getValueArgumentsCount();
                while (n < n2) {
                    void v;
                    ((IrFunctionReferenceImpl)it).putValueArgument((int)v, expression2.getValueArgument((int)v));
                    ++v;
                }
                return newReference;
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final InnerClassesSupport getInnerClassesSupport() {
        return this.innerClassesSupport;
    }

    public InnerClassConstructorCallsLowering(@NotNull BackendContext context2, @NotNull InnerClassesSupport innerClassesSupport) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)innerClassesSupport, (String)"innerClassesSupport");
        this.context = context2;
        this.innerClassesSupport = innerClassesSupport;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        BodyLoweringPass.DefaultImpls.lower(this, irFile);
    }
}

