/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting;

import java.io.File;
import org.gradle.api.Incubating;
import org.gradle.api.Namer;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.model.ReplacedBy;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.util.Configurable;

public interface Report
extends Configurable<Report> {
    public static final Namer<Report> NAMER = new Namer<Report>(){

        public String determineName(Report report) {
            return report.getName();
        }
    };

    @Input
    public String getName();

    @Input
    public String getDisplayName();

    @Input
    @Incubating
    public Property<Boolean> getRequired();

    @ReplacedBy(value="required")
    public boolean isEnabled();

    public void setEnabled(boolean var1);

    @Incubating
    @Internal(value="Implementations need to add the correct annotation, @OutputDirectory or @OutputFile")
    public Provider<? extends FileSystemLocation> getOutputLocation();

    @ReplacedBy(value="outputLocation")
    public File getDestination();

    @Input
    public OutputType getOutputType();

    public static enum OutputType {
        FILE,
        DIRECTORY;

    }
}

