/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.impl;

import com.google.common.collect.Ordering;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.file.FileType;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.SnapshotUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputsCleaner {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutputsCleaner.class);
    private final Deleter deleter;
    private final PriorityQueue<File> directoriesToDelete;
    private final Predicate<File> fileSafeToDelete;
    private final Predicate<File> dirSafeToDelete;
    private boolean didWork;

    public OutputsCleaner(Deleter deleter, Predicate<File> fileSafeToDelete, Predicate<File> dirSafeToDelete) {
        this.deleter = deleter;
        this.fileSafeToDelete = fileSafeToDelete;
        this.dirSafeToDelete = dirSafeToDelete;
        this.directoriesToDelete = new PriorityQueue(10, Ordering.natural().reverse());
    }

    public void cleanupOutputs(FileSystemSnapshot snapshot) throws IOException {
        for (Map.Entry entry : SnapshotUtil.index((FileSystemSnapshot)snapshot).entrySet()) {
            this.cleanupOutput(new File((String)entry.getKey()), ((FileSystemLocationSnapshot)entry.getValue()).getType());
        }
        this.cleanupDirectories();
    }

    public void cleanupOutput(File file, FileType fileType) throws IOException {
        switch (fileType) {
            case Directory: {
                this.markDirForDeletion(file);
                break;
            }
            case RegularFile: {
                if (!this.fileSafeToDelete.test(file)) break;
                if (file.exists()) {
                    LOGGER.debug("Deleting stale output file '{}'.", (Object)file);
                    this.deleter.delete(file);
                    this.didWork = true;
                }
                this.markParentDirForDeletion(file);
                break;
            }
            case Missing: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown file type: " + fileType));
            }
        }
    }

    public boolean getDidWork() {
        return this.didWork;
    }

    private void markParentDirForDeletion(File f) {
        this.markDirForDeletion(f.getParentFile());
    }

    private void markDirForDeletion(@Nullable File dir) {
        if (dir != null && this.dirSafeToDelete.test(dir)) {
            this.directoriesToDelete.add(dir);
        }
    }

    public void cleanupDirectories() throws IOException {
        File directory;
        while ((directory = this.directoriesToDelete.poll()) != null) {
            if (!this.isEmpty(directory)) continue;
            LOGGER.debug("Deleting stale empty output directory '{}'.", (Object)directory);
            Files.delete(directory.toPath());
            this.didWork = true;
            this.markParentDirForDeletion(directory);
        }
    }

    private boolean isEmpty(File parentDir) {
        String[] children = parentDir.list();
        return children != null && children.length == 0;
    }
}

