/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ConfigurationVariantInternal;
import org.gradle.api.internal.artifacts.DefaultPublishArtifactSet;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.LeafOutgoingVariant;
import org.gradle.api.internal.artifacts.configurations.OutgoingVariant;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributeContainerWithErrorMessage;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factory;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultVariant
implements ConfigurationVariantInternal {
    private final Describable parentDisplayName;
    private final String name;
    private AttributeContainerInternal attributes;
    private final NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser;
    private final PublishArtifactSet artifacts;
    private Factory<List<PublishArtifact>> lazyArtifacts;

    public DefaultVariant(Describable parentDisplayName, String name, AttributeContainerInternal parentAttributes, NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser, FileCollectionFactory fileCollectionFactory, ImmutableAttributesFactory cache, DomainObjectCollectionFactory domainObjectCollectionFactory) {
        this.parentDisplayName = parentDisplayName;
        this.name = name;
        this.attributes = cache.mutable(parentAttributes);
        this.artifactNotationParser = artifactNotationParser;
        this.artifacts = new DefaultPublishArtifactSet((Describable)this.getAsDescribable(), (DomainObjectSet<PublishArtifact>)domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class), fileCollectionFactory);
    }

    public String getName() {
        return this.name;
    }

    public OutgoingVariant convertToOutgoingVariant() {
        return new LeafOutgoingVariant(this.getAsDescribable(), this.attributes, (Set<? extends PublishArtifact>)this.getArtifacts());
    }

    public void visit(ConfigurationInternal.VariantVisitor visitor) {
        visitor.visitChildVariant(this.name, this.getAsDescribable(), this.attributes.asImmutable(), (Collection<? extends PublishArtifact>)this.getArtifacts());
    }

    private DisplayName getAsDescribable() {
        return Describables.of((Object)this.parentDisplayName, (Object)"variant", (Object)this.name);
    }

    public AttributeContainerInternal getAttributes() {
        return this.attributes;
    }

    public ConfigurationVariant attributes(Action<? super AttributeContainer> action) {
        action.execute((Object)this.attributes);
        return this;
    }

    public PublishArtifactSet getArtifacts() {
        if (this.lazyArtifacts != null) {
            this.artifacts.addAll((Collection)this.lazyArtifacts.create());
            this.lazyArtifacts = null;
        }
        return this.artifacts;
    }

    public void artifact(Object notation) {
        this.artifacts.add((Object)((PublishArtifact)this.artifactNotationParser.parseNotation(notation)));
    }

    public void artifact(Object notation, Action<? super ConfigurablePublishArtifact> configureAction) {
        ConfigurablePublishArtifact publishArtifact = (ConfigurablePublishArtifact)this.artifactNotationParser.parseNotation(notation);
        this.artifacts.add((Object)publishArtifact);
        configureAction.execute((Object)publishArtifact);
    }

    public String toString() {
        return this.getAsDescribable().getDisplayName();
    }

    public void artifactsProvider(Factory<List<PublishArtifact>> artifacts) {
        this.lazyArtifacts = artifacts;
    }

    public void preventFurtherMutation() {
        this.attributes = new ImmutableAttributeContainerWithErrorMessage((AttributeContainerInternal)this.attributes.asImmutable(), this.parentDisplayName);
    }
}

