/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.compiled;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.compiled.ClassFileDecompilers;
import org.jetbrains.kotlin.com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.BinaryFileStubBuilder;
import org.jetbrains.kotlin.com.intellij.psi.stubs.Stub;
import org.jetbrains.kotlin.com.intellij.util.cls.ClsFormatException;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.indexing.FileContent;
import org.jetbrains.kotlin.com.intellij.util.indexing.InvertedIndex;

public class ClassFileStubBuilder
implements BinaryFileStubBuilder.CompositeBinaryFileStubBuilder<ClassFileDecompilers.Decompiler> {
    private static final Logger LOG = Logger.getInstance(ClassFileStubBuilder.class);
    public static final int STUB_VERSION = 23;
    private static final Comparator<Object> CLASS_NAME_COMPARATOR = Comparator.comparing(o -> o.getClass().getName());

    @Override
    public boolean acceptsFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Override
    @NotNull
    public Stream<ClassFileDecompilers.Decompiler> getAllSubBuilders() {
        Stream<ClassFileDecompilers.Decompiler> stream = ClassFileDecompilers.EP_NAME.extensions();
        if (stream == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(1);
        }
        return stream;
    }

    @Override
    @Nullable
    public ClassFileDecompilers.Decompiler getSubBuilder(@NotNull FileContent fileContent) {
        if (fileContent == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(2);
        }
        return ClassFileStubBuilder.setContentAndCompute(fileContent, () -> ClassFileDecompilers.find(fileContent.getFile()));
    }

    @Override
    @NotNull
    public String getSubBuilderVersion(@Nullable ClassFileDecompilers.Decompiler decompiler) {
        if (decompiler == null) {
            return "default";
        }
        int version = decompiler instanceof ClassFileDecompilers.Full ? ((ClassFileDecompilers.Full)decompiler).getStubBuilder().getStubVersion() : 0;
        String string2 = decompiler.getClass().getName() + ":" + version;
        if (string2 == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    @Nullable
    public Stub buildStubTree(@NotNull FileContent fileContent, @Nullable ClassFileDecompilers.Decompiler decompiler) {
        if (fileContent == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(4);
        }
        return ClassFileStubBuilder.setContentAndCompute(fileContent, () -> {
            VirtualFile file2 = fileContent.getFile();
            try {
                if (decompiler instanceof ClassFileDecompilers.Full) {
                    return ((ClassFileDecompilers.Full)decompiler).getStubBuilder().buildFileStub(fileContent);
                }
            }
            catch (ClsFormatException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(file2.getPath(), e);
                }
                LOG.info(file2.getPath() + ": " + e.getMessage());
            }
            try {
                PsiJavaFileStub stub = ClsFileImpl.buildFileStub(file2, fileContent.getContent());
                if (stub == null && fileContent.getFileName().indexOf(36) < 0) {
                    LOG.info("No stub built for the file " + fileContent);
                }
                return stub;
            }
            catch (ClsFormatException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(file2.getPath(), e);
                } else {
                    LOG.info(file2.getPath() + ": " + e.getMessage());
                }
                return null;
            }
        });
    }

    @Override
    public int getStubVersion() {
        int version = 23;
        if (!InvertedIndex.ARE_COMPOSITE_INDEXERS_ENABLED) {
            ArrayList<ClassFileDecompilers.Decompiler> decompilers = ContainerUtil.newArrayList(ClassFileDecompilers.EP_NAME.getExtensions());
            decompilers.sort(CLASS_NAME_COMPARATOR);
            for (ClassFileDecompilers.Decompiler decompiler : decompilers) {
                if (!(decompiler instanceof ClassFileDecompilers.Full)) continue;
                version = version * 31 + ((ClassFileDecompilers.Full)decompiler).getStubBuilder().getStubVersion() + decompiler.getClass().getName().hashCode();
            }
        }
        return version;
    }

    private static <T> T setContentAndCompute(@NotNull FileContent content, @NotNull Supplier<T> computation) {
        if (content == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(5);
        }
        if (computation == null) {
            ClassFileStubBuilder.$$$reportNull$$$0(6);
        }
        try {
            content.getFile().setPreloadedContentHint(content.getContent());
            T t = computation.get();
            return t;
        }
        finally {
            content.getFile().setPreloadedContentHint(null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClassFileStubBuilder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/compiled/ClassFileStubBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSubBuilders";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBuilderVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSubBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildStubTree";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setContentAndCompute";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

