/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformDependencies;
import org.gradle.api.internal.artifacts.transform.DefaultArtifactTransformDependencies;
import org.gradle.api.internal.artifacts.transform.ExecutionGraphDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.FilteredResultFactory;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.api.internal.artifacts.transform.Transformer;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.WorkNodeAction;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Factory;
import org.gradle.internal.Try;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;

public class DefaultExecutionGraphDependenciesResolver
implements ExecutionGraphDependenciesResolver {
    public static final ArtifactTransformDependencies MISSING_DEPENDENCIES = new ArtifactTransformDependencies(){

        @Override
        public FileCollection getFiles() {
            throw new IllegalStateException("Transform does not use artifact dependencies.");
        }

        @Override
        public CurrentFileCollectionFingerprint fingerprint(FileCollectionFingerprinter fingerprinter) {
            return fingerprinter.empty();
        }
    };
    private final ComponentIdentifier componentIdentifier;
    private final Factory<ResolverResults> graphResults;
    private final Factory<ResolverResults> artifactResults;
    private final WorkNodeAction graphResolveAction;
    private final FilteredResultFactory filteredResultFactory;
    private Set<ComponentIdentifier> buildDependencies;
    private Set<ComponentIdentifier> dependencies;

    public DefaultExecutionGraphDependenciesResolver(ComponentIdentifier componentIdentifier, Factory<ResolverResults> graphResults, Factory<ResolverResults> artifactResults, WorkNodeAction graphResolveAction, FilteredResultFactory filteredResultFactory) {
        this.componentIdentifier = componentIdentifier;
        this.graphResults = graphResults;
        this.artifactResults = artifactResults;
        this.graphResolveAction = graphResolveAction;
        this.filteredResultFactory = filteredResultFactory;
    }

    @Override
    public FileCollection selectedArtifacts(Transformer transformer) {
        if (!transformer.requiresDependencies()) {
            return MISSING_DEPENDENCIES.getFiles();
        }
        ResolverResults results = (ResolverResults)this.artifactResults.create();
        if (this.dependencies == null) {
            this.dependencies = DefaultExecutionGraphDependenciesResolver.computeDependencies(this.componentIdentifier, ComponentIdentifier.class, results.getResolutionResult().getAllComponents(), false);
        }
        return this.filteredResultFactory.resultsMatching(transformer.getFromAttributes(), (Spec<? super ComponentIdentifier>)((Spec)element -> this.dependencies.contains(element)));
    }

    @Override
    public Try<ArtifactTransformDependencies> computeArtifacts(Transformer transformer) {
        if (!transformer.requiresDependencies()) {
            return Try.successful((Object)MISSING_DEPENDENCIES);
        }
        try {
            FileCollection files = this.selectedArtifacts(transformer);
            files.getFiles();
            return Try.successful((Object)new DefaultArtifactTransformDependencies(files));
        }
        catch (Exception e) {
            return Try.failure((Throwable)e);
        }
    }

    @Override
    public TaskDependencyContainer computeDependencyNodes(TransformationStep transformationStep) {
        if (!transformationStep.requiresDependencies()) {
            return TaskDependencyContainer.EMPTY;
        }
        return context -> {
            ResolverResults results = (ResolverResults)this.graphResults.create();
            if (this.buildDependencies == null) {
                this.buildDependencies = DefaultExecutionGraphDependenciesResolver.computeDependencies(this.componentIdentifier, ProjectComponentIdentifier.class, results.getResolutionResult().getAllComponents(), true);
            }
            context.add((Object)this.filteredResultFactory.resultsMatching(transformationStep.getFromAttributes(), (Spec<? super ComponentIdentifier>)((Spec)element -> this.buildDependencies.contains(element))));
            context.add((Object)this.graphResolveAction);
        };
    }

    private static Set<ComponentIdentifier> computeDependencies(ComponentIdentifier componentIdentifier, Class<? extends ComponentIdentifier> type, Set<ResolvedComponentResult> componentResults, boolean strict) {
        ResolvedComponentResult targetComponent = null;
        for (ResolvedComponentResult component : componentResults) {
            if (!component.getId().equals(componentIdentifier)) continue;
            targetComponent = component;
            break;
        }
        if (targetComponent == null) {
            if (strict) {
                throw new AssertionError((Object)("Could not find component " + componentIdentifier + " in provided results."));
            }
            return Collections.emptySet();
        }
        HashSet<ComponentIdentifier> buildDependencies = new HashSet<ComponentIdentifier>();
        DefaultExecutionGraphDependenciesResolver.collectDependenciesIdentifiers(buildDependencies, type, new HashSet<ComponentIdentifier>(), targetComponent.getDependencies());
        return buildDependencies;
    }

    private static void collectDependenciesIdentifiers(Set<ComponentIdentifier> dependenciesIdentifiers, Class<? extends ComponentIdentifier> type, Set<ComponentIdentifier> visited, Set<? extends DependencyResult> dependencies) {
        for (DependencyResult dependencyResult : dependencies) {
            if (!(dependencyResult instanceof ResolvedDependencyResult)) continue;
            ResolvedDependencyResult resolvedDependency = (ResolvedDependencyResult)dependencyResult;
            ResolvedComponentResult selected = resolvedDependency.getSelected();
            if (type.isInstance(selected.getId())) {
                dependenciesIdentifiers.add(selected.getId());
            }
            if (!visited.add(selected.getId())) continue;
            DefaultExecutionGraphDependenciesResolver.collectDependenciesIdentifiers(dependenciesIdentifiers, type, visited, selected.getDependencies());
        }
    }
}

