/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.internal.service.scopes.VirtualFileSystemServices;
import org.gradle.internal.watch.vfs.WatchingAwareVirtualFileSystem;
import org.gradle.util.IncubationLogger;

public class FileSystemWatchingBuildActionRunner
implements BuildActionRunner {
    private final BuildActionRunner delegate;

    public FileSystemWatchingBuildActionRunner(BuildActionRunner delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildActionRunner.Result run(BuildAction action, BuildController buildController) {
        GradleInternal gradle = buildController.getGradle();
        StartParameterInternal startParameter = gradle.getStartParameter();
        WatchingAwareVirtualFileSystem virtualFileSystem = gradle.getServices().get(WatchingAwareVirtualFileSystem.class);
        boolean watchFileSystem = startParameter.isWatchFileSystem();
        FileSystemWatchingBuildActionRunner.logMessageForDeprecatedVfsRetentionProperty(startParameter);
        if (watchFileSystem) {
            IncubationLogger.incubatingFeatureUsed((String)"Watching the file system");
            FileSystemWatchingBuildActionRunner.dropVirtualFileSystemIfRequested(startParameter, virtualFileSystem);
        }
        virtualFileSystem.afterBuildStarted(watchFileSystem);
        try {
            BuildActionRunner.Result result = this.delegate.run(action, buildController);
            return result;
        }
        finally {
            virtualFileSystem.beforeBuildFinished(watchFileSystem);
        }
    }

    private static void dropVirtualFileSystemIfRequested(StartParameterInternal startParameter, WatchingAwareVirtualFileSystem virtualFileSystem) {
        if (VirtualFileSystemServices.isDropVfs((StartParameter)startParameter)) {
            virtualFileSystem.invalidateAll();
        }
    }

    private static void logMessageForDeprecatedVfsRetentionProperty(StartParameterInternal startParameter) {
        if (VirtualFileSystemServices.isDeprecatedVfsRetentionPropertyPresent((StartParameter)startParameter)) {
            String deprecatedVfsRetentionEnabledProperty = "org.gradle.unsafe.vfs.retention";
            DeprecationLogger.deprecateIndirectUsage((String)("Using the system property " + deprecatedVfsRetentionEnabledProperty + " to enable watching the file system")).withAdvice("Use the gradle property org.gradle.unsafe.watch-fs instead.").willBeRemovedInGradle7().withUserManual("gradle_daemon").nagUser();
        }
    }
}

