/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publication.maven.internal.action;

import org.gradle.api.logging.Logging;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.slf4j.Logger;
import org.sonatype.aether.transfer.AbstractTransferListener;
import org.sonatype.aether.transfer.MetadataNotFoundException;
import org.sonatype.aether.transfer.TransferEvent;

class LoggingMavenTransferListener
extends AbstractTransferListener {
    private static final Logger LOGGER = Logging.getLogger(LoggingMavenTransferListener.class);
    private static final int KILO = 1024;
    private final CurrentBuildOperationRef currentBuildOperationRef;
    private final BuildOperationRef buildOperationRef;
    private final ThreadLocal<BuildOperationRef> previousBuildOperationRef = new ThreadLocal();

    public LoggingMavenTransferListener(CurrentBuildOperationRef currentBuildOperationRef, BuildOperationRef buildOperationRef) {
        this.currentBuildOperationRef = currentBuildOperationRef;
        this.buildOperationRef = buildOperationRef;
    }

    public void transferInitiated(TransferEvent event) {
        this.previousBuildOperationRef.set(this.currentBuildOperationRef.get());
        this.currentBuildOperationRef.set(this.buildOperationRef);
        String message = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading: {} to repository {} at {}" : "Downloading: {} from repository {} at {}";
        LOGGER.info(message, new Object[]{event.getResource().getResourceName(), "remote", event.getResource().getRepositoryUrl()});
    }

    public void transferStarted(TransferEvent event) {
        long contentLength = event.getResource().getContentLength();
        if (contentLength > 0L) {
            LOGGER.info("Transferring {}K from remote", (Object)((contentLength + 512L) / 1024L));
        }
    }

    public void transferFailed(TransferEvent event) {
        if (event.getException() instanceof MetadataNotFoundException) {
            LOGGER.info(event.getException().getMessage());
        } else {
            LOGGER.error(event.getException().getMessage());
        }
        this.resetCurrentBuildOperationRef();
    }

    public void transferSucceeded(TransferEvent event) {
        long contentLength = event.getResource().getContentLength();
        if (contentLength > 0L && event.getRequestType() == TransferEvent.RequestType.PUT) {
            LOGGER.info("Uploaded {}K", (Object)((contentLength + 512L) / 1024L));
        }
        this.resetCurrentBuildOperationRef();
    }

    private void resetCurrentBuildOperationRef() {
        this.currentBuildOperationRef.set(this.previousBuildOperationRef.get());
    }
}

