/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.VariantMetadata;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ComponentMetadataProcessor;
import org.gradle.api.internal.artifacts.MetadataResolutionContext;
import org.gradle.api.internal.artifacts.dsl.ComponentMetadataRuleContainer;
import org.gradle.api.internal.artifacts.dsl.DefaultComponentMetadataContext;
import org.gradle.api.internal.artifacts.dsl.MetadataDescriptorFactory;
import org.gradle.api.internal.artifacts.dsl.MetadataRuleWrapper;
import org.gradle.api.internal.artifacts.dsl.SpecConfigurableRule;
import org.gradle.api.internal.artifacts.dsl.WrappingComponentMetadataContext;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.UserProvidedMetadata;
import org.gradle.api.internal.artifacts.repositories.resolver.ComponentMetadataDetailsAdapter;
import org.gradle.api.internal.artifacts.repositories.resolver.DependencyConstraintMetadataImpl;
import org.gradle.api.internal.artifacts.repositories.resolver.DirectDependencyMetadataImpl;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.Actions;
import org.gradle.internal.Factory;
import org.gradle.internal.action.ConfigurableRule;
import org.gradle.internal.action.ConfigurableRules;
import org.gradle.internal.action.DefaultConfigurableRules;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ivy.DefaultIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.ivy.RealisedIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.DefaultMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.RealisedMavenModuleResolveMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.caching.ComponentMetadataRuleExecutor;
import org.gradle.internal.rules.RuleAction;
import org.gradle.internal.rules.SpecRuleAction;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.InputStreamBackedDecoder;
import org.gradle.internal.serialize.OutputStreamBackedEncoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultComponentMetadataProcessor
implements ComponentMetadataProcessor {
    private static final boolean FORCE_REALIZE = Boolean.getBoolean("org.gradle.integtest.force.realize.metadata");
    private static final Transformer<ModuleComponentResolveMetadata, WrappingComponentMetadataContext> DETAILS_TO_RESULT = componentMetadataContext -> {
        ModuleComponentResolveMetadata metadata = componentMetadataContext.getMutableMetadata().asImmutable();
        return DefaultComponentMetadataProcessor.realizeMetadata(metadata);
    };
    private final Instantiator instantiator;
    private final NotationParser<Object, DirectDependencyMetadataImpl> dependencyMetadataNotationParser;
    private final NotationParser<Object, DependencyConstraintMetadataImpl> dependencyConstraintMetadataNotationParser;
    private final NotationParser<Object, ComponentIdentifier> componentIdentifierNotationParser;
    private final ImmutableAttributesFactory attributesFactory;
    private final ComponentMetadataRuleExecutor ruleExecutor;
    private final MetadataResolutionContext metadataResolutionContext;
    private final ComponentMetadataRuleContainer metadataRuleContainer;
    private final PlatformSupport platformSupport;

    private ModuleComponentResolveMetadata maybeForceRealisation(ModuleComponentResolveMetadata metadata) {
        if (FORCE_REALIZE) {
            metadata = DefaultComponentMetadataProcessor.realizeMetadata(metadata);
            metadata = this.forceSerialization(metadata);
        }
        return metadata;
    }

    private static ModuleComponentResolveMetadata realizeMetadata(ModuleComponentResolveMetadata metadata) {
        if (metadata instanceof DefaultIvyModuleResolveMetadata) {
            metadata = RealisedIvyModuleResolveMetadata.transform((DefaultIvyModuleResolveMetadata)metadata);
        } else if (metadata instanceof DefaultMavenModuleResolveMetadata) {
            metadata = RealisedMavenModuleResolveMetadata.transform((DefaultMavenModuleResolveMetadata)metadata);
        } else {
            throw new IllegalStateException("Invalid type received: " + metadata.getClass());
        }
        return metadata;
    }

    private ModuleComponentResolveMetadata forceSerialization(ModuleComponentResolveMetadata metadata) {
        byte[] bytes;
        Serializer<ModuleComponentResolveMetadata> serializer = this.ruleExecutor.getComponentMetadataContextSerializer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            serializer.write((Encoder)new OutputStreamBackedEncoder((OutputStream)byteArrayOutputStream), (Object)metadata);
            bytes = byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            ModuleComponentResolveMetadata forceRead;
            metadata = forceRead = (ModuleComponentResolveMetadata)serializer.read((Decoder)new InputStreamBackedDecoder((InputStream)new ByteArrayInputStream(bytes)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return metadata;
    }

    public DefaultComponentMetadataProcessor(ComponentMetadataRuleContainer metadataRuleContainer, Instantiator instantiator, NotationParser<Object, DirectDependencyMetadataImpl> dependencyMetadataNotationParser, NotationParser<Object, DependencyConstraintMetadataImpl> dependencyConstraintMetadataNotationParser, NotationParser<Object, ComponentIdentifier> componentIdentifierNotationParser, ImmutableAttributesFactory attributesFactory, ComponentMetadataRuleExecutor ruleExecutor, PlatformSupport platformSupport, MetadataResolutionContext resolutionContext) {
        this.metadataRuleContainer = metadataRuleContainer;
        this.instantiator = instantiator;
        this.dependencyMetadataNotationParser = dependencyMetadataNotationParser;
        this.dependencyConstraintMetadataNotationParser = dependencyConstraintMetadataNotationParser;
        this.componentIdentifierNotationParser = componentIdentifierNotationParser;
        this.attributesFactory = attributesFactory;
        this.ruleExecutor = ruleExecutor;
        this.platformSupport = platformSupport;
        this.metadataResolutionContext = resolutionContext;
    }

    @Override
    public ModuleComponentResolveMetadata processMetadata(ModuleComponentResolveMetadata metadata) {
        ModuleComponentResolveMetadata updatedMetadata;
        metadata.getVariantMetadataRules().setVariantDerivationStrategy(this.metadataRuleContainer.getVariantDerivationStrategy());
        if (this.metadataRuleContainer.isEmpty()) {
            updatedMetadata = this.maybeForceRealisation(metadata);
        } else if (this.metadataRuleContainer.isClassBasedRulesOnly()) {
            Action<ComponentMetadataContext> action = this.collectRulesAndCreateAction(this.metadataRuleContainer.getOnlyClassRules(), metadata.getModuleVersionId(), this.metadataResolutionContext.getInjectingInstantiator());
            if (action instanceof InstantiatingAction) {
                InstantiatingAction ia = (InstantiatingAction)action;
                if (ia.getRules().isCacheable()) {
                    updatedMetadata = this.processClassRuleWithCaching((InstantiatingAction<ComponentMetadataContext>)ia, metadata, this.metadataResolutionContext);
                } else {
                    MutableModuleComponentResolveMetadata mutableMetadata = metadata.asMutable();
                    this.processClassRule(action, metadata, this.createDetails(mutableMetadata));
                    updatedMetadata = this.maybeForceRealisation(mutableMetadata.asImmutable());
                }
            } else {
                updatedMetadata = this.maybeForceRealisation(metadata);
            }
        } else {
            MutableModuleComponentResolveMetadata mutableMetadata = metadata.asMutable();
            ComponentMetadataDetails details = this.createDetails(mutableMetadata);
            this.processAllRules(metadata, details, metadata.getModuleVersionId());
            updatedMetadata = this.maybeForceRealisation(mutableMetadata.asImmutable());
        }
        if (!updatedMetadata.getStatusScheme().contains(updatedMetadata.getStatus())) {
            throw new ModuleVersionResolveException(updatedMetadata.getModuleVersionId(), (Factory<String>)((Factory)() -> String.format("Unexpected status '%s' specified for %s. Expected one of: %s", updatedMetadata.getStatus(), updatedMetadata.getId().getDisplayName(), updatedMetadata.getStatusScheme())));
        }
        return updatedMetadata;
    }

    protected ComponentMetadataDetails createDetails(MutableModuleComponentResolveMetadata mutableMetadata) {
        return (ComponentMetadataDetails)this.instantiator.newInstance(ComponentMetadataDetailsAdapter.class, new Object[]{mutableMetadata, this.instantiator, this.dependencyMetadataNotationParser, this.dependencyConstraintMetadataNotationParser, this.componentIdentifierNotationParser, this.platformSupport});
    }

    @Override
    public ComponentMetadata processMetadata(ComponentMetadata metadata) {
        ComponentMetadata updatedMetadata;
        if (this.metadataRuleContainer.isEmpty()) {
            updatedMetadata = metadata;
        } else {
            ShallowComponentMetadataAdapter details = new ShallowComponentMetadataAdapter(this.componentIdentifierNotationParser, metadata, this.attributesFactory);
            this.processAllRules(null, details, metadata.getId());
            updatedMetadata = details.asImmutable();
        }
        if (!updatedMetadata.getStatusScheme().contains(updatedMetadata.getStatus())) {
            throw new ModuleVersionResolveException(updatedMetadata.getId(), (Factory<String>)((Factory)() -> String.format("Unexpected status '%s' specified for %s. Expected one of: %s", updatedMetadata.getStatus(), updatedMetadata.getId().toString(), updatedMetadata.getStatusScheme())));
        }
        return updatedMetadata;
    }

    @Override
    public int getRulesHash() {
        return this.metadataRuleContainer.getRulesHash();
    }

    private void processAllRules(ModuleComponentResolveMetadata metadata, ComponentMetadataDetails details, ModuleVersionIdentifier id) {
        for (MetadataRuleWrapper wrapper : this.metadataRuleContainer) {
            if (wrapper.isClassBased()) {
                Collection<SpecConfigurableRule> rules = wrapper.getClassRules();
                Action<ComponentMetadataContext> action = this.collectRulesAndCreateAction(rules, id, this.metadataResolutionContext.getInjectingInstantiator());
                this.processClassRule(action, metadata, details);
                continue;
            }
            this.processRule(wrapper.getRule(), metadata, details);
        }
    }

    private void processClassRule(Action<ComponentMetadataContext> action, ModuleComponentResolveMetadata metadata, ComponentMetadataDetails details) {
        DefaultComponentMetadataContext componentMetadataContext = new DefaultComponentMetadataContext(details, metadata);
        try {
            action.execute((Object)componentMetadataContext);
        }
        catch (InvalidUserCodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidUserCodeException(String.format("There was an error while evaluating a component metadata rule for %s.", details.getId()), (Throwable)e);
        }
    }

    private ModuleComponentResolveMetadata processClassRuleWithCaching(InstantiatingAction<ComponentMetadataContext> action, ModuleComponentResolveMetadata metadata, MetadataResolutionContext metadataResolutionContext) {
        try {
            return this.ruleExecutor.execute(metadata, action, DETAILS_TO_RESULT, moduleVersionIdentifier -> new WrappingComponentMetadataContext(metadata, this.instantiator, this.dependencyMetadataNotationParser, this.dependencyConstraintMetadataNotationParser, this.componentIdentifierNotationParser, this.platformSupport), metadataResolutionContext.getCachePolicy());
        }
        catch (InvalidUserCodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidUserCodeException(String.format("There was an error while evaluating a component metadata rule for %s.", metadata.getModuleVersionId()), (Throwable)e);
        }
    }

    private Action<ComponentMetadataContext> collectRulesAndCreateAction(Collection<SpecConfigurableRule> rules, ModuleVersionIdentifier id, Instantiator instantiator) {
        if (rules.isEmpty()) {
            return Actions.doNothing();
        }
        ArrayList<ConfigurableRule<ComponentMetadataContext>> collectedRules = new ArrayList<ConfigurableRule<ComponentMetadataContext>>();
        for (SpecConfigurableRule classBasedRule : rules) {
            if (!classBasedRule.getSpec().isSatisfiedBy((Object)id)) continue;
            collectedRules.add(classBasedRule.getConfigurableRule());
        }
        return new InstantiatingAction((ConfigurableRules)new DefaultConfigurableRules(collectedRules), instantiator, (InstantiatingAction.ExceptionHandler)new ExceptionHandler());
    }

    private void processRule(SpecRuleAction<? super ComponentMetadataDetails> specRuleAction, ModuleComponentResolveMetadata metadata, ComponentMetadataDetails details) {
        if (!specRuleAction.getSpec().isSatisfiedBy((Object)details)) {
            return;
        }
        RuleAction<? super ComponentMetadataDetails> action = specRuleAction.getAction();
        if (!this.shouldExecute(action, metadata)) {
            return;
        }
        List<?> inputs = this.gatherAdditionalInputs(action, metadata);
        this.executeAction(action, inputs, details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAction(RuleAction<? super ComponentMetadataDetails> action, List<?> inputs, ComponentMetadataDetails details) {
        try {
            DefaultComponentMetadataProcessor defaultComponentMetadataProcessor = this;
            synchronized (defaultComponentMetadataProcessor) {
                action.execute((ComponentMetadataDetails)details, inputs);
            }
        }
        catch (InvalidUserCodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidUserCodeException(String.format("There was an error while evaluating a component metadata rule for %s.", details.getId()), (Throwable)e);
        }
    }

    private boolean shouldExecute(RuleAction<? super ComponentMetadataDetails> action, ModuleComponentResolveMetadata metadata) {
        List<Class<?>> inputTypes = action.getInputTypes();
        if (!inputTypes.isEmpty()) {
            return inputTypes.stream().anyMatch(input -> MetadataDescriptorFactory.isMatchingMetadata(input, metadata));
        }
        return true;
    }

    private List<?> gatherAdditionalInputs(RuleAction<? super ComponentMetadataDetails> action, ModuleComponentResolveMetadata metadata) {
        ArrayList inputs = Lists.newArrayList();
        Iterator<Class<?>> iterator = action.getInputTypes().iterator();
        while (iterator.hasNext()) {
            MetadataDescriptorFactory descriptorFactory = new MetadataDescriptorFactory(metadata);
            Class<?> inputType = iterator.next();
            Object descriptor = descriptorFactory.createDescriptor(inputType);
            if (descriptor == null) continue;
            inputs.add(descriptor);
        }
        return inputs;
    }

    static class ShallowComponentMetadataAdapter
    implements ComponentMetadataDetails {
        private final NotationParser<Object, ComponentIdentifier> componentIdentifierNotationParser;
        private final ModuleVersionIdentifier id;
        private boolean changing;
        private List<String> statusScheme;
        private AttributeContainerInternal attributes;

        public ShallowComponentMetadataAdapter(NotationParser<Object, ComponentIdentifier> componentIdentifierNotationParser, ComponentMetadata source, ImmutableAttributesFactory attributesFactory) {
            this.componentIdentifierNotationParser = componentIdentifierNotationParser;
            this.id = source.getId();
            this.changing = source.isChanging();
            this.statusScheme = source.getStatusScheme();
            this.attributes = attributesFactory.mutable((AttributeContainerInternal)source.getAttributes());
        }

        public void setChanging(boolean changing) {
            this.changing = changing;
        }

        public void setStatus(String status) {
            this.attributes.attribute(ProjectInternal.STATUS_ATTRIBUTE, (Object)status);
        }

        public void setStatusScheme(List<String> statusScheme) {
            this.statusScheme = statusScheme;
        }

        public void withVariant(String name, Action<? super VariantMetadata> action) {
        }

        public void allVariants(Action<? super VariantMetadata> action) {
        }

        public void addVariant(String name, Action<? super VariantMetadata> action) {
        }

        public void addVariant(String name, String base, Action<? super VariantMetadata> action) {
        }

        public void maybeAddVariant(String name, String base, Action<? super VariantMetadata> action) {
        }

        public void belongsTo(Object notation) {
        }

        public void belongsTo(Object notation, boolean virtual) {
        }

        public ModuleVersionIdentifier getId() {
            return this.id;
        }

        public boolean isChanging() {
            return this.changing;
        }

        public String getStatus() {
            return (String)this.attributes.getAttribute(ProjectInternal.STATUS_ATTRIBUTE);
        }

        public List<String> getStatusScheme() {
            return this.statusScheme;
        }

        public ComponentMetadataDetails attributes(Action<? super AttributeContainer> action) {
            action.execute((Object)this.attributes);
            return this;
        }

        public AttributeContainer getAttributes() {
            return this.attributes;
        }

        public ComponentMetadata asImmutable() {
            return new UserProvidedMetadata(this.id, this.statusScheme, this.attributes.asImmutable());
        }
    }

    private static class ExceptionHandler
    implements InstantiatingAction.ExceptionHandler<ComponentMetadataContext> {
        private ExceptionHandler() {
        }

        public void handleException(ComponentMetadataContext context, Throwable throwable) {
            throw new InvalidUserCodeException(String.format("There was an error while evaluating a component metadata rule for %s.", context.getDetails().getId()), throwable);
        }
    }
}

