/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.runtimeshaded;

import java.io.File;
import java.util.Collection;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.runtimeshaded.ImplementationDependencyRelocator;
import org.gradle.api.internal.runtimeshaded.RuntimeShadedJarCreator;
import org.gradle.api.internal.runtimeshaded.RuntimeShadedJarType;
import org.gradle.cache.internal.GeneratedGradleJarCache;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeShadedJarFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeShadedJarFactory.class);
    private final GeneratedGradleJarCache cache;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final BuildOperationExecutor executor;

    public RuntimeShadedJarFactory(GeneratedGradleJarCache cache, ProgressLoggerFactory progressLoggerFactory, DirectoryFileTreeFactory directoryFileTreeFactory, BuildOperationExecutor executor) {
        this.cache = cache;
        this.progressLoggerFactory = progressLoggerFactory;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.executor = executor;
    }

    public File get(final RuntimeShadedJarType type, Collection<? extends File> classpath) {
        File jarFile = this.cache.get(type.getIdentifier(), file -> this.executor.run(new RunnableBuildOperation((File)file, classpath){
            final /* synthetic */ File val$file;
            final /* synthetic */ Collection val$classpath;
            {
                this.val$file = file;
                this.val$classpath = collection;
            }

            public void run(BuildOperationContext context) {
                RuntimeShadedJarCreator creator = new RuntimeShadedJarCreator(RuntimeShadedJarFactory.this.progressLoggerFactory, new ImplementationDependencyRelocator(type), RuntimeShadedJarFactory.this.directoryFileTreeFactory);
                creator.create(this.val$file, this.val$classpath);
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Generate " + this.val$file)).progressDisplayName("Generating " + this.val$file.getName());
            }
        }));
        LOGGER.debug("Using Gradle runtime shaded JAR file: {}", (Object)jarFile);
        return jarFile;
    }
}

