/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.artifacts.transform.Transformation;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;

public class ConsumerVariantMatchResult {
    private int minDepth;
    private final List<ConsumerVariant> matches;

    ConsumerVariantMatchResult(int estimateSize) {
        this.matches = Lists.newArrayListWithExpectedSize((int)estimateSize);
    }

    private ConsumerVariantMatchResult(ConsumerVariantMatchResult other) {
        this.minDepth = other.minDepth;
        this.matches = Collections.unmodifiableList(other.matches);
    }

    public void matched(ImmutableAttributes output, Transformation transformation, int depth) {
        if (this.minDepth == 0) {
            this.minDepth = depth;
        } else if (depth < this.minDepth) {
            this.matches.clear();
            this.minDepth = depth;
        } else if (depth > this.minDepth) {
            return;
        }
        this.matches.add(new ConsumerVariant((AttributeContainerInternal)output, transformation, depth));
    }

    public boolean hasMatches() {
        return !this.matches.isEmpty();
    }

    public Collection<ConsumerVariant> getMatches() {
        return this.matches;
    }

    public ConsumerVariantMatchResult asImmutable() {
        return new ConsumerVariantMatchResult(this);
    }

    public static class ConsumerVariant {
        final AttributeContainerInternal attributes;
        final Transformation transformation;
        final int depth;

        public ConsumerVariant(AttributeContainerInternal attributes, Transformation transformation, int depth) {
            this.attributes = attributes;
            this.transformation = transformation;
            this.depth = depth;
        }
    }
}

