/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Interner;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.tools.ant.DirectoryScanner;
import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.BuildScopeFileTimeStampInspector;
import org.gradle.api.internal.changedetection.state.CachingFileHasher;
import org.gradle.api.internal.changedetection.state.CrossBuildFileHashCache;
import org.gradle.api.internal.changedetection.state.DefaultResourceSnapshotterCacheService;
import org.gradle.api.internal.changedetection.state.GlobalScopeFileTimeStampInspector;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceSnapshotterCacheService;
import org.gradle.api.internal.changedetection.state.SplitFileHasher;
import org.gradle.api.internal.changedetection.state.SplitResourceSnapshotterCacheService;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.initialization.loadercache.DefaultClasspathHasher;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.CacheScopeMapping;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.internal.VersionStrategy;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.initialization.layout.ProjectCacheDir;
import org.gradle.internal.classloader.ClasspathHasher;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.execution.OutputChangeListener;
import org.gradle.internal.file.Stat;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.fingerprint.FileCollectionSnapshotter;
import org.gradle.internal.fingerprint.GenericFileTreeSnapshotter;
import org.gradle.internal.fingerprint.classpath.ClasspathFingerprinter;
import org.gradle.internal.fingerprint.classpath.CompileClasspathFingerprinter;
import org.gradle.internal.fingerprint.classpath.impl.DefaultClasspathFingerprinter;
import org.gradle.internal.fingerprint.classpath.impl.DefaultCompileClasspathFingerprinter;
import org.gradle.internal.fingerprint.impl.AbsolutePathFileCollectionFingerprinter;
import org.gradle.internal.fingerprint.impl.DefaultFileCollectionFingerprinterRegistry;
import org.gradle.internal.fingerprint.impl.DefaultFileCollectionSnapshotter;
import org.gradle.internal.fingerprint.impl.DefaultGenericFileTreeSnapshotter;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileCollectionFingerprinter;
import org.gradle.internal.fingerprint.impl.NameOnlyFileCollectionFingerprinter;
import org.gradle.internal.fingerprint.impl.OutputFileCollectionFingerprinter;
import org.gradle.internal.fingerprint.impl.RelativePathFileCollectionFingerprinter;
import org.gradle.internal.hash.DefaultFileHasher;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.scopes.AbstractPluginServiceRegistry;
import org.gradle.internal.service.scopes.VirtualFileSystemBuildLifecycleListener;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.vfs.AdditiveCacheLocations;
import org.gradle.internal.vfs.DarwinFileWatcherRegistry;
import org.gradle.internal.vfs.LinuxFileWatcherRegistry;
import org.gradle.internal.vfs.RoutingVirtualFileSystem;
import org.gradle.internal.vfs.VirtualFileSystem;
import org.gradle.internal.vfs.WatchingAwareVirtualFileSystem;
import org.gradle.internal.vfs.WindowsFileWatcherRegistry;
import org.gradle.internal.vfs.impl.AbstractVirtualFileSystem;
import org.gradle.internal.vfs.impl.DefaultVirtualFileSystem;
import org.gradle.internal.vfs.impl.DelegatingDiffCapturingUpdateFunctionDecorator;
import org.gradle.internal.vfs.impl.NonWatchingVirtualFileSystem;
import org.gradle.internal.vfs.impl.WatchingVirtualFileSystem;
import org.gradle.internal.vfs.watch.FileWatcherRegistryFactory;

public class VirtualFileSystemServices
extends AbstractPluginServiceRegistry {
    public static final String VFS_PARTIAL_INVALIDATION_ENABLED_PROPERTY = "org.gradle.unsafe.vfs.partial-invalidation";
    public static final String VFS_RETENTION_ENABLED_PROPERTY = "org.gradle.unsafe.vfs.retention";
    public static final String VFS_CHANGES_SINCE_LAST_BUILD_PROPERTY = "org.gradle.unsafe.vfs.changes";
    public static final String VFS_DROP_PROPERTY = "org.gradle.unsafe.vfs.drop";

    public static boolean isPartialInvalidationEnabled(Map<String, String> systemPropertiesArgs) {
        return VirtualFileSystemServices.isSystemPropertyEnabled(VFS_PARTIAL_INVALIDATION_ENABLED_PROPERTY, systemPropertiesArgs) || VirtualFileSystemServices.isRetentionEnabled(systemPropertiesArgs);
    }

    public static boolean isRetentionEnabled(Map<String, String> systemPropertiesArgs) {
        return VirtualFileSystemServices.isSystemPropertyEnabled(VFS_RETENTION_ENABLED_PROPERTY, systemPropertiesArgs);
    }

    private static boolean isSystemPropertyEnabled(String systemProperty, Map<String, String> systemPropertiesArgs) {
        String value = VirtualFileSystemServices.getSystemProperty(systemProperty, systemPropertiesArgs);
        return value != null && !"false".equalsIgnoreCase(value);
    }

    @Nullable
    private static String getSystemProperty(String systemProperty, Map<String, String> systemPropertiesArgs) {
        return systemPropertiesArgs.getOrDefault(systemProperty, System.getProperty(systemProperty));
    }

    public void registerGradleUserHomeServices(ServiceRegistration registration) {
        registration.addProvider((Object)new GradleUserHomeServices());
    }

    public void registerBuildSessionServices(ServiceRegistration registration) {
        registration.addProvider((Object)new BuildSessionServices());
    }

    @VisibleForTesting
    static class BuildSessionServices {
        BuildSessionServices() {
        }

        CrossBuildFileHashCache createCrossBuildFileHashCache(ProjectCacheDir projectCacheDir, CacheScopeMapping cacheScopeMapping, CacheRepository cacheRepository, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
            File cacheDir = cacheScopeMapping.getBaseDirectory((Object)projectCacheDir.getDir(), "fileHashes", VersionStrategy.CachePerVersion);
            return new CrossBuildFileHashCache(cacheDir, cacheRepository, inMemoryCacheDecoratorFactory, CrossBuildFileHashCache.Kind.FILE_HASHES);
        }

        FileHasher createFileHasher(AdditiveCacheLocations additiveCacheLocations, BuildScopeFileTimeStampInspector fileTimeStampInspector, CrossBuildFileHashCache cacheAccess, FileHasher globalHasher, FileSystem fileSystem, StreamHasher streamHasher, StringInterner stringInterner) {
            CachingFileHasher localHasher = new CachingFileHasher((FileHasher)new DefaultFileHasher(streamHasher), cacheAccess, stringInterner, fileTimeStampInspector, "fileHashes", fileSystem);
            return new SplitFileHasher(globalHasher, localHasher, additiveCacheLocations);
        }

        VirtualFileSystem createVirtualFileSystem(AdditiveCacheLocations additiveCacheLocations, FileHasher hasher, FileSystem fileSystem, ListenerManager listenerManager, StartParameter startParameter, Stat stat, StringInterner stringInterner, VirtualFileSystem gradleUserHomeVirtualFileSystem) {
            DefaultVirtualFileSystem buildSessionsScopedVirtualFileSystem = new DefaultVirtualFileSystem(hasher, (Interner)stringInterner, stat, fileSystem.isCaseSensitive() ? CaseSensitivity.CASE_SENSITIVE : CaseSensitivity.CASE_INSENSITIVE, SnapshotHierarchy.DiffCapturingUpdateFunctionDecorator.NOOP, DirectoryScanner.getDefaultExcludes());
            final RoutingVirtualFileSystem routingVirtualFileSystem = new RoutingVirtualFileSystem(additiveCacheLocations, gradleUserHomeVirtualFileSystem, (VirtualFileSystem)buildSessionsScopedVirtualFileSystem, () -> VirtualFileSystemServices.isRetentionEnabled(startParameter.getSystemPropertiesArgs()));
            listenerManager.addListener((Object)new RootBuildLifecycleListener((VirtualFileSystem)buildSessionsScopedVirtualFileSystem){
                final /* synthetic */ VirtualFileSystem val$buildSessionsScopedVirtualFileSystem;
                {
                    this.val$buildSessionsScopedVirtualFileSystem = virtualFileSystem;
                }

                @Override
                public void afterStart(GradleInternal gradle) {
                }

                @Override
                public void beforeComplete(GradleInternal gradle) {
                    this.val$buildSessionsScopedVirtualFileSystem.invalidateAll();
                }
            });
            listenerManager.addListener((Object)new OutputChangeListener(){

                public void beforeOutputChange() {
                    routingVirtualFileSystem.invalidateAll();
                }

                public void beforeOutputChange(Iterable<String> affectedOutputPaths) {
                    routingVirtualFileSystem.update(affectedOutputPaths, () -> {});
                }
            });
            return routingVirtualFileSystem;
        }

        GenericFileTreeSnapshotter createGenericFileTreeSnapshotter(FileHasher hasher, StringInterner stringInterner) {
            return new DefaultGenericFileTreeSnapshotter(hasher, (Interner<String>)stringInterner);
        }

        FileCollectionSnapshotter createFileCollectionSnapshotter(VirtualFileSystem virtualFileSystem, GenericFileTreeSnapshotter genericFileTreeSnapshotter, Stat stat) {
            return new DefaultFileCollectionSnapshotter(virtualFileSystem, genericFileTreeSnapshotter, stat);
        }

        AbsolutePathFileCollectionFingerprinter createAbsolutePathFileCollectionFingerprinter(FileCollectionSnapshotter fileCollectionSnapshotter) {
            return new AbsolutePathFileCollectionFingerprinter(fileCollectionSnapshotter);
        }

        RelativePathFileCollectionFingerprinter createRelativePathFileCollectionFingerprinter(StringInterner stringInterner, FileCollectionSnapshotter fileCollectionSnapshotter) {
            return new RelativePathFileCollectionFingerprinter(stringInterner, fileCollectionSnapshotter);
        }

        NameOnlyFileCollectionFingerprinter createNameOnlyFileCollectionFingerprinter(FileCollectionSnapshotter fileCollectionSnapshotter) {
            return new NameOnlyFileCollectionFingerprinter(fileCollectionSnapshotter);
        }

        IgnoredPathFileCollectionFingerprinter createIgnoredPathFileCollectionFingerprinter(FileCollectionSnapshotter fileCollectionSnapshotter) {
            return new IgnoredPathFileCollectionFingerprinter(fileCollectionSnapshotter);
        }

        OutputFileCollectionFingerprinter createOutputFileCollectionFingerprinter(FileCollectionSnapshotter fileCollectionSnapshotter) {
            return new OutputFileCollectionFingerprinter(fileCollectionSnapshotter);
        }

        FileCollectionFingerprinterRegistry createFileCollectionFingerprinterRegistry(List<FileCollectionFingerprinter> fingerprinters) {
            return new DefaultFileCollectionFingerprinterRegistry(fingerprinters);
        }

        ResourceSnapshotterCacheService createResourceSnapshotterCacheService(AdditiveCacheLocations additiveCacheLocations, CrossBuildFileHashCache store, ResourceSnapshotterCacheService globalCache) {
            PersistentIndexedCache resourceHashesCache = store.createCache(PersistentIndexedCacheParameters.of((String)"resourceHashesCache", HashCode.class, (Serializer)new HashCodeSerializer()), 800000, true);
            DefaultResourceSnapshotterCacheService localCache = new DefaultResourceSnapshotterCacheService(resourceHashesCache);
            return new SplitResourceSnapshotterCacheService(globalCache, localCache, additiveCacheLocations);
        }

        CompileClasspathFingerprinter createCompileClasspathFingerprinter(ResourceSnapshotterCacheService resourceSnapshotterCacheService, FileCollectionSnapshotter fileCollectionSnapshotter, StringInterner stringInterner) {
            return new DefaultCompileClasspathFingerprinter(resourceSnapshotterCacheService, fileCollectionSnapshotter, stringInterner);
        }
    }

    @VisibleForTesting
    static class GradleUserHomeServices {
        GradleUserHomeServices() {
        }

        CrossBuildFileHashCache createCrossBuildFileHashCache(CacheRepository cacheRepository, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
            return new CrossBuildFileHashCache(null, cacheRepository, inMemoryCacheDecoratorFactory, CrossBuildFileHashCache.Kind.FILE_HASHES);
        }

        FileHasher createCachingFileHasher(StringInterner stringInterner, CrossBuildFileHashCache fileStore, FileSystem fileSystem, GlobalScopeFileTimeStampInspector fileTimeStampInspector, StreamHasher streamHasher) {
            CachingFileHasher fileHasher = new CachingFileHasher((FileHasher)new DefaultFileHasher(streamHasher), fileStore, stringInterner, fileTimeStampInspector, "fileHashes", fileSystem);
            fileTimeStampInspector.attach(fileHasher);
            return fileHasher;
        }

        WatchingAwareVirtualFileSystem createVirtualFileSystem(AdditiveCacheLocations additiveCacheLocations, FileHasher hasher, FileSystem fileSystem, Stat stat, StringInterner stringInterner, ListenerManager listenerManager) {
            Predicate<String> watchFilter = path -> !additiveCacheLocations.isInsideAdditiveCache((String)path);
            DelegatingDiffCapturingUpdateFunctionDecorator updateFunctionDecorator = new DelegatingDiffCapturingUpdateFunctionDecorator(watchFilter);
            DefaultVirtualFileSystem delegate = new DefaultVirtualFileSystem(hasher, (Interner)stringInterner, stat, fileSystem.isCaseSensitive() ? CaseSensitivity.CASE_SENSITIVE : CaseSensitivity.CASE_INSENSITIVE, (SnapshotHierarchy.DiffCapturingUpdateFunctionDecorator)updateFunctionDecorator, DirectoryScanner.getDefaultExcludes());
            WatchingAwareVirtualFileSystem watchingAwareVirtualFileSystem = this.determineWatcherRegistryFactory(OperatingSystem.current()).map(watcherRegistryFactory -> new WatchingVirtualFileSystem(watcherRegistryFactory, (AbstractVirtualFileSystem)delegate, updateFunctionDecorator, watchFilter)).orElse((WatchingAwareVirtualFileSystem)new NonWatchingVirtualFileSystem((AbstractVirtualFileSystem)delegate));
            listenerManager.addListener((Object)new VirtualFileSystemBuildLifecycleListener(watchingAwareVirtualFileSystem, startParameter -> VirtualFileSystemServices.isRetentionEnabled(startParameter.getSystemPropertiesArgs()), startParameter -> VirtualFileSystemServices.isSystemPropertyEnabled(VirtualFileSystemServices.VFS_DROP_PROPERTY, startParameter.getSystemPropertiesArgs()), startParameter -> VirtualFileSystemServices.getSystemProperty(VirtualFileSystemServices.VFS_CHANGES_SINCE_LAST_BUILD_PROPERTY, startParameter.getSystemPropertiesArgs())));
            return watchingAwareVirtualFileSystem;
        }

        private Optional<FileWatcherRegistryFactory> determineWatcherRegistryFactory(OperatingSystem operatingSystem) {
            if (operatingSystem.isMacOsX()) {
                return Optional.of(new DarwinFileWatcherRegistry.Factory());
            }
            if (operatingSystem.isWindows()) {
                return Optional.of(new WindowsFileWatcherRegistry.Factory());
            }
            if (operatingSystem.isLinux()) {
                return Optional.of(new LinuxFileWatcherRegistry.Factory());
            }
            return Optional.empty();
        }

        GenericFileTreeSnapshotter createGenericFileTreeSnapshotter(FileHasher hasher, StringInterner stringInterner) {
            return new DefaultGenericFileTreeSnapshotter(hasher, (Interner<String>)stringInterner);
        }

        FileCollectionSnapshotter createFileCollectionSnapshotter(VirtualFileSystem virtualFileSystem, GenericFileTreeSnapshotter genericFileTreeSnapshotter, Stat stat) {
            return new DefaultFileCollectionSnapshotter(virtualFileSystem, genericFileTreeSnapshotter, stat);
        }

        ResourceSnapshotterCacheService createResourceSnapshotterCacheService(CrossBuildFileHashCache store) {
            PersistentIndexedCache resourceHashesCache = store.createCache(PersistentIndexedCacheParameters.of((String)"resourceHashesCache", HashCode.class, (Serializer)new HashCodeSerializer()), 400000, true);
            return new DefaultResourceSnapshotterCacheService(resourceHashesCache);
        }

        ClasspathFingerprinter createClasspathFingerprinter(ResourceSnapshotterCacheService resourceSnapshotterCacheService, FileCollectionSnapshotter fileCollectionSnapshotter, StringInterner stringInterner) {
            return new DefaultClasspathFingerprinter(resourceSnapshotterCacheService, fileCollectionSnapshotter, ResourceFilter.FILTER_NOTHING, stringInterner);
        }

        ClasspathHasher createClasspathHasher(ClasspathFingerprinter fingerprinter, FileCollectionFactory fileCollectionFactory) {
            return new DefaultClasspathHasher(fingerprinter, fileCollectionFactory);
        }
    }
}

