/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.tasks.properties.ModifierAnnotationCategory;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.internal.tasks.properties.TypeMetadataStore;
import org.gradle.api.internal.tasks.properties.annotations.AbstractOutputPropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.PropertyAnnotationHandler;
import org.gradle.api.internal.tasks.properties.annotations.TypeAnnotationHandler;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.reflect.AnnotationCategory;
import org.gradle.internal.reflect.PropertyMetadata;
import org.gradle.internal.reflect.TypeValidationContext;
import org.gradle.internal.reflect.annotations.PropertyAnnotationMetadata;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadata;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadataStore;

public class DefaultTypeMetadataStore
implements TypeMetadataStore {
    private final Collection<? extends TypeAnnotationHandler> typeAnnotationHandlers;
    private final ImmutableMap<Class<? extends Annotation>, ? extends PropertyAnnotationHandler> propertyAnnotationHandlers;
    private final ImmutableSet<Class<? extends Annotation>> allowedPropertyModifiers;
    private final CrossBuildInMemoryCache<Class<?>, TypeMetadata> cache;
    private final TypeAnnotationMetadataStore typeAnnotationMetadataStore;
    private final String displayName;
    private final Transformer<TypeMetadata, Class<?>> typeMetadataFactory = this::createTypeMetadata;

    public DefaultTypeMetadataStore(Collection<? extends TypeAnnotationHandler> typeAnnotationHandlers, Collection<? extends PropertyAnnotationHandler> propertyAnnotationHandlers, Collection<Class<? extends Annotation>> allowedPropertyModifiers, TypeAnnotationMetadataStore typeAnnotationMetadataStore, CrossBuildInMemoryCacheFactory cacheFactory) {
        this.typeAnnotationHandlers = ImmutableSet.copyOf(typeAnnotationHandlers);
        this.propertyAnnotationHandlers = Maps.uniqueIndex(propertyAnnotationHandlers, PropertyAnnotationHandler::getAnnotationType);
        this.allowedPropertyModifiers = ImmutableSet.copyOf(allowedPropertyModifiers);
        this.typeAnnotationMetadataStore = typeAnnotationMetadataStore;
        this.displayName = DefaultTypeMetadataStore.calculateDisplayName(propertyAnnotationHandlers);
        this.cache = cacheFactory.newClassCache();
    }

    private static String calculateDisplayName(Iterable<? extends PropertyAnnotationHandler> annotationHandlers) {
        for (PropertyAnnotationHandler propertyAnnotationHandler : annotationHandlers) {
            if (!(propertyAnnotationHandler instanceof AbstractOutputPropertyAnnotationHandler)) continue;
            return "an input or output annotation";
        }
        return "an input annotation";
    }

    @Override
    public <T> TypeMetadata getTypeMetadata(Class<T> type) {
        return (TypeMetadata)this.cache.get(type, this.typeMetadataFactory);
    }

    private <T> TypeMetadata createTypeMetadata(Class<T> type) {
        Class publicType = GeneratedSubclasses.unpack(type);
        TypeValidationContext.ReplayingTypeValidationContext validationContext = new TypeValidationContext.ReplayingTypeValidationContext();
        TypeAnnotationMetadata annotationMetadata = this.typeAnnotationMetadataStore.getTypeAnnotationMetadata(publicType);
        annotationMetadata.visitValidationFailures((TypeValidationContext)validationContext);
        for (TypeAnnotationHandler typeAnnotationHandler : this.typeAnnotationHandlers) {
            if (!annotationMetadata.isAnnotationPresent(typeAnnotationHandler.getAnnotationType())) continue;
            typeAnnotationHandler.validateTypeMetadata(publicType, (TypeValidationContext)validationContext);
        }
        ImmutableSet.Builder effectiveProperties = ImmutableSet.builderWithExpectedSize((int)annotationMetadata.getPropertiesAnnotationMetadata().size());
        for (PropertyAnnotationMetadata propertyAnnotationMetadata : annotationMetadata.getPropertiesAnnotationMetadata()) {
            Annotation normalizationAnnotation;
            ImmutableMap propertyAnnotations = propertyAnnotationMetadata.getAnnotations();
            Annotation typeAnnotation = (Annotation)propertyAnnotations.get(AnnotationCategory.TYPE);
            Class<? extends Annotation> propertyType = this.determinePropertyType(typeAnnotation, normalizationAnnotation = (Annotation)propertyAnnotations.get((Object)ModifierAnnotationCategory.NORMALIZATION));
            if (propertyType == null) {
                validationContext.visitPropertyProblem(TypeValidationContext.Severity.WARNING, propertyAnnotationMetadata.getPropertyName(), String.format("is not annotated with %s", this.displayName));
                continue;
            }
            PropertyAnnotationHandler annotationHandler = (PropertyAnnotationHandler)this.propertyAnnotationHandlers.get(propertyType);
            if (annotationHandler == null) {
                validationContext.visitPropertyProblem(TypeValidationContext.Severity.ERROR, propertyAnnotationMetadata.getPropertyName(), String.format("is annotated with invalid property type @%s", propertyType.getSimpleName()));
                continue;
            }
            ImmutableSet<? extends AnnotationCategory> allowedModifiersForPropertyType = annotationHandler.getAllowedModifiers();
            for (Map.Entry entry : propertyAnnotations.entrySet()) {
                AnnotationCategory annotationCategory = (AnnotationCategory)entry.getKey();
                if (annotationCategory == AnnotationCategory.TYPE) continue;
                Class<? extends Annotation> annotationType = ((Annotation)entry.getValue()).annotationType();
                if (!allowedModifiersForPropertyType.contains((Object)annotationCategory)) {
                    validationContext.visitPropertyProblem(TypeValidationContext.Severity.WARNING, propertyAnnotationMetadata.getPropertyName(), String.format("is annotated with @%s that is not allowed for @%s properties", annotationType.getSimpleName(), propertyType.getSimpleName()));
                    continue;
                }
                if (this.allowedPropertyModifiers.contains(annotationType)) continue;
                validationContext.visitPropertyProblem(TypeValidationContext.Severity.ERROR, propertyAnnotationMetadata.getPropertyName(), String.format("has invalid annotation @%s", annotationType.getSimpleName()));
            }
            DefaultPropertyMetadata property = new DefaultPropertyMetadata(propertyType, propertyAnnotationMetadata);
            annotationHandler.validatePropertyMetadata(property, (TypeValidationContext)validationContext);
            if (!annotationHandler.isPropertyRelevant()) continue;
            effectiveProperties.add((Object)property);
        }
        return new DefaultTypeMetadata((ImmutableSet<PropertyMetadata>)effectiveProperties.build(), validationContext, this.propertyAnnotationHandlers);
    }

    @Nullable
    private Class<? extends Annotation> determinePropertyType(@Nullable Annotation typeAnnotation, @Nullable Annotation normalizationAnnotation) {
        if (typeAnnotation != null) {
            return typeAnnotation.annotationType();
        }
        if (normalizationAnnotation != null && (normalizationAnnotation.annotationType().equals(Classpath.class) || normalizationAnnotation.annotationType().equals(CompileClasspath.class))) {
            return InputFiles.class;
        }
        return null;
    }

    private static class DefaultPropertyMetadata
    implements PropertyMetadata {
        private final Class<? extends Annotation> propertyType;
        private final PropertyAnnotationMetadata annotationMetadata;

        public DefaultPropertyMetadata(Class<? extends Annotation> propertyType, PropertyAnnotationMetadata annotationMetadata) {
            this.propertyType = propertyType;
            this.annotationMetadata = annotationMetadata;
        }

        public String getPropertyName() {
            return this.annotationMetadata.getPropertyName();
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.annotationMetadata.isAnnotationPresent(annotationType);
        }

        @Nullable
        public Annotation getAnnotationForCategory(AnnotationCategory category) {
            return (Annotation)this.annotationMetadata.getAnnotations().get((Object)category);
        }

        public boolean hasAnnotationForCategory(AnnotationCategory category) {
            return this.annotationMetadata.getAnnotations().get((Object)category) != null;
        }

        public Class<? extends Annotation> getPropertyType() {
            return this.propertyType;
        }

        public Method getGetterMethod() {
            return this.annotationMetadata.getMethod();
        }

        public String toString() {
            return String.format("@%s %s", this.propertyType.getSimpleName(), this.getPropertyName());
        }
    }

    private static class DefaultTypeMetadata
    implements TypeMetadata {
        private final ImmutableSet<PropertyMetadata> propertiesMetadata;
        private final TypeValidationContext.ReplayingTypeValidationContext validationProblems;
        private final ImmutableMap<Class<? extends Annotation>, ? extends PropertyAnnotationHandler> annotationHandlers;

        DefaultTypeMetadata(ImmutableSet<PropertyMetadata> propertiesMetadata, TypeValidationContext.ReplayingTypeValidationContext validationProblems, ImmutableMap<Class<? extends Annotation>, ? extends PropertyAnnotationHandler> annotationHandlers) {
            this.propertiesMetadata = propertiesMetadata;
            this.validationProblems = validationProblems;
            this.annotationHandlers = annotationHandlers;
        }

        @Override
        public void visitValidationFailures(@Nullable String ownerPropertyPath, TypeValidationContext validationContext) {
            this.validationProblems.replay(ownerPropertyPath, validationContext);
        }

        @Override
        public Set<PropertyMetadata> getPropertiesMetadata() {
            return this.propertiesMetadata;
        }

        @Override
        public boolean hasAnnotatedProperties() {
            return !this.propertiesMetadata.isEmpty();
        }

        @Override
        public PropertyAnnotationHandler getAnnotationHandlerFor(PropertyMetadata propertyMetadata) {
            return (PropertyAnnotationHandler)this.annotationHandlers.get((Object)propertyMetadata.getPropertyType());
        }
    }
}

