/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.BeforeExecutionContext;
import org.gradle.internal.execution.CurrentSnapshotResult;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.steps.BuildOperationStep;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class SnapshotOutputsStep<C extends BeforeExecutionContext>
extends BuildOperationStep<C, CurrentSnapshotResult> {
    private final UniqueId buildInvocationScopeId;
    private final Step<? super C, ? extends Result> delegate;

    public SnapshotOutputsStep(BuildOperationExecutor buildOperationExecutor, UniqueId buildInvocationScopeId, Step<? super C, ? extends Result> delegate) {
        super(buildOperationExecutor);
        this.buildInvocationScopeId = buildInvocationScopeId;
        this.delegate = delegate;
    }

    @Override
    public CurrentSnapshotResult execute(C context) {
        final Result result = this.delegate.execute(context);
        final ImmutableSortedMap finalOutputs = this.operation(operationContext -> {
            ImmutableSortedMap<String, CurrentFileCollectionFingerprint> outputSnapshots = SnapshotOutputsStep.captureOutputs(context);
            operationContext.setResult((Object)Operation.Result.INSTANCE);
            return outputSnapshots;
        }, BuildOperationDescriptor.displayName((String)("Snapshot outputs after executing " + context.getWork().getDisplayName())).details((Object)Operation.Details.INSTANCE));
        final OriginMetadata originMetadata = new OriginMetadata(this.buildInvocationScopeId.asString(), context.getWork().markExecutionTime());
        return new CurrentSnapshotResult(){

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getFinalOutputs() {
                return finalOutputs;
            }

            @Override
            public OriginMetadata getOriginMetadata() {
                return originMetadata;
            }

            @Override
            public Try<ExecutionOutcome> getOutcome() {
                return result.getOutcome();
            }

            @Override
            public boolean isReused() {
                return false;
            }
        };
    }

    private static ImmutableSortedMap<String, CurrentFileCollectionFingerprint> captureOutputs(BeforeExecutionContext context) {
        UnitOfWork work = context.getWork();
        ImmutableSortedMap afterPreviousExecutionStateOutputFingerprints = context.getAfterPreviousExecutionState().map(AfterPreviousExecutionState::getOutputFileProperties).orElse(ImmutableSortedMap.of());
        ImmutableSortedMap beforeExecutionOutputSnapshots = context.getBeforeExecutionState().map(BeforeExecutionState::getOutputFileSnapshots).orElse(ImmutableSortedMap.of());
        boolean hasDetectedOverlappingOutputs = context.getBeforeExecutionState().flatMap(BeforeExecutionState::getDetectedOverlappingOutputs).isPresent();
        ImmutableSortedMap<String, FileSystemSnapshot> afterExecutionOutputSnapshots = work.snapshotOutputsAfterExecution();
        return work.fingerprintAndFilterOutputSnapshots((ImmutableSortedMap<String, FileCollectionFingerprint>)afterPreviousExecutionStateOutputFingerprints, (ImmutableSortedMap<String, FileSystemSnapshot>)beforeExecutionOutputSnapshots, afterExecutionOutputSnapshots, hasDetectedOverlappingOutputs);
    }

    public static interface Operation
    extends BuildOperationType<Details, Result> {

        public static interface Result {
            public static final Result INSTANCE = new Result(){};
        }

        public static interface Details {
            public static final Details INSTANCE = new Details(){};
        }
    }
}

