/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.internal;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.Link;
import org.gradle.plugins.ide.eclipse.model.SourceFolder;
import org.gradle.plugins.ide.eclipse.model.internal.SourceFoldersCreator;

public class LinkedResourcesCreator {
    public Set<Link> links(final Project project) {
        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        EclipseClasspath classpath = ((EclipseModel)project.getExtensions().getByType(EclipseModel.class)).getClasspath();
        File defaultOutputDir = classpath == null ? project.file((Object)"bin/default") : classpath.getDefaultOutputDir();
        List<SourceFolder> sourceFolders = new SourceFoldersCreator().getBasicExternalSourceFolders((Iterable<SourceSet>)sourceSets, new Function<File, String>(){

            public String apply(File dir) {
                return project.relativePath((Object)dir);
            }
        }, defaultOutputDir);
        LinkedHashSet links = Sets.newLinkedHashSetWithExpectedSize((int)sourceFolders.size());
        for (SourceFolder sourceFolder : sourceFolders) {
            links.add(new Link(sourceFolder.getName(), "2", sourceFolder.getAbsolutePath(), null));
        }
        return links;
    }
}

