/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing.signatory.internal.gnupg;

import groovy.lang.Closure;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.Project;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.signatory.SignatoryProvider;
import org.gradle.plugins.signing.signatory.internal.gnupg.GnupgSignatory;
import org.gradle.plugins.signing.signatory.internal.gnupg.GnupgSignatoryFactory;
import org.gradle.util.ConfigureUtil;

public class GnupgSignatoryProvider
implements SignatoryProvider<GnupgSignatory> {
    private final GnupgSignatoryFactory factory = new GnupgSignatoryFactory();
    private final Map<String, GnupgSignatory> signatories = new LinkedHashMap<String, GnupgSignatory>();

    @Override
    public void configure(final SigningExtension settings, Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)new Object(){

            public void methodMissing(String name, Object args) {
                GnupgSignatoryProvider.this.createSignatoryFor(settings.getProject(), name, (Object[])DefaultGroovyMethods.asType((Object)args, Object[].class));
            }
        });
    }

    private void createSignatoryFor(Project project, String name, Object[] args) {
        if (args.length != 0) {
            throw new IllegalArgumentException("Invalid args (" + name + ": " + String.valueOf(args) + ")");
        }
        this.signatories.put(name, this.factory.createSignatory(project, name, name));
    }

    @Override
    public GnupgSignatory getDefaultSignatory(Project project) {
        return this.factory.createSignatory(project);
    }

    @Override
    public GnupgSignatory getSignatory(String name) {
        return this.signatories.get(name);
    }

    public GnupgSignatory propertyMissing(String signatoryName) {
        return this.getSignatory(signatoryName);
    }
}

