/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.lang.ref.Reference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Getter;
import org.jetbrains.kotlin.com.intellij.openapi.util.ModificationTracker;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProfiler;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.ProfilingInfo;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.IdempotenceChecker;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.NotNullList;

public abstract class CachedValueBase<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.CachedValueImpl");
    private final boolean myTrackValue;
    private volatile SoftReference<Data<T>> myData;

    protected CachedValueBase(boolean trackValue) {
        this.myTrackValue = trackValue;
    }

    @NotNull
    private Data<T> computeData(@Nullable CachedValueProvider.Result<T> result2) {
        ProfilingInfo profilingInfo;
        if (result2 == null) {
            Data<Object> data = new Data<Object>(null, ArrayUtilRt.EMPTY_OBJECT_ARRAY, ArrayUtil.EMPTY_LONG_ARRAY);
            if (data == null) {
                CachedValueBase.$$$reportNull$$$0(0);
            }
            return data;
        }
        T value2 = result2.getValue();
        Object[] inferredDependencies = this.normalizeDependencies(result2);
        long[] inferredTimeStamps = new long[inferredDependencies.length];
        for (int i = 0; i < inferredDependencies.length; ++i) {
            inferredTimeStamps[i] = this.getTimeStamp(inferredDependencies[i]);
        }
        if (CachedValueProfiler.canProfile() && (profilingInfo = CachedValueProfiler.getInstance().getTemporaryInfo(result2)) != null) {
            ProfilingData profilingData = new ProfilingData(value2, inferredDependencies, inferredTimeStamps, profilingInfo);
            if (profilingData == null) {
                CachedValueBase.$$$reportNull$$$0(1);
            }
            return profilingData;
        }
        Data<T> data = new Data<T>(value2, inferredDependencies, inferredTimeStamps);
        if (data == null) {
            CachedValueBase.$$$reportNull$$$0(2);
        }
        return data;
    }

    @Nullable
    private synchronized Data<T> cacheOrGetData(@Nullable Data<T> expected, @Nullable Data<T> updatedValue) {
        if (expected != this.getRawData()) {
            return null;
        }
        if (updatedValue != null) {
            this.setData(updatedValue);
            return updatedValue;
        }
        return expected;
    }

    private synchronized void setData(@Nullable Data<T> data) {
        this.myData = data == null ? null : new SoftReference<Data<Data<Data<Data<T>>>>>(data);
    }

    @NotNull
    protected Object[] normalizeDependencies(@NotNull CachedValueProvider.Result<T> result2) {
        if (result2 == null) {
            CachedValueBase.$$$reportNull$$$0(3);
        }
        Object[] items = result2.getDependencyItems();
        T value2 = result2.getValue();
        Object[] rawDependencies = this.myTrackValue && value2 != null ? ArrayUtil.append(items, value2) : items;
        NotNullList<Object> flattened = new NotNullList<Object>(rawDependencies.length);
        CachedValueBase.collectDependencies(flattened, rawDependencies);
        Object[] objectArray = ArrayUtil.toObjectArray(flattened);
        if (objectArray == null) {
            CachedValueBase.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    public void clear() {
        this.setData(null);
    }

    public boolean hasUpToDateValue() {
        return this.getUpToDateOrNull() != null;
    }

    @Nullable
    public final Data<T> getUpToDateOrNull() {
        Data<T> data = this.getRawData();
        if (data != null) {
            if (this.isUpToDate(data)) {
                return data;
            }
            if (data instanceof ProfilingData) {
                ((ProfilingData)data).myProfilingInfo.valueDisposed();
            }
        }
        return null;
    }

    @Nullable
    final Data<T> getRawData() {
        return SoftReference.dereference(this.myData);
    }

    protected boolean isUpToDate(@NotNull Data data) {
        if (data == null) {
            CachedValueBase.$$$reportNull$$$0(5);
        }
        for (int i = 0; i < data.myDependencies.length; ++i) {
            Object dependency = data.myDependencies[i];
            if (!this.isDependencyOutOfDate(dependency, data.myTimeStamps[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isDependencyOutOfDate(@NotNull Object dependency, long oldTimeStamp) {
        if (dependency == null) {
            CachedValueBase.$$$reportNull$$$0(6);
        }
        if (dependency instanceof CachedValueBase) {
            return !((CachedValueBase)dependency).hasUpToDateValue();
        }
        long timeStamp = this.getTimeStamp(dependency);
        return timeStamp < 0L || timeStamp != oldTimeStamp;
    }

    private static void collectDependencies(@NotNull List<Object> resultingDeps, @NotNull Object[] dependencies2) {
        if (resultingDeps == null) {
            CachedValueBase.$$$reportNull$$$0(7);
        }
        if (dependencies2 == null) {
            CachedValueBase.$$$reportNull$$$0(8);
        }
        for (Object dependency : dependencies2) {
            if (dependency == ObjectUtils.NULL) continue;
            if (dependency instanceof Object[]) {
                CachedValueBase.collectDependencies(resultingDeps, (Object[])dependency);
                continue;
            }
            resultingDeps.add(dependency);
        }
    }

    protected long getTimeStamp(@NotNull Object dependency) {
        if (dependency == null) {
            CachedValueBase.$$$reportNull$$$0(9);
        }
        if (dependency instanceof VirtualFile) {
            return ((VirtualFile)dependency).getModificationStamp();
        }
        if (dependency instanceof ModificationTracker) {
            return ((ModificationTracker)dependency).getModificationCount();
        }
        if (dependency instanceof Reference) {
            Object original = ((Reference)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Ref) {
            Object original = ((Ref)dependency).get();
            if (original == null) {
                return -1L;
            }
            return this.getTimeStamp(original);
        }
        if (dependency instanceof Document) {
            return ((Document)dependency).getModificationStamp();
        }
        if (dependency instanceof CachedValueBase) {
            return 0L;
        }
        LOG.error("Wrong dependency type: " + dependency.getClass());
        return -1L;
    }

    public T setValue(@NotNull CachedValueProvider.Result<T> result2) {
        if (result2 == null) {
            CachedValueBase.$$$reportNull$$$0(10);
        }
        Data<T> data = this.computeData(result2);
        this.setData(data);
        return data.getValue();
    }

    public abstract boolean isFromMyProject(@NotNull Project var1);

    public abstract Object getValueProvider();

    @Nullable
    protected <P> T getValueWithLock(P param) {
        Data data = this.getUpToDateOrNull();
        if (data != null) {
            if (IdempotenceChecker.areRandomChecksEnabled()) {
                IdempotenceChecker.applyForRandomCheck(data, this.getValueProvider(), () -> this.computeData(this.doCompute(param)));
            }
            return data.getValue();
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        Computable<Data> calcData = () -> this.computeData(this.doCompute(param));
        data = RecursionManager.doPreventingRecursion(this, true, calcData);
        if (data == null) {
            data = calcData.compute();
        } else if (stamp.mayCacheNow()) {
            boolean reuse;
            Data<T> alreadyComputed;
            Data<T> toReturn;
            do {
                boolean bl = reuse = (alreadyComputed = this.getRawData()) != null && this.isUpToDate(alreadyComputed);
                if (!reuse) continue;
                IdempotenceChecker.checkEquivalence(alreadyComputed, data, this.getValueProvider().getClass());
            } while ((toReturn = this.cacheOrGetData(alreadyComputed, reuse ? null : data)) == null);
            return toReturn.getValue();
        }
        return data.getValue();
    }

    protected abstract <P> CachedValueProvider.Result<T> doCompute(P var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/CachedValueBase";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultingDeps";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "computeData";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/CachedValueBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "normalizeDependencies";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDependencyOutOfDate";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectDependencies";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProfilingData<T>
    extends Data<T> {
        @NotNull
        private final ProfilingInfo myProfilingInfo;

        private ProfilingData(T value2, @NotNull Object[] dependencies2, @NotNull long[] timeStamps, @NotNull ProfilingInfo profilingInfo) {
            if (dependencies2 == null) {
                ProfilingData.$$$reportNull$$$0(0);
            }
            if (timeStamps == null) {
                ProfilingData.$$$reportNull$$$0(1);
            }
            if (profilingInfo == null) {
                ProfilingData.$$$reportNull$$$0(2);
            }
            super(value2, dependencies2, timeStamps);
            this.myProfilingInfo = profilingInfo;
        }

        @Override
        public T getValue() {
            this.myProfilingInfo.valueUsed();
            return super.getValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dependencies";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "timeStamps";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "profilingInfo";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/util/CachedValueBase$ProfilingData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class Data<T>
    implements Getter<T> {
        private final T myValue;
        @NotNull
        private final Object[] myDependencies;
        @NotNull
        private final long[] myTimeStamps;

        Data(T value2, @NotNull Object[] dependencies2, @NotNull long[] timeStamps) {
            if (dependencies2 == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (timeStamps == null) {
                Data.$$$reportNull$$$0(1);
            }
            this.myValue = value2;
            this.myDependencies = dependencies2;
            this.myTimeStamps = timeStamps;
        }

        @NotNull
        public Object[] getDependencies() {
            if (this.myDependencies == null) {
                Data.$$$reportNull$$$0(2);
            }
            return this.myDependencies;
        }

        @NotNull
        public long[] getTimeStamps() {
            if (this.myTimeStamps == null) {
                Data.$$$reportNull$$$0(3);
            }
            return this.myTimeStamps;
        }

        @Override
        public final T get() {
            return this.getValue();
        }

        public T getValue() {
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timeStamps";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/CachedValueBase$Data";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/CachedValueBase$Data";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTimeStamps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

