/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.NonExtensible;
import org.gradle.api.internal.provider.AbstractReadOnlyProvider;
import org.gradle.api.internal.provider.ValueSourceProviderFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.api.provider.ValueSourceSpec;
import org.gradle.internal.Try;
import org.gradle.internal.event.AnonymousListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolated.IsolationScheme;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceLookup;
import org.jetbrains.annotations.NotNull;

public class DefaultValueSourceProviderFactory
implements ValueSourceProviderFactory {
    private final InstantiatorFactory instantiatorFactory;
    private final IsolatableFactory isolatableFactory;
    private final AnonymousListenerBroadcast<ValueSourceProviderFactory.Listener> broadcaster;
    private final IsolationScheme<ValueSource, ValueSourceParameters> isolationScheme = new IsolationScheme<ValueSource, ValueSourceParameters.None>(ValueSource.class, ValueSourceParameters.class, ValueSourceParameters.None.class);
    private final InstanceGenerator paramsInstantiator;
    private final InstanceGenerator specInstantiator;

    public DefaultValueSourceProviderFactory(ListenerManager listenerManager, InstantiatorFactory instantiatorFactory, IsolatableFactory isolatableFactory, ServiceLookup services) {
        this.broadcaster = listenerManager.createAnonymousBroadcaster(ValueSourceProviderFactory.Listener.class);
        this.instantiatorFactory = instantiatorFactory;
        this.isolatableFactory = isolatableFactory;
        this.paramsInstantiator = instantiatorFactory.decorateScheme().withServices(services).instantiator();
        this.specInstantiator = instantiatorFactory.decorateLenientScheme().withServices(services).instantiator();
    }

    @Override
    public <T, P extends ValueSourceParameters> Provider<T> createProviderOf(Class<? extends ValueSource<T, P>> valueSourceType, Action<? super ValueSourceSpec<P>> configureAction) {
        Class<P> parametersType = this.extractParametersTypeOf(valueSourceType);
        ValueSourceParameters parameters = (ValueSourceParameters)this.paramsInstantiator.newInstance(parametersType, new Object[0]);
        this.configureParameters(parameters, configureAction);
        return this.instantiateValueSourceProvider(valueSourceType, parametersType, parameters);
    }

    @Override
    public void addListener(ValueSourceProviderFactory.Listener listener) {
        this.broadcaster.add((Object)listener);
    }

    @Override
    public void removeListener(ValueSourceProviderFactory.Listener listener) {
        this.broadcaster.remove((Object)listener);
    }

    @Override
    @NotNull
    public <T, P extends ValueSourceParameters> Provider<T> instantiateValueSourceProvider(Class<? extends ValueSource<T, P>> valueSourceType, Class<P> parametersType, P parameters) {
        return new ValueSourceProvider(this, valueSourceType, parametersType, parameters);
    }

    @NotNull
    public <T, P extends ValueSourceParameters> ValueSource<T, P> instantiateValueSource(Class<? extends ValueSource<T, P>> valueSourceType, Class<P> parametersType, P isolatedParameters) {
        DefaultServiceRegistry services = new DefaultServiceRegistry();
        services.add(parametersType, isolatedParameters);
        return (ValueSource)this.instantiatorFactory.injectScheme().withServices((ServiceLookup)services).instantiator().newInstance(valueSourceType, new Object[0]);
    }

    @NotNull
    private <T, P extends ValueSourceParameters> Class<P> extractParametersTypeOf(Class<? extends ValueSource<T, P>> valueSourceType) {
        Class parametersType = this.isolationScheme.parameterTypeFor(valueSourceType, 1);
        if (parametersType == null) {
            throw new IllegalArgumentException();
        }
        return parametersType;
    }

    private <P extends ValueSourceParameters> void configureParameters(P parameters, Action<? super ValueSourceSpec<P>> configureAction) {
        DefaultValueSourceSpec valueSourceSpec = (DefaultValueSourceSpec)this.specInstantiator.newInstance(DefaultValueSourceSpec.class, new Object[]{parameters});
        configureAction.execute((Object)valueSourceSpec);
    }

    private static class DefaultObtainedValue<T, P extends ValueSourceParameters>
    implements ValueSourceProviderFactory.Listener.ObtainedValue<T, P> {
        private final Try<T> value;
        private final Class<? extends ValueSource<T, P>> valueSourceType;
        private final Class<P> parametersType;
        private final P parameters;

        public DefaultObtainedValue(Try<T> value, Class<? extends ValueSource<T, P>> valueSourceType, Class<P> parametersType, P parameters) {
            this.value = value;
            this.valueSourceType = valueSourceType;
            this.parametersType = parametersType;
            this.parameters = parameters;
        }

        @Override
        public Try<T> getValue() {
            return this.value;
        }

        @Override
        public Class<? extends ValueSource<T, P>> getValueSourceType() {
            return this.valueSourceType;
        }

        @Override
        public Class<P> getValueSourceParametersType() {
            return this.parametersType;
        }

        @Override
        public P getValueSourceParameters() {
            return this.parameters;
        }
    }

    public static class ValueSourceProvider<T, P extends ValueSourceParameters>
    extends AbstractReadOnlyProvider<T> {
        private final Class<? extends ValueSource<T, P>> valueSourceType;
        private final Class<P> parametersType;
        private final P parameters;
        @Nullable
        private Try<T> value = null;
        final /* synthetic */ DefaultValueSourceProviderFactory this$0;

        public ValueSourceProvider(Class<? extends ValueSource<T, P>> valueSourceType, Class<P> parametersType, P parameters) {
            this.this$0 = this$0;
            this.valueSourceType = valueSourceType;
            this.parametersType = parametersType;
            this.parameters = parameters;
        }

        public Class<? extends ValueSource<T, P>> getValueSourceType() {
            return this.valueSourceType;
        }

        public Class<P> getParametersType() {
            return this.parametersType;
        }

        public P getParameters() {
            return this.parameters;
        }

        @Override
        public boolean isValueProducedByTask() {
            return this.value == null;
        }

        @Override
        public boolean immutable() {
            return true;
        }

        @Nullable
        public Try<T> getObtainedValueOrNull() {
            return this.value;
        }

        @Override
        @Nullable
        public Class<T> getType() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T getOrNull() {
            ValueSourceProvider valueSourceProvider = this;
            synchronized (valueSourceProvider) {
                if (this.value == null) {
                    this.value = Try.ofFailable(() -> this.obtainValueFromSource());
                    this.onValueObtained();
                }
                return (T)this.value.get();
            }
        }

        @Nullable
        private T obtainValueFromSource() {
            return (T)this.this$0.instantiateValueSource(this.valueSourceType, this.parametersType, this.isolateParameters()).obtain();
        }

        private P isolateParameters() {
            return (P)((ValueSourceParameters)this.this$0.isolatableFactory.isolate(this.parameters).isolate());
        }

        private void onValueObtained() {
            ((ValueSourceProviderFactory.Listener)this.this$0.broadcaster.getSource()).valueObtained(new DefaultObtainedValue<T, P>(this.value, this.valueSourceType, this.parametersType, this.parameters));
        }
    }

    @NonExtensible
    public static abstract class DefaultValueSourceSpec<P extends ValueSourceParameters>
    implements ValueSourceSpec<P> {
        private final P parameters;

        public DefaultValueSourceSpec(P parameters) {
            this.parameters = parameters;
        }

        public P getParameters() {
            return this.parameters;
        }

        public void parameters(Action<? super P> configureAction) {
            configureAction.execute(this.parameters);
        }
    }
}

