/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.file.internal;

import java.io.File;
import org.apache.commons.lang.StringUtils;

public class FilePathUtil {
    private static final String FILE_PATH_SEPARATORS = File.separatorChar != '/' ? "/" + File.separator : File.separator;

    private FilePathUtil() {
    }

    public static String[] getPathSegments(String path) {
        return StringUtils.split((String)path, (String)FILE_PATH_SEPARATORS);
    }

    public static int sizeOfCommonPrefix(String path1, String path2, int offset) {
        return FilePathUtil.sizeOfCommonPrefix(path1, path2, offset, File.separatorChar);
    }

    public static int sizeOfCommonPrefix(String path1, String path2, int offset, char separatorChar) {
        int pos;
        int lastSeparator = 0;
        int maxPos = Math.min(path1.length(), path2.length() - offset);
        for (pos = 0; pos < maxPos && path1.charAt(pos) == path2.charAt(pos + offset); ++pos) {
            if (path1.charAt(pos) != separatorChar) continue;
            lastSeparator = pos;
        }
        if (pos == maxPos) {
            if (path1.length() == path2.length() - offset) {
                return pos;
            }
            if (pos < path1.length() && path1.charAt(pos) == separatorChar) {
                return pos;
            }
            if (pos < path2.length() - offset && path2.charAt(pos + offset) == separatorChar) {
                return pos;
            }
        }
        return lastSeparator;
    }
}

