/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.DependencyVerifyingModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.ArtifactVerificationOperation;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.DependencyVerificationOverride;
import org.gradle.api.internal.artifacts.verification.DependencyVerifierBuilder;
import org.gradle.api.internal.artifacts.verification.model.ChecksumKind;
import org.gradle.api.internal.artifacts.verification.serializer.DependencyVerificationsXmlReader;
import org.gradle.api.internal.artifacts.verification.serializer.DependencyVerificationsXmlWriter;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteDependencyVerificationFile
implements DependencyVerificationOverride,
ArtifactVerificationOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteDependencyVerificationFile.class);
    private static final Action<ArtifactView.ViewConfiguration> MODULE_COMPONENT_FILES = conf -> {
        conf.componentFilter(id -> id instanceof ModuleComponentIdentifier);
        conf.setLenient(true);
    };
    private static final Set<String> SUPPORTED_CHECKSUMS = ImmutableSet.of((Object)"md5", (Object)"sha1", (Object)"sha256", (Object)"sha512");
    private static final Set<String> SECURE_CHECKSUMS = ImmutableSet.of((Object)"sha256", (Object)"sha512");
    private static final List<String> DEFAULT_CHECKSUMS = ImmutableList.of((Object)"sha1", (Object)"sha512");
    private final DependencyVerifierBuilder verificationsBuilder = new DependencyVerifierBuilder();
    private final File buildDirectory;
    private final BuildOperationExecutor buildOperationExecutor;
    private final List<String> checksums;
    private final Set<ChecksumEntry> entriesToBeWritten = Sets.newLinkedHashSetWithExpectedSize((int)512);
    private final ChecksumService checksumService;

    public WriteDependencyVerificationFile(File buildDirectory, BuildOperationExecutor buildOperationExecutor, List<String> checksums, ChecksumService checksumService) {
        this.buildDirectory = buildDirectory;
        this.buildOperationExecutor = buildOperationExecutor;
        this.checksums = this.validateChecksums(checksums);
        this.checksumService = checksumService;
    }

    private List<String> validateChecksums(List<String> checksums) {
        checksums = this.assertSupportedChecksums(checksums);
        this.warnAboutInsecureChecksums(checksums);
        return checksums;
    }

    private List<String> assertSupportedChecksums(List<String> checksums) {
        List<String> copy = new ArrayList<String>(checksums);
        boolean updated = copy.retainAll(SUPPORTED_CHECKSUMS);
        if (updated) {
            for (String checksum : checksums) {
                if (SUPPORTED_CHECKSUMS.contains(checksum)) continue;
                LOGGER.warn("Invalid checksum type: '" + checksum + "'. You must choose one or more in " + SUPPORTED_CHECKSUMS);
            }
            if (copy.isEmpty()) {
                LOGGER.warn("Falling back to the default checksums: sha1 and sha512");
                copy = DEFAULT_CHECKSUMS;
            }
            return copy;
        }
        return checksums;
    }

    private void warnAboutInsecureChecksums(List<String> checksums) {
        if (checksums.stream().noneMatch(SECURE_CHECKSUMS::contains)) {
            LOGGER.warn("You chose to generate " + checksums.stream().collect(Collectors.joining(" and ")) + " checksums but they are all considered insecure. You should consider adding at least one of " + SECURE_CHECKSUMS.stream().collect(Collectors.joining(" or ")) + ".");
        }
    }

    @Override
    public ModuleComponentRepository overrideDependencyVerification(ModuleComponentRepository original) {
        return new DependencyVerifyingModuleComponentRepository(original, this);
    }

    @Override
    public void buildFinished(Gradle gradle) {
        File verifFile = DependencyVerificationOverride.dependencyVerificationsFile(this.buildDirectory);
        try {
            this.maybeReadExistingFile(verifFile);
            this.computeHashsConcurrently(gradle);
            this.writeEntriesSerially();
            this.serializeResult(verifFile);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private void serializeResult(File verifFile) throws IOException {
        DependencyVerificationsXmlWriter.serialize(this.verificationsBuilder.build(), new FileOutputStream(verifFile));
    }

    private void maybeReadExistingFile(File verifFile) throws FileNotFoundException {
        if (verifFile.exists()) {
            LOGGER.info("Found dependency verification metadata file, updating");
            DependencyVerificationsXmlReader.readFromXml(new FileInputStream(verifFile), this.verificationsBuilder);
        }
    }

    private void writeEntriesSerially() {
        this.entriesToBeWritten.stream().sorted().forEachOrdered(entry -> this.verificationsBuilder.addChecksum(((ChecksumEntry)entry).id, ((ChecksumEntry)entry).checksumKind, ((ChecksumEntry)entry).checksum, "Generated by Gradle"));
    }

    private void computeHashsConcurrently(Gradle gradle) {
        this.buildOperationExecutor.runAll(queue -> {
            Set allprojects = gradle.getRootProject().getAllprojects();
            for (final Project project : allprojects) {
                queue.add((BuildOperation)new RunnableBuildOperation(){

                    public void run(BuildOperationContext context) {
                        WriteDependencyVerificationFile.resolveAllConfigurationsAndForceDownload(project);
                    }

                    public BuildOperationDescriptor.Builder description() {
                        return BuildOperationDescriptor.displayName((String)("Computing dependency verification metadata for " + project.getDisplayName()));
                    }
                });
            }
        });
    }

    @Override
    public void onArtifact(ModuleComponentArtifactIdentifier id, File file) {
        for (String checksum : this.checksums) {
            this.addChecksum(id, file, ChecksumKind.valueOf(checksum));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChecksum(final ModuleComponentArtifactIdentifier id, final File file, final ChecksumKind kind) {
        ChecksumEntry entry = (ChecksumEntry)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<ChecksumEntry>(){

            public ChecksumEntry call(BuildOperationContext context) {
                if (file.exists()) {
                    return new ChecksumEntry(id, file, kind, WriteDependencyVerificationFile.this.createHash(file, kind));
                }
                LOGGER.warn("Cannot compute checksum for " + file + " because it doesn't exist. It may indicate a corrupt or tampered cache.");
                return null;
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Generate " + (Object)((Object)kind) + " checksum for " + id));
            }
        });
        if (entry != null) {
            Set<ChecksumEntry> set = this.entriesToBeWritten;
            synchronized (set) {
                this.entriesToBeWritten.add(entry);
            }
        }
    }

    private String createHash(File file, ChecksumKind kind) {
        return this.checksumService.hash(file, kind.getAlgorithm()).toString();
    }

    private static void resolveAllConfigurationsAndForceDownload(Project p) {
        ((ProjectInternal)p).getMutationState().withMutableState(() -> p.getConfigurations().all(cnf -> {
            if (((DeprecatableConfiguration)cnf).canSafelyBeResolved()) {
                try {
                    WriteDependencyVerificationFile.resolveAndDownloadExternalFiles(cnf);
                }
                catch (Exception e) {
                    LOGGER.debug("Cannot resolve configuration {}: {}", (Object)cnf.getName(), (Object)e.getMessage());
                }
            }
        }));
    }

    private static void resolveAndDownloadExternalFiles(Configuration cnf) {
        cnf.getIncoming().artifactView(MODULE_COMPONENT_FILES).getFiles().getFiles();
    }

    private static class ChecksumEntry
    implements Comparable<ChecksumEntry> {
        private static final Comparator<ChecksumEntry> CHECKSUM_ENTRY_COMPARATOR = Comparator.comparing(ChecksumEntry::getGroup).thenComparing(ChecksumEntry::getModule).thenComparing(ChecksumEntry::getVersion).thenComparing(ChecksumEntry::getFile).thenComparing(ChecksumEntry::getChecksumKind).thenComparing(ChecksumEntry::getChecksum);
        private final ModuleComponentArtifactIdentifier id;
        private final File file;
        private final ChecksumKind checksumKind;
        private final String checksum;
        private final int hashCode;

        private ChecksumEntry(ModuleComponentArtifactIdentifier id, File file, ChecksumKind checksumKind, String checksum) {
            this.id = id;
            this.file = file;
            this.checksumKind = checksumKind;
            this.checksum = checksum;
            this.hashCode = this.precomputeHashCode();
        }

        private int precomputeHashCode() {
            int result = this.id.hashCode();
            result = 31 * result + this.file.getName().hashCode();
            result = 31 * result + this.checksum.hashCode();
            result = 31 * result + this.checksumKind.hashCode();
            return result;
        }

        String getGroup() {
            return this.id.getComponentIdentifier().getGroup();
        }

        String getModule() {
            return this.id.getComponentIdentifier().getModule();
        }

        String getVersion() {
            return this.id.getComponentIdentifier().getVersion();
        }

        String getChecksum() {
            return this.checksum;
        }

        @Override
        public int compareTo(ChecksumEntry other) {
            return CHECKSUM_ENTRY_COMPARATOR.compare(this, other);
        }

        ChecksumKind getChecksumKind() {
            return this.checksumKind;
        }

        String getFile() {
            return this.file.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChecksumEntry that = (ChecksumEntry)o;
            if (!this.id.equals(that.id)) {
                return false;
            }
            if (!this.checksum.equals(that.checksum)) {
                return false;
            }
            if (!this.getFile().equals(that.getFile())) {
                return false;
            }
            return this.checksumKind == that.checksumKind;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

