/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.use.resolve.internal;

import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.plugins.DefaultPluginRegistry;
import org.gradle.api.internal.plugins.PluginImplementation;
import org.gradle.api.internal.plugins.PluginInspector;
import org.gradle.api.plugins.UnknownPluginException;
import org.gradle.internal.Factory;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.resolve.internal.PluginResolution;
import org.gradle.plugin.use.resolve.internal.PluginResolveContext;

public class ClassPathPluginResolution
implements PluginResolution {
    private final PluginId pluginId;
    private final ClassLoaderScope parent;
    private final Factory<? extends ClassPath> classPathFactory;
    private final PluginInspector pluginInspector;

    public ClassPathPluginResolution(PluginId pluginId, ClassLoaderScope parent, Factory<? extends ClassPath> classPathFactory, PluginInspector pluginInspector) {
        this.pluginId = pluginId;
        this.parent = parent;
        this.classPathFactory = classPathFactory;
        this.pluginInspector = pluginInspector;
    }

    @Override
    public PluginId getPluginId() {
        return this.pluginId;
    }

    public void execute(PluginResolveContext pluginResolveContext) {
        ClassPath classPath = (ClassPath)this.classPathFactory.create();
        ClassLoaderScope loaderScope = this.parent.createChild("plugin-" + this.pluginId.getId());
        loaderScope.local(classPath);
        loaderScope.lock();
        DefaultPluginRegistry pluginRegistry = new DefaultPluginRegistry(this.pluginInspector, loaderScope);
        PluginImplementation plugin = pluginRegistry.lookup(this.pluginId);
        if (plugin == null) {
            throw new UnknownPluginException("Plugin with id '" + this.pluginId + "' not found.");
        }
        pluginResolveContext.add(plugin);
    }
}

