/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.contracts.ContractDeserializerImpl$ContractDeserializationWorker$WhenMappings;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.BooleanExpression;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractProviderImpl;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.InvocationKind;
import org.jetbrains.kotlin.contracts.description.ReturnsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.BooleanVariableReference;
import org.jetbrains.kotlin.contracts.description.expressions.ConstantReference;
import org.jetbrains.kotlin.contracts.description.expressions.IsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.expressions.IsNullPredicate;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalAnd;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalNot;
import org.jetbrains.kotlin.contracts.description.expressions.LogicalOr;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.metadata.deserialization.ProtoTypeTableUtilKt;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.serialization.deserialization.ContractDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.serialization.deserialization.TypeDeserializer;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J:\u0010\u0007\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/contracts/ContractDeserializerImpl;", "Lorg/jetbrains/kotlin/serialization/deserialization/ContractDeserializer;", "configuration", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "(Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "deserializeContractFromFunction", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor$UserDataKey;", "Lorg/jetbrains/kotlin/contracts/description/AbstractContractProvider;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function;", "ownerFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "typeTable", "Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "typeDeserializer", "Lorg/jetbrains/kotlin/serialization/deserialization/TypeDeserializer;", "ContractDeserializationWorker", "frontend"})
public final class ContractDeserializerImpl
implements ContractDeserializer {
    private final DeserializationConfiguration configuration;
    private final StorageManager storageManager;

    @Nullable
    public Pair<CallableDescriptor.UserDataKey<?>, AbstractContractProvider> deserializeContractFromFunction(@NotNull ProtoBuf.Function proto, @NotNull FunctionDescriptor ownerFunction, @NotNull TypeTable typeTable, @NotNull TypeDeserializer typeDeserializer) {
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)ownerFunction, (String)"ownerFunction");
        Intrinsics.checkParameterIsNotNull((Object)typeTable, (String)"typeTable");
        Intrinsics.checkParameterIsNotNull((Object)typeDeserializer, (String)"typeDeserializer");
        if (!proto.hasContract()) {
            return null;
        }
        if (!this.configuration.getReadDeserializedContracts()) {
            return null;
        }
        ContractDeserializationWorker worker = new ContractDeserializationWorker(typeTable, typeDeserializer, ownerFunction, this.storageManager);
        ProtoBuf.Contract contract = proto.getContract();
        Intrinsics.checkExpressionValueIsNotNull((Object)contract, (String)"proto.contract");
        ContractDescription contractDescription = worker.deserializeContract(contract);
        if (contractDescription == null) {
            return null;
        }
        ContractDescription contract2 = contractDescription;
        return TuplesKt.to((Object)ContractProviderKey.INSTANCE, (Object)new ContractProviderImpl(contract2));
    }

    public ContractDeserializerImpl(@NotNull DeserializationConfiguration configuration, @NotNull StorageManager storageManager) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
        this.configuration = configuration;
        this.storageManager = storageManager;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0002+,B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0011\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0011\u001a\u00020\u0018H\u0002J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0011\u001a\u00020\u0015H\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0011\u001a\u00020\u0015H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0011\u001a\u00020\u0015H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0011\u001a\u00020\u0015H\u0002J\f\u0010$\u001a\u00020%*\u00020\u0015H\u0002J\u0014\u0010&\u001a\u00020\u0014*\u00020\u00142\u0006\u0010'\u001a\u00020%H\u0002J\u000e\u0010(\u001a\u0004\u0018\u00010)*\u00020*H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/contracts/ContractDeserializerImpl$ContractDeserializationWorker;", "", "typeTable", "Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;", "typeDeserializer", "Lorg/jetbrains/kotlin/serialization/deserialization/TypeDeserializer;", "ownerFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "(Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;Lorg/jetbrains/kotlin/serialization/deserialization/TypeDeserializer;Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Lorg/jetbrains/kotlin/storage/StorageManager;)V", "deserializeConstant", "Lorg/jetbrains/kotlin/contracts/description/expressions/ConstantReference;", "value", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression$ConstantValue;", "deserializeContract", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Contract;", "deserializeExpression", "Lorg/jetbrains/kotlin/contracts/description/BooleanExpression;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression;", "deserializePossiblyConditionalEffect", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Effect;", "deserializeSimpleEffect", "extractPrimitiveExpression", "primitiveType", "Lorg/jetbrains/kotlin/contracts/ContractDeserializerImpl$ContractDeserializationWorker$PrimitiveExpressionType;", "extractType", "Lorg/jetbrains/kotlin/types/KotlinType;", "extractVariable", "Lorg/jetbrains/kotlin/contracts/description/expressions/VariableReference;", "getComplexType", "Lorg/jetbrains/kotlin/contracts/ContractDeserializerImpl$ContractDeserializationWorker$ComplexExpressionType;", "getPrimitiveType", "hasType", "", "invertIfNecessary", "shouldInvert", "toDescriptorInvocationKind", "Lorg/jetbrains/kotlin/contracts/description/InvocationKind;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Effect$InvocationKind;", "ComplexExpressionType", "PrimitiveExpressionType", "frontend"})
    private static final class ContractDeserializationWorker {
        private final TypeTable typeTable;
        private final TypeDeserializer typeDeserializer;
        private final FunctionDescriptor ownerFunction;
        private final StorageManager storageManager;

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final ContractDescription deserializeContract(@NotNull ProtoBuf.Contract proto) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
            List<ProtoBuf.Effect> list2 = proto.getEffectList();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"proto.effectList");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                EffectDeclaration effectDeclaration;
                void it;
                ProtoBuf.Effect effect = (ProtoBuf.Effect)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                if (this.deserializePossiblyConditionalEffect((ProtoBuf.Effect)v1) == null) {
                    return null;
                }
                collection.add(effectDeclaration);
            }
            List effects = (List)destination$iv$iv;
            return new ContractDescription(effects, this.ownerFunction, this.storageManager);
        }

        private final EffectDeclaration deserializePossiblyConditionalEffect(ProtoBuf.Effect proto) {
            if (proto.hasConclusionOfConditionalEffect()) {
                ProtoBuf.Expression expression2 = proto.getConclusionOfConditionalEffect();
                Intrinsics.checkExpressionValueIsNotNull((Object)expression2, (String)"proto.conclusionOfConditionalEffect");
                BooleanExpression booleanExpression = this.deserializeExpression(expression2);
                if (booleanExpression == null) {
                    return null;
                }
                BooleanExpression conclusion = booleanExpression;
                EffectDeclaration effectDeclaration = this.deserializeSimpleEffect(proto);
                if (effectDeclaration == null) {
                    return null;
                }
                EffectDeclaration effect = effectDeclaration;
                return new ConditionalEffectDeclaration(effect, conclusion);
            }
            return this.deserializeSimpleEffect(proto);
        }

        private final EffectDeclaration deserializeSimpleEffect(ProtoBuf.Effect proto) {
            EffectDeclaration effectDeclaration;
            ProtoBuf.Effect.EffectType type2;
            if (!proto.hasEffectType()) {
                return null;
            }
            ProtoBuf.Effect.EffectType effectType = type2 = proto.getEffectType();
            if (effectType == null) {
                Intrinsics.throwNpe();
            }
            switch (ContractDeserializerImpl$ContractDeserializationWorker$WhenMappings.$EnumSwitchMapping$0[effectType.ordinal()]) {
                case 1: {
                    ConstantReference constantReference;
                    List<ProtoBuf.Expression> list2 = proto.getEffectConstructorArgumentList();
                    Intrinsics.checkExpressionValueIsNotNull(list2, (String)"proto.effectConstructorArgumentList");
                    ProtoBuf.Expression argument = (ProtoBuf.Expression)kotlin.collections.CollectionsKt.getOrNull(list2, (int)0);
                    if (argument == null) {
                        constantReference = ConstantReference.Companion.getWILDCARD();
                    } else {
                        BooleanExpression booleanExpression = this.deserializeExpression(argument);
                        if (!(booleanExpression instanceof ConstantReference)) {
                            booleanExpression = null;
                        }
                        if ((constantReference = (ConstantReference)((Object)booleanExpression)) == null) {
                            return null;
                        }
                    }
                    ConstantReference returnValue = constantReference;
                    effectDeclaration = new ReturnsEffectDeclaration(returnValue);
                    break;
                }
                case 2: {
                    effectDeclaration = new ReturnsEffectDeclaration(ConstantReference.Companion.getNOT_NULL());
                    break;
                }
                case 3: {
                    InvocationKind invocationKind;
                    List<ProtoBuf.Expression> list3 = proto.getEffectConstructorArgumentList();
                    Intrinsics.checkExpressionValueIsNotNull(list3, (String)"proto.effectConstructorArgumentList");
                    ProtoBuf.Expression expression2 = (ProtoBuf.Expression)kotlin.collections.CollectionsKt.getOrNull(list3, (int)0);
                    if (expression2 == null) {
                        return null;
                    }
                    ProtoBuf.Expression argument = expression2;
                    VariableReference variableReference = this.extractVariable(argument);
                    if (variableReference == null) {
                        return null;
                    }
                    VariableReference callable = variableReference;
                    if (proto.hasKind()) {
                        ProtoBuf.Effect.InvocationKind invocationKind2 = proto.getKind();
                        Intrinsics.checkExpressionValueIsNotNull((Object)invocationKind2, (String)"proto.kind");
                        invocationKind = this.toDescriptorInvocationKind(invocationKind2);
                        if (invocationKind == null) {
                            return null;
                        }
                    } else {
                        invocationKind = InvocationKind.UNKNOWN;
                    }
                    InvocationKind invocationKind3 = invocationKind;
                    effectDeclaration = new CallsEffectDeclaration(callable, invocationKind3);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return effectDeclaration;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        private final BooleanExpression deserializeExpression(ProtoBuf.Expression proto) {
            BooleanExpression booleanExpression;
            PrimitiveExpressionType primitiveType = this.getPrimitiveType(proto);
            BooleanExpression primitiveExpression = this.extractPrimitiveExpression(proto, primitiveType);
            ComplexExpressionType complexType = this.getComplexType(proto);
            boolean bl = false;
            List childs = new ArrayList();
            CollectionsKt.addIfNotNull(childs, primitiveExpression);
            ComplexExpressionType complexExpressionType = complexType;
            if (complexExpressionType != null) {
                switch (ContractDeserializerImpl$ContractDeserializationWorker$WhenMappings.$EnumSwitchMapping$1[complexExpressionType.ordinal()]) {
                    case 1: {
                        BooleanExpression it;
                        List<ProtoBuf.Expression> list2 = proto.getAndArgumentList();
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"proto.andArgumentList");
                        Iterable $this$mapTo$iv = list2;
                        boolean $i$f$mapTo = false;
                        for (Object t : $this$mapTo$iv) {
                            BooleanExpression booleanExpression2;
                            ProtoBuf.Expression expression2 = (ProtoBuf.Expression)t;
                            Collection collection = childs;
                            boolean bl2 = false;
                            void v2 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                            if (this.deserializeExpression((ProtoBuf.Expression)v2) == null) return null;
                            collection.add(booleanExpression2);
                        }
                        Iterable $this$reduce$iv = childs;
                        boolean $i$f$reduce = false;
                        Iterator iterator$iv = $this$reduce$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
                        }
                        Object t = iterator$iv.next();
                        while (true) {
                            void booleanExpression3;
                            void var9_15;
                            if (!iterator$iv.hasNext()) {
                                booleanExpression = (BooleanExpression)var9_15;
                                return booleanExpression;
                            }
                            it = (BooleanExpression)iterator$iv.next();
                            BooleanExpression acc = (BooleanExpression)var9_15;
                            boolean bl3 = false;
                            BooleanExpression booleanExpression4 = new LogicalAnd(acc, (BooleanExpression)booleanExpression3);
                        }
                    }
                    case 2: {
                        BooleanExpression it;
                        ProtoBuf.Expression booleanExpression3;
                        List<ProtoBuf.Expression> list3 = proto.getOrArgumentList();
                        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"proto.orArgumentList");
                        Iterable $this$mapTo$iv = list3;
                        boolean $i$f$mapTo = false;
                        for (Object t : $this$mapTo$iv) {
                            BooleanExpression booleanExpression5;
                            booleanExpression3 = (ProtoBuf.Expression)t;
                            Collection collection = childs;
                            boolean bl4 = false;
                            void v5 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
                            if (this.deserializeExpression((ProtoBuf.Expression)v5) == null) return null;
                            collection.add(booleanExpression5);
                        }
                        Iterable $this$reduce$iv = childs;
                        boolean $i$f$reduce = false;
                        Iterator iterator$iv = $this$reduce$iv.iterator();
                        if (!iterator$iv.hasNext()) {
                            throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
                        }
                        Object t = iterator$iv.next();
                        while (true) {
                            void var9_19;
                            if (!iterator$iv.hasNext()) {
                                booleanExpression = (BooleanExpression)var9_19;
                                return booleanExpression;
                            }
                            it = (BooleanExpression)iterator$iv.next();
                            BooleanExpression acc = (BooleanExpression)var9_19;
                            boolean bl5 = false;
                            BooleanExpression booleanExpression6 = new LogicalOr(acc, (BooleanExpression)((Object)booleanExpression3));
                        }
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            booleanExpression = primitiveExpression;
            return booleanExpression;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final BooleanExpression extractPrimitiveExpression(ProtoBuf.Expression proto, PrimitiveExpressionType primitiveType) {
            Boolean bl = Flags.IS_NEGATED.get(proto.getFlags());
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"Flags.IS_NEGATED.get(proto.flags)");
            boolean isInverted = bl;
            PrimitiveExpressionType primitiveExpressionType = primitiveType;
            if (primitiveExpressionType == null) return null;
            switch (ContractDeserializerImpl$ContractDeserializationWorker$WhenMappings.$EnumSwitchMapping$2[primitiveExpressionType.ordinal()]) {
                case 1: 
                case 2: {
                    VariableReference variableReference = this.extractVariable(proto);
                    if (!(variableReference instanceof BooleanVariableReference)) {
                        variableReference = null;
                    }
                    BooleanVariableReference booleanVariableReference = (BooleanVariableReference)variableReference;
                    if (booleanVariableReference == null) return null;
                    BooleanExpression booleanExpression = this.invertIfNecessary(booleanVariableReference, isInverted);
                    return booleanExpression;
                }
                case 3: {
                    ProtoBuf.Expression.ConstantValue constantValue = proto.getConstantValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)constantValue, (String)"proto.constantValue");
                    ConstantReference constantReference = this.deserializeConstant(constantValue);
                    if (!(constantReference instanceof BooleanConstantReference)) {
                        constantReference = null;
                    }
                    BooleanConstantReference booleanConstantReference = (BooleanConstantReference)constantReference;
                    if (booleanConstantReference == null) return null;
                    BooleanExpression booleanExpression = this.invertIfNecessary(booleanConstantReference, isInverted);
                    return booleanExpression;
                }
                case 4: {
                    VariableReference variableReference = this.extractVariable(proto);
                    if (variableReference == null) return null;
                    VariableReference variable2 = variableReference;
                    KotlinType kotlinType2 = this.extractType(proto);
                    if (kotlinType2 == null) return null;
                    KotlinType type2 = kotlinType2;
                    BooleanExpression booleanExpression = new IsInstancePredicate(variable2, type2, isInverted);
                    return booleanExpression;
                }
                case 5: {
                    VariableReference variableReference = this.extractVariable(proto);
                    if (variableReference == null) return null;
                    VariableReference variable3 = variableReference;
                    BooleanExpression booleanExpression = new IsNullPredicate(variable3, isInverted);
                    return booleanExpression;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        private final BooleanExpression invertIfNecessary(@NotNull BooleanExpression $this$invertIfNecessary, boolean shouldInvert) {
            return shouldInvert ? (BooleanExpression)new LogicalNot($this$invertIfNecessary) : $this$invertIfNecessary;
        }

        private final VariableReference extractVariable(ProtoBuf.Expression proto) {
            ParameterDescriptor parameterDescriptor;
            if (!proto.hasValueParameterReference()) {
                return null;
            }
            if (proto.getValueParameterReference() == 0) {
                ReceiverParameterDescriptor receiverParameterDescriptor = this.ownerFunction.getExtensionReceiverParameter();
                if (receiverParameterDescriptor == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)receiverParameterDescriptor, (String)"ownerFunction.extensionR\u2026rParameter ?: return null");
                parameterDescriptor = receiverParameterDescriptor;
            } else {
                List<ValueParameterDescriptor> list2 = this.ownerFunction.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ownerFunction.valueParameters");
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)kotlin.collections.CollectionsKt.getOrNull(list2, (int)(proto.getValueParameterReference() - 1));
                if (valueParameterDescriptor == null) {
                    return null;
                }
                parameterDescriptor = valueParameterDescriptor;
            }
            ParameterDescriptor parameterDescriptor2 = parameterDescriptor;
            return !KotlinBuiltIns.isBoolean(parameterDescriptor2.getType()) ? new VariableReference(parameterDescriptor2) : (VariableReference)new BooleanVariableReference(parameterDescriptor2);
        }

        private final InvocationKind toDescriptorInvocationKind(@NotNull ProtoBuf.Effect.InvocationKind $this$toDescriptorInvocationKind) {
            InvocationKind invocationKind;
            switch (ContractDeserializerImpl$ContractDeserializationWorker$WhenMappings.$EnumSwitchMapping$3[$this$toDescriptorInvocationKind.ordinal()]) {
                case 1: {
                    invocationKind = InvocationKind.AT_MOST_ONCE;
                    break;
                }
                case 2: {
                    invocationKind = InvocationKind.EXACTLY_ONCE;
                    break;
                }
                case 3: {
                    invocationKind = InvocationKind.AT_LEAST_ONCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return invocationKind;
        }

        private final KotlinType extractType(ProtoBuf.Expression proto) {
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.isInstanceType(proto, this.typeTable);
            if (type2 == null) {
                return null;
            }
            return this.typeDeserializer.type(type2);
        }

        private final ConstantReference deserializeConstant(ProtoBuf.Expression.ConstantValue value) {
            ConstantReference constantReference;
            switch (ContractDeserializerImpl$ContractDeserializationWorker$WhenMappings.$EnumSwitchMapping$4[value.ordinal()]) {
                case 1: {
                    constantReference = BooleanConstantReference.Companion.getTRUE();
                    break;
                }
                case 2: {
                    constantReference = BooleanConstantReference.Companion.getFALSE();
                    break;
                }
                case 3: {
                    constantReference = ConstantReference.Companion.getNULL();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return constantReference;
        }

        private final ComplexExpressionType getComplexType(ProtoBuf.Expression proto) {
            boolean isOrSequence = proto.getOrArgumentCount() != 0;
            boolean isAndSequence = proto.getAndArgumentCount() != 0;
            return isOrSequence && isAndSequence ? null : (isOrSequence ? ComplexExpressionType.OR_SEQUENCE : (isAndSequence ? ComplexExpressionType.AND_SEQUENCE : null));
        }

        private final PrimitiveExpressionType getPrimitiveType(ProtoBuf.Expression proto) {
            boolean bl = false;
            List expressionTypes = new ArrayList();
            if (proto.hasValueParameterReference() && this.hasType(proto)) {
                expressionTypes.add(PrimitiveExpressionType.INSTANCE_CHECK);
            } else if (proto.hasValueParameterReference()) {
                Boolean bl2 = Flags.IS_NULL_CHECK_PREDICATE.get(proto.getFlags());
                Intrinsics.checkExpressionValueIsNotNull((Object)bl2, (String)"Flags.IS_NULL_CHECK_PREDICATE.get(proto.flags)");
                if (bl2.booleanValue()) {
                    expressionTypes.add(PrimitiveExpressionType.NULLABILITY_CHECK);
                }
            }
            Collection collection = expressionTypes;
            boolean bl3 = false;
            if (!collection.isEmpty()) {
                return (PrimitiveExpressionType)((Object)kotlin.collections.CollectionsKt.singleOrNull((List)expressionTypes));
            }
            if (proto.hasValueParameterReference() && proto.getValueParameterReference() > 0) {
                expressionTypes.add(PrimitiveExpressionType.VALUE_PARAMETER_REFERENCE);
            } else if (proto.hasValueParameterReference() && proto.getValueParameterReference() == 0) {
                expressionTypes.add(PrimitiveExpressionType.RECEIVER_REFERENCE);
            } else if (proto.hasConstantValue()) {
                expressionTypes.add(PrimitiveExpressionType.CONSTANT);
            }
            return (PrimitiveExpressionType)((Object)kotlin.collections.CollectionsKt.singleOrNull((List)expressionTypes));
        }

        private final boolean hasType(@NotNull ProtoBuf.Expression $this$hasType) {
            return $this$hasType.hasIsInstanceType() || $this$hasType.hasIsInstanceTypeId();
        }

        public ContractDeserializationWorker(@NotNull TypeTable typeTable, @NotNull TypeDeserializer typeDeserializer, @NotNull FunctionDescriptor ownerFunction, @NotNull StorageManager storageManager) {
            Intrinsics.checkParameterIsNotNull((Object)typeTable, (String)"typeTable");
            Intrinsics.checkParameterIsNotNull((Object)typeDeserializer, (String)"typeDeserializer");
            Intrinsics.checkParameterIsNotNull((Object)ownerFunction, (String)"ownerFunction");
            Intrinsics.checkParameterIsNotNull((Object)storageManager, (String)"storageManager");
            this.typeTable = typeTable;
            this.typeDeserializer = typeDeserializer;
            this.ownerFunction = ownerFunction;
            this.storageManager = storageManager;
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/contracts/ContractDeserializerImpl$ContractDeserializationWorker$PrimitiveExpressionType;", "", "(Ljava/lang/String;I)V", "VALUE_PARAMETER_REFERENCE", "RECEIVER_REFERENCE", "CONSTANT", "INSTANCE_CHECK", "NULLABILITY_CHECK", "frontend"})
        private static final class PrimitiveExpressionType
        extends Enum<PrimitiveExpressionType> {
            public static final /* enum */ PrimitiveExpressionType VALUE_PARAMETER_REFERENCE;
            public static final /* enum */ PrimitiveExpressionType RECEIVER_REFERENCE;
            public static final /* enum */ PrimitiveExpressionType CONSTANT;
            public static final /* enum */ PrimitiveExpressionType INSTANCE_CHECK;
            public static final /* enum */ PrimitiveExpressionType NULLABILITY_CHECK;
            private static final /* synthetic */ PrimitiveExpressionType[] $VALUES;

            static {
                PrimitiveExpressionType[] primitiveExpressionTypeArray = new PrimitiveExpressionType[5];
                PrimitiveExpressionType[] primitiveExpressionTypeArray2 = primitiveExpressionTypeArray;
                primitiveExpressionTypeArray[0] = VALUE_PARAMETER_REFERENCE = new PrimitiveExpressionType();
                primitiveExpressionTypeArray[1] = RECEIVER_REFERENCE = new PrimitiveExpressionType();
                primitiveExpressionTypeArray[2] = CONSTANT = new PrimitiveExpressionType();
                primitiveExpressionTypeArray[3] = INSTANCE_CHECK = new PrimitiveExpressionType();
                primitiveExpressionTypeArray[4] = NULLABILITY_CHECK = new PrimitiveExpressionType();
                $VALUES = primitiveExpressionTypeArray;
            }

            public static PrimitiveExpressionType[] values() {
                return (PrimitiveExpressionType[])$VALUES.clone();
            }

            public static PrimitiveExpressionType valueOf(String string) {
                return Enum.valueOf(PrimitiveExpressionType.class, string);
            }
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/contracts/ContractDeserializerImpl$ContractDeserializationWorker$ComplexExpressionType;", "", "(Ljava/lang/String;I)V", "AND_SEQUENCE", "OR_SEQUENCE", "frontend"})
        private static final class ComplexExpressionType
        extends Enum<ComplexExpressionType> {
            public static final /* enum */ ComplexExpressionType AND_SEQUENCE;
            public static final /* enum */ ComplexExpressionType OR_SEQUENCE;
            private static final /* synthetic */ ComplexExpressionType[] $VALUES;

            static {
                ComplexExpressionType[] complexExpressionTypeArray = new ComplexExpressionType[2];
                ComplexExpressionType[] complexExpressionTypeArray2 = complexExpressionTypeArray;
                complexExpressionTypeArray[0] = AND_SEQUENCE = new ComplexExpressionType();
                complexExpressionTypeArray[1] = OR_SEQUENCE = new ComplexExpressionType();
                $VALUES = complexExpressionTypeArray;
            }

            public static ComplexExpressionType[] values() {
                return (ComplexExpressionType[])$VALUES.clone();
            }

            public static ComplexExpressionType valueOf(String string) {
                return Enum.valueOf(ComplexExpressionType.class, string);
            }
        }
    }
}

