/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.AnnotationTargetUtil;
import org.jetbrains.kotlin.com.intellij.codeInsight.AnnotationUtil;
import org.jetbrains.kotlin.com.intellij.codeInsight.CheckerFrameworkNullityUtil;
import org.jetbrains.kotlin.com.intellij.codeInsight.Nullability;
import org.jetbrains.kotlin.com.intellij.codeInsight.NullabilityAnnotationInfo;
import org.jetbrains.kotlin.com.intellij.openapi.components.ServiceManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public abstract class NullableNotNullManager {
    protected static final Logger LOG = Logger.getInstance(NullableNotNullManager.class);
    protected final Project myProject;
    protected static final String JAVAX_ANNOTATION_NULLABLE = "javax.annotation.Nullable";
    protected static final String JAVAX_ANNOTATION_NONNULL = "javax.annotation.Nonnull";
    static final String[] DEFAULT_NULLABLES = new String[]{"org.jetbrains.annotations.Nullable", "javax.annotation.Nullable", "javax.annotation.CheckForNull", "edu.umd.cs.findbugs.annotations.Nullable", "android.support.annotation.Nullable", "androidx.annotation.Nullable", "androidx.annotation.RecentlyNullable", "org.checkerframework.checker.nullness.qual.Nullable", "org.checkerframework.checker.nullness.compatqual.NullableDecl", "org.checkerframework.checker.nullness.compatqual.NullableType", "com.android.annotations.Nullable"};
    static final String[] DEFAULT_NOT_NULLS = new String[]{"org.jetbrains.annotations.NotNull", "javax.annotation.Nonnull", "edu.umd.cs.findbugs.annotations.NonNull", "android.support.annotation.NonNull", "androidx.annotation.NonNull", "androidx.annotation.RecentlyNonNull", "org.checkerframework.checker.nullness.qual.NonNull", "org.checkerframework.checker.nullness.compatqual.NonNullDecl", "org.checkerframework.checker.nullness.compatqual.NonNullType", "com.android.annotations.NonNull"};
    private static final List<String> DEFAULT_ALL = Arrays.asList(ArrayUtil.mergeArrays(DEFAULT_NULLABLES, DEFAULT_NOT_NULLS));

    protected NullableNotNullManager(Project project) {
        this.myProject = project;
    }

    public static NullableNotNullManager getInstance(Project project) {
        return ServiceManager.getService(project, NullableNotNullManager.class);
    }

    public boolean hasNullability(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(0);
        }
        return this.isNullable(owner, false) || this.isNotNull(owner, false);
    }

    public abstract void setNotNulls(String ... var1);

    public abstract void setNullables(String ... var1);

    @NotNull
    public abstract String getDefaultNullable();

    @Nullable
    public PsiAnnotation getNullableAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(1);
        }
        return this.findNullityAnnotationWithDefault(owner, checkBases, true);
    }

    public abstract void setDefaultNullable(@NotNull String var1);

    @NotNull
    public abstract String getDefaultNotNull();

    @Nullable
    public PsiAnnotation getNotNullAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(2);
        }
        return this.findNullityAnnotationWithDefault(owner, checkBases, false);
    }

    @Nullable
    public PsiAnnotation copyNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo info2;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(3);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(4);
        }
        if ((info2 = this.findOwnNullabilityInfo(original)) == null || info2.getNullability() != Nullability.NOT_NULL) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(info2.getAnnotation(), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo info2;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(5);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(6);
        }
        if ((info2 = this.findOwnNullabilityInfo(original)) == null || info2.getNullability() != Nullability.NULLABLE) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(info2.getAnnotation(), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableOrNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo src;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(7);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(8);
        }
        if ((src = this.findOwnNullabilityInfo(original)) == null) {
            return null;
        }
        NullabilityAnnotationInfo effective = this.findEffectiveNullabilityInfo(generated);
        if (effective != null && effective.getNullability() == src.getNullability()) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(src.getAnnotation(), generated);
    }

    @Nullable
    private static PsiAnnotation copyAnnotation(@NotNull PsiAnnotation annotation2, @NotNull PsiModifierListOwner target) {
        String qualifiedName;
        if (annotation2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(9);
        }
        if (target == null) {
            NullableNotNullManager.$$$reportNull$$$0(10);
        }
        if ((qualifiedName = annotation2.getQualifiedName()) != null) {
            PsiModifierList modifierList2;
            if (JavaPsiFacade.getInstance(annotation2.getProject()).findClass(qualifiedName, target.getResolveScope()) == null) {
                return null;
            }
            if (!AnnotationTargetUtil.isTypeAnnotation(annotation2) && (modifierList2 = target.getModifierList()) != null && !modifierList2.hasAnnotation(qualifiedName)) {
                return modifierList2.addAnnotation(qualifiedName);
            }
        }
        return null;
    }

    @Deprecated
    public PsiAnnotation copyNotNullAnnotation(@NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo info2;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(11);
        }
        if ((info2 = this.findOwnNullabilityInfo(owner)) == null || info2.getNullability() != Nullability.NOT_NULL) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(owner, info2.getAnnotation());
    }

    private static PsiAnnotation copyAnnotation(@NotNull PsiModifierListOwner owner, @NotNull PsiAnnotation annotation2) {
        String qualifiedName;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(12);
        }
        if (annotation2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(13);
        }
        return (qualifiedName = annotation2.getQualifiedName()) != null ? JavaPsiFacade.getElementFactory(owner.getProject()).createAnnotationFromText("@" + qualifiedName, owner) : null;
    }

    public abstract void setDefaultNotNull(@NotNull String var1);

    @Nullable
    private PsiAnnotation findNullityAnnotationWithDefault(@NotNull PsiModifierListOwner owner, boolean checkBases, boolean nullable) {
        List<PsiParameter> superParameters;
        int flags;
        PsiAnnotation annotation2;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(14);
        }
        if ((annotation2 = this.findPlainNullityAnnotation(owner, checkBases)) != null) {
            List<String> contradictory;
            String qName = annotation2.getQualifiedName();
            if (qName == null) {
                return null;
            }
            List<String> list2 = contradictory = nullable ? this.getNotNullsWithNickNames() : this.getNullablesWithNickNames();
            if (contradictory.contains(qName)) {
                return null;
            }
            return annotation2;
        }
        PsiType type2 = NullableNotNullManager.getOwnerType(owner);
        if (type2 == null || TypeConversionUtil.isPrimitiveAndNotNull(type2)) {
            return null;
        }
        List<String> annotations2 = Arrays.asList(nullable ? DEFAULT_NOT_NULLS : DEFAULT_NULLABLES);
        if (AnnotationUtil.isAnnotated(owner, annotations2, flags = (checkBases ? 1 : 0) | 2 | 4 | 8)) {
            return null;
        }
        if (!nullable && this.hasHardcodedContracts(owner)) {
            return null;
        }
        if (owner instanceof PsiParameter && !nullable && checkBases && !(superParameters = AnnotationUtil.getSuperAnnotationOwners((PsiParameter)owner)).isEmpty()) {
            return this.takeAnnotationFromSuperParameters((PsiParameter)owner, superParameters);
        }
        NullabilityAnnotationInfo nullityDefault = this.findNullityDefaultInHierarchy(owner);
        Nullability wantedNullability = nullable ? Nullability.NULLABLE : Nullability.NOT_NULL;
        return nullityDefault != null && nullityDefault.getNullability() == wantedNullability ? nullityDefault.getAnnotation() : null;
    }

    @Nullable
    public NullabilityAnnotationInfo findOwnNullabilityInfo(@NotNull PsiModifierListOwner owner) {
        PsiType type2;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(15);
        }
        if ((type2 = NullableNotNullManager.getOwnerType(owner)) == null || TypeConversionUtil.isPrimitiveAndNotNull(type2)) {
            return null;
        }
        List<String> nullables = this.getNullablesWithNickNames();
        HashSet<String> annotationNames = ContainerUtil.newHashSet(nullables);
        annotationNames.addAll(this.getNotNullsWithNickNames());
        PsiAnnotation annotation2 = this.findPlainNullityAnnotation(owner, false);
        if (annotation2 != null) {
            return new NullabilityAnnotationInfo(annotation2, nullables.contains(annotation2.getQualifiedName()) ? Nullability.NULLABLE : Nullability.NOT_NULL, false);
        }
        return null;
    }

    @Nullable
    public NullabilityAnnotationInfo findEffectiveNullabilityInfo(@NotNull PsiModifierListOwner owner) {
        PsiType type2;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(16);
        }
        if ((type2 = NullableNotNullManager.getOwnerType(owner)) == null || TypeConversionUtil.isPrimitiveAndNotNull(type2)) {
            return null;
        }
        return (NullabilityAnnotationInfo)CachedValuesManager.getCachedValue(owner, () -> CachedValueProvider.Result.create(this.doFindEffectiveNullabilityAnnotation(owner), PsiModificationTracker.MODIFICATION_COUNT));
    }

    @Nullable
    private NullabilityAnnotationInfo doFindEffectiveNullabilityAnnotation(@NotNull PsiModifierListOwner owner) {
        List<PsiParameter> superParameters;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(17);
        }
        List<String> nullables = this.getNullablesWithNickNames();
        HashSet<String> annotationNames = ContainerUtil.newHashSet(nullables);
        annotationNames.addAll(this.getNotNullsWithNickNames());
        Set extraAnnotations = DEFAULT_ALL.stream().filter(anno -> !annotationNames.contains(anno)).collect(Collectors.toSet());
        annotationNames.addAll(extraAnnotations);
        PsiAnnotation annotation2 = NullableNotNullManager.findPlainAnnotation(owner, true, annotationNames);
        if (annotation2 != null) {
            if (extraAnnotations.contains(annotation2.getQualifiedName())) {
                return null;
            }
            return new NullabilityAnnotationInfo(annotation2, nullables.contains(annotation2.getQualifiedName()) ? Nullability.NULLABLE : Nullability.NOT_NULL, false);
        }
        if (owner instanceof PsiParameter && !(superParameters = AnnotationUtil.getSuperAnnotationOwners((PsiParameter)owner)).isEmpty()) {
            for (PsiParameter parameter : superParameters) {
                PsiAnnotation plain = NullableNotNullManager.findPlainAnnotation(parameter, false, annotationNames);
                if (plain != null) {
                    return null;
                }
                NullabilityAnnotationInfo defaultInfo = this.findNullityDefaultInHierarchy(parameter);
                if (defaultInfo == null) continue;
                return defaultInfo.getNullability() == Nullability.NOT_NULL ? defaultInfo : null;
            }
            return null;
        }
        NullabilityAnnotationInfo defaultInfo = this.findNullityDefaultInHierarchy(owner);
        if (!(defaultInfo == null || defaultInfo.getNullability() != Nullability.NULLABLE && this.hasHardcodedContracts(owner))) {
            return defaultInfo;
        }
        return null;
    }

    private PsiAnnotation takeAnnotationFromSuperParameters(@NotNull PsiParameter owner, @NotNull List<PsiParameter> superOwners) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(18);
        }
        if (superOwners == null) {
            NullableNotNullManager.$$$reportNull$$$0(19);
        }
        return RecursionManager.doPreventingRecursion(owner, true, () -> {
            for (PsiParameter superOwner : superOwners) {
                PsiAnnotation anno = this.findNullityAnnotationWithDefault(superOwner, false, false);
                if (anno == null) continue;
                return anno;
            }
            return null;
        });
    }

    private PsiAnnotation findPlainNullityAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(20);
        }
        HashSet<String> qNames = ContainerUtil.newHashSet(this.getNullablesWithNickNames());
        qNames.addAll(this.getNotNullsWithNickNames());
        return NullableNotNullManager.findPlainAnnotation(owner, checkBases, qNames);
    }

    @Nullable
    private static PsiAnnotation findPlainAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases, @NotNull Set<String> qualifiedNames) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(21);
        }
        if (qualifiedNames == null) {
            NullableNotNullManager.$$$reportNull$$$0(22);
        }
        PsiAnnotation memberAnno = checkBases && owner instanceof PsiMethod ? AnnotationUtil.findAnnotationInHierarchy(owner, qualifiedNames) : AnnotationUtil.findAnnotation(owner, qualifiedNames);
        PsiType type2 = NullableNotNullManager.getOwnerType(owner);
        if (memberAnno != null) {
            return NullableNotNullManager.preferTypeAnnotation(memberAnno, type2);
        }
        if (type2 != null) {
            return ContainerUtil.find(type2.getAnnotations(), a -> qualifiedNames.contains(a.getQualifiedName()));
        }
        return null;
    }

    @NotNull
    private static PsiAnnotation preferTypeAnnotation(@NotNull PsiAnnotation memberAnno, @Nullable PsiType type2) {
        if (memberAnno == null) {
            NullableNotNullManager.$$$reportNull$$$0(23);
        }
        if (type2 != null) {
            for (PsiAnnotation typeAnno : type2.getApplicableAnnotations()) {
                if (!NullableNotNullManager.areDifferentNullityAnnotations(memberAnno, typeAnno)) continue;
                PsiAnnotation psiAnnotation = typeAnno;
                if (psiAnnotation == null) {
                    NullableNotNullManager.$$$reportNull$$$0(24);
                }
                return psiAnnotation;
            }
        }
        PsiAnnotation psiAnnotation = memberAnno;
        if (psiAnnotation == null) {
            NullableNotNullManager.$$$reportNull$$$0(25);
        }
        return psiAnnotation;
    }

    private static boolean areDifferentNullityAnnotations(@NotNull PsiAnnotation memberAnno, @NotNull PsiAnnotation typeAnno) {
        if (memberAnno == null) {
            NullableNotNullManager.$$$reportNull$$$0(26);
        }
        if (typeAnno == null) {
            NullableNotNullManager.$$$reportNull$$$0(27);
        }
        return NullableNotNullManager.isNullableAnnotation(typeAnno) && NullableNotNullManager.isNotNullAnnotation(memberAnno) || NullableNotNullManager.isNullableAnnotation(memberAnno) && NullableNotNullManager.isNotNullAnnotation(typeAnno);
    }

    @NotNull
    protected List<String> getNullablesWithNickNames() {
        List<String> list2 = this.getNullables();
        if (list2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(28);
        }
        return list2;
    }

    @NotNull
    protected List<String> getNotNullsWithNickNames() {
        List<String> list2 = this.getNotNulls();
        if (list2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(29);
        }
        return list2;
    }

    protected boolean hasHardcodedContracts(@NotNull PsiElement element) {
        if (element == null) {
            NullableNotNullManager.$$$reportNull$$$0(30);
        }
        return false;
    }

    @Nullable
    private static PsiType getOwnerType(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(31);
        }
        if (owner instanceof PsiVariable) {
            return ((PsiVariable)owner).getType();
        }
        if (owner instanceof PsiMethod) {
            return ((PsiMethod)owner).getReturnType();
        }
        return null;
    }

    public boolean isNullable(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(32);
        }
        return this.findNullityAnnotationWithDefault(owner, checkBases, true) != null;
    }

    public boolean isNotNull(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(33);
        }
        return this.findNullityAnnotationWithDefault(owner, checkBases, false) != null;
    }

    @Nullable
    NullabilityAnnotationInfo findNullityDefaultInHierarchy(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(34);
        }
        PsiAnnotation.TargetType[] placeTargetTypes = AnnotationTargetUtil.getTargetsForLocation(owner.getModifierList());
        for (PsiElement element = owner.getParent(); element != null; element = element.getContext()) {
            NullabilityAnnotationInfo result2;
            if (element instanceof PsiModifierListOwner && (result2 = this.getNullityDefault((PsiModifierListOwner)element, placeTargetTypes, false)) != null) {
                return result2;
            }
            if (!(element instanceof PsiClassOwner)) continue;
            String packageName = ((PsiClassOwner)element).getPackageName();
            return this.findNullityDefaultOnPackage(placeTargetTypes, JavaPsiFacade.getInstance(element.getProject()).findPackage(packageName));
        }
        return null;
    }

    @Nullable
    private NullabilityAnnotationInfo findNullityDefaultOnPackage(@NotNull PsiAnnotation.TargetType[] placeTargetTypes, @Nullable PsiPackage psiPackage) {
        if (placeTargetTypes == null) {
            NullableNotNullManager.$$$reportNull$$$0(35);
        }
        boolean superPackage = false;
        while (psiPackage != null) {
            NullabilityAnnotationInfo onPkg = this.getNullityDefault(psiPackage, placeTargetTypes, superPackage);
            if (onPkg != null) {
                return onPkg;
            }
            superPackage = true;
            psiPackage = psiPackage.getParentPackage();
        }
        return null;
    }

    @Nullable
    private NullabilityAnnotationInfo getNullityDefault(@NotNull PsiModifierListOwner container, @NotNull PsiAnnotation.TargetType[] placeTargetTypes, boolean superPackage) {
        PsiModifierList modifierList2;
        if (container == null) {
            NullableNotNullManager.$$$reportNull$$$0(36);
        }
        if (placeTargetTypes == null) {
            NullableNotNullManager.$$$reportNull$$$0(37);
        }
        if ((modifierList2 = container.getModifierList()) == null) {
            return null;
        }
        for (PsiAnnotation annotation2 : modifierList2.getAnnotations()) {
            NullabilityAnnotationInfo result2 = this.checkNullityDefault(annotation2, placeTargetTypes, superPackage);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    private NullabilityAnnotationInfo checkNullityDefault(@NotNull PsiAnnotation annotation2, @NotNull PsiAnnotation.TargetType[] placeTargetTypes, boolean superPackage) {
        if (annotation2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(38);
        }
        if (placeTargetTypes == null) {
            NullableNotNullManager.$$$reportNull$$$0(39);
        }
        NullabilityAnnotationInfo jsr = superPackage ? null : this.isJsr305Default(annotation2, placeTargetTypes);
        return jsr != null ? jsr : CheckerFrameworkNullityUtil.isCheckerDefault(annotation2, placeTargetTypes);
    }

    @Nullable
    protected abstract NullabilityAnnotationInfo isJsr305Default(@NotNull PsiAnnotation var1, @NotNull PsiAnnotation.TargetType[] var2);

    @NotNull
    public abstract List<String> getNullables();

    @NotNull
    public abstract List<String> getNotNulls();

    public static boolean isNullable(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(40);
        }
        return NullableNotNullManager.getNullability(owner) == Nullability.NULLABLE;
    }

    public static boolean isNotNull(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(41);
        }
        return NullableNotNullManager.getNullability(owner) == Nullability.NOT_NULL;
    }

    @NotNull
    public static Nullability getNullability(@NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo info2;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(42);
        }
        Nullability nullability = (info2 = NullableNotNullManager.getInstance(owner.getProject()).findEffectiveNullabilityInfo(owner)) == null ? Nullability.UNKNOWN : info2.getNullability();
        if (nullability == null) {
            NullableNotNullManager.$$$reportNull$$$0(43);
        }
        return nullability;
    }

    @NotNull
    public abstract List<String> getInstrumentedNotNulls();

    public abstract void setInstrumentedNotNulls(@NotNull List<String> var1);

    public static boolean isNullableAnnotation(@NotNull PsiAnnotation annotation2) {
        if (annotation2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(44);
        }
        return NullableNotNullManager.getInstance(annotation2.getProject()).getNullablesWithNickNames().contains(annotation2.getQualifiedName());
    }

    public static boolean isNotNullAnnotation(@NotNull PsiAnnotation annotation2) {
        if (annotation2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(45);
        }
        return NullableNotNullManager.getInstance(annotation2.getProject()).getNotNullsWithNickNames().contains(annotation2.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 43: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 43: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generated";
                break;
            }
            case 9: 
            case 13: 
            case 38: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superOwners";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedNames";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberAnno";
                break;
            }
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/codeInsight/NullableNotNullManager";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAnno";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeTargetTypes";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/codeInsight/NullableNotNullManager";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "preferTypeAnnotation";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullablesWithNickNames";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullsWithNickNames";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasNullability";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNullableAnnotation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNotNullAnnotation";
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyNotNullAnnotation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyNullableAnnotation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyNullableOrNotNullAnnotation";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyAnnotation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findNullityAnnotationWithDefault";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findOwnNullabilityInfo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findEffectiveNullabilityInfo";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "doFindEffectiveNullabilityAnnotation";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "takeAnnotationFromSuperParameters";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findPlainNullityAnnotation";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findPlainAnnotation";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "preferTypeAnnotation";
                break;
            }
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 43: {
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "areDifferentNullityAnnotations";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "hasHardcodedContracts";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getOwnerType";
                break;
            }
            case 32: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isNullable";
                break;
            }
            case 33: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isNotNull";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findNullityDefaultInHierarchy";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findNullityDefaultOnPackage";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getNullityDefault";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkNullityDefault";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getNullability";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isNullableAnnotation";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isNotNullAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 43: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

