/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import org.gradle.internal.Cast;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.ProvidesWorkResult;
import org.gradle.workers.internal.WorkerProtocol;

public class DefaultWorkerServer
implements WorkerProtocol {
    private final ServiceRegistry workServices;
    private final InstantiatorFactory instantiatorFactory;

    public DefaultWorkerServer(ServiceRegistry workServices, InstantiatorFactory instantiatorFactory) {
        this.workServices = workServices;
        this.instantiatorFactory = instantiatorFactory;
    }

    @Override
    public DefaultWorkResult execute(ActionExecutionSpec spec) {
        try {
            Class implementationClass = (Class)Cast.uncheckedCast(spec.getImplementationClass());
            DefaultServiceRegistry serviceRegistry = new DefaultServiceRegistry(new ServiceRegistry[]{this.workServices});
            InstanceGenerator instantiator = this.instantiatorFactory.inject((ServiceLookup)serviceRegistry);
            if (spec.getParameters() != null) {
                serviceRegistry.add(spec.getParameters().getClass(), (Object)((WorkParameters)Cast.uncheckedCast(spec.getParameters())));
            }
            serviceRegistry.add(Instantiator.class, (Object)instantiator);
            WorkAction execution = (WorkAction)instantiator.newInstance(implementationClass, new Object[0]);
            execution.execute();
            if (execution instanceof ProvidesWorkResult) {
                return ((ProvidesWorkResult)((Object)execution)).getWorkResult();
            }
            return DefaultWorkResult.SUCCESS;
        }
        catch (Throwable t) {
            return new DefaultWorkResult(true, t);
        }
    }

    public String toString() {
        return "DefaultWorkerServer{}";
    }
}

