/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.composite.internal.IncludedBuildTaskResource;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.Actions;
import org.gradle.internal.build.BuildState;

public class TaskNodeFactory {
    private final Map<Task, TaskNode> nodes = new HashMap<Task, TaskNode>();
    private final IncludedBuildTaskGraph taskGraph;
    private final GradleInternal thisBuild;
    private final BuildIdentifier currentBuildId;
    private final Map<File, String> canonicalizedFileCache = Maps.newIdentityHashMap();

    public TaskNodeFactory(GradleInternal thisBuild, IncludedBuildTaskGraph taskGraph) {
        this.thisBuild = thisBuild;
        this.currentBuildId = ((BuildState)thisBuild.getServices().get(BuildState.class)).getBuildIdentifier();
        this.taskGraph = taskGraph;
    }

    public Set<Task> getTasks() {
        return this.nodes.keySet();
    }

    public TaskNode getOrCreateNode(Task task) {
        TaskNode node = this.nodes.get(task);
        if (node == null) {
            node = task.getProject().getGradle() == this.thisBuild ? new LocalTaskNode((TaskInternal)task, this.canonicalizedFileCache) : new TaskInAnotherBuild((TaskInternal)task, this.currentBuildId, this.taskGraph);
            this.nodes.put(task, node);
        }
        return node;
    }

    public void clear() {
        this.nodes.clear();
    }

    private static class TaskInAnotherBuild
    extends TaskNode {
        private final BuildIdentifier thisBuild;
        private final IncludedBuildTaskGraph taskGraph;
        private final BuildIdentifier targetBuild;
        private final TaskInternal task;
        private IncludedBuildTaskResource.State state = IncludedBuildTaskResource.State.WAITING;

        TaskInAnotherBuild(TaskInternal task, BuildIdentifier thisBuild, IncludedBuildTaskGraph taskGraph) {
            this.thisBuild = thisBuild;
            this.task = task;
            this.taskGraph = taskGraph;
            this.targetBuild = ((BuildState)((ProjectInternal)task.getProject()).getServices().get(BuildState.class)).getBuildIdentifier();
            this.doNotRequire();
        }

        @Override
        public TaskInternal getTask() {
            return this.task;
        }

        @Override
        @Nullable
        public Project getProjectToLock() {
            return null;
        }

        @Override
        @Nullable
        public Project getOwningProject() {
            return null;
        }

        @Override
        public Throwable getNodeFailure() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void rethrowNodeFailure() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void appendPostAction(Action<? super Task> action) {
        }

        @Override
        public Action<? super Task> getPostAction() {
            return Actions.doNothing();
        }

        @Override
        public void prepareForExecution() {
            this.taskGraph.addTask(this.thisBuild, this.targetBuild, this.task.getPath());
        }

        @Override
        public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<Node> processHardSuccessor) {
        }

        @Override
        public boolean requiresMonitoring() {
            return true;
        }

        @Override
        public void require() {
        }

        @Override
        public boolean isSuccessful() {
            return this.state == IncludedBuildTaskResource.State.SUCCESS;
        }

        @Override
        public boolean isFailed() {
            return this.state == IncludedBuildTaskResource.State.FAILED;
        }

        @Override
        public boolean isComplete() {
            if (this.state != IncludedBuildTaskResource.State.WAITING) {
                return true;
            }
            this.state = this.taskGraph.getTaskState(this.targetBuild, this.task.getPath());
            return this.state != IncludedBuildTaskResource.State.WAITING;
        }

        @Override
        public int compareTo(Node other) {
            if (this.getClass() != other.getClass()) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            TaskInAnotherBuild taskNode = (TaskInAnotherBuild)other;
            return this.task.getIdentityPath().compareTo(taskNode.task.getIdentityPath());
        }

        @Override
        public void resolveMutations() {
        }

        @Override
        public String toString() {
            return this.task.getIdentityPath().toString();
        }
    }
}

