/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementVisitorVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.descriptors.DescriptorUtilsKt;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedClassConstructorDescriptor;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedFieldDescriptor;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedSimpleFunctionDescriptor;
import org.jetbrains.kotlin.backend.common.descriptors.WrappedValueParameterDescriptor;
import org.jetbrains.kotlin.backend.common.ir.IrUtilsKt;
import org.jetbrains.kotlin.backend.common.ir.SetDeclarationsParentVisitor;
import org.jetbrains.kotlin.backend.common.lower.BOUND_RECEIVER_PARAMETER;
import org.jetbrains.kotlin.backend.common.lower.BOUND_VALUE_PARAMETER;
import org.jetbrains.kotlin.backend.common.lower.Closure;
import org.jetbrains.kotlin.backend.common.lower.ClosureAnnotator;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLoweringKt;
import org.jetbrains.kotlin.backend.common.lower.LocalNameProvider;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrReturnTarget;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrConstructorImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFieldImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrValueParameterImpl;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrConstructorSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\t\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001bB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "localNameProvider", "Lorg/jetbrains/kotlin/backend/common/lower/LocalNameProvider;", "loweredConstructorVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;Lorg/jetbrains/kotlin/backend/common/lower/LocalNameProvider;Lorg/jetbrains/kotlin/descriptors/Visibility;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "getLocalNameProvider", "()Lorg/jetbrains/kotlin/backend/common/lower/LocalNameProvider;", "getLoweredConstructorVisibility", "()Lorg/jetbrains/kotlin/descriptors/Visibility;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "DECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE", "LocalClassConstructorContext", "LocalClassContext", "LocalClassMemberContext", "LocalContext", "LocalContextWithClosureAsParameters", "LocalDeclarationsTransformer", "LocalFunctionContext", "STATEMENT_ORIGIN_INITIALIZER_OF_FIELD_FOR_CAPTURED_VALUE", "ir.backend.common"})
public final class LocalDeclarationsLowering
implements FileLoweringPass {
    @NotNull
    private final BackendContext context;
    @NotNull
    private final LocalNameProvider localNameProvider;
    @NotNull
    private final Visibility loweredConstructorVisibility;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        new LocalDeclarationsTransformer(irFile).lowerLocalDeclarations();
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final LocalNameProvider getLocalNameProvider() {
        return this.localNameProvider;
    }

    @NotNull
    public final Visibility getLoweredConstructorVisibility() {
        return this.loweredConstructorVisibility;
    }

    public LocalDeclarationsLowering(@NotNull BackendContext context2, @NotNull LocalNameProvider localNameProvider, @NotNull Visibility loweredConstructorVisibility) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)localNameProvider, (String)"localNameProvider");
        Intrinsics.checkParameterIsNotNull((Object)loweredConstructorVisibility, (String)"loweredConstructorVisibility");
        this.context = context2;
        this.localNameProvider = localNameProvider;
        this.loweredConstructorVisibility = loweredConstructorVisibility;
    }

    public /* synthetic */ LocalDeclarationsLowering(BackendContext backendContext, LocalNameProvider localNameProvider, Visibility visibility, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            localNameProvider = LocalNameProvider.Companion.getDEFAULT();
        }
        if ((n & 4) != 0) {
            Visibility visibility2 = Visibilities.PRIVATE;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility2, (String)"Visibilities.PRIVATE");
            visibility = visibility2;
        }
        this(backendContext, localNameProvider, visibility);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$DECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "ir.backend.common"})
    public static final class DECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE
    extends IrDeclarationOriginImpl {
        public static final DECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE INSTANCE;

        private DECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE() {
            super("FIELD_FOR_CAPTURED_VALUE", true);
        }

        static {
            DECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE dECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE;
            INSTANCE = dECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE = new DECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$STATEMENT_ORIGIN_INITIALIZER_OF_FIELD_FOR_CAPTURED_VALUE;", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "()V", "ir.backend.common"})
    private static final class STATEMENT_ORIGIN_INITIALIZER_OF_FIELD_FOR_CAPTURED_VALUE
    extends IrStatementOriginImpl {
        public static final STATEMENT_ORIGIN_INITIALIZER_OF_FIELD_FOR_CAPTURED_VALUE INSTANCE;

        private STATEMENT_ORIGIN_INITIALIZER_OF_FIELD_FOR_CAPTURED_VALUE() {
            super("INITIALIZER_OF_FIELD_FOR_CAPTURED_VALUE");
        }

        static {
            STATEMENT_ORIGIN_INITIALIZER_OF_FIELD_FOR_CAPTURED_VALUE sTATEMENT_ORIGIN_INITIALIZER_OF_FIELD_FOR_CAPTURED_VALUE;
            INSTANCE = sTATEMENT_ORIGIN_INITIALIZER_OF_FIELD_FOR_CAPTURED_VALUE = new STATEMENT_ORIGIN_INITIALIZER_OF_FIELD_FOR_CAPTURED_VALUE();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "", "()V", "irGet", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "valueDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "ir.backend.common"})
    private static abstract class LocalContext {
        @Nullable
        public abstract IrExpression irGet(int var1, int var2, @NotNull IrValueDeclaration var3);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0005H\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContextWithClosureAsParameters;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "()V", "capturedValueToParameter", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "getCapturedValueToParameter", "()Ljava/util/Map;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "transformedDeclaration", "getTransformedDeclaration", "irGet", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "valueDeclaration", "ir.backend.common"})
    private static abstract class LocalContextWithClosureAsParameters
    extends LocalContext {
        @NotNull
        private final Map<IrValueDeclaration, IrValueParameter> capturedValueToParameter = new HashMap();

        @NotNull
        public abstract IrFunction getDeclaration();

        @NotNull
        public abstract IrFunction getTransformedDeclaration();

        @NotNull
        public final Map<IrValueDeclaration, IrValueParameter> getCapturedValueToParameter() {
            return this.capturedValueToParameter;
        }

        @Override
        @Nullable
        public IrExpression irGet(int startOffset, int endOffset, @NotNull IrValueDeclaration valueDeclaration) {
            Intrinsics.checkParameterIsNotNull((Object)valueDeclaration, (String)"valueDeclaration");
            IrValueParameter irValueParameter = this.capturedValueToParameter.get(valueDeclaration);
            if (irValueParameter == null) {
                return null;
            }
            IrValueParameter parameter = irValueParameter;
            return new IrGetValueImpl(startOffset, endOffset, parameter.getType(), (IrValueSymbol)parameter.getSymbol(), null, 16, null);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0003X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0010\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalFunctionContext;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContextWithClosureAsParameters;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "index", "", "ownerForLoweredDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;ILorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;)V", "closure", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "getClosure", "()Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "setClosure", "(Lorg/jetbrains/kotlin/backend/common/lower/Closure;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getIndex", "()I", "getOwnerForLoweredDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationContainer;", "transformedDeclaration", "getTransformedDeclaration", "setTransformedDeclaration", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)V", "ir.backend.common"})
    private static final class LocalFunctionContext
    extends LocalContextWithClosureAsParameters {
        @NotNull
        public Closure closure;
        @NotNull
        public IrSimpleFunction transformedDeclaration;
        @NotNull
        private final IrSimpleFunction declaration;
        private final int index;
        @NotNull
        private final IrDeclarationContainer ownerForLoweredDeclaration;

        @NotNull
        public final Closure getClosure() {
            Closure closure = this.closure;
            if (closure == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"closure");
            }
            return closure;
        }

        public final void setClosure(@NotNull Closure closure) {
            Intrinsics.checkParameterIsNotNull((Object)closure, (String)"<set-?>");
            this.closure = closure;
        }

        @Override
        @NotNull
        public IrSimpleFunction getTransformedDeclaration() {
            IrSimpleFunction irSimpleFunction = this.transformedDeclaration;
            if (irSimpleFunction == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"transformedDeclaration");
            }
            return irSimpleFunction;
        }

        public void setTransformedDeclaration(@NotNull IrSimpleFunction irSimpleFunction) {
            Intrinsics.checkParameterIsNotNull((Object)irSimpleFunction, (String)"<set-?>");
            this.transformedDeclaration = irSimpleFunction;
        }

        @Override
        @NotNull
        public IrSimpleFunction getDeclaration() {
            return this.declaration;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final IrDeclarationContainer getOwnerForLoweredDeclaration() {
            return this.ownerForLoweredDeclaration;
        }

        public LocalFunctionContext(@NotNull IrSimpleFunction declaration2, int index2, @NotNull IrDeclarationContainer ownerForLoweredDeclaration) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)ownerForLoweredDeclaration, (String)"ownerForLoweredDeclaration");
            this.declaration = declaration2;
            this.index = index2;
            this.ownerForLoweredDeclaration = ownerForLoweredDeclaration;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\u0003X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0006\"\u0004\b\t\u0010\u0004\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassConstructorContext;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContextWithClosureAsParameters;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "(Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "transformedDeclaration", "getTransformedDeclaration", "setTransformedDeclaration", "ir.backend.common"})
    private static final class LocalClassConstructorContext
    extends LocalContextWithClosureAsParameters {
        @NotNull
        public IrConstructor transformedDeclaration;
        @NotNull
        private final IrConstructor declaration;

        @Override
        @NotNull
        public IrConstructor getTransformedDeclaration() {
            IrConstructor irConstructor = this.transformedDeclaration;
            if (irConstructor == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"transformedDeclaration");
            }
            return irConstructor;
        }

        public void setTransformedDeclaration(@NotNull IrConstructor irConstructor) {
            Intrinsics.checkParameterIsNotNull((Object)irConstructor, (String)"<set-?>");
            this.transformedDeclaration = irConstructor;
        }

        @Override
        @NotNull
        public IrConstructor getDeclaration() {
            return this.declaration;
        }

        public LocalClassConstructorContext(@NotNull IrConstructor declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            this.declaration = declaration2;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0007H\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "capturedValueToField", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getCapturedValueToField", "()Ljava/util/Map;", "closure", "Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "getClosure", "()Lorg/jetbrains/kotlin/backend/common/lower/Closure;", "setClosure", "(Lorg/jetbrains/kotlin/backend/common/lower/Closure;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irGet", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "valueDeclaration", "ir.backend.common"})
    private static final class LocalClassContext
    extends LocalContext {
        @NotNull
        public Closure closure;
        @NotNull
        private final Map<IrValueDeclaration, IrField> capturedValueToField;
        @NotNull
        private final IrClass declaration;

        @NotNull
        public final Closure getClosure() {
            Closure closure = this.closure;
            if (closure == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"closure");
            }
            return closure;
        }

        public final void setClosure(@NotNull Closure closure) {
            Intrinsics.checkParameterIsNotNull((Object)closure, (String)"<set-?>");
            this.closure = closure;
        }

        @NotNull
        public final Map<IrValueDeclaration, IrField> getCapturedValueToField() {
            return this.capturedValueToField;
        }

        @Override
        @Nullable
        public IrExpression irGet(int startOffset, int endOffset, @NotNull IrValueDeclaration valueDeclaration) {
            Intrinsics.checkParameterIsNotNull((Object)valueDeclaration, (String)"valueDeclaration");
            IrField irField = this.capturedValueToField.get(valueDeclaration);
            if (irField == null) {
                return null;
            }
            IrField field = irField;
            IrValueParameter irValueParameter = this.declaration.getThisReceiver();
            if (irValueParameter == null) {
                Intrinsics.throwNpe();
            }
            IrValueParameter receiver = irValueParameter;
            return new IrGetFieldImpl(startOffset, endOffset, (IrFieldSymbol)field.getSymbol(), field.getType(), new IrGetValueImpl(startOffset, endOffset, receiver.getType(), (IrValueSymbol)receiver.getSymbol(), null, 16, null), null, null, 96, null);
        }

        @NotNull
        public final IrClass getDeclaration() {
            return this.declaration;
        }

        public LocalClassContext(@NotNull IrClass declaration2) {
            Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
            this.declaration = declaration2;
            this.capturedValueToField = new HashMap();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassMemberContext;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "member", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "classContext", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext;)V", "getClassContext", "()Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext;", "getMember", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "irGet", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "startOffset", "", "endOffset", "valueDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "ir.backend.common"})
    private static final class LocalClassMemberContext
    extends LocalContext {
        @NotNull
        private final IrFunction member;
        @NotNull
        private final LocalClassContext classContext;

        @Override
        @Nullable
        public IrExpression irGet(int startOffset, int endOffset, @NotNull IrValueDeclaration valueDeclaration) {
            Intrinsics.checkParameterIsNotNull((Object)valueDeclaration, (String)"valueDeclaration");
            IrField irField = this.classContext.getCapturedValueToField().get(valueDeclaration);
            if (irField == null) {
                return null;
            }
            IrField field = irField;
            IrValueParameter irValueParameter = this.member.getDispatchReceiverParameter();
            if (irValueParameter == null) {
                Intrinsics.throwNpe();
            }
            IrValueParameter receiver = irValueParameter;
            return new IrGetFieldImpl(startOffset, endOffset, (IrFieldSymbol)field.getSymbol(), field.getType(), new IrGetValueImpl(startOffset, endOffset, receiver.getType(), (IrValueSymbol)receiver.getSymbol(), null, 16, null), null, null, 96, null);
        }

        @NotNull
        public final IrFunction getMember() {
            return this.member;
        }

        @NotNull
        public final LocalClassContext getClassContext() {
            return this.classContext;
        }

        public LocalClassMemberContext(@NotNull IrFunction member, @NotNull LocalClassContext classContext) {
            Intrinsics.checkParameterIsNotNull((Object)member, (String)"member");
            Intrinsics.checkParameterIsNotNull((Object)classContext, (String)"classContext");
            this.member = member;
            this.classContext = classContext;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0002J8\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020%2\u0006\u00104\u001a\u00020\u000fH\u0002J\u0010\u00105\u001a\u00020%2\u0006\u00106\u001a\u00020\u0013H\u0002J\u0018\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u0012H\u0002J\u0018\u00107\u001a\u00020<2\u0006\u00109\u001a\u00020=2\u0006\u0010;\u001a\u00020\tH\u0002J\u0010\u0010>\u001a\u00020%2\u0006\u0010?\u001a\u00020\nH\u0002J,\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00160A2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00170C2\u0006\u0010D\u001a\u00020\u00122\u0006\u0010E\u001a\u00020\u0012H\u0002J\u0018\u0010F\u001a\u00020-2\u0006\u0010G\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020IH\u0002J\b\u0010J\u001a\u00020%H\u0002J\u0006\u0010K\u001a\u00020%J\u0018\u0010L\u001a\u00020%2\u0006\u0010M\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\u000fH\u0002J\b\u0010N\u001a\u00020%H\u0002J\u001a\u0010O\u001a\u00020%2\u0006\u0010P\u001a\u00020Q2\b\u0010R\u001a\u0004\u0018\u00010SH\u0002J\u0010\u0010T\u001a\u00020U2\u0006\u0010G\u001a\u00020VH\u0002J\u0010\u0010W\u001a\u00020-2\u0006\u0010G\u001a\u00020XH\u0002J\b\u0010Y\u001a\u00020%H\u0002J9\u0010Z\u001a\u00020%\"\u0004\b\u0000\u0010[\"\u0004\b\u0001\u0010\\*\u000e\u0012\u0004\u0012\u0002H[\u0012\u0004\u0012\u0002H\\0\b2\u0006\u0010]\u001a\u0002H[2\u0006\u0010^\u001a\u0002H\\H\u0002\u00a2\u0006\u0002\u0010_J\u0014\u0010`\u001a\u00020%*\u00020\u00122\u0006\u0010R\u001a\u00020aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\fR\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\fR\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR\u001d\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\fR\u001d\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\fR\u0017\u0010!\u001a\u0004\u0018\u00010\u0012*\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006c"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer;", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "getIrFile", "()Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "localClassConstructors", "", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassConstructorContext;", "getLocalClassConstructors", "()Ljava/util/Map;", "localClasses", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalClassContext;", "getLocalClasses", "localFunctions", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalFunctionContext;", "getLocalFunctions", "newParameterToCaptured", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "getNewParameterToCaptured", "newParameterToOld", "getNewParameterToOld", "oldParameterToNew", "getOldParameterToNew", "transformedDeclarations", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "getTransformedDeclarations", "transformed", "getTransformed", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "collectClosureForLocalDeclarations", "", "collectLocalDeclarations", "createFieldForCapturedValue", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "startOffset", "", "endOffset", "name", "Lorg/jetbrains/kotlin/name/Name;", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "parent", "fieldType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "createFieldsForCapturedValues", "localClassContext", "createLiftedDeclaration", "localFunctionContext", "createNewCall", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCallImpl;", "oldCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "newCallee", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstructorCallImpl;", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "createTransformedConstructorDeclaration", "constructorContext", "createTransformedValueParameters", "Ljava/util/ArrayList;", "capturedValues", "", "oldDeclaration", "newDeclaration", "generateNameForLiftedDeclaration", "declaration", "newOwner", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "insertLoweredDeclarationForLocalFunctions", "lowerLocalDeclarations", "rewriteClassMembers", "irClass", "rewriteDeclarations", "rewriteFunctionBody", "irDeclaration", "Lorg/jetbrains/kotlin/ir/IrElement;", "localContext", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "suggestLocalName", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "suggestNameForCapturedValue", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "transformDeclarations", "putAbsentOrSame", "K", "V", "key", "value", "(Ljava/util/Map;Ljava/lang/Object;Ljava/lang/Object;)V", "recordTransformedValueParameters", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContextWithClosureAsParameters;", "FunctionBodiesRewriter", "ir.backend.common"})
    private final class LocalDeclarationsTransformer {
        @NotNull
        private final Map<IrFunction, LocalFunctionContext> localFunctions;
        @NotNull
        private final Map<IrClass, LocalClassContext> localClasses;
        @NotNull
        private final Map<IrConstructor, LocalClassConstructorContext> localClassConstructors;
        @NotNull
        private final Map<IrSymbolOwner, IrDeclaration> transformedDeclarations;
        @NotNull
        private final Map<IrValueParameter, IrValueParameter> newParameterToOld;
        @NotNull
        private final Map<IrValueParameter, IrValueParameter> oldParameterToNew;
        @NotNull
        private final Map<IrValueParameter, IrValueSymbol> newParameterToCaptured;
        @NotNull
        private final IrFile irFile;

        @NotNull
        public final Map<IrFunction, LocalFunctionContext> getLocalFunctions() {
            return this.localFunctions;
        }

        @NotNull
        public final Map<IrClass, LocalClassContext> getLocalClasses() {
            return this.localClasses;
        }

        @NotNull
        public final Map<IrConstructor, LocalClassConstructorContext> getLocalClassConstructors() {
            return this.localClassConstructors;
        }

        @NotNull
        public final Map<IrSymbolOwner, IrDeclaration> getTransformedDeclarations() {
            return this.transformedDeclarations;
        }

        @Nullable
        public final IrFunction getTransformed(@NotNull IrFunction $this$transformed) {
            Intrinsics.checkParameterIsNotNull((Object)$this$transformed, (String)"$this$transformed");
            return (IrFunction)this.transformedDeclarations.get($this$transformed);
        }

        @NotNull
        public final Map<IrValueParameter, IrValueParameter> getNewParameterToOld() {
            return this.newParameterToOld;
        }

        @NotNull
        public final Map<IrValueParameter, IrValueParameter> getOldParameterToNew() {
            return this.oldParameterToNew;
        }

        @NotNull
        public final Map<IrValueParameter, IrValueSymbol> getNewParameterToCaptured() {
            return this.newParameterToCaptured;
        }

        public final void lowerLocalDeclarations() {
            this.collectLocalDeclarations();
            if (this.localFunctions.isEmpty() && this.localClasses.isEmpty()) {
                return;
            }
            this.collectClosureForLocalDeclarations();
            this.transformDeclarations();
            this.rewriteDeclarations();
            this.insertLoweredDeclarationForLocalFunctions();
        }

        /*
         * WARNING - void declaration
         */
        private final void insertLoweredDeclarationForLocalFunctions() {
            Iterable $this$forEach$iv = this.localFunctions.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$filterTo$iv$iv;
                LocalFunctionContext it = (LocalFunctionContext)element$iv;
                boolean bl = false;
                IrSimpleFunction irSimpleFunction = it.getTransformedDeclaration();
                boolean bl2 = false;
                boolean bl3 = false;
                IrSimpleFunction $this$apply = irSimpleFunction;
                boolean bl4 = false;
                IrSimpleFunction original = it.getDeclaration();
                $this$apply.setBody(original.getBody());
                Iterable $this$filter$iv = original.getValueParameters();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    IrValueParameter v = (IrValueParameter)element$iv$iv;
                    boolean bl5 = false;
                    if (!(v.getDefaultValue() != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv2 = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    IrExpressionBody body;
                    IrValueParameter argument = (IrValueParameter)element$iv2;
                    boolean bl6 = false;
                    if (argument.getDefaultValue() == null) {
                        Intrinsics.throwNpe();
                    }
                    IrValueParameter irValueParameter = this.oldParameterToNew.get(argument);
                    if (irValueParameter == null) {
                        Intrinsics.throwNpe();
                    }
                    irValueParameter.setDefaultValue(body);
                }
                $this$apply.acceptChildren(SetDeclarationsParentVisitor.INSTANCE, $this$apply);
                IrUtilsKt.addChild(it.getOwnerForLoweredDeclaration(), it.getTransformedDeclaration());
            }
        }

        private final void rewriteFunctionBody(IrElement irDeclaration, LocalContext localContext) {
            IrElementTransformerVoidKt.transformChildrenVoid(irDeclaration, new FunctionBodiesRewriter(localContext));
        }

        /*
         * WARNING - void declaration
         */
        private final void rewriteClassMembers(IrClass irClass, LocalClassContext localClassContext) {
            void $this$filterIsInstanceTo$iv$iv2;
            Iterable $this$filterIsInstance$iv = irClass.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof IrConstructor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List constructors2 = (List)destination$iv$iv;
            IrElementTransformerVoidKt.transformChildrenVoid(irClass, new FunctionBodiesRewriter(localClassContext));
            List constructorsCallingSuper2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)constructors2), (Function1)((Function1)new Function1<IrConstructor, LocalClassConstructorContext>(this){
                final /* synthetic */ LocalDeclarationsTransformer this$0;

                @NotNull
                public final LocalClassConstructorContext invoke(@NotNull IrConstructor it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    LocalClassConstructorContext localClassConstructorContext = this.this$0.getLocalClassConstructors().get(it);
                    if (localClassConstructorContext == null) {
                        Intrinsics.throwNpe();
                    }
                    return localClassConstructorContext;
                }
                {
                    this.this$0 = localDeclarationsTransformer;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<LocalClassConstructorContext, Boolean>(this){
                final /* synthetic */ LocalDeclarationsTransformer this$0;

                public final boolean invoke(@NotNull LocalClassConstructorContext it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return LowerUtilsKt.callsSuper(it.getDeclaration(), this.this$0.LocalDeclarationsLowering.this.getContext().getIrBuiltIns());
                }
                {
                    this.this$0 = localDeclarationsTransformer;
                    super(1);
                }
            })));
            $i$f$filterIsInstance = CollectionsKt.any((Iterable)constructorsCallingSuper2);
            boolean $this$filterIsInstanceTo$iv$iv2 = false;
            if (_Assertions.ENABLED && !$i$f$filterIsInstance) {
                boolean bl = false;
                String string = "Expected at least one constructor calling super; class: " + irClass;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Map<IrValueDeclaration, IrField> $this$forEach$iv = localClassContext.getCapturedValueToField();
            boolean $i$f$forEach = false;
            Map<IrValueDeclaration, IrField> map2 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Object> iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$capturedValue$field = element$iv = (Map.Entry)iterator2.next();
                boolean bl2 = false;
                Map.Entry entry = $dstr$capturedValue$field;
                boolean bl3 = false;
                IrValueDeclaration capturedValue = (IrValueDeclaration)entry.getKey();
                entry = $dstr$capturedValue$field;
                bl3 = false;
                IrField field = (IrField)entry.getValue();
                int startOffset = irClass.getStartOffset();
                int endOffset = irClass.getEndOffset();
                irClass.getDeclarations().add(field);
                for (LocalClassConstructorContext constructorContext : constructorsCallingSuper2) {
                    IrExpression capturedValueExpression;
                    IrBlockBody blockBody;
                    IrBody irBody = constructorContext.getDeclaration().getBody();
                    if (!(irBody instanceof IrBlockBody)) {
                        irBody = null;
                    }
                    if ((IrBlockBody)irBody == null) {
                        throw (Throwable)((Object)new AssertionError((Object)("Unexpected constructor body: " + constructorContext.getDeclaration().getBody())));
                    }
                    if (constructorContext.irGet(startOffset, endOffset, capturedValue) == null) {
                        Intrinsics.throwNpe();
                    }
                    List<IrStatement> list2 = blockBody.getStatements();
                    IrFieldSymbol irFieldSymbol = (IrFieldSymbol)field.getSymbol();
                    IrValueParameter irValueParameter = irClass.getThisReceiver();
                    if (irValueParameter == null) {
                        Intrinsics.throwNpe();
                    }
                    list2.add(0, new IrSetFieldImpl(startOffset, endOffset, irFieldSymbol, new IrGetValueImpl(startOffset, endOffset, (IrValueSymbol)irValueParameter.getSymbol(), null, 8, null), capturedValueExpression, LocalDeclarationsLowering.this.getContext().getIrBuiltIns().getUnitType(), STATEMENT_ORIGIN_INITIALIZER_OF_FIELD_FOR_CAPTURED_VALUE.INSTANCE, null, 128, null));
                }
            }
        }

        private final void rewriteDeclarations() {
            LocalContext it;
            Iterable $this$forEach$iv = this.localFunctions.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LocalFunctionContext)element$iv;
                boolean bl = false;
                this.rewriteFunctionBody(((LocalFunctionContext)it).getDeclaration(), it);
            }
            $this$forEach$iv = this.localClassConstructors.values();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LocalClassConstructorContext)element$iv;
                boolean bl = false;
                this.rewriteFunctionBody(((LocalClassConstructorContext)it).getDeclaration(), it);
            }
            $this$forEach$iv = this.localClasses.values();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LocalClassContext)element$iv;
                boolean bl = false;
                this.rewriteClassMembers(((LocalClassContext)it).getDeclaration(), (LocalClassContext)it);
            }
            this.rewriteFunctionBody(this.irFile, null);
        }

        private final IrCallImpl createNewCall(IrCall oldCall, IrFunction newCallee) {
            IrCallImpl irCallImpl = new IrCallImpl(oldCall.getStartOffset(), oldCall.getEndOffset(), newCallee.getReturnType(), newCallee.getSymbol(), newCallee.getDescriptor(), oldCall.getTypeArgumentsCount(), oldCall.getOrigin(), oldCall.getSuperQualifierSymbol());
            boolean bl = false;
            boolean bl2 = false;
            IrCallImpl it = irCallImpl;
            boolean bl3 = false;
            IrMemberAccessExpressionKt.copyTypeArgumentsFrom(it, oldCall);
            return irCallImpl;
        }

        private final IrConstructorCallImpl createNewCall(IrConstructorCall oldCall, IrConstructor newCallee) {
            IrConstructorCallImpl irConstructorCallImpl = IrConstructorCallImpl.Companion.fromSymbolOwner(oldCall.getStartOffset(), oldCall.getEndOffset(), newCallee.getReturnType(), (IrConstructorSymbol)newCallee.getSymbol(), oldCall.getOrigin());
            boolean bl = false;
            boolean bl2 = false;
            IrConstructorCallImpl it = irConstructorCallImpl;
            boolean bl3 = false;
            IrMemberAccessExpressionKt.copyTypeArgumentsFrom(it, oldCall);
            return irConstructorCallImpl;
        }

        private final void transformDeclarations() {
            LocalContext it;
            Iterable $this$forEach$iv = this.localFunctions.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LocalFunctionContext)element$iv;
                boolean bl = false;
                this.createLiftedDeclaration((LocalFunctionContext)it);
            }
            $this$forEach$iv = this.localClasses.values();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LocalClassContext)element$iv;
                boolean bl = false;
                this.createFieldsForCapturedValues((LocalClassContext)it);
            }
            $this$forEach$iv = this.localClassConstructors.values();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (LocalClassConstructorContext)element$iv;
                boolean bl = false;
                this.createTransformedConstructorDeclaration((LocalClassConstructorContext)it);
            }
        }

        private final String suggestLocalName(IrDeclarationWithName declaration2) {
            Object object = this.localFunctions;
            boolean bl = false;
            LocalFunctionContext localFunctionContext = object.get(declaration2);
            if (localFunctionContext != null) {
                object = localFunctionContext;
                bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                if (((LocalFunctionContext)it).getIndex() >= 0) {
                    return "lambda-" + ((LocalFunctionContext)it).getIndex();
                }
            }
            return LocalDeclarationsLowering.this.getLocalNameProvider().localName(declaration2);
        }

        private final Name generateNameForLiftedDeclaration(IrDeclaration declaration2, IrDeclarationParent newOwner) {
            Name name = Name.identifier(CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.takeWhile(LocalDeclarationsLoweringKt.getParentsWithSelf(declaration2), (Function1)((Function1)new Function1<IrDeclarationParent, Boolean>(newOwner){
                final /* synthetic */ IrDeclarationParent $newOwner;

                public final boolean invoke(@NotNull IrDeclarationParent it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$newOwner) ^ true;
                }
                {
                    this.$newOwner = irDeclarationParent;
                    super(1);
                }
            })))), (CharSequence)"$", null, null, (int)0, null, (Function1)((Function1)new Function1<IrDeclarationParent, CharSequence>(this){
                final /* synthetic */ LocalDeclarationsTransformer this$0;

                @NotNull
                public final CharSequence invoke(@NotNull IrDeclarationParent it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return LocalDeclarationsTransformer.access$suggestLocalName(this.this$0, (IrDeclarationWithName)((Object)it));
                }
                {
                    this.this$0 = localDeclarationsTransformer;
                    super(1);
                }
            }), (int)30, null));
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(\n       \u2026WithName) }\n            )");
            return name;
        }

        private final void createLiftedDeclaration(LocalFunctionContext localFunctionContext) {
            IrValueParameter irValueParameter;
            boolean bl;
            Object object;
            IrSimpleFunction oldDeclaration = localFunctionContext.getDeclaration();
            IrDeclarationContainer memberOwner = localFunctionContext.getOwnerForLoweredDeclaration();
            WrappedSimpleFunctionDescriptor newDescriptor2 = new WrappedSimpleFunctionDescriptor(oldDeclaration.getDescriptor());
            IrSimpleFunctionSymbolImpl newSymbol = new IrSimpleFunctionSymbolImpl(newDescriptor2);
            Name newName2 = this.generateNameForLiftedDeclaration(oldDeclaration, memberOwner);
            if (oldDeclaration.getDispatchReceiverParameter() != null) {
                throw (Throwable)((Object)new AssertionError((Object)"local functions must not have dispatch receiver"));
            }
            Object newDispatchReceiverParameter = null;
            List<IrValueSymbol> capturedValues = localFunctionContext.getClosure().getCapturedValues();
            int n = oldDeclaration.getStartOffset();
            int n2 = oldDeclaration.getEndOffset();
            IrDeclarationOrigin irDeclarationOrigin = oldDeclaration.getOrigin();
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = newSymbol;
            Visibility visibility = Visibilities.PRIVATE;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.PRIVATE");
            IrFunctionImpl newDeclaration = new IrFunctionImpl(n, n2, irDeclarationOrigin, irSimpleFunctionSymbol, newName2, visibility, Modality.FINAL, oldDeclaration.getReturnType(), oldDeclaration.isInline(), oldDeclaration.isExternal(), oldDeclaration.isTailrec(), oldDeclaration.isSuspend());
            newDescriptor2.bind((IrDeclaration)newDeclaration);
            localFunctionContext.setTransformedDeclaration(newDeclaration);
            newDeclaration.setParent(memberOwner);
            IrUtilsKt.copyTypeParametersFrom$default(newDeclaration, oldDeclaration, null, 2, null);
            newDeclaration.setDispatchReceiverParameter(newDispatchReceiverParameter);
            IrFunctionImpl irFunctionImpl = newDeclaration;
            IrValueParameter irValueParameter2 = oldDeclaration.getExtensionReceiverParameter();
            if (irValueParameter2 != null) {
                object = irValueParameter2;
                IrFunctionImpl irFunctionImpl2 = irFunctionImpl;
                boolean bl2 = false;
                bl = false;
                IrValueParameter $this$run = object;
                boolean bl3 = false;
                IrValueParameter irValueParameter3 = IrUtilsKt.copyTo$default($this$run, newDeclaration, null, 0, 0, 0, null, null, null, null, false, false, 2046, null);
                boolean bl4 = false;
                boolean bl5 = false;
                IrValueParameter it = irValueParameter3;
                boolean bl6 = false;
                this.putAbsentOrSame(this.newParameterToOld, it, $this$run);
                IrValueParameter irValueParameter4 = irValueParameter3;
                irFunctionImpl = irFunctionImpl2;
                irValueParameter = irValueParameter4;
            } else {
                irValueParameter = null;
            }
            irFunctionImpl.setExtensionReceiverParameter(irValueParameter);
            object = newDeclaration.getValueParameters();
            Iterable iterable = this.createTransformedValueParameters(capturedValues, oldDeclaration, newDeclaration);
            bl = false;
            CollectionsKt.addAll((Collection)object, (Iterable)iterable);
            this.recordTransformedValueParameters(newDeclaration, localFunctionContext);
            newDeclaration.getAnnotations().addAll((Collection<IrConstructorCall>)oldDeclaration.getAnnotations());
            this.transformedDeclarations.put(oldDeclaration, newDeclaration);
        }

        /*
         * WARNING - void declaration
         */
        private final ArrayList<IrValueParameter> createTransformedValueParameters(List<? extends IrValueSymbol> capturedValues, IrFunction oldDeclaration, IrFunction newDeclaration) {
            Object object;
            Collection collection;
            int n;
            boolean bl;
            Object object2;
            ArrayList<IrValueParameter> arrayList = new ArrayList<IrValueParameter>(capturedValues.size() + oldDeclaration.getValueParameters().size());
            boolean bl2 = false;
            boolean bl3 = false;
            ArrayList<IrValueParameter> $this$apply = arrayList;
            boolean bl4 = false;
            Iterable $this$mapIndexedTo$iv = capturedValues;
            boolean $i$f$mapIndexedTo = false;
            int index$iv = 0;
            for (Object item$iv2 : $this$mapIndexedTo$iv) {
                void i;
                void capturedValue;
                int n2 = index$iv++;
                object2 = $this$apply;
                bl = false;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                n = n2;
                IrValueSymbol irValueSymbol = (IrValueSymbol)item$iv2;
                int n3 = n;
                collection = object2;
                boolean bl5 = false;
                WrappedValueParameterDescriptor parameterDescriptor = new WrappedValueParameterDescriptor(null, null, 3, null);
                IrValueDeclaration p = capturedValue.getOwner();
                IrValueParameterImpl irValueParameterImpl = new IrValueParameterImpl(p.getStartOffset(), p.getEndOffset(), p.getDescriptor() instanceof ReceiverParameterDescriptor && newDeclaration instanceof IrConstructor ? (IrDeclarationOriginImpl)BOUND_RECEIVER_PARAMETER.INSTANCE : (IrDeclarationOriginImpl)BOUND_VALUE_PARAMETER.INSTANCE, new IrValueParameterSymbolImpl(parameterDescriptor), this.suggestNameForCapturedValue(p), (int)i, p.getType(), null, false, false);
                boolean bl6 = false;
                boolean bl7 = false;
                IrValueParameterImpl it = irValueParameterImpl;
                boolean bl8 = false;
                parameterDescriptor.bind((IrDeclaration)it);
                it.setParent(newDeclaration);
                this.newParameterToCaptured.put(it, (IrValueSymbol)capturedValue);
                object = irValueParameterImpl;
                collection.add(object);
            }
            Iterable $this$mapTo$iv = oldDeclaration.getValueParameters();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void v;
                Object item$iv2;
                item$iv2 = (IrValueParameter)item$iv;
                collection = $this$apply;
                boolean bl9 = false;
                object2 = IrUtilsKt.copyTo$default((IrValueParameter)v, newDeclaration, null, v.getIndex() + capturedValues.size(), 0, 0, null, null, null, null, false, false, 2042, null);
                bl = false;
                n = 0;
                Object it = object2;
                boolean bl10 = false;
                this.putAbsentOrSame(this.newParameterToOld, it, v);
                object = object2;
                collection.add(object);
            }
            return arrayList;
        }

        private final void recordTransformedValueParameters(@NotNull IrFunction $this$recordTransformedValueParameters, LocalContextWithClosureAsParameters localContext) {
            IrValueParameter it;
            Iterable $this$forEach$iv = $this$recordTransformedValueParameters.getValueParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (IrValueParameter)element$iv;
                boolean bl = false;
                IrValueSymbol capturedValue = this.newParameterToCaptured.get(it);
                if (capturedValue == null) continue;
                localContext.getCapturedValueToParameter().put(capturedValue.getOwner(), it);
            }
            $this$forEach$iv = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])new IrValueParameter[]{$this$recordTransformedValueParameters.getDispatchReceiverParameter(), $this$recordTransformedValueParameters.getExtensionReceiverParameter()}), (Iterable)$this$recordTransformedValueParameters.getValueParameters());
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (IrValueParameter)element$iv;
                boolean bl = false;
                IrValueParameter oldParameter = this.newParameterToOld.get(it);
                if (oldParameter == null) continue;
                this.putAbsentOrSame(this.oldParameterToNew, oldParameter, it);
            }
        }

        private final void createTransformedConstructorDeclaration(LocalClassConstructorContext constructorContext) {
            IrConstructor oldDeclaration = constructorContext.getDeclaration();
            Map<IrClass, LocalClassContext> map2 = this.localClasses;
            IrDeclarationParent irDeclarationParent = oldDeclaration.getParent();
            boolean bl = false;
            LocalClassContext localClassContext = map2.get(irDeclarationParent);
            if (localClassContext == null) {
                Intrinsics.throwNpe();
            }
            LocalClassContext localClassContext2 = localClassContext;
            List<IrValueSymbol> capturedValues = localClassContext2.getClosure().getCapturedValues();
            Annotations annotations2 = oldDeclaration.getDescriptor().getAnnotations();
            SourceElement sourceElement = oldDeclaration.getDescriptor().getSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"oldDeclaration.descriptor.source");
            WrappedClassConstructorDescriptor newDescriptor2 = new WrappedClassConstructorDescriptor(annotations2, sourceElement);
            IrConstructorSymbolImpl newSymbol = new IrConstructorSymbolImpl(newDescriptor2);
            IrConstructorImpl newDeclaration = new IrConstructorImpl(oldDeclaration.getStartOffset(), oldDeclaration.getEndOffset(), oldDeclaration.getOrigin(), newSymbol, oldDeclaration.getName(), LocalDeclarationsLowering.this.getLoweredConstructorVisibility(), oldDeclaration.getReturnType(), oldDeclaration.isInline(), oldDeclaration.isExternal(), oldDeclaration.isPrimary());
            newDescriptor2.bind((IrDeclaration)newDeclaration);
            constructorContext.setTransformedDeclaration(newDeclaration);
            newDeclaration.setParent(localClassContext2.getDeclaration());
            IrUtilsKt.copyTypeParametersFrom$default(newDeclaration, oldDeclaration, null, 2, null);
            IrValueParameter irValueParameter = oldDeclaration.getDispatchReceiverParameter();
            if (irValueParameter != null) {
                IrValueParameter irValueParameter2 = irValueParameter;
                boolean bl2 = false;
                boolean bl3 = false;
                IrValueParameter $this$run = irValueParameter2;
                boolean bl4 = false;
                throw (Throwable)((Object)new AssertionError((Object)("Local class constructor can't have dispatch receiver: " + IrUtilsKt.ir2string(oldDeclaration))));
            }
            IrValueParameter irValueParameter3 = oldDeclaration.getExtensionReceiverParameter();
            if (irValueParameter3 != null) {
                IrValueParameter irValueParameter4 = irValueParameter3;
                boolean bl5 = false;
                boolean bl6 = false;
                IrValueParameter $this$run = irValueParameter4;
                boolean bl7 = false;
                throw (Throwable)((Object)new AssertionError((Object)("Local class constructor can't have extension receiver: " + IrUtilsKt.ir2string(oldDeclaration))));
            }
            Collection collection = newDeclaration.getValueParameters();
            Iterable iterable = this.createTransformedValueParameters(capturedValues, oldDeclaration, newDeclaration);
            boolean bl8 = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            this.recordTransformedValueParameters(newDeclaration, constructorContext);
            newDeclaration.setMetadata(oldDeclaration.getMetadata());
            this.transformedDeclarations.put(oldDeclaration, newDeclaration);
        }

        private final IrField createFieldForCapturedValue(int startOffset, int endOffset, Name name, Visibility visibility, IrClass parent2, IrType fieldType) {
            WrappedFieldDescriptor descriptor2 = new WrappedFieldDescriptor(null, null, 3, null);
            IrFieldSymbolImpl symbol2 = new IrFieldSymbolImpl(descriptor2);
            IrFieldImpl irFieldImpl = new IrFieldImpl(startOffset, endOffset, DECLARATION_ORIGIN_FIELD_FOR_CAPTURED_VALUE.INSTANCE, symbol2, name, fieldType, visibility, true, false, false);
            boolean bl = false;
            boolean bl2 = false;
            IrFieldImpl it = irFieldImpl;
            boolean bl3 = false;
            descriptor2.bind((IrDeclaration)it);
            it.setParent(parent2);
            return irFieldImpl;
        }

        private final void createFieldsForCapturedValues(LocalClassContext localClassContext) {
            IrClass classDeclaration = localClassContext.getDeclaration();
            Iterable $this$forEach$iv = localClassContext.getClosure().getCapturedValues();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrValueSymbol capturedValue = (IrValueSymbol)element$iv;
                boolean bl = false;
                int n = classDeclaration.getStartOffset();
                int n2 = classDeclaration.getEndOffset();
                Name name = this.suggestNameForCapturedValue(capturedValue.getOwner());
                Visibility visibility = Visibilities.PRIVATE;
                Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.PRIVATE");
                IrField irField = this.createFieldForCapturedValue(n, n2, name, visibility, classDeclaration, capturedValue.getOwner().getType());
                localClassContext.getCapturedValueToField().put(capturedValue.getOwner(), irField);
            }
        }

        private final <K, V> void putAbsentOrSame(@NotNull Map<K, V> $this$putAbsentOrSame, K key, V value) {
            V current;
            V v;
            Map<K, V> $this$getOrPut$iv = $this$putAbsentOrSame;
            boolean $i$f$getOrPut = false;
            V value$iv = $this$getOrPut$iv.get(key);
            if (value$iv == null) {
                boolean bl = false;
                V answer$iv = value;
                $this$getOrPut$iv.put(key, answer$iv);
                v = answer$iv;
            } else {
                v = value$iv;
            }
            if (Intrinsics.areEqual(current = v, value) ^ true) {
                String string = current + " != " + value;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }

        private final Name suggestNameForCapturedValue(IrValueDeclaration declaration2) {
            Name name;
            if (declaration2.getName().isSpecial()) {
                String oldNameStr;
                String string = declaration2.getName().asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"declaration.name.asString()");
                String string2 = oldNameStr = string;
                int n = 1;
                int n2 = oldNameStr.length() - 1;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                name = DescriptorUtilsKt.getSynthesizedName(string4);
            } else {
                String string = declaration2.getName().asString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"declaration.name.asString()");
                name = DescriptorUtilsKt.getSynthesizedName(string);
            }
            return name;
        }

        private final void collectClosureForLocalDeclarations() {
            LocalContext context2;
            IrTypeParametersContainer declaration2;
            boolean bl;
            Map.Entry<IrFunction, LocalFunctionContext> entry;
            Map.Entry<IrFunction, LocalFunctionContext> $dstr$declaration$context;
            Map.Entry<IrFunction, LocalFunctionContext> element$iv;
            ClosureAnnotator annotator = new ClosureAnnotator(this.irFile);
            Map<IrTypeParametersContainer, LocalContext> $this$forEach$iv = this.localFunctions;
            boolean $i$f$forEach = false;
            Map<IrFunction, LocalFunctionContext> map2 = $this$forEach$iv;
            boolean bl2 = false;
            Iterator<Map.Entry<IrFunction, LocalFunctionContext>> iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                $dstr$declaration$context = element$iv = iterator2.next();
                boolean bl3 = false;
                entry = $dstr$declaration$context;
                bl = false;
                declaration2 = entry.getKey();
                entry = $dstr$declaration$context;
                bl = false;
                context2 = entry.getValue();
                ((LocalFunctionContext)context2).setClosure(annotator.getFunctionClosure((IrFunction)declaration2));
            }
            $this$forEach$iv = this.localClasses;
            $i$f$forEach = false;
            map2 = $this$forEach$iv;
            bl2 = false;
            iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                $dstr$declaration$context = element$iv = iterator2.next();
                boolean bl4 = false;
                entry = $dstr$declaration$context;
                bl = false;
                declaration2 = (IrClass)((Object)entry.getKey());
                entry = $dstr$declaration$context;
                bl = false;
                context2 = (LocalClassContext)((Object)entry.getValue());
                ((LocalClassContext)context2).setClosure(annotator.getClassClosure((IrClass)declaration2));
            }
        }

        private final void collectLocalDeclarations() {
            IrElementVisitorVoidKt.acceptVoid(this.irFile, new IrElementVisitorVoidWithContext(this){
                final /* synthetic */ LocalDeclarationsTransformer this$0;

                public void visitElement(@NotNull IrElement element) {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    IrElementVisitorVoidKt.acceptChildrenVoid(element, this);
                }

                @NotNull
                protected ScopeWithIr createScope(@NotNull IrSymbolOwner declaration2) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"org/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer$collectLocalDeclarations$ScopeWithCounter", "Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;", "scope", "Lorg/jetbrains/kotlin/ir/builders/Scope;", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "(Lorg/jetbrains/kotlin/ir/builders/Scope;Lorg/jetbrains/kotlin/ir/IrElement;)V", "counter", "", "getCounter", "()I", "setCounter", "(I)V", "ir.backend.common"})
                    public final class ScopeWithCounter
                    extends ScopeWithIr {
                        private int counter;

                        public final int getCounter() {
                            return this.counter;
                        }

                        public final void setCounter(int n) {
                            this.counter = n;
                        }

                        public ScopeWithCounter(@NotNull Scope scope, @NotNull IrElement irElement) {
                            Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
                            Intrinsics.checkParameterIsNotNull((Object)irElement, (String)"irElement");
                            super(scope, irElement);
                        }
                    }
                    return new ScopeWithCounter(new Scope(declaration2.getSymbol()), declaration2);
                }

                public void visitSimpleFunction(@NotNull IrSimpleFunction declaration2) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                    super.visitSimpleFunction(declaration2);
                    if (Intrinsics.areEqual((Object)declaration2.getVisibility(), (Object)Visibilities.LOCAL)) {
                        int n;
                        ScopeWithIr scopeWithIr = this.getCurrentClass();
                        if (scopeWithIr == null) {
                            scopeWithIr = this.getCurrentFile();
                        }
                        if (scopeWithIr == null) {
                            String string = "No scope for " + DumpIrTreeKt.dump(declaration2);
                            boolean bl = false;
                            throw (Throwable)new IllegalStateException(string.toString());
                        }
                        ScopeWithIr scopeWithIr2 = scopeWithIr;
                        Map<IrFunction, LocalFunctionContext> map2 = this.this$0.getLocalFunctions();
                        if (declaration2.getName().isSpecial()) {
                            ScopeWithIr scopeWithIr3 = scopeWithIr2;
                            if (scopeWithIr3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type ScopeWithCounter");
                            }
                            ScopeWithCounter scopeWithCounter = (ScopeWithCounter)scopeWithIr3;
                            int n2 = scopeWithCounter.getCounter();
                            scopeWithCounter.setCounter(n2 + 1);
                            n = n2;
                        } else {
                            n = -1;
                        }
                        IrElement irElement = scopeWithIr2.getIrElement();
                        if (irElement == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
                        }
                        map2.put(declaration2, new LocalFunctionContext(declaration2, n, (IrDeclarationContainer)((Object)irElement)));
                    }
                }

                public void visitConstructor(@NotNull IrConstructor declaration2) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                    super.visitConstructor(declaration2);
                    IrDeclarationParent irDeclarationParent = declaration2.getParent();
                    if (irDeclarationParent == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                    }
                    if (!LocalDeclarationsLoweringKt.isLocalNotInner((IrClass)irDeclarationParent)) {
                        return;
                    }
                    this.this$0.getLocalClassConstructors().put(declaration2, new LocalClassConstructorContext(declaration2));
                }

                public void visitClassNew(@NotNull IrClass declaration2) {
                    Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                    super.visitClassNew(declaration2);
                    if (!LocalDeclarationsLoweringKt.isLocalNotInner(declaration2)) {
                        return;
                    }
                    LocalClassContext localClassContext = new LocalClassContext(declaration2);
                    this.this$0.getLocalClasses().put(declaration2, localClassContext);
                }
                {
                    this.this$0 = $outer;
                }
            });
        }

        @NotNull
        public final IrFile getIrFile() {
            return this.irFile;
        }

        public LocalDeclarationsTransformer(IrFile irFile) {
            Map map2;
            Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
            this.irFile = irFile;
            this.localFunctions = new LinkedHashMap();
            this.localClasses = new LinkedHashMap();
            this.localClassConstructors = new LinkedHashMap();
            LocalDeclarationsTransformer localDeclarationsTransformer = this;
            boolean bl = false;
            localDeclarationsTransformer.transformedDeclarations = map2 = (Map)new LinkedHashMap();
            localDeclarationsTransformer = this;
            bl = false;
            localDeclarationsTransformer.newParameterToOld = map2 = (Map)new LinkedHashMap();
            localDeclarationsTransformer = this;
            bl = false;
            localDeclarationsTransformer.oldParameterToNew = map2 = (Map)new LinkedHashMap();
            localDeclarationsTransformer = this;
            bl = false;
            localDeclarationsTransformer.newParameterToCaptured = map2 = (Map)new LinkedHashMap();
        }

        public static final /* synthetic */ String access$suggestLocalName(LocalDeclarationsTransformer $this, IrDeclarationWithName declaration2) {
            return $this.suggestLocalName(declaration2);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\"H\u0016J+\u0010#\u001a\u0002H$\"\b\b\u0000\u0010$*\u00020%*\u0002H$2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010(J:\u0010)\u001a\u0002H$\"\b\b\u0000\u0010$*\u00020%*\u0002H$2\u0006\u0010'\u001a\u00020\u001a2\u0014\u0010*\u001a\u0010\u0012\u0004\u0012\u00020,\u0012\u0006\u0012\u0004\u0018\u00010\b0+H\u0086\b\u00a2\u0006\u0002\u0010-R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer$FunctionBodiesRewriter;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "localContext", "Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "(Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalDeclarationsTransformer;Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;)V", "getLocalContext", "()Lorg/jetbrains/kotlin/backend/common/lower/LocalDeclarationsLowering$LocalContext;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "visitDeclarationReference", "Lorg/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitLocalDelegatedProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrLocalDelegatedProperty;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "fillArguments2", "T", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "oldExpression", "newTarget", "(Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "mapValueParameters", "transform", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "(Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "ir.backend.common"})
        private final class FunctionBodiesRewriter
        extends IrElementTransformerVoid {
            @Nullable
            private final LocalContext localContext;

            @Override
            @NotNull
            public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                return declaration2.getDelegate().transform(this, null);
            }

            @Override
            @NotNull
            public IrStatement visitClass(@NotNull IrClass declaration2) {
                IrStatement irStatement;
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                Map<IrClass, LocalClassContext> map2 = LocalDeclarationsTransformer.this.getLocalClasses();
                boolean bl = false;
                Map<IrClass, LocalClassContext> map3 = map2;
                boolean bl2 = false;
                if (map3.containsKey(declaration2)) {
                    LocalClassContext localClassContext = LocalDeclarationsTransformer.this.getLocalClasses().get(declaration2);
                    if (localClassContext == null) {
                        Intrinsics.throwNpe();
                    }
                    irStatement = localClassContext.getDeclaration();
                } else {
                    irStatement = super.visitClass(declaration2);
                }
                return irStatement;
            }

            @Override
            @NotNull
            public IrStatement visitFunction(@NotNull IrFunction declaration2) {
                IrStatement irStatement;
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                Object object = LocalDeclarationsTransformer.this.getLocalFunctions();
                boolean bl = false;
                Map<IrFunction, LocalFunctionContext> map2 = object;
                boolean bl2 = false;
                if (map2.containsKey(declaration2)) {
                    irStatement = new IrCompositeImpl(declaration2.getStartOffset(), declaration2.getEndOffset(), LocalDeclarationsLowering.this.getContext().getIrBuiltIns().getUnitType(), null, 8, null);
                } else if (this.localContext instanceof LocalClassContext && Intrinsics.areEqual((Object)declaration2.getParent(), (Object)((LocalClassContext)this.localContext).getDeclaration())) {
                    object = declaration2;
                    bl = false;
                    boolean bl3 = false;
                    Object $this$apply = object;
                    boolean bl4 = false;
                    LocalClassMemberContext classMemberLocalContext = new LocalClassMemberContext(declaration2, (LocalClassContext)this.localContext);
                    IrElementTransformerVoidKt.transformChildrenVoid((IrElement)$this$apply, new FunctionBodiesRewriter(classMemberLocalContext));
                    irStatement = (IrStatement)object;
                } else {
                    irStatement = super.visitFunction(declaration2);
                }
                return irStatement;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            public IrStatement visitConstructor(@NotNull IrConstructor declaration2) {
                IrStatement irStatement;
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                LocalClassConstructorContext constructorContext = LocalDeclarationsTransformer.this.getLocalClassConstructors().get(declaration2);
                Object object = constructorContext;
                if (object != null && (object = ((LocalClassConstructorContext)object).getTransformedDeclaration()) != null) {
                    void $this$filterTo$iv$iv;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object $this$apply = object2;
                    boolean bl3 = false;
                    IrBody irBody = declaration2.getBody();
                    if (irBody == null) {
                        Intrinsics.throwNpe();
                    }
                    $this$apply.setBody(irBody);
                    Iterable $this$filter$iv = declaration2.getValueParameters();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv$iv;
                        boolean bl4 = false;
                        if (!(it.getDefaultValue() != null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$forEach$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IrValueParameter argument = (IrValueParameter)element$iv;
                        boolean bl5 = false;
                        IrValueParameter irValueParameter = LocalDeclarationsTransformer.this.getOldParameterToNew().get(argument);
                        if (irValueParameter == null) {
                            Intrinsics.throwNpe();
                        }
                        irValueParameter.setDefaultValue(argument.getDefaultValue());
                    }
                    object = object2;
                    if (object != null) {
                        irStatement = (IrStatement)object;
                        return irStatement;
                    }
                }
                irStatement = super.visitConstructor(declaration2);
                return irStatement;
            }

            @Override
            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrValueDeclaration declaration2 = expression2.getSymbol().getOwner();
                Object object = this.localContext;
                if (object != null && (object = ((LocalContext)object).irGet(expression2.getStartOffset(), expression2.getEndOffset(), declaration2)) != null) {
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    return it;
                }
                Object object3 = LocalDeclarationsTransformer.this.getOldParameterToNew();
                boolean bl = false;
                IrValueParameter irValueParameter = object3.get(declaration2);
                if (irValueParameter != null) {
                    object3 = irValueParameter;
                    bl = false;
                    boolean bl4 = false;
                    Object it = object3;
                    boolean bl5 = false;
                    return new IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), (IrValueSymbol)it.getSymbol(), null, 16, null);
                }
                return expression2;
            }

            @Override
            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrFunction oldCallee = expression2.getSymbol().getOwner();
                IrFunction irFunction = LocalDeclarationsTransformer.this.getTransformed(oldCallee);
                if (irFunction == null) {
                    return expression2;
                }
                if (irFunction == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSimpleFunction");
                }
                IrSimpleFunction newCallee = (IrSimpleFunction)irFunction;
                return this.fillArguments2((IrMemberAccessExpression)LocalDeclarationsTransformer.this.createNewCall(expression2, newCallee), expression2, newCallee);
            }

            @Override
            @NotNull
            public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrConstructor oldCallee = (IrConstructor)expression2.getSymbol().getOwner();
                IrFunction irFunction = LocalDeclarationsTransformer.this.getTransformed(oldCallee);
                if (irFunction == null) {
                    return expression2;
                }
                if (irFunction == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrConstructor");
                }
                IrConstructor newCallee = (IrConstructor)irFunction;
                return this.fillArguments2((IrMemberAccessExpression)LocalDeclarationsTransformer.this.createNewCall(expression2, newCallee), expression2, newCallee);
            }

            @Override
            @NotNull
            public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrConstructor oldCallee = (IrConstructor)expression2.getSymbol().getOwner();
                IrConstructor irConstructor = (IrConstructor)LocalDeclarationsTransformer.this.getTransformedDeclarations().get(oldCallee);
                if (irConstructor == null) {
                    return expression2;
                }
                IrConstructor newCallee = irConstructor;
                IrDelegatingConstructorCallImpl irDelegatingConstructorCallImpl = new IrDelegatingConstructorCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), LocalDeclarationsLowering.this.getContext().getIrBuiltIns().getUnitType(), (IrConstructorSymbol)newCallee.getSymbol(), newCallee.getDescriptor(), expression2.getTypeArgumentsCount());
                boolean bl = false;
                boolean bl2 = false;
                IrDelegatingConstructorCallImpl it = irDelegatingConstructorCallImpl;
                boolean bl3 = false;
                this.fillArguments2((IrMemberAccessExpression)it, expression2, newCallee);
                IrMemberAccessExpressionKt.copyTypeArgumentsFrom(it, expression2);
                return irDelegatingConstructorCallImpl;
            }

            @NotNull
            public final <T extends IrMemberAccessExpression> T mapValueParameters(@NotNull T $this$mapValueParameters, @NotNull IrFunction newTarget, @NotNull Function1<? super IrValueParameter, ? extends IrExpression> transform2) {
                int $i$f$mapValueParameters = 0;
                Intrinsics.checkParameterIsNotNull($this$mapValueParameters, (String)"$this$mapValueParameters");
                Intrinsics.checkParameterIsNotNull((Object)newTarget, (String)"newTarget");
                Intrinsics.checkParameterIsNotNull(transform2, (String)"transform");
                T t = $this$mapValueParameters;
                boolean bl = false;
                boolean bl2 = false;
                T $this$apply = t;
                boolean bl3 = false;
                for (IrValueParameter p : newTarget.getValueParameters()) {
                    $this$apply.putValueArgument(p.getIndex(), (IrExpression)transform2.invoke((Object)p));
                }
                return t;
            }

            /*
             * WARNING - void declaration
             */
            private final <T extends IrMemberAccessExpression> T fillArguments2(@NotNull T $this$fillArguments2, IrMemberAccessExpression oldExpression, IrFunction newTarget) {
                void $this$mapValueParameters$iv;
                T t = $this$fillArguments2;
                FunctionBodiesRewriter this_$iv = this;
                boolean $i$f$mapValueParameters = false;
                void var7_7 = $this$mapValueParameters$iv;
                boolean bl = false;
                boolean bl2 = false;
                void $this$apply$iv = var7_7;
                boolean bl3 = false;
                Iterator<IrValueParameter> iterator2 = newTarget.getValueParameters().iterator();
                while (iterator2.hasNext()) {
                    Object object;
                    void newValueParameterDeclaration;
                    IrValueParameter p$iv;
                    IrValueParameter irValueParameter = p$iv = iterator2.next();
                    int n = p$iv.getIndex();
                    void var28_28 = $this$apply$iv;
                    boolean bl4 = false;
                    IrValueParameter oldParameter = LocalDeclarationsTransformer.this.getNewParameterToOld().get(newValueParameterDeclaration);
                    if (oldParameter != null) {
                        object = oldExpression.getValueArgument(oldParameter.getIndex());
                    } else {
                        IrValueSymbol capturedValueSymbol;
                        if (LocalDeclarationsTransformer.this.getNewParameterToCaptured().get(newValueParameterDeclaration) == null) {
                            throw (Throwable)((Object)new AssertionError((Object)("Non-mapped parameter " + newValueParameterDeclaration)));
                        }
                        IrValueDeclaration capturedValue = capturedValueSymbol.getOwner();
                        object = this.localContext;
                        if (object == null || (object = ((LocalContext)object).irGet(oldExpression.getStartOffset(), oldExpression.getEndOffset(), capturedValue)) == null) {
                            T t2 = $this$fillArguments2;
                            boolean bl5 = false;
                            boolean bl6 = false;
                            T $this$run = t2;
                            boolean bl7 = false;
                            Map<IrValueParameter, IrValueParameter> map2 = LocalDeclarationsTransformer.this.getOldParameterToNew();
                            IrValueDeclaration irValueDeclaration = capturedValue;
                            boolean bl8 = false;
                            IrValueParameter irValueParameter2 = map2.get(irValueDeclaration);
                            IrValueDeclaration value = irValueParameter2 != null ? (IrValueDeclaration)irValueParameter2 : capturedValue;
                            object = new IrGetValueImpl(oldExpression.getStartOffset(), oldExpression.getEndOffset(), value.getSymbol(), null, 8, null);
                        }
                    }
                    IrExpression irExpression = object;
                    var28_28.putValueArgument(n, irExpression);
                }
                $this$fillArguments2.setDispatchReceiver(oldExpression.getDispatchReceiver());
                $this$fillArguments2.setExtensionReceiver(oldExpression.getExtensionReceiver());
                return $this$fillArguments2;
            }

            @Override
            @NotNull
            public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrFunction oldCallee = expression2.getSymbol().getOwner();
                IrFunction irFunction = LocalDeclarationsTransformer.this.getTransformed(oldCallee);
                if (irFunction == null) {
                    return expression2;
                }
                IrFunction newCallee = irFunction;
                IrFunctionReferenceImpl irFunctionReferenceImpl = new IrFunctionReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), newCallee.getSymbol(), newCallee.getDescriptor(), expression2.getTypeArgumentsCount(), expression2.getOrigin());
                boolean bl = false;
                boolean bl2 = false;
                IrFunctionReferenceImpl it = irFunctionReferenceImpl;
                boolean bl3 = false;
                this.fillArguments2((IrMemberAccessExpression)it, expression2, newCallee);
                IrMemberAccessExpressionKt.copyTypeArgumentsFrom(it, expression2);
                return irFunctionReferenceImpl;
            }

            @Override
            @NotNull
            public IrExpression visitReturn(@NotNull IrReturn expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrReturnTarget irReturnTarget = expression2.getReturnTargetSymbol().getOwner();
                if (!(irReturnTarget instanceof IrFunction)) {
                    irReturnTarget = null;
                }
                IrFunction irFunction = (IrFunction)irReturnTarget;
                if (irFunction == null) {
                    return expression2;
                }
                IrFunction oldReturnTarget = irFunction;
                IrFunction irFunction2 = LocalDeclarationsTransformer.this.getTransformed(oldReturnTarget);
                if (irFunction2 == null) {
                    return expression2;
                }
                IrFunction newReturnTarget = irFunction2;
                return new IrReturnImpl(expression2.getStartOffset(), expression2.getEndOffset(), LocalDeclarationsLowering.this.getContext().getIrBuiltIns().getNothingType(), newReturnTarget.getSymbol(), expression2.getValue());
            }

            @Override
            @NotNull
            public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                Map<IrSymbolOwner, IrDeclaration> map2 = LocalDeclarationsTransformer.this.getTransformedDeclarations();
                IrSymbolOwner irSymbolOwner = expression2.getSymbol().getOwner();
                boolean bl = false;
                Map<IrSymbolOwner, IrDeclaration> map3 = map2;
                boolean bl2 = false;
                if (map3.containsKey(irSymbolOwner)) {
                    boolean bl3 = false;
                    throw (Throwable)new NotImplementedError(null, 1, null);
                }
                return super.visitDeclarationReference(expression2);
            }

            @Override
            @NotNull
            public IrStatement visitDeclaration(@NotNull IrDeclaration declaration2) {
                Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
                if (declaration2 instanceof IrSymbolOwner) {
                    Map<IrSymbolOwner, IrDeclaration> map2 = LocalDeclarationsTransformer.this.getTransformedDeclarations();
                    boolean bl = false;
                    Map<IrSymbolOwner, IrDeclaration> map3 = map2;
                    boolean bl2 = false;
                    if (map3.containsKey(declaration2)) {
                        boolean bl3 = false;
                        throw (Throwable)new NotImplementedError(null, 1, null);
                    }
                }
                return super.visitDeclaration(declaration2);
            }

            @Nullable
            public final LocalContext getLocalContext() {
                return this.localContext;
            }

            public FunctionBodiesRewriter(LocalContext localContext) {
                this.localContext = localContext;
            }
        }
    }
}

