/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.base.MoreObjects;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.application.AccessToken;
import org.jetbrains.kotlin.com.intellij.openapi.application.Application;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.application.TransactionId;
import org.jetbrains.kotlin.com.intellij.openapi.application.ex.ApplicationEx;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class TransactionGuardImpl
extends TransactionGuard {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.application.TransactionGuardImpl");
    private final Queue<Transaction> myQueue = new LinkedBlockingQueue<Transaction>();
    private final Map<ModalityState, TransactionIdImpl> myModality2Transaction = ContainerUtil.createConcurrentWeakMap();
    private final Map<ModalityState, Boolean> myWriteSafeModalities = ContainerUtil.createConcurrentWeakMap();
    private TransactionIdImpl myCurrentTransaction;
    private boolean myWritingAllowed;
    private boolean myErrorReported;

    public TransactionGuardImpl() {
        this.myWriteSafeModalities.put(ModalityState.NON_MODAL, true);
        this.myWritingAllowed = SwingUtilities.isEventDispatchThread();
    }

    @NotNull
    private Queue<Transaction> getQueue(@Nullable TransactionIdImpl transaction) {
        while (transaction != null && transaction.myFinished) {
            transaction = transaction.myParent;
        }
        Queue<Transaction> queue = transaction == null ? this.myQueue : transaction.myQueue;
        if (queue == null) {
            TransactionGuardImpl.$$$reportNull$$$0(0);
        }
        return queue;
    }

    private void pollQueueLater() {
        TransactionGuardImpl.invokeLater(() -> {
            Queue<Transaction> queue = this.getQueue(this.myCurrentTransaction);
            Transaction next = queue.peek();
            if (next != null && this.canRunTransactionNow(next, false)) {
                queue.remove();
                this.runSyncTransaction(next);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSyncTransaction(@NotNull Transaction transaction) {
        if (transaction == null) {
            TransactionGuardImpl.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (Disposer.isDisposed(transaction.parentDisposable)) {
            return;
        }
        boolean wasWritingAllowed = this.myWritingAllowed;
        this.myWritingAllowed = true;
        this.myCurrentTransaction = new TransactionIdImpl(this.myCurrentTransaction);
        try {
            transaction.runnable.run();
        }
        finally {
            Queue<Transaction> queue = this.getQueue(this.myCurrentTransaction.myParent);
            queue.addAll(this.myCurrentTransaction.myQueue);
            if (!queue.isEmpty()) {
                this.pollQueueLater();
            }
            this.myWritingAllowed = wasWritingAllowed;
            this.myCurrentTransaction.myFinished = true;
            this.myCurrentTransaction = this.myCurrentTransaction.myParent;
        }
    }

    public void submitTransaction(@NotNull Disposable parentDisposable, @Nullable TransactionId expectedContext, @NotNull Runnable _transaction) {
        if (parentDisposable == null) {
            TransactionGuardImpl.$$$reportNull$$$0(2);
        }
        if (_transaction == null) {
            TransactionGuardImpl.$$$reportNull$$$0(3);
        }
        TransactionIdImpl expectedId = (TransactionIdImpl)expectedContext;
        Transaction transaction = new Transaction(_transaction, expectedId, parentDisposable);
        Application app = ApplicationManager.getApplication();
        boolean isDispatchThread = app.isDispatchThread();
        Runnable runnable = () -> {
            if (this.canRunTransactionNow(transaction, isDispatchThread)) {
                this.runSyncTransaction(transaction);
            } else {
                this.getQueue(expectedId).offer(transaction);
                this.pollQueueLater();
            }
        };
        if (isDispatchThread) {
            runnable.run();
        } else {
            TransactionGuardImpl.invokeLater(runnable);
        }
    }

    private boolean canRunTransactionNow(Transaction transaction, boolean sync) {
        if (sync && !this.myWritingAllowed) {
            return false;
        }
        TransactionIdImpl currentId = this.myCurrentTransaction;
        if (currentId == null) {
            return true;
        }
        return transaction.expectedContext != null && currentId.myStartCounter <= transaction.expectedContext.myStartCounter;
    }

    @NotNull
    public AccessToken startActivity(boolean userActivity) {
        boolean allowWriting;
        this.myErrorReported = false;
        boolean bl = allowWriting = userActivity && this.isWriteSafeModality(ModalityState.current());
        if (this.myWritingAllowed == allowWriting) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                TransactionGuardImpl.$$$reportNull$$$0(5);
            }
            return accessToken;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final boolean prev = this.myWritingAllowed;
        this.myWritingAllowed = allowWriting;
        AccessToken accessToken = new AccessToken(){

            @Override
            public void finish() {
                TransactionGuardImpl.this.myWritingAllowed = prev;
            }
        };
        if (accessToken == null) {
            TransactionGuardImpl.$$$reportNull$$$0(6);
        }
        return accessToken;
    }

    public boolean isWriteSafeModality(ModalityState state2) {
        return Boolean.TRUE.equals(this.myWriteSafeModalities.get(state2));
    }

    public void assertWriteActionAllowed() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (TransactionGuardImpl.areAssertionsEnabled() && !this.myWritingAllowed && !this.myErrorReported) {
            LOG.error(this.reportWriteUnsafeContext(ModalityState.current()));
            this.myErrorReported = true;
        }
    }

    private String reportWriteUnsafeContext(@NotNull ModalityState modality) {
        if (modality == null) {
            TransactionGuardImpl.$$$reportNull$$$0(7);
        }
        return "Write-unsafe context! Model changes are allowed from write-safe contexts only. Please ensure you're using invokeLater/invokeAndWait with a correct modality state (not \"any\"). See TransactionGuard documentation for details.\n  current modality=" + modality + "\n  known modalities:\n" + StringUtil.join(this.myWriteSafeModalities.entrySet(), entry -> String.format("    %s, writingAllowed=%s", entry.getKey(), entry.getValue()), ";\n");
    }

    private static boolean areAssertionsEnabled() {
        Application app = ApplicationManager.getApplication();
        if (app instanceof ApplicationEx && !((ApplicationEx)app).isLoaded()) {
            return false;
        }
        return Registry.is("ide.require.transaction.for.model.changes", false);
    }

    @Override
    public void submitTransactionLater(@NotNull Disposable parentDisposable, @NotNull Runnable transaction) {
        if (parentDisposable == null) {
            TransactionGuardImpl.$$$reportNull$$$0(9);
        }
        if (transaction == null) {
            TransactionGuardImpl.$$$reportNull$$$0(10);
        }
        TransactionIdImpl id = this.getContextTransaction();
        ModalityState startModality = ModalityState.defaultModalityState();
        TransactionGuardImpl.invokeLater(() -> {
            boolean allowWriting = ModalityState.current() == startModality;
            AccessToken token = this.startActivity(allowWriting);
            try {
                this.submitTransaction(parentDisposable, id, transaction);
            }
            finally {
                token.finish();
            }
        });
    }

    private static void invokeLater(Runnable runnable) {
        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.any(), Condition.FALSE);
    }

    @Override
    public TransactionIdImpl getContextTransaction() {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return this.myModality2Transaction.get(ModalityState.defaultModalityState());
        }
        return this.myWritingAllowed ? this.myCurrentTransaction : null;
    }

    public void enteredModality(@NotNull ModalityState modality) {
        TransactionIdImpl contextTransaction;
        if (modality == null) {
            TransactionGuardImpl.$$$reportNull$$$0(11);
        }
        if ((contextTransaction = this.getContextTransaction()) != null) {
            this.myModality2Transaction.put(modality, contextTransaction);
        }
        this.myWriteSafeModalities.put(modality, this.myWritingAllowed);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("currentTransaction", this.myCurrentTransaction).add("writingAllowed", this.myWritingAllowed).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/application/TransactionGuardImpl";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_transaction";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modality";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueue";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/application/TransactionGuardImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "startActivity";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapLaterInvocation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runSyncTransaction";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "submitTransaction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "submitTransactionAndWait";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reportWriteUnsafeContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "assertWriteSafeContext";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "submitTransactionLater";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "enteredModality";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModalityTransaction";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "wrapLaterInvocation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TransactionIdImpl
    implements TransactionId {
        private static final AtomicLong ourTransactionCounter = new AtomicLong();
        final long myStartCounter = ourTransactionCounter.getAndIncrement();
        final Queue<Transaction> myQueue = new LinkedBlockingQueue<Transaction>();
        boolean myFinished;
        final TransactionIdImpl myParent;

        TransactionIdImpl(@Nullable TransactionIdImpl parent2) {
            this.myParent = parent2;
        }

        public String toString() {
            return "Transaction " + this.myStartCounter + (this.myFinished ? "(finished)" : "");
        }
    }

    private static class Transaction {
        @NotNull
        final Runnable runnable;
        @Nullable
        final TransactionIdImpl expectedContext;
        @NotNull
        final Disposable parentDisposable;

        Transaction(@NotNull Runnable runnable, @Nullable TransactionIdImpl expectedContext, @NotNull Disposable parentDisposable) {
            if (runnable == null) {
                Transaction.$$$reportNull$$$0(0);
            }
            if (parentDisposable == null) {
                Transaction.$$$reportNull$$$0(1);
            }
            this.runnable = runnable;
            this.expectedContext = expectedContext;
            this.parentDisposable = parentDisposable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "runnable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentDisposable";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/openapi/application/TransactionGuardImpl$Transaction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

