/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import com.google.common.base.Strings;
import java.io.IOException;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Rule;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.project.ProjectTaskLister;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.diagnostics.AbstractReportTask;
import org.gradle.api.tasks.diagnostics.internal.AggregateMultiProjectTaskReportModel;
import org.gradle.api.tasks.diagnostics.internal.DefaultGroupTaskReportModel;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.SingleProjectTaskReportModel;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TaskDetailsFactory;
import org.gradle.api.tasks.diagnostics.internal.TaskReportRenderer;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.Factory;

public class TaskReportTask
extends AbstractReportTask {
    private TaskReportRenderer renderer = new TaskReportRenderer();
    private boolean detail;
    private String group;

    @Override
    public ReportRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(TaskReportRenderer renderer) {
        this.renderer = renderer;
    }

    @Option(option="all", description="Show additional tasks and detail.")
    public void setShowDetail(boolean detail) {
        this.detail = detail;
    }

    @Console
    public boolean isDetail() {
        return this.detail;
    }

    @Incubating
    @Option(option="group", description="Show tasks for a specific group.")
    public void setDisplayGroup(String group) {
        this.group = group;
    }

    @Incubating
    @Console
    public String getDisplayGroup() {
        return this.group;
    }

    @Override
    public void generate(Project project) throws IOException {
        this.renderer.showDetail(this.isDetail());
        this.renderer.addDefaultTasks(project.getDefaultTasks());
        AggregateMultiProjectTaskReportModel aggregateModel = new AggregateMultiProjectTaskReportModel(!this.isDetail(), this.isDetail(), this.getDisplayGroup());
        TaskDetailsFactory taskDetailsFactory = new TaskDetailsFactory(project);
        SingleProjectTaskReportModel projectTaskModel = this.buildTaskReportModelFor(taskDetailsFactory, project);
        aggregateModel.add(projectTaskModel);
        for (Project subproject : project.getSubprojects()) {
            aggregateModel.add(this.buildTaskReportModelFor(taskDetailsFactory, subproject));
        }
        aggregateModel.build();
        DefaultGroupTaskReportModel model = new DefaultGroupTaskReportModel();
        model.build(aggregateModel);
        for (String group : model.getGroups()) {
            this.renderer.startTaskGroup(group);
            for (TaskDetails task : model.getTasksForGroup(group)) {
                this.renderer.addTask(task);
            }
        }
        this.renderer.completeTasks();
        if (Strings.isNullOrEmpty((String)this.group)) {
            for (Rule rule : project.getTasks().getRules()) {
                this.renderer.addRule(rule);
            }
        }
    }

    private SingleProjectTaskReportModel buildTaskReportModelFor(final TaskDetailsFactory taskDetailsFactory, final Project subproject) {
        ProjectState projectState = this.getProjectStateRegistry().stateFor(subproject);
        return (SingleProjectTaskReportModel)projectState.withMutableState((Factory)new Factory<SingleProjectTaskReportModel>(){

            public SingleProjectTaskReportModel create() {
                SingleProjectTaskReportModel subprojectTaskModel = new SingleProjectTaskReportModel(taskDetailsFactory);
                subprojectTaskModel.build(TaskReportTask.this.getProjectTaskLister().listProjectTasks(subproject));
                return subprojectTaskModel;
            }
        });
    }

    @Inject
    protected ProjectStateRegistry getProjectStateRegistry() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ProjectTaskLister getProjectTaskLister() {
        throw new UnsupportedOperationException();
    }
}

