/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.kotlin.com.intellij.util.io.AntivirusDetector;

public class OpenChannelsCache {
    private final int myCacheSizeLimit;
    private final String myAccessMode;
    private final Map<File, ChannelDescriptor> myCache;

    public OpenChannelsCache(int cacheSizeLimit, @NonNls String accessMode) {
        this.myCacheSizeLimit = cacheSizeLimit;
        this.myAccessMode = accessMode;
        this.myCache = new LinkedHashMap<File, ChannelDescriptor>(cacheSizeLimit, 0.5f, true);
    }

    public synchronized RandomAccessFile getChannel(File ioFile) throws FileNotFoundException {
        ChannelDescriptor descriptor2 = this.myCache.get(ioFile);
        if (descriptor2 == null) {
            this.dropOvercache();
            descriptor2 = new ChannelDescriptor(ioFile, this.myAccessMode);
            this.myCache.put(ioFile, descriptor2);
        }
        descriptor2.lock();
        return descriptor2.getChannel();
    }

    private void dropOvercache() {
        int dropCount = this.myCache.size() - this.myCacheSizeLimit;
        if (dropCount >= 0) {
            ArrayList<File> keysToDrop = new ArrayList<File>();
            for (Map.Entry<File, ChannelDescriptor> entry : this.myCache.entrySet()) {
                if (dropCount < 0) break;
                if (entry.getValue().isLocked()) continue;
                --dropCount;
                keysToDrop.add(entry.getKey());
            }
            for (File file2 : keysToDrop) {
                this.closeChannel(file2);
            }
        }
    }

    public synchronized void releaseChannel(File ioFile) {
        ChannelDescriptor descriptor2 = this.myCache.get(ioFile);
        assert (descriptor2 != null);
        descriptor2.unlock();
    }

    public synchronized void closeChannel(File ioFile) {
        ChannelDescriptor descriptor2 = this.myCache.remove(ioFile);
        if (descriptor2 != null) {
            assert (!descriptor2.isLocked());
            AntivirusDetector.getInstance().execute(() -> {
                try {
                    descriptor2.getChannel().close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private static class ChannelDescriptor {
        private int lockCount = 0;
        private final RandomAccessFile myChannel;
        private final File myFile;

        ChannelDescriptor(File file2, String accessMode) throws FileNotFoundException {
            this.myFile = file2;
            this.myChannel = new RandomAccessFile(file2, accessMode);
        }

        public void lock() {
            ++this.lockCount;
        }

        public void unlock() {
            --this.lockCount;
        }

        public boolean isLocked() {
            return this.lockCount != 0;
        }

        public RandomAccessFile getChannel() {
            return this.myChannel;
        }
    }
}

