/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.gitrepo;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.SubmoduleAddCommand;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.gitrepo.ManifestParser;
import org.eclipse.jgit.gitrepo.RepoProject;
import org.eclipse.jgit.gitrepo.internal.RepoText;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.FileUtils;

public class RepoCommand
extends GitCommand<RevCommit> {
    private String manifestPath;
    private String baseUri;
    private URI targetUri;
    private String groupsParam;
    private String branch;
    private String targetBranch = "HEAD";
    private boolean recordRemoteBranch = false;
    private boolean recordSubmoduleLabels = false;
    private boolean recordShallowSubmodules = false;
    private PersonIdent author;
    private RemoteReader callback;
    private InputStream inputStream;
    private ManifestParser.IncludedFileReader includedReader;
    private boolean ignoreRemoteFailures = false;
    private List<RepoProject> bareProjects;
    private ProgressMonitor monitor;
    private static final String SLASH = "/";
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result;

    public RepoCommand(Repository repo) {
        super(repo);
    }

    public RepoCommand setPath(String path) {
        this.manifestPath = path;
        return this;
    }

    public RepoCommand setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public RepoCommand setURI(String uri) {
        this.baseUri = uri;
        return this;
    }

    public RepoCommand setTargetURI(String uri) {
        this.targetUri = URI.create(String.valueOf(uri) + SLASH);
        return this;
    }

    public RepoCommand setGroups(String groups) {
        this.groupsParam = groups;
        return this;
    }

    public RepoCommand setBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public RepoCommand setTargetBranch(String branch) {
        this.targetBranch = "refs/heads/" + branch;
        return this;
    }

    public RepoCommand setRecordRemoteBranch(boolean enable) {
        this.recordRemoteBranch = enable;
        return this;
    }

    public RepoCommand setRecordSubmoduleLabels(boolean enable) {
        this.recordSubmoduleLabels = enable;
        return this;
    }

    public RepoCommand setRecommendShallow(boolean enable) {
        this.recordShallowSubmodules = enable;
        return this;
    }

    public RepoCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public RepoCommand setIgnoreRemoteFailures(boolean ignore) {
        this.ignoreRemoteFailures = ignore;
        return this;
    }

    public RepoCommand setAuthor(PersonIdent author) {
        this.author = author;
        return this;
    }

    public RepoCommand setRemoteReader(RemoteReader callback) {
        this.callback = callback;
        return this;
    }

    public RepoCommand setIncludedFileReader(ManifestParser.IncludedFileReader reader) {
        this.includedReader = reader;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public RevCommit call() throws GitAPIException {
        this.checkCallable();
        if (this.baseUri == null) {
            this.baseUri = "";
        }
        if (this.inputStream == null) {
            if (this.manifestPath == null || this.manifestPath.length() == 0) {
                throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
            }
            try {
                this.inputStream = new FileInputStream(this.manifestPath);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(JGitText.get().pathNotConfigured);
            }
        }
        try {
            try {
                parser = new ManifestParser(this.includedReader, this.manifestPath, this.branch, this.baseUri, this.groupsParam, this.repo);
                parser.read(this.inputStream);
                filteredProjects = parser.getFilteredProjects();
            }
            catch (IOException e) {
                throw new ManifestErrorException(e);
            }
        }
        finally {
            try {
                this.inputStream.close();
            }
            catch (IOException var4_12) {}
        }
        if (this.repo.isBare()) {
            this.bareProjects = new ArrayList<RepoProject>();
            if (this.author == null) {
                this.author = new PersonIdent(this.repo);
            }
            if (this.callback == null) {
                this.callback = new DefaultRemoteReader();
            }
            for (RepoProject proj : filteredProjects) {
                this.addSubmoduleBare(proj.getUrl(), proj.getPath(), proj.getRevision(), proj.getCopyFiles(), proj.getLinkFiles(), proj.getGroups(), proj.getRecommendShallow());
            }
            index = DirCache.newInCore();
            builder = index.builder();
            inserter = this.repo.newObjectInserter();
            try {
                var5_15 = null;
                var6_19 = null;
                try {
                    rw = new RevWalk(this.repo);
                    try {
                        cfg = new Config();
                        attributes = new StringBuilder();
                        for (RepoProject proj : this.bareProjects) {
                            path = proj.getPath();
                            nameUri = proj.getName();
                            if (ObjectId.isId(proj.getRevision())) {
                                objectId = ObjectId.fromString(proj.getRevision());
                            } else {
                                objectId = this.callback.sha1(nameUri, proj.getRevision());
                                if (objectId == null && !this.ignoreRemoteFailures) {
                                    throw new RemoteUnavailableException(nameUri);
                                }
                                if (this.recordRemoteBranch) {
                                    cfg.setString("submodule", path, "branch", proj.getRevision());
                                }
                                if (this.recordShallowSubmodules && proj.getRecommendShallow() != null) {
                                    cfg.setBoolean("submodule", path, "shallow", true);
                                }
                            }
                            if (this.recordSubmoduleLabels) {
                                rec = new StringBuilder();
                                rec.append("/");
                                rec.append(path);
                                for (String group : proj.getGroups()) {
                                    rec.append(" ");
                                    rec.append(group);
                                }
                                rec.append("\n");
                                attributes.append(rec.toString());
                            }
                            submodUrl = URI.create(nameUri);
                            if (this.targetUri != null) {
                                submodUrl = RepoCommand.relativize(this.targetUri, submodUrl);
                            }
                            cfg.setString("submodule", path, "path", path);
                            cfg.setString("submodule", path, "url", submodUrl.toString());
                            if (objectId == null) continue;
                            dcEntry = new DirCacheEntry(path);
                            dcEntry.setObjectId(objectId);
                            dcEntry.setFileMode(FileMode.GITLINK);
                            builder.add(dcEntry);
                            for (RepoProject.CopyFile copyfile : proj.getCopyFiles()) {
                                src = this.callback.readFile(nameUri, proj.getRevision(), copyfile.src);
                                objectId = inserter.insert(3, src);
                                dcEntry = new DirCacheEntry(copyfile.dest);
                                dcEntry.setObjectId(objectId);
                                dcEntry.setFileMode(FileMode.REGULAR_FILE);
                                builder.add(dcEntry);
                            }
                            for (RepoProject.LinkFile linkfile : proj.getLinkFiles()) {
                                link = linkfile.dest.contains("/") != false ? FileUtils.relativizeGitPath(linkfile.dest.substring(0, linkfile.dest.lastIndexOf(47)), String.valueOf(proj.getPath()) + "/" + linkfile.src) : String.valueOf(proj.getPath()) + "/" + linkfile.src;
                                objectId = inserter.insert(3, link.getBytes(Constants.CHARACTER_ENCODING));
                                dcEntry = new DirCacheEntry(linkfile.dest);
                                dcEntry.setObjectId(objectId);
                                dcEntry.setFileMode(FileMode.SYMLINK);
                                builder.add(dcEntry);
                            }
                        }
                        content = cfg.toText();
                        dcEntry = new DirCacheEntry(".gitmodules");
                        objectId = inserter.insert(3, content.getBytes(Constants.CHARACTER_ENCODING));
                        dcEntry.setObjectId(objectId);
                        dcEntry.setFileMode(FileMode.REGULAR_FILE);
                        builder.add(dcEntry);
                        if (this.recordSubmoduleLabels) {
                            dcEntryAttr = new DirCacheEntry(".gitattributes");
                            attrId = inserter.insert(3, attributes.toString().getBytes(Constants.CHARACTER_ENCODING));
                            dcEntryAttr.setObjectId(attrId);
                            dcEntryAttr.setFileMode(FileMode.REGULAR_FILE);
                            builder.add(dcEntryAttr);
                        }
                        builder.finish();
                        treeId = index.writeTree(inserter);
                        headId = this.repo.resolve(String.valueOf(this.targetBranch) + "^{commit}");
                        if (headId != null && rw.parseCommit(headId).getTree().getId().equals(treeId)) {
                            v0 = rw.parseCommit(headId);
                            return v0;
                        }
                        commit = new CommitBuilder();
                        commit.setTreeId(treeId);
                        if (headId != null) {
                            commit.setParentIds(new ObjectId[]{headId});
                        }
                        commit.setAuthor(this.author);
                        commit.setCommitter(this.author);
                        commit.setMessage(RepoText.get().repoCommitMessage);
                        commitId = inserter.insert(commit);
                        inserter.flush();
                        ru = this.repo.updateRef(this.targetBranch);
                        ru.setNewObjectId(commitId);
                        ru.setExpectedOldObjectId(headId != null ? headId : ObjectId.zeroId());
                        rc = ru.update(rw);
                        switch (RepoCommand.$SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result()[rc.ordinal()]) {
                            case 4: 
                            case 5: 
                            case 6: {
                                break;
                            }
                            case 2: 
                            case 7: {
                                throw new ConcurrentRefUpdateException(MessageFormat.format(JGitText.get().cannotLock, new Object[]{this.targetBranch}), ru.getRef(), rc);
                            }
                            default: {
                                throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{this.targetBranch, commitId.name(), rc}));
                            }
                        }
                        return rw.parseCommit(commitId);
                    }
                    catch (Throwable var5_16) {
                        throw var5_16;
                    }
                    finally {
                        if (rw == null) ** continue;
                        rw.close();
                    }
                }
                catch (Throwable var6_20) {
                    if (var5_15 == null) {
                        var5_15 = var6_20;
                    } else if (var5_15 != var6_20) {
                        var5_15.addSuppressed(var6_20);
                    }
                    throw var5_15;
                }
            }
            catch (IOException | GitAPIException e) {
                throw new ManifestErrorException(e);
            }
        }
        try {
            index = null;
            var3_9 = null;
            try {
                git = new Git(this.repo);
                try {
                    for (RepoProject proj : filteredProjects) {
                        this.addSubmodule(proj.getUrl(), proj.getPath(), proj.getRevision(), proj.getCopyFiles(), proj.getLinkFiles(), git);
                    }
                    return git.commit().setMessage(RepoText.get().repoCommitMessage).call();
                }
                catch (Throwable index) {
                    throw index;
                }
                finally {
                    if (git != null) {
                        git.close();
                    }
                }
            }
            catch (Throwable var3_10) {
                if (index == null) {
                    index = var3_10;
                } else if (index != var3_10) {
                    index.addSuppressed(var3_10);
                }
                throw index;
            }
        }
        catch (IOException | GitAPIException e) {
            throw new ManifestErrorException(e);
        }
    }

    private void addSubmodule(String url, String path, String revision, List<RepoProject.CopyFile> copyfiles, List<RepoProject.LinkFile> linkfiles, Git git) throws GitAPIException, IOException {
        assert (!this.repo.isBare());
        assert (git != null);
        if (!linkfiles.isEmpty()) {
            throw new UnsupportedOperationException(JGitText.get().nonBareLinkFilesNotSupported);
        }
        SubmoduleAddCommand add = git.submoduleAdd().setPath(path).setURI(url);
        if (this.monitor != null) {
            add.setProgressMonitor(this.monitor);
        }
        Repository subRepo = add.call();
        if (revision != null) {
            Throwable throwable = null;
            Iterator<RepoProject.CopyFile> iterator = null;
            try (Git sub = new Git(subRepo);){
                sub.checkout().setName(RepoCommand.findRef(revision, subRepo)).call();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            subRepo.close();
            git.add().addFilepattern(path).call();
        }
        for (RepoProject.CopyFile copyfile : copyfiles) {
            copyfile.copy();
            git.add().addFilepattern(copyfile.dest).call();
        }
    }

    private void addSubmoduleBare(String url, String path, String revision, List<RepoProject.CopyFile> copyfiles, List<RepoProject.LinkFile> linkfiles, Set<String> groups, String recommendShallow) {
        assert (this.repo.isBare());
        assert (this.bareProjects != null);
        RepoProject proj = new RepoProject(url, path, revision, null, groups, recommendShallow);
        proj.addCopyFiles(copyfiles);
        proj.addLinkFiles(linkfiles);
        this.bareProjects.add(proj);
    }

    /*
     * Unable to fully structure code
     */
    static URI relativize(URI current, URI target) {
        if (!Objects.equals(current.getHost(), target.getHost())) {
            return target;
        }
        cur = current.normalize().getPath();
        dest = target.normalize().getPath();
        if (cur.startsWith("/") == dest.startsWith("/")) ** GOTO lbl8
        return target;
lbl-1000:
        // 1 sources

        {
            cur = cur.substring(1);
lbl8:
            // 2 sources

            ** while (cur.startsWith((String)"/"))
        }
lbl9:
        // 2 sources

        while (dest.startsWith("/")) {
            dest = dest.substring(1);
        }
        if (cur.indexOf(47) == -1 || dest.indexOf(47) == -1) {
            prefix = "prefix/";
            cur = String.valueOf(prefix) + cur;
            dest = String.valueOf(prefix) + dest;
        }
        if (!cur.endsWith("/")) {
            lastSlash = cur.lastIndexOf(47);
            cur = cur.substring(0, lastSlash);
        }
        destFile = "";
        if (!dest.endsWith("/")) {
            lastSlash = dest.lastIndexOf(47);
            destFile = dest.substring(lastSlash + 1, dest.length());
            dest = dest.substring(0, dest.lastIndexOf(47));
        }
        cs = cur.split("/");
        ds = dest.split("/");
        common = 0;
        while (common < cs.length && common < ds.length && cs[common].equals(ds[common])) {
            ++common;
        }
        j = new StringJoiner("/");
        i = common;
        while (i < cs.length) {
            j.add("..");
            ++i;
        }
        i = common;
        while (i < ds.length) {
            j.add(ds[i]);
            ++i;
        }
        j.add(destFile);
        return URI.create(j.toString());
    }

    private static String findRef(String ref, Repository repo) throws IOException {
        Ref r;
        if (!ObjectId.isId(ref) && (r = repo.exactRef("refs/remotes/origin/" + ref)) != null) {
            return r.getName();
        }
        return ref;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result() {
        if ($SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result != null) {
            return $SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result;
        }
        int[] nArray = new int[RefUpdate.Result.values().length];
        try {
            nArray[RefUpdate.Result.FAST_FORWARD.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.FORCED.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.IO_FAILURE.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.LOCK_FAILURE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.NEW.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.NOT_ATTEMPTED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.NO_CHANGE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.REJECTED.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.REJECTED_CURRENT_BRANCH.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.REJECTED_MISSING_OBJECT.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.REJECTED_OTHER_REASON.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RefUpdate.Result.RENAMED.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$jgit$lib$RefUpdate$Result = nArray;
        return nArray;
    }

    public static class DefaultRemoteReader
    implements RemoteReader {
        @Override
        public ObjectId sha1(String uri, String ref) throws GitAPIException {
            Map<String, Ref> map = Git.lsRemoteRepository().setRemote(uri).callAsMap();
            Ref r = RefDatabase.findRef(map, ref);
            return r != null ? r.getObjectId() : null;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public byte[] readFile(String uri, String ref, String path) throws GitAPIException, IOException {
            dir = FileUtils.createTempDir("jgit_", ".git", null);
            try {
                var5_5 = null;
                var6_7 = null;
                try {
                    git = Git.cloneRepository().setBare(true).setDirectory(dir).setURI(uri).call();
                    try {
                        var9_10 = this.readFileFromRepo(git.getRepository(), ref, path);
                        ** try [egrp 3[TRYBLOCK] [1 : 60->69)] { 
                    }
lbl12:
                    // 1 sources

                    catch (Throwable var5_6) {
                        throw var5_6;
                    }
                    finally {
                        if (git != null) {
                            git.close();
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        FileUtils.delete(dir, 1);
                        return var9_10;
                    }
                }
                catch (Throwable var6_8) {
                    if (var5_5 == null) {
                        var5_5 = var6_8;
                    } else if (var5_5 != var6_8) {
                        var5_5.addSuppressed(var6_8);
                    }
                    throw var5_5;
                }
            }
            catch (Throwable var8_11) {
                FileUtils.delete(dir, 1);
                throw var8_11;
            }
        }

        protected byte[] readFileFromRepo(Repository repo, String ref, String path) throws GitAPIException, IOException {
            Throwable throwable = null;
            Object var5_6 = null;
            try (ObjectReader reader = repo.newObjectReader();){
                ObjectId oid = repo.resolve(String.valueOf(ref) + ":" + path);
                return reader.open(oid).getBytes(Integer.MAX_VALUE);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static class ManifestErrorException
    extends GitAPIException {
        ManifestErrorException(Throwable cause) {
            super(RepoText.get().invalidManifest, cause);
        }
    }

    public static interface RemoteReader {
        @Nullable
        public ObjectId sha1(String var1, String var2) throws GitAPIException;

        public byte[] readFile(String var1, String var2, String var3) throws GitAPIException, IOException;
    }

    private static class RemoteUnavailableException
    extends GitAPIException {
        RemoteUnavailableException(String uri) {
            super(MessageFormat.format(RepoText.get().errorRemoteUnavailable, uri));
        }
    }
}

