/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.Context;
import org.gradle.internal.execution.CurrentSnapshotResult;
import org.gradle.internal.execution.ExecutionOutcome;
import org.gradle.internal.execution.Result;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.id.UniqueId;

public class SnapshotOutputsStep<C extends Context>
implements Step<C, CurrentSnapshotResult> {
    private final UniqueId buildInvocationScopeId;
    private final Step<? super C, ? extends Result> delegate;

    public SnapshotOutputsStep(UniqueId buildInvocationScopeId, Step<? super C, ? extends Result> delegate) {
        this.buildInvocationScopeId = buildInvocationScopeId;
        this.delegate = delegate;
    }

    @Override
    public CurrentSnapshotResult execute(C context) {
        final Result result = this.delegate.execute(context);
        UnitOfWork work = context.getWork();
        final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> finalOutputs = work.snapshotAfterOutputsGenerated();
        final OriginMetadata originMetadata = new OriginMetadata(this.buildInvocationScopeId.asString(), work.markExecutionTime());
        return new CurrentSnapshotResult(){

            @Override
            public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getFinalOutputs() {
                return finalOutputs;
            }

            @Override
            public OriginMetadata getOriginMetadata() {
                return originMetadata;
            }

            @Override
            public Try<ExecutionOutcome> getOutcome() {
                return result.getOutcome();
            }

            @Override
            public boolean isReused() {
                return false;
            }
        };
    }
}

