/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.validation;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.publish.internal.PublicationInternal;

public class DuplicatePublicationTracker {
    private static final Logger LOG = Logging.getLogger(DuplicatePublicationTracker.class);
    private final Multimap<String, PublicationInternal> published = LinkedHashMultimap.create();

    public synchronized void checkCanPublish(PublicationInternal publication, @Nullable URI repositoryLocation, String repositoryName) {
        if (repositoryLocation == null) {
            return;
        }
        String repositoryKey = this.normalizeLocation(repositoryLocation);
        if (this.published.get((Object)repositoryKey).contains(publication)) {
            LOG.warn("Publication '" + publication.getCoordinates() + "' is published multiple times to the same location. It is likely that repository '" + repositoryName + "' is duplicated.");
            return;
        }
        ModuleVersionIdentifier projectIdentity = publication.getCoordinates();
        for (PublicationInternal previousPublication : this.published.get((Object)repositoryKey)) {
            if (!previousPublication.getCoordinates().equals(projectIdentity)) continue;
            throw new GradleException("Cannot publish multiple publications with coordinates '" + projectIdentity + "' to repository '" + repositoryName + "'");
        }
        this.published.put((Object)repositoryKey, (Object)publication);
    }

    private String normalizeLocation(URI location) {
        String repoUrl = location.toString();
        if (!repoUrl.endsWith("/")) {
            return repoUrl + "/";
        }
        return repoUrl;
    }
}

