/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.versionmapping;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.publish.VariantVersionMappingStrategy;
import org.gradle.api.publish.internal.versionmapping.VariantVersionMappingStrategyInternal;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.maven.internal.versionmapping.DefaultVariantVersionMappingStrategy;
import org.gradle.internal.component.model.AttributeMatcher;

public class DefaultVersionMappingStrategy
implements VersionMappingStrategyInternal {
    private final ObjectFactory objectFactory;
    private final ConfigurationContainer configurations;
    private final AttributesSchemaInternal schema;
    private final ImmutableAttributesFactory attributesFactory;
    private final List<Action<? super VariantVersionMappingStrategy>> mappingsForAllVariants = Lists.newArrayListWithExpectedSize((int)2);
    private final Map<ImmutableAttributes, String> defaultConfigurations = Maps.newHashMap();
    private final Multimap<ImmutableAttributes, Action<? super VariantVersionMappingStrategy>> attributeBasedMappings = ArrayListMultimap.create();

    public DefaultVersionMappingStrategy(ObjectFactory objectFactory, ConfigurationContainer configurations, AttributesSchemaInternal schema, ImmutableAttributesFactory attributesFactory) {
        this.objectFactory = objectFactory;
        this.configurations = configurations;
        this.schema = schema;
        this.attributesFactory = attributesFactory;
    }

    public void allVariants(Action<? super VariantVersionMappingStrategy> action) {
        this.mappingsForAllVariants.add(action);
    }

    public <T> void variant(Attribute<T> attribute, T attributeValue, Action<? super VariantVersionMappingStrategy> action) {
        this.attributeBasedMappings.put((Object)this.attributesFactory.of(attribute, attributeValue), action);
    }

    public void usage(String usage, Action<? super VariantVersionMappingStrategy> action) {
        this.variant(Usage.USAGE_ATTRIBUTE, (Usage)this.objectFactory.named(Usage.class, usage), action);
    }

    public void defaultResolutionConfiguration(String usage, String defaultConfiguration) {
        this.defaultConfigurations.put(this.attributesFactory.of(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.objectFactory.named(Usage.class, usage))), defaultConfiguration);
    }

    public VariantVersionMappingStrategyInternal findStrategyForVariant(ImmutableAttributes variantAttributes) {
        DefaultVariantVersionMappingStrategy strategy = this.createDefaultMappingStrategy(variantAttributes);
        for (Action<? super VariantVersionMappingStrategy> action : this.mappingsForAllVariants) {
            action.execute((Object)strategy);
        }
        if (!this.attributeBasedMappings.isEmpty()) {
            Set candidates;
            AttributeMatcher matcher = this.schema.matcher();
            List matches = matcher.matches((Collection)(candidates = this.attributeBasedMappings.keySet()), (AttributeContainerInternal)variantAttributes);
            if (matches.size() == 1) {
                Collection actions = this.attributeBasedMappings.get((Object)((ImmutableAttributes)matches.get(0)));
                for (Action action : actions) {
                    action.execute((Object)strategy);
                }
            } else if (matches.size() > 1) {
                throw new InvalidUserCodeException("Unable to find a suitable version mapping strategy for " + variantAttributes);
            }
        }
        return strategy;
    }

    private DefaultVariantVersionMappingStrategy createDefaultMappingStrategy(ImmutableAttributes variantAttributes) {
        DefaultVariantVersionMappingStrategy strategy = new DefaultVariantVersionMappingStrategy(this.configurations);
        if (!this.defaultConfigurations.isEmpty()) {
            AttributeMatcher matcher = this.schema.matcher();
            Set<ImmutableAttributes> candidates = this.defaultConfigurations.keySet();
            List matches = matcher.matches(candidates, (AttributeContainerInternal)variantAttributes);
            for (ImmutableAttributes match : matches) {
                strategy.setTargetConfiguration(this.configurations.getByName(this.defaultConfigurations.get(match)));
            }
        }
        return strategy;
    }
}

