/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import com.google.common.collect.Maps;
import groovy.lang.Script;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.gradle.api.Action;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.CompileOperation;
import org.gradle.groovy.scripts.internal.CompiledScript;
import org.gradle.groovy.scripts.internal.CrossBuildInMemoryCachingScriptClassCache;
import org.gradle.groovy.scripts.internal.ScriptCacheKey;
import org.gradle.groovy.scripts.internal.ScriptClassCompiler;
import org.gradle.internal.Cast;

public class BuildScopeInMemoryCachingScriptClassCompiler
implements ScriptClassCompiler {
    private final CrossBuildInMemoryCachingScriptClassCache cache;
    private final ScriptClassCompiler scriptClassCompiler;
    private final Map<ScriptCacheKey, CompiledScript<?, ?>> cachedCompiledScripts = Maps.newHashMap();

    public BuildScopeInMemoryCachingScriptClassCompiler(CrossBuildInMemoryCachingScriptClassCache cache, ScriptClassCompiler scriptClassCompiler) {
        this.cache = cache;
        this.scriptClassCompiler = scriptClassCompiler;
    }

    @Override
    public <T extends Script, M> CompiledScript<T, M> compile(ScriptSource source, ClassLoader classLoader, ClassLoaderId classLoaderId, CompileOperation<M> operation, Class<T> scriptBaseClass, Action<? super ClassNode> verifier) {
        ScriptCacheKey key = new ScriptCacheKey(source.getClassName(), classLoader, operation.getId());
        CompiledScript<T, M> compiledScript = (CompiledScript<T, M>)Cast.uncheckedCast(this.cachedCompiledScripts.get(key));
        if (compiledScript == null) {
            compiledScript = this.cache.getOrCompile(source, classLoader, classLoaderId, operation, scriptBaseClass, verifier, this.scriptClassCompiler);
            this.cachedCompiledScripts.put(key, compiledScript);
        }
        return compiledScript;
    }
}

