/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependencies.internal;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import groovy.json.JsonBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.reporting.dependencies.internal.StrictDependencyResultSpec;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.AbstractRenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableModuleResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.UnresolvableConfigurationResult;
import org.gradle.api.tasks.diagnostics.internal.insight.DependencyInsightReporter;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GradleVersion;

public class JsonProjectDependencyRenderer {
    private final VersionSelectorScheme versionSelectorScheme;
    private final VersionComparator versionComparator;
    private final VersionParser versionParser;

    public JsonProjectDependencyRenderer(VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator, VersionParser versionParser) {
        this.versionSelectorScheme = versionSelectorScheme;
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
    }

    public String render(Project project) {
        JsonBuilder json = new JsonBuilder();
        this.renderProject(project, json);
        return json.toString();
    }

    private void renderProject(Project project, JsonBuilder json) {
        LinkedHashMap overall = Maps.newLinkedHashMap();
        overall.put("gradleVersion", GradleVersion.current().toString());
        overall.put("generationDate", new Date().toString());
        LinkedHashMap projectOut = Maps.newLinkedHashMap();
        projectOut.put("name", project.getName());
        projectOut.put("description", project.getDescription());
        projectOut.put("configurations", this.createConfigurations(project));
        overall.put("project", projectOut);
        json.call((Map)overall);
    }

    private List<Map> createConfigurations(Project project) {
        ConfigurationContainer configurations = project.getConfigurations();
        return CollectionUtils.collect((Iterable)configurations, (Transformer)new Transformer<Map, Configuration>(){

            public Map transform(Configuration configuration) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(4);
                map.put("name", configuration.getName());
                map.put("description", configuration.getDescription());
                map.put("dependencies", JsonProjectDependencyRenderer.this.createDependencies(configuration));
                map.put("moduleInsights", JsonProjectDependencyRenderer.this.createModuleInsights(configuration));
                return map;
            }
        });
    }

    private List createDependencies(Configuration configuration) {
        if (configuration.isCanBeResolved()) {
            ResolutionResult result = configuration.getIncoming().getResolutionResult();
            RenderableModuleResult root = new RenderableModuleResult(result.getRoot());
            return this.createDependencyChildren(root, new HashSet<Object>());
        }
        return this.createDependencyChildren(new UnresolvableConfigurationResult(configuration), new HashSet<Object>());
    }

    private List createDependencyChildren(RenderableDependency dependency, final Set<Object> visited) {
        Set<? extends RenderableDependency> children = dependency.getChildren();
        return CollectionUtils.collect(children, (Transformer)new Transformer<Map, RenderableDependency>(){

            public Map transform(RenderableDependency childDependency) {
                boolean alreadyVisited = !visited.add(childDependency.getId());
                boolean alreadyRendered = alreadyVisited && !childDependency.getChildren().isEmpty();
                String name = JsonProjectDependencyRenderer.this.replaceArrow(childDependency.getName());
                boolean hasConflict = !name.equals(childDependency.getName());
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(6);
                ModuleIdentifier moduleIdentifier = JsonProjectDependencyRenderer.this.getModuleIdentifier(childDependency);
                map.put("module", moduleIdentifier == null ? null : moduleIdentifier.toString());
                map.put("name", name);
                map.put("resolvable", (Object)childDependency.getResolutionState());
                map.put("hasConflict", hasConflict);
                map.put("alreadyRendered", alreadyRendered);
                map.put("children", Collections.emptyList());
                if (!alreadyRendered) {
                    map.put("children", JsonProjectDependencyRenderer.this.createDependencyChildren(childDependency, visited));
                }
                return map;
            }
        });
    }

    private ModuleIdentifier getModuleIdentifier(RenderableDependency renderableDependency) {
        if (renderableDependency.getId() instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier id = (ModuleComponentIdentifier)renderableDependency.getId();
            return id.getModuleIdentifier();
        }
        return null;
    }

    private List createModuleInsights(final Configuration configuration) {
        Set<ModuleIdentifier> modules = this.collectModules(configuration);
        return CollectionUtils.collect(modules, (Transformer)new Transformer<Object, ModuleIdentifier>(){

            public Object transform(ModuleIdentifier moduleIdentifier) {
                return JsonProjectDependencyRenderer.this.createModuleInsight(moduleIdentifier, configuration);
            }
        });
    }

    private Set<ModuleIdentifier> collectModules(Configuration configuration) {
        AbstractRenderableDependency root;
        if (configuration.isCanBeResolved()) {
            ResolutionResult result = configuration.getIncoming().getResolutionResult();
            root = new RenderableModuleResult(result.getRoot());
        } else {
            root = new UnresolvableConfigurationResult(configuration);
        }
        HashSet modules = Sets.newHashSet();
        HashSet visited = Sets.newHashSet();
        this.populateModulesWithChildDependencies(root, visited, modules);
        return modules;
    }

    private void populateModulesWithChildDependencies(RenderableDependency dependency, Set<ComponentIdentifier> visited, Set<ModuleIdentifier> modules) {
        for (RenderableDependency renderableDependency : dependency.getChildren()) {
            ModuleIdentifier moduleId = this.getModuleIdentifier(renderableDependency);
            if (moduleId == null) continue;
            modules.add(moduleId);
            boolean alreadyVisited = !visited.add((ComponentIdentifier)renderableDependency.getId());
            if (alreadyVisited) continue;
            this.populateModulesWithChildDependencies(renderableDependency, visited, modules);
        }
    }

    private Map createModuleInsight(ModuleIdentifier module, Configuration configuration) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(2);
        map.put("module", module.toString());
        map.put("insight", this.createInsight(module, configuration));
        return map;
    }

    private List createInsight(ModuleIdentifier module, final Configuration configuration) {
        final StrictDependencyResultSpec dependencySpec = new StrictDependencyResultSpec(module);
        ResolutionResult result = configuration.getIncoming().getResolutionResult();
        final LinkedHashSet<DependencyResult> selectedDependencies = new LinkedHashSet<DependencyResult>();
        result.allDependencies((Action)new Action<DependencyResult>(){

            public void execute(DependencyResult it) {
                if (dependencySpec.isSatisfiedBy((Object)it)) {
                    selectedDependencies.add(it);
                }
            }
        });
        Collection<RenderableDependency> sortedDeps = new DependencyInsightReporter(this.versionSelectorScheme, this.versionComparator, this.versionParser).convertToRenderableItems(selectedDependencies, false);
        return CollectionUtils.collect(sortedDeps, (Transformer)new Transformer<Object, RenderableDependency>(){

            public Object transform(RenderableDependency dependency) {
                String name = JsonProjectDependencyRenderer.this.replaceArrow(dependency.getName());
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(5);
                map.put("name", JsonProjectDependencyRenderer.this.replaceArrow(dependency.getName()));
                map.put("description", dependency.getDescription());
                map.put("resolvable", (Object)dependency.getResolutionState());
                map.put("hasConflict", !name.equals(dependency.getName()));
                map.put("children", JsonProjectDependencyRenderer.this.createInsightDependencyChildren(dependency, new HashSet(), configuration));
                return map;
            }
        });
    }

    private List createInsightDependencyChildren(RenderableDependency dependency, final Set<Object> visited, final Configuration configuration) {
        Set<? extends RenderableDependency> children = dependency.getChildren();
        return CollectionUtils.collect(children, (Transformer)new Transformer<Object, RenderableDependency>(){

            public Object transform(RenderableDependency childDependency) {
                boolean alreadyVisited = !visited.add(childDependency.getId());
                boolean leaf = childDependency.getChildren().isEmpty();
                boolean alreadyRendered = alreadyVisited && !leaf;
                String childName = JsonProjectDependencyRenderer.this.replaceArrow(childDependency.getName());
                boolean hasConflict = !childName.equals(childDependency.getName());
                String name = leaf ? configuration.getName() : childName;
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(6);
                map.put("name", name);
                map.put("resolvable", (Object)childDependency.getResolutionState());
                map.put("hasConflict", hasConflict);
                map.put("alreadyRendered", alreadyRendered);
                map.put("isLeaf", leaf);
                map.put("children", Collections.emptyList());
                if (!alreadyRendered) {
                    map.put("children", JsonProjectDependencyRenderer.this.createInsightDependencyChildren(childDependency, visited, configuration));
                }
                return map;
            }
        });
    }

    private String replaceArrow(String name) {
        return name.replace(" -> ", " \u27a1 ");
    }
}

