/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.application.CachedSingletonsRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.util.ClearableLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;

public class StandardFileSystems {
    public static final String FILE_PROTOCOL = "file";
    public static final String FILE_PROTOCOL_PREFIX = "file://";
    public static final String JAR_PROTOCOL = "jar";
    public static final String JAR_PROTOCOL_PREFIX = "jar://";
    public static final String JRT_PROTOCOL = "jrt";
    public static final String JRT_PROTOCOL_PREFIX = "jrt://";
    private static final ClearableLazyValue<VirtualFileSystem> ourLocal = CachedSingletonsRegistry.markLazyValue(new ClearableLazyValue<VirtualFileSystem>(){

        @Override
        @NotNull
        protected VirtualFileSystem compute() {
            VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem(StandardFileSystems.FILE_PROTOCOL);
            if (virtualFileSystem == null) {
                1.$$$reportNull$$$0(0);
            }
            return virtualFileSystem;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/StandardFileSystems$1", "compute"));
        }
    });
    private static final ClearableLazyValue<VirtualFileSystem> ourJar = CachedSingletonsRegistry.markLazyValue(new ClearableLazyValue<VirtualFileSystem>(){

        @Override
        @NotNull
        protected VirtualFileSystem compute() {
            VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem(StandardFileSystems.JAR_PROTOCOL);
            if (virtualFileSystem == null) {
                2.$$$reportNull$$$0(0);
            }
            return virtualFileSystem;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/StandardFileSystems$2", "compute"));
        }
    });

    public static VirtualFileSystem local() {
        return ourLocal.getValue();
    }

    public static VirtualFileSystem jar() {
        return ourJar.getValue();
    }

    @Deprecated
    public static VirtualFile getJarRootForLocalFile(@NotNull VirtualFile local) {
        if (local == null) {
            StandardFileSystems.$$$reportNull$$$0(0);
        }
        return StandardFileSystems.jar().findFileByPath(local.getPath() + "!/");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "org/jetbrains/kotlin/com/intellij/openapi/vfs/StandardFileSystems", "getJarRootForLocalFile"));
    }
}

